/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleSerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buffer;
    private long length;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Sep_17_16:39:28_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleSerialClob(char[] cArray) throws SQLException {
        this.length = cArray.length;
        this.buffer = new char[(int)this.length];
        int n2 = 0;
        while ((long)n2 < this.length) {
            this.buffer[n2] = cArray[n2];
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleSerialClob(Clob clob) throws SQLException {
        this.length = clob.length();
        this.buffer = new char[(int)this.length];
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                n2 = bufferedReader.read(this.buffer, n3, (int)(this.length - (long)n3));
                n3 += n2;
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 347, iOException.getMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 347, iOException.getMessage());
            }
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new StringBufferInputStream(new String(this.buffer));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new CharArrayReader(this.buffer);
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        if (l2 >= 0L && (long)n2 <= this.length && l2 + (long)n2 <= this.length) {
            return new String(this.buffer, (int)l2, n2);
        }
        DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        return null;
    }

    @Override
    public long length() throws SQLException {
        return this.length;
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        if (l2 < 0L || l2 > this.length || l2 + (long)string.length() > this.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        }
        char[] cArray = string.toCharArray();
        int n2 = (int)(l2 - 1L);
        boolean bl = false;
        long l3 = cArray.length;
        if (l2 < 0L || l2 > this.length) {
            return -1L;
        }
        while ((long)n2 < this.length) {
            int n3 = 0;
            long l4 = n2 + 1;
            while (cArray[n3++] == this.buffer[n2++]) {
                if ((long)n3 != l3) continue;
                return l4;
            }
        }
        return -1L;
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        return this.position(clob.getSubString(0L, (int)clob.length()), l2);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    @Override
    public void truncate(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        return null;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

