/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Sep_17_16:39:28_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleSerialBlob(byte[] byArray) throws SQLException {
        this.length = byArray.length;
        this.buffer = new byte[(int)this.length];
        int n2 = 0;
        while ((long)n2 < this.length) {
            this.buffer[n2] = byArray[n2];
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleSerialBlob(Blob blob) throws SQLException {
        this.length = blob.length();
        this.buffer = new byte[(int)this.length];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                n2 = bufferedInputStream.read(this.buffer, n3, (int)(this.length - (long)n3));
                n3 += n2;
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 346, iOException.getMessage());
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 346, iOException.getMessage());
            }
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.buffer);
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        byte[] byArray = null;
        if (--l2 < 0L || (long)n2 > this.length || l2 + (long)n2 > this.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        } else {
            byArray = new byte[n2];
            System.arraycopy(this.buffer, (int)l2, byArray, 0, n2);
        }
        return byArray;
    }

    @Override
    public long length() throws SQLException {
        return this.length;
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        if (l2 < 0L || l2 > this.length || l2 + (long)byArray.length > this.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        }
        int n2 = (int)(l2 - 1L);
        boolean bl = false;
        long l3 = byArray.length;
        if (l2 < 0L || l2 > this.length) {
            return -1L;
        }
        while ((long)n2 < this.length) {
            int n3 = 0;
            long l4 = n2 + 1;
            while (byArray[n3++] == this.buffer[n2++]) {
                if ((long)n3 != l3) continue;
                return l4;
            }
        }
        return -1L;
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l2);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    @Override
    public void truncate(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        return null;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

