/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;

public class OracleDataSourceFactory
implements ObjectFactory {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Sep_17_16:39:24_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        String string;
        Object object2;
        Reference reference = (Reference)object;
        OracleDataSource oracleDataSource = null;
        String string2 = reference.getClassName();
        Properties properties = new Properties();
        if (string2.equals("oracle.jdbc.pool.OracleDataSource") || string2.equals("oracle.jdbc.xa.client.OracleXADataSource")) {
            oracleDataSource = string2.equals("oracle.jdbc.pool.OracleDataSource") ? new OracleDataSource() : new OracleXADataSource();
            object2 = null;
            object2 = (StringRefAddr)reference.get("connectionCachingEnabled");
            if (object2 != null && (string = (String)((StringRefAddr)object2).getContent()).equals(String.valueOf("true"))) {
                oracleDataSource.setConnectionCachingEnabled(true);
            }
            if ((object2 = (StringRefAddr)reference.get("connectionCacheName")) != null) {
                oracleDataSource.setConnectionCacheName((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("connectionCacheProperties")) != null) {
                string = (String)((StringRefAddr)object2).getContent();
                Properties properties2 = this.extractConnectionCacheProperties(string);
                oracleDataSource.setConnectionCacheProperties(properties2);
            }
            if ((object2 = (StringRefAddr)reference.get("fastConnectionFailoverEnabled")) != null && (string = (String)((StringRefAddr)object2).getContent()).equals(String.valueOf("true"))) {
                oracleDataSource.setFastConnectionFailoverEnabled(true);
            }
            if ((object2 = (StringRefAddr)reference.get("onsConfigStr")) != null) {
                oracleDataSource.setONSConfiguration((String)((StringRefAddr)object2).getContent());
            }
        } else if (string2.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource")) {
            oracleDataSource = new OracleConnectionPoolDataSource();
        } else if (string2.equals("oracle.jdbc.pool.OracleOCIConnectionPool")) {
            oracleDataSource = new OracleOCIConnectionPool();
            object2 = null;
            string = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            StringRefAddr stringRefAddr = null;
            Object var17_18 = null;
            String string8 = null;
            stringRefAddr = (StringRefAddr)reference.get("connpool_min_limit");
            if (stringRefAddr != null) {
                object2 = (String)stringRefAddr.getContent();
            }
            if ((stringRefAddr = (StringRefAddr)reference.get("connpool_max_limit")) != null) {
                string = (String)stringRefAddr.getContent();
            }
            if ((stringRefAddr = (StringRefAddr)reference.get("connpool_increment")) != null) {
                string3 = (String)stringRefAddr.getContent();
            }
            if ((stringRefAddr = (StringRefAddr)reference.get("connpool_active_size")) != null) {
                string4 = (String)stringRefAddr.getContent();
            }
            if ((stringRefAddr = (StringRefAddr)reference.get("connpool_pool_size")) != null) {
                string5 = (String)stringRefAddr.getContent();
            }
            if ((stringRefAddr = (StringRefAddr)reference.get("connpool_timeout")) != null) {
                string6 = (String)stringRefAddr.getContent();
            }
            if ((stringRefAddr = (StringRefAddr)reference.get("connpool_nowait")) != null) {
                string7 = (String)stringRefAddr.getContent();
            }
            if ((stringRefAddr = (StringRefAddr)reference.get("transactions_distributed")) != null) {
                string8 = (String)stringRefAddr.getContent();
            }
            properties.put("connpool_min_limit", object2);
            properties.put("connpool_max_limit", string);
            properties.put("connpool_increment", string3);
            properties.put("connpool_active_size", string4);
            properties.put("connpool_pool_size", string5);
            properties.put("connpool_timeout", string6);
            if (string7 == "true") {
                properties.put("connpool_nowait", string7);
            }
            if (string8 == "true") {
                properties.put("transactions_distributed", string8);
            }
        } else {
            return null;
        }
        if (oracleDataSource != null) {
            object2 = null;
            object2 = (StringRefAddr)reference.get("url");
            if (object2 != null) {
                oracleDataSource.setURL((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("userName")) != null || (object2 = (StringRefAddr)reference.get("u")) != null || (object2 = (StringRefAddr)reference.get("user")) != null) {
                oracleDataSource.setUser((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("passWord")) != null || (object2 = (StringRefAddr)reference.get("password")) != null) {
                oracleDataSource.setPassword((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("description")) != null || (object2 = (StringRefAddr)reference.get("describe")) != null) {
                oracleDataSource.setDescription((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("driverType")) != null || (object2 = (StringRefAddr)reference.get("driver")) != null) {
                oracleDataSource.setDriverType((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("serverName")) != null || (object2 = (StringRefAddr)reference.get("host")) != null) {
                oracleDataSource.setServerName((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("databaseName")) != null || (object2 = (StringRefAddr)reference.get("sid")) != null) {
                oracleDataSource.setDatabaseName((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("serviceName")) != null) {
                oracleDataSource.setServiceName((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("networkProtocol")) != null || (object2 = (StringRefAddr)reference.get("protocol")) != null) {
                oracleDataSource.setNetworkProtocol((String)((StringRefAddr)object2).getContent());
            }
            if ((object2 = (StringRefAddr)reference.get("portNumber")) != null || (object2 = (StringRefAddr)reference.get("port")) != null) {
                string = (String)((StringRefAddr)object2).getContent();
                oracleDataSource.setPortNumber(Integer.parseInt(string));
            }
            if ((object2 = (StringRefAddr)reference.get("tnsentryname")) != null || (object2 = (StringRefAddr)reference.get("tns")) != null) {
                oracleDataSource.setTNSEntryName((String)((StringRefAddr)object2).getContent());
            } else if (string2.equals("oracle.jdbc.pool.OracleOCIConnectionPool")) {
                string = null;
                object2 = (StringRefAddr)reference.get("connpool_is_poolcreated");
                if (object2 != null) {
                    string = (String)((StringRefAddr)object2).getContent();
                }
                if (string.equals(String.valueOf("true"))) {
                    ((OracleOCIConnectionPool)oracleDataSource).setPoolConfig(properties);
                }
            }
        }
        return oracleDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties extractConnectionCacheProperties(String string) throws SQLException {
        String string2;
        Object object;
        String string3;
        Object object2;
        Properties properties = new Properties();
        int n2 = (string = string.substring(1, string.length() - 1)).indexOf("AttributeWeights", 0);
        if (n2 >= 0) {
            if (string.charAt(n2 + 16) != '=' || n2 > 0 && string.charAt(n2 - 1) != ' ') {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 139);
            }
            object2 = new Properties();
            int n3 = string.indexOf("}", n2);
            string3 = string.substring(n2, n3);
            String string4 = string3.substring(18);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ");
            object = stringTokenizer;
            synchronized (object) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    int n4 = string2.length();
                    int n5 = string2.indexOf("=");
                    String string5 = string2.substring(0, n5);
                    String string6 = string2.substring(n5 + 1, n4);
                    ((Properties)object2).setProperty(string5, string6);
                }
            }
            properties.put("AttributeWeights", object2);
            if (n2 > 0 && n3 + 1 == string.length()) {
                string = string.substring(0, n2 - 2);
            } else if (n2 > 0 && n3 + 1 < string.length()) {
                object = string.substring(0, n2 - 2);
                string2 = string.substring(n3 + 1, string.length());
                string = ((String)object).concat(string2);
            } else {
                string = string.substring(n3 + 2, string.length());
            }
        }
        object2 = new StringTokenizer(string, ", ");
        StringTokenizer stringTokenizer = object2;
        synchronized (stringTokenizer) {
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string3 = ((StringTokenizer)object2).nextToken();
                int n6 = string3.length();
                int n7 = string3.indexOf("=");
                object = string3.substring(0, n7);
                string2 = string3.substring(n7 + 1, n6);
                properties.setProperty((String)object, string2);
            }
        }
        return properties;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

