/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSPatch;

public class TDSReader {
    static final int KOPT_NONE_FINAL_TYPE = 1;
    static final int KOPT_JAVA_OBJECT = 2;
    long fixedDataSize = 0L;
    Vector patches = null;
    byte[] tds;
    int beginIndex;
    int index;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Sep_17_16:39:12_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    TDSReader(byte[] byArray, long l2) {
        this.tds = byArray;
        this.beginIndex = (int)l2;
        this.index = (int)l2;
    }

    void skipBytes(int n2) throws SQLException {
        this.index += n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNextByte(byte by) throws SQLException {
        try {
            if (by != this.tds[this.index]) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS");
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte readByte() throws SQLException {
        try {
            byte by = this.tds[this.index];
            return by;
        }
        finally {
            ++this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readUnsignedByte() throws SQLException {
        try {
            int n2 = this.tds[this.index] & 0xFF;
            return n2;
        }
        finally {
            ++this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readUB2() throws SQLException {
        try {
            int n2 = ((this.tds[this.index] & 0xFF) << 8) + (this.tds[this.index + 1] & 0xFF);
            return n2;
        }
        finally {
            this.index += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readLong() throws SQLException {
        try {
            long l2 = (((this.tds[this.index] & 0xFF) * 256 + (this.tds[this.index + 1] & 0xFF)) * 256 + (this.tds[this.index + 2] & 0xFF)) * 256 + (this.tds[this.index + 3] & 0xFF);
            return l2;
        }
        finally {
            this.index += 4;
        }
    }

    void addNormalPatch(long l2, byte by, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(0, oracleType, l2, by));
    }

    void addSimplePatch(long l2, OracleType oracleType) throws SQLException {
        this.addPatch(new TDSPatch(1, oracleType, l2, 0));
    }

    void addPatch(TDSPatch tDSPatch) throws SQLException {
        if (this.patches == null) {
            this.patches = new Vector(5);
        }
        this.patches.addElement(tDSPatch);
    }

    long moveToPatchPos(TDSPatch tDSPatch) throws SQLException {
        long l2 = tDSPatch.getPosition();
        if ((long)this.beginIndex + l2 > (long)this.tds.length) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS");
        }
        this.skip_to(l2);
        return l2;
    }

    TDSPatch getNextPatch() throws SQLException {
        TDSPatch tDSPatch = null;
        if (this.patches != null && this.patches.size() > 0) {
            tDSPatch = (TDSPatch)this.patches.firstElement();
            this.patches.removeElementAt(0);
        }
        return tDSPatch;
    }

    void skip_to(long l2) {
        this.index = this.beginIndex + (int)l2;
    }

    long offset() throws SQLException {
        return this.index - this.beginIndex;
    }

    long absoluteOffset() throws SQLException {
        return this.index;
    }

    byte[] tds() throws SQLException {
        return this.tds;
    }

    boolean isJavaObject(int n2, byte by) {
        return n2 >= 3 && (by & 2) != 0;
    }

    boolean isFinalType(int n2, byte by) {
        return n2 >= 3 && (by & 1) == 0;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

