/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scanview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.landicorp.android.scan.scanDecoder.GlobalState;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.util.Util;
import java.util.ArrayList;

public class ScanLayout
extends RelativeLayout {
    private static final String TAG = "ScanDecoder_ScanLayout";
    private boolean bNoPreview = true;
    private boolean bUseGifPicture = true;
    private Paint paint;
    private Rect mRect;
    private ImageView mScanView;
    private RelativeLayout.LayoutParams mParam;
    private int mScreenWidth = 0;
    private int mScreenHeight = 0;
    private Context mContext;
    private int cropWidth;
    private int cropHeight;
    private static ArrayList<View> userViewList = new ArrayList();
    private static boolean removeViewFlag = false;

    public static void setViewList(ArrayList<View> viewList) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "setView"));
        userViewList = viewList;
    }

    public static void clearViewList() {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "clearViewList"));
        userViewList.clear();
    }

    private void removeViewForScanLayout() {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "removeViewForScanLayout"));
        if (!userViewList.isEmpty()) {
            int i = 0;
            while (i < userViewList.size()) {
                Log.i((String)TAG, (String)("remove userView, i=" + i + ",userView=" + userViewList.get(i)));
                this.removeView(userViewList.get(i));
                ++i;
            }
        }
    }

    public static void setRemoveViewFlag(boolean enable) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "setRemoveViewFlag, enable=" + enable));
        removeViewFlag = enable;
    }

    private void initCropRect() {
        String PreviewCutSize = PreferencesManager.getPreviewCutSize();
        String[] size = PreviewCutSize.split("x");
        this.cropWidth = Integer.parseInt(size[0]);
        this.cropHeight = Integer.parseInt(size[1]);
    }

    public ScanLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setWillNotDraw(false);
        this.paint = new Paint(1);
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        this.mScreenWidth = wm.getDefaultDisplay().getWidth();
        this.mScreenHeight = wm.getDefaultDisplay().getHeight();
        this.initCropRect();
        this.initScanView(context, attrs);
    }

    public void startScanViewAnimation() {
        ScaleAnimation animation = new ScaleAnimation(1.0f, 1.0f, 0.0f, 1.0f);
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        animation.setInterpolator((Interpolator)new LinearInterpolator());
        animation.setDuration(1200L);
        this.mScanView.startAnimation((Animation)animation);
    }

    @SuppressLint(value={"NewApi"})
    private void initScanView(Context context, AttributeSet attrs) {
        this.bNoPreview = PreferencesManager.getNoPreview();
        this.bUseGifPicture = PreferencesManager.getUseGifPicture();
        if (this.bNoPreview && !this.bUseGifPicture) {
            if (PreferencesManager.getFrontFaceCamera()) {
                Log.i((String)TAG, (String)"front camera do not open preview");
                if (!userViewList.isEmpty()) {
                    int i = 0;
                    while (i < userViewList.size()) {
                        Log.i((String)TAG, (String)("add userView, i=" + i + ",childView=" + userViewList.get(i)));
                        this.addView(userViewList.get(i));
                        ++i;
                    }
                    ScanLayout.setRemoveViewFlag(false);
                } else {
                    this.mScanView = new ImageView(context);
                    String lang = this.getResources().getConfiguration().locale.getLanguage();
                    Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + ",lang=" + lang));
                    if (lang.equals("zh")) {
                        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Chinese Language"));
                        this.mScanView.setBackgroundResource(GlobalState.getResId(context, "drawable", "please_scan"));
                    } else {
                        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "not Chinese Language"));
                        this.mScanView.setBackgroundResource(GlobalState.getResId(context, "drawable", "please_scan_english"));
                    }
                    this.mParam = new RelativeLayout.LayoutParams(this.mScreenWidth, this.mScreenHeight);
                    this.mParam.leftMargin = 0;
                    this.mParam.topMargin = 0;
                    this.addView((View)this.mScanView, (ViewGroup.LayoutParams)this.mParam);
                }
            } else {
                Log.i((String)TAG, (String)"back camera open preview default");
                if (!userViewList.isEmpty()) {
                    int i = 0;
                    while (i < userViewList.size()) {
                        Log.i((String)TAG, (String)("add userView, i=" + i + ",childView=" + userViewList.get(i)));
                        this.addView(userViewList.get(i));
                        ++i;
                    }
                    ScanLayout.setRemoveViewFlag(false);
                }
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    protected void onDetachedFromWindow() {
        Log.i((String)TAG, (String)"onDetachedFromWindow");
        this.removeViewForScanLayout();
        super.onDetachedFromWindow();
    }

    public void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        Log.i((String)TAG, (String)"onFocusChanged");
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        Log.i((String)TAG, (String)("onWindowFocusChanged--removeViewFlag=" + removeViewFlag));
        if (removeViewFlag) {
            this.removeViewForScanLayout();
        }
        super.onWindowFocusChanged(hasFocus);
    }
}

