/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scanview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.Build;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import java.io.InputStream;

public class GifView
extends View {
    private static final int DEFAULT_MOVIE_DURATION = 1000;
    private int mMovieResourceId;
    private Movie mMovie;
    private long mMovieStart;
    private int mCurrentAnimationTime = 0;
    private float mLeft;
    private float mTop;
    private float mScale;
    private int mMeasuredMovieWidth;
    private int mMeasuredMovieHeight;
    private boolean mVisible = true;
    private volatile boolean mPaused = false;

    public GifView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setViewAttributes(context);
    }

    @SuppressLint(value={"NewApi"})
    private void setViewAttributes(Context context) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    public void setMovieResource(int movieResId) {
        this.mMovieResourceId = movieResId;
        this.mMovie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.mMovieResourceId));
        this.requestLayout();
    }

    public void setMovie(Movie movie) {
        this.mMovie = movie;
        this.requestLayout();
    }

    public Movie getMovie() {
        return this.mMovie;
    }

    public void setMovieTime(int time) {
        this.mCurrentAnimationTime = time;
        this.invalidate();
    }

    public void setPaused(boolean paused) {
        this.mPaused = paused;
        if (!paused) {
            this.mMovieStart = SystemClock.uptimeMillis() - (long)this.mCurrentAnimationTime;
        }
        this.invalidate();
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMovie != null) {
            int movieWidth = this.mMovie.width();
            int movieHeight = this.mMovie.height();
            int maximumWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            float scaleW = (float)movieWidth / (float)maximumWidth;
            this.mScale = 1.0f / scaleW;
            this.mMeasuredMovieWidth = maximumWidth;
            this.mMeasuredMovieHeight = (int)((float)movieHeight * this.mScale);
            this.setMeasuredDimension(this.mMeasuredMovieWidth, this.mMeasuredMovieHeight);
        } else {
            this.setMeasuredDimension(this.getSuggestedMinimumWidth(), this.getSuggestedMinimumHeight());
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mLeft = (float)(this.getWidth() - this.mMeasuredMovieWidth) / 2.0f;
        this.mTop = (float)(this.getHeight() - this.mMeasuredMovieHeight) / 2.0f;
        this.mVisible = this.getVisibility() == 0;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mMovie != null) {
            if (!this.mPaused) {
                this.updateAnimationTime();
                this.drawMovieFrame(canvas);
                this.invalidateView();
            } else {
                this.drawMovieFrame(canvas);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void invalidateView() {
        if (this.mVisible) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.postInvalidateOnAnimation();
            } else {
                this.invalidate();
            }
        }
    }

    private void updateAnimationTime() {
        int dur;
        long now = SystemClock.uptimeMillis();
        if (this.mMovieStart == 0L) {
            this.mMovieStart = now;
        }
        if ((dur = this.mMovie.duration()) == 0) {
            dur = 1000;
        }
        this.mCurrentAnimationTime = (int)((now - this.mMovieStart) % (long)dur);
    }

    private void drawMovieFrame(Canvas canvas) {
        this.mMovie.setTime(this.mCurrentAnimationTime);
        canvas.save(1);
        canvas.scale(this.mScale, this.mScale);
        this.mMovie.draw(canvas, this.mLeft / this.mScale, this.mTop / this.mScale);
        canvas.restore();
    }

    @SuppressLint(value={"NewApi"})
    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        this.mVisible = screenState == 1;
        this.invalidateView();
    }

    @SuppressLint(value={"NewApi"})
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.invalidateView();
    }
}

