/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.util;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class bmpUtil {
    public static void saveBmpImage(Bitmap bitmap) {
        if (bitmap != null) {
            byte[] buffer = bmpUtil.bitmap2BmpBytes(bitmap);
            try {
                FileOutputStream fos = new FileOutputStream(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + "/hello.bmp");
                fos.write(buffer);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap getViewBitmap(View v) {
        v.clearFocus();
        v.setPressed(false);
        boolean willNotCache = v.willNotCacheDrawing();
        v.setWillNotCacheDrawing(false);
        int color = v.getDrawingCacheBackgroundColor();
        v.setDrawingCacheBackgroundColor(0);
        if (color != 0) {
            v.destroyDrawingCache();
        }
        v.buildDrawingCache();
        Bitmap cacheBitmap = v.getDrawingCache();
        if (cacheBitmap == null) {
            Log.e((String)"BtPrinter", (String)("failed getViewBitmap(" + v + ")"), (Throwable)new RuntimeException());
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)cacheBitmap);
        v.destroyDrawingCache();
        v.setWillNotCacheDrawing(willNotCache);
        v.setDrawingCacheBackgroundColor(color);
        return bitmap;
    }

    public static byte[] bitmap2BmpBytes(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        int nBmpWidth = bitmap.getWidth();
        int nBmpHeight = bitmap.getHeight();
        int bufferSize = nBmpHeight * (nBmpWidth * 3 + nBmpWidth % 4);
        byte[] bmpData = new byte[54 + bufferSize];
        int pos = 0;
        int bfType = 19778;
        long bfSize = 54 + bufferSize;
        int bfReserved1 = 0;
        int bfReserved2 = 0;
        long bfOffBits = 54L;
        bmpUtil.writeWord2ByteArray(bmpData, pos, bfType);
        bmpUtil.writeDword2ByteArray(bmpData, pos += 2, bfSize);
        bmpUtil.writeWord2ByteArray(bmpData, pos += 4, bfReserved1);
        bmpUtil.writeWord2ByteArray(bmpData, pos += 2, bfReserved2);
        bmpUtil.writeDword2ByteArray(bmpData, pos += 2, bfOffBits);
        pos += 4;
        long biSize = 40L;
        long biWidth = nBmpWidth;
        long biHeight = nBmpHeight;
        int biPlanes = 1;
        int biBitCount = 24;
        long biCompression = 0L;
        long biSizeImage = 0L;
        long biXpelsPerMeter = 0L;
        long biYPelsPerMeter = 0L;
        long biClrUsed = 0L;
        long biClrImportant = 0L;
        bmpUtil.writeDword2ByteArray(bmpData, pos, biSize);
        bmpUtil.writeLong2ByteArray(bmpData, pos += 4, biWidth);
        bmpUtil.writeLong2ByteArray(bmpData, pos += 4, biHeight);
        bmpUtil.writeWord2ByteArray(bmpData, pos += 4, biPlanes);
        bmpUtil.writeWord2ByteArray(bmpData, pos += 2, biBitCount);
        bmpUtil.writeDword2ByteArray(bmpData, pos += 2, biCompression);
        bmpUtil.writeDword2ByteArray(bmpData, pos += 4, biSizeImage);
        bmpUtil.writeLong2ByteArray(bmpData, pos += 4, biXpelsPerMeter);
        bmpUtil.writeLong2ByteArray(bmpData, pos += 4, biYPelsPerMeter);
        bmpUtil.writeDword2ByteArray(bmpData, pos += 4, biClrUsed);
        bmpUtil.writeDword2ByteArray(bmpData, pos += 4, biClrImportant);
        pos += 4;
        int wWidth = nBmpWidth * 3 + nBmpWidth % 4;
        int nCol = 0;
        int nRealCol = nBmpHeight - 1;
        while (nCol < nBmpHeight) {
            int wRow = 0;
            int wByteIdex = 0;
            while (wRow < nBmpWidth) {
                int clr = bitmap.getPixel(wRow, nCol);
                bmpData[pos + nRealCol * wWidth + wByteIdex] = (byte)Color.blue((int)clr);
                bmpData[pos + nRealCol * wWidth + wByteIdex + 1] = (byte)Color.green((int)clr);
                bmpData[pos + nRealCol * wWidth + wByteIdex + 2] = (byte)Color.red((int)clr);
                ++wRow;
                wByteIdex += 3;
            }
            ++nCol;
            --nRealCol;
        }
        return bmpData;
    }

    private static void writeWord2ByteArray(byte[] b, int pos, int value) {
        b[pos] = (byte)(value & 0xFF);
        b[pos + 1] = (byte)(value >> 8 & 0xFF);
    }

    private static void writeDword2ByteArray(byte[] b, int pos, long value) {
        b[pos] = (byte)(value & 0xFFL);
        b[pos + 1] = (byte)(value >> 8 & 0xFFL);
        b[pos + 2] = (byte)(value >> 16 & 0xFFL);
        b[pos + 3] = (byte)(value >> 24 & 0xFFL);
    }

    private static void writeLong2ByteArray(byte[] b, int pos, long value) {
        b[pos] = (byte)(value & 0xFFL);
        b[pos + 1] = (byte)(value >> 8 & 0xFFL);
        b[pos + 2] = (byte)(value >> 16 & 0xFFL);
        b[pos + 3] = (byte)(value >> 24 & 0xFFL);
    }

    public static int toInt_littleEndian(byte[] b, int pos) {
        int ret = 0;
        ret = b[pos] & 0xFF;
        ret |= b[pos + 1] << 8 & 0xFF00;
        ret |= b[pos + 2] << 16 & 0xFF0000;
        return ret |= b[pos + 3] << 24 & 0xFF000000;
    }

    public static short toShort_littleEndian(byte[] b, int pos) {
        int d = 0;
        d = b[pos] & 0xFF;
        short ret = (short)((d |= b[pos + 1] << 8 & 0xFF00) & 0xFFFF);
        return ret;
    }

    public static imageRaw_8bitPerPix getBmpGreybytes(byte[] bmp) {
        imageRaw_8bitPerPix image_Raw = new imageRaw_8bitPerPix();
        int bmpSize = 0;
        int bfOffBits = 0;
        int biSizeImage = 0;
        short biBitCount = 0;
        image_Raw.data = null;
        image_Raw.width = 0;
        image_Raw.height = 0;
        image_Raw.ret = 0;
        if (bmp[0] != 66 || bmp[1] != 77) {
            image_Raw.ret = 1;
            return image_Raw;
        }
        bmpSize = bmpUtil.toInt_littleEndian(bmp, 2);
        bfOffBits = bmpUtil.toInt_littleEndian(bmp, 10);
        image_Raw.width = bmpUtil.toInt_littleEndian(bmp, 18);
        image_Raw.height = bmpUtil.toInt_littleEndian(bmp, 22);
        biBitCount = bmpUtil.toShort_littleEndian(bmp, 28);
        biSizeImage = bmpUtil.toInt_littleEndian(bmp, 34);
        if (biBitCount != 1 && biBitCount != 8) {
            image_Raw.ret = 2;
            return image_Raw;
        }
        if (biBitCount == 8) {
            int bytePerLine;
            int bitPerPix = 8;
            image_Raw.width = bytePerLine = (image_Raw.width * bitPerPix + 31) / 32 * 4;
            biSizeImage = image_Raw.width * Math.abs(image_Raw.height);
            if (biSizeImage != bmp.length - bfOffBits) {
                image_Raw.ret = 3;
                return image_Raw;
            }
            image_Raw.data = new byte[biSizeImage];
            if (image_Raw.height < 0) {
                int i = 0;
                while (i < biSizeImage) {
                    image_Raw.data[i] = bmp[bfOffBits + i];
                    ++i;
                }
            } else {
                int pos = 0;
                int i = image_Raw.height - 1;
                while (i >= 0) {
                    int j = 0;
                    while (j < bytePerLine) {
                        image_Raw.data[pos++] = bmp[bfOffBits + i * bytePerLine + j];
                        ++j;
                    }
                    --i;
                }
            }
        } else if (biBitCount == 1) {
            int bitPerPix = 1;
            int bytePerLine = (image_Raw.width * bitPerPix + 31) / 32 * 4;
            image_Raw.width = bytePerLine * 8;
            biSizeImage = image_Raw.width * Math.abs(image_Raw.height);
            if (biSizeImage / 8 != bmp.length - bfOffBits) {
                image_Raw.ret = 4;
                return image_Raw;
            }
            image_Raw.data = new byte[biSizeImage];
            if (image_Raw.height < 0) {
                int i = 0;
                while (i < biSizeImage / 8) {
                    image_Raw.data[i * 8 + 7] = (byte)((bmp[bfOffBits + i] >> 0 & 1) == 0 ? 0 : 255);
                    image_Raw.data[i * 8 + 6] = (byte)((bmp[bfOffBits + i] >> 1 & 1) == 0 ? 0 : 255);
                    image_Raw.data[i * 8 + 5] = (byte)((bmp[bfOffBits + i] >> 2 & 1) == 0 ? 0 : 255);
                    image_Raw.data[i * 8 + 4] = (byte)((bmp[bfOffBits + i] >> 3 & 1) == 0 ? 0 : 255);
                    image_Raw.data[i * 8 + 3] = (byte)((bmp[bfOffBits + i] >> 4 & 1) == 0 ? 0 : 255);
                    image_Raw.data[i * 8 + 2] = (byte)((bmp[bfOffBits + i] >> 5 & 1) == 0 ? 0 : 255);
                    image_Raw.data[i * 8 + 1] = (byte)((bmp[bfOffBits + i] >> 6 & 1) == 0 ? 0 : 255);
                    image_Raw.data[i * 8 + 0] = (byte)((bmp[bfOffBits + i] >> 7 & 1) == 0 ? 0 : 255);
                    ++i;
                }
            } else {
                int pos = 0;
                int i = image_Raw.height - 1;
                while (i >= 0) {
                    int j = 0;
                    while (j < bytePerLine) {
                        image_Raw.data[pos * 8 + 7] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 0 & 1) == 0 ? 0 : 255);
                        image_Raw.data[pos * 8 + 6] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 1 & 1) == 0 ? 0 : 255);
                        image_Raw.data[pos * 8 + 5] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 2 & 1) == 0 ? 0 : 255);
                        image_Raw.data[pos * 8 + 4] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 3 & 1) == 0 ? 0 : 255);
                        image_Raw.data[pos * 8 + 3] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 4 & 1) == 0 ? 0 : 255);
                        image_Raw.data[pos * 8 + 2] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 5 & 1) == 0 ? 0 : 255);
                        image_Raw.data[pos * 8 + 1] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 6 & 1) == 0 ? 0 : 255);
                        image_Raw.data[pos * 8 + 0] = (byte)((bmp[bfOffBits + i * bytePerLine + j] >> 7 & 1) == 0 ? 0 : 255);
                        ++pos;
                        ++j;
                    }
                    --i;
                }
            }
        }
        image_Raw.ret = 0;
        return image_Raw;
    }

    public static class imageRaw_8bitPerPix {
        public byte[] data;
        public int width;
        public int height;
        public int ret;
    }
}

