/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Environment;
import com.landicorp.android.scan.util.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.text.SimpleDateFormat;

@TargetApi(value=9)
@SuppressLint(value={"NewApi"})
public final class Util {
    private static final String DEBUG_TAG = "landi_Util";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Util() {
    }

    public static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static byte[] toBytes(int a) {
        return new byte[]{(byte)(0xFF & a >>> 24), (byte)(0xFF & a >>> 16), (byte)(0xFF & a >>> 8), (byte)(0xFF & a)};
    }

    public static boolean testBit(byte data, int bit) {
        byte mask = (byte)(1 << bit & 0xFF);
        return (data & mask) == mask;
    }

    public static int toInt(byte[] b, int start, int sizeofint) {
        int ret = 0;
        int e = start + sizeofint;
        int i = start;
        while (i < e) {
            ret <<= 8;
            ret |= b[i] & 0xFF;
            ++i;
        }
        return ret;
    }

    public static int toIntR(byte[] b, int s, int n) {
        int ret = 0;
        int i = s;
        while (i >= 0 && n > 0) {
            ret <<= 8;
            ret |= b[i] & 0xFF;
            --i;
            --n;
        }
        return ret;
    }

    public static int toInt(byte ... b) {
        int ret = 0;
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte a = byArray[n2];
            ret <<= 8;
            ret |= a & 0xFF;
            ++n2;
        }
        return ret;
    }

    public static int toIntR(byte ... b) {
        return Util.toIntR(b, b.length - 1, b.length);
    }

    public static String toGBKString(byte[] data, int start, int length) {
        try {
            return new String(data, start, length, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toBCDString(byte[] data) {
        return Util.toBCDString(data, 0, data.length);
    }

    public static byte[] StringtoBCD(String str) {
        str.length();
        if (str.contains(".")) {
            int dotIndex = str.indexOf(46);
            String newString = String.valueOf(str.substring(0, dotIndex)) + str.substring(dotIndex + 1, str.length());
            byte[] data1 = newString.getBytes();
            int len = 0;
            len = data1.length % 2 == 0 ? data1.length / 2 : data1.length / 2 + 1;
            byte[] data = new byte[len];
            int i = 0;
            while (i < len) {
                data[i] = data1.length % 2 == 0 ? (byte)(data1[i * 2] - 48 << 4 | data1[i * 2 + 1] - 48) : (i == 0 ? (byte)(data1[i * 2] - 48) : (byte)(data1[i * 2 - 1] - 48 << 4 | data1[i * 2] - 48));
                ++i;
            }
            return data;
        }
        byte[] data1 = str.getBytes();
        int len = 0;
        len = data1.length % 2 == 0 ? data1.length / 2 : data1.length / 2 + 1;
        byte[] data = new byte[len];
        int i = 0;
        while (i < len) {
            data[i] = data1.length % 2 == 0 ? (byte)(data1[i * 2] - 48 << 4 | data1[i * 2 + 1] - 48) : (i == 0 ? (byte)(data1[i * 2] - 48) : (byte)(data1[i * 2 - 1] - 48 << 4 | data1[i * 2] - 48));
            ++i;
        }
        return data;
    }

    public static String toBCDString(byte[] data, int start, int length) {
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < start + length) {
            byte b = data[i];
            char c1 = (char)((b >> 4 & 0xF) + 48);
            char c2 = (char)((b & 0xF) + 48);
            buf.append(c1);
            buf.append(c2);
            ++i;
        }
        return buf.toString();
    }

    public static String toGBKString(byte[] data) {
        try {
            return new String(data, 0, data.length, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toHexString(byte ... d) {
        return d == null || d.length == 0 ? "" : Util.toHexString(d, 0, d.length);
    }

    public static String toHexString(byte[] d, int s, int n) {
        char[] ret = new char[n * 2];
        int e = s + n;
        int x = 0;
        int i = s;
        while (i < e) {
            byte v = d[i];
            ret[x++] = HEX[0xF & v >> 4];
            ret[x++] = HEX[0xF & v];
            ++i;
        }
        return new String(ret);
    }

    public static String toHexStringR(byte[] d, int s, int n) {
        char[] ret = new char[n * 2];
        int x = 0;
        int i = s + n - 1;
        while (i >= s) {
            byte v = d[i];
            ret[x++] = HEX[0xF & v >> 4];
            ret[x++] = HEX[0xF & v];
            --i;
        }
        return new String(ret);
    }

    public static String ensureString(String str) {
        return str == null ? "" : str;
    }

    public static String toStringR(int n) {
        StringBuilder ret = new StringBuilder(16).append('0');
        long N = 0xFFFFFFFFL & (long)n;
        while (N != 0L) {
            ret.append((int)(N % 100L));
            N /= 100L;
        }
        return ret.toString();
    }

    public static int parseInt(String txt, int radix, int def) {
        int ret;
        try {
            ret = Integer.valueOf(txt, radix);
        }
        catch (Exception e) {
            ret = def;
        }
        return ret;
    }

    public static int BCDtoInt(byte[] b, int s, int n) {
        int ret = 0;
        int e = s + n;
        int i = s;
        while (i < e) {
            int h = b[i] >> 4 & 0xF;
            int l = b[i] & 0xF;
            if (h > 9 || l > 9) {
                return -1;
            }
            ret = ret * 100 + h * 10 + l;
            ++i;
        }
        return ret;
    }

    public static int BCDtoInt(byte ... b) {
        return Util.BCDtoInt(b, 0, b.length);
    }

    public static String byte2string(byte[] data, Boolean hexFormat) {
        StringBuilder sb = new StringBuilder();
        String str = "";
        if (data == null) {
            return str;
        }
        if (hexFormat.booleanValue()) {
            int i = 0;
            while (i < data.length) {
                sb.append(String.valueOf(Integer.toHexString(data[i] & 0xFF)) + " ");
                ++i;
            }
            str = "0x" + new String(sb.toString());
        } else {
            str = new String(data, 0, data.length);
        }
        sb = null;
        return str;
    }

    public static String getFileMethodLine() {
        StackTraceElement traceElement = new Exception().getStackTrace()[1];
        StringBuffer toStringBuffer = new StringBuffer("[").append(traceElement.getFileName()).append("|").append(traceElement.getMethodName()).append("|").append(traceElement.getLineNumber()).append("] ");
        return toStringBuffer.toString();
    }

    public static String getMethodLine() {
        StackTraceElement traceElement = new Exception().getStackTrace()[1];
        StringBuffer toStringBuffer = new StringBuffer("[").append(traceElement.getMethodName()).append("|").append(traceElement.getLineNumber()).append("] ");
        return toStringBuffer.toString();
    }

    public static String _FILE_() {
        StackTraceElement traceElement = new Exception().getStackTrace()[1];
        return traceElement.getFileName();
    }

    public static String _FUNC_() {
        StackTraceElement traceElement = new Exception().getStackTrace()[1];
        return traceElement.getMethodName();
    }

    public static int _LINE_() {
        StackTraceElement traceElement = new Exception().getStackTrace()[1];
        return traceElement.getLineNumber();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String _TIME_() {
        Date now = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return sdf.format(now);
    }

    public static String getSDPath() {
        File sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory();
            LogUtils.e(DEBUG_TAG, "sdCard path=" + sdDir.toString());
            LogUtils.e(DEBUG_TAG, "DataDirectory path=" + Environment.getDataDirectory().toString());
            LogUtils.e(DEBUG_TAG, "RootDirectory path=" + Environment.getRootDirectory().toString());
            LogUtils.e(DEBUG_TAG, "DownloadCacheDirectory path=" + Environment.getDownloadCacheDirectory().toString());
            return sdDir.toString();
        }
        LogUtils.e(DEBUG_TAG, "sdCard is not Exist");
        return null;
    }

    @TargetApi(value=9)
    @SuppressLint(value={"NewApi"})
    public static void saveDataToFile(byte[] data, String dirName, String fileName) {
        String sdPath = Util.getSDPath();
        File fileDir = new File(String.valueOf(sdPath) + File.separator + dirName);
        File file = new File(String.valueOf(sdPath) + File.separator + dirName + File.separator + fileName);
        if (!fileDir.exists()) {
            LogUtils.w(DEBUG_TAG, "dir=" + fileDir.getAbsolutePath() + "/ not exist,creat it");
            fileDir.mkdirs();
            fileDir.setReadable(true);
            fileDir.setWritable(true);
        } else {
            LogUtils.w(DEBUG_TAG, "dir=" + fileDir.getAbsolutePath() + "/ exist");
        }
        if (!file.exists()) {
            LogUtils.w(DEBUG_TAG, "file=" + file.getAbsolutePath() + " not exist,creat it");
            try {
                file.createNewFile();
                file.setReadable(true);
                file.setWritable(true);
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtils.e(DEBUG_TAG, "File.createNewFile() failed!---IOException");
                return;
            }
        } else {
            LogUtils.w(DEBUG_TAG, "file=" + file.getAbsolutePath() + " exist");
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            ((OutputStream)outStream).write(data);
            ((OutputStream)outStream).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static float getAverage_except_MinMax(int[] dataArray) {
        if (dataArray == null) {
            return -1.0f;
        }
        int maxValue = dataArray[0];
        int maxIndex = 0;
        int minValue = dataArray[0];
        int minIndex = 0;
        float sum = 0.0f;
        float average = 0.0f;
        int i = 0;
        while (i < dataArray.length) {
            if (maxValue < dataArray[i]) {
                maxValue = dataArray[i];
                maxIndex = i;
            }
            if (minValue > dataArray[i]) {
                minValue = dataArray[i];
                minIndex = i;
            }
            ++i;
        }
        i = 0;
        while (i < dataArray.length) {
            LogUtils.i(DEBUG_TAG, String.valueOf(Util.getMethodLine()) + "dataArray[" + i + "]" + "=" + dataArray[i]);
            if (i == maxIndex || i == minIndex) {
                LogUtils.i(DEBUG_TAG, String.valueOf(Util.getMethodLine()) + "index " + i + " is min or max, abandon it...");
            } else {
                sum += (float)dataArray[i];
            }
            ++i;
        }
        average = maxIndex == minIndex ? sum / (float)(dataArray.length - 1) : sum / (float)(dataArray.length - 2);
        return average;
    }

    public static float getAverage(int[] dataArray) {
        if (dataArray == null) {
            return -1.0f;
        }
        float sum = 0.0f;
        float average = 0.0f;
        int i = 0;
        while (i < dataArray.length) {
            LogUtils.i(DEBUG_TAG, String.valueOf(Util.getMethodLine()) + "dataArray[" + i + "]" + "=" + dataArray[i]);
            sum += (float)dataArray[i];
            ++i;
        }
        average = sum / (float)dataArray.length;
        return average;
    }
}

