/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.util;

import android.graphics.Bitmap;

public final class PlanarYUVLuminanceSource {
    public byte[] renderCroppedGreyscaleBitmapByte(byte[] yuvData, int previewWidth, int previewHeight, int left, int top, int width, int height) {
        int outWidth = previewWidth < width ? previewWidth : width;
        int outHeight = previewHeight < height ? previewHeight : height;
        byte[] pixels = new byte[outWidth * outHeight];
        byte[] yuv = yuvData;
        int inputOffset = top * previewWidth + left;
        int y = 0;
        while (y < outHeight) {
            int outputOffset = y * outWidth;
            int x = 0;
            while (x < outWidth) {
                pixels[outputOffset + x] = yuv[inputOffset + x];
                ++x;
            }
            inputOffset += previewWidth;
            ++y;
        }
        return pixels;
    }

    private int[] renderCroppedGreyscaleBitmap(byte[] yuvData, int previewWidth, int previewHeight, int left, int top, int width, int height) {
        int outWidth = previewWidth < width ? previewWidth : width;
        int outHeight = previewHeight < height ? previewHeight : height;
        int[] pixels = new int[outWidth * outHeight];
        byte[] yuv = yuvData;
        int inputOffset = top * previewWidth + left;
        int y = 0;
        while (y < outHeight) {
            int outputOffset = y * outWidth;
            int x = 0;
            while (x < outWidth) {
                int grey = yuv[inputOffset + x] & 0xFF;
                pixels[outputOffset + x] = 0xFF000000 | grey * 65793;
                ++x;
            }
            inputOffset += previewWidth;
            ++y;
        }
        return pixels;
    }

    public Bitmap toBitmapFromCropper(byte[] yuvCropData, int previewWidth, int previewHeight, int width, int height) {
        int outWidth = previewWidth < width ? previewWidth : width;
        int outHeight = previewHeight < height ? previewHeight : height;
        int[] pixels = new int[outWidth * outHeight];
        byte[] yuv = yuvCropData;
        int inputOffset = 0;
        int y = 0;
        while (y < outHeight) {
            int outputOffset = y * outWidth;
            int x = 0;
            while (x < outWidth) {
                int grey = yuv[inputOffset + x] & 0xFF;
                pixels[outputOffset + x] = 0xFF000000 | grey * 65793;
                ++x;
            }
            inputOffset += outWidth;
            ++y;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)outWidth, (int)outHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, outWidth, 0, 0, outWidth, outHeight);
        return bitmap;
    }

    public Bitmap toBitmap(byte[] yuvData, int previewWidth, int previewHeight, int left, int top, int scanWidth, int scanHeight) {
        int[] pixels = this.renderCroppedGreyscaleBitmap(yuvData, previewWidth, previewHeight, left, top, scanWidth, scanHeight);
        Bitmap bitmap = Bitmap.createBitmap((int)scanWidth, (int)scanHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, scanWidth, 0, 0, scanWidth, scanHeight);
        return bitmap;
    }
}

