/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.util;

import android.util.Log;

public class LogUtils {
    private static final String DEBUG_TAG = "LogUtils";
    private static boolean logEnable = false;
    private static int LOG_MAXLENGTH = 1024;

    public static boolean getLogUtilsStatus() {
        return logEnable;
    }

    public static void setLogUtils(boolean Enable) {
        Log.d((String)DEBUG_TAG, (String)("log enable=" + Enable));
        logEnable = Enable;
    }

    public static int v(String tag, String msg) {
        if (logEnable) {
            return Log.v((String)tag, (String)msg);
        }
        return 1;
    }

    public static int d(String tag, String msg) {
        if (logEnable) {
            return Log.d((String)tag, (String)msg);
        }
        return 1;
    }

    public static int i(String tag, String msg) {
        if (logEnable) {
            return Log.i((String)tag, (String)msg);
        }
        return 1;
    }

    public static int w(String tag, String msg) {
        if (logEnable) {
            return Log.w((String)tag, (String)msg);
        }
        return 1;
    }

    public static int e(String tag, String msg) {
        if (logEnable) {
            return Log.e((String)tag, (String)msg);
        }
        return 1;
    }

    public static int e(String tag, String msg, Throwable tr) {
        if (logEnable) {
            return Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        return 1;
    }

    public static void printLargeData(String tag, String msg) {
        int strLength = msg.length();
        int start = 0;
        int end = LOG_MAXLENGTH;
        int i = 0;
        while (i < 100) {
            if (strLength > end) {
                Log.i((String)tag, (String)msg.substring(start, end));
                start = end;
                end += LOG_MAXLENGTH;
            } else {
                Log.i((String)tag, (String)msg.substring(start, strLength));
                break;
            }
            ++i;
        }
    }
}

