/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.util.Log;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;
import com.landicorp.android.scan.util.bmpUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileUtils {
    private static final String TAG = "ScanDecoder_FileUtils";
    private static final String IMG_SAVE_PATH = "/ScanPreview/";
    private static final String IMAGE_FILE_NAME_FORMAT = "yyyyMMdd_HHmmssSSS";
    private static final String SD_PATH = Environment.getExternalStorageDirectory().toString();
    private static final String RESULT_SAVE_PATH = "/DecodeResult/";
    private static final String RESULT_FILE_NAME = "DecodeResult.txt";
    private static final String LANDI_DECODE_CERTIFICATION_DIR = "LandiDecodeCert";

    public static void saveBitmap_pngFormat(Bitmap bitmap, String dir) {
        String path = String.valueOf(SD_PATH) + IMG_SAVE_PATH + dir + "/";
        File savedDir = new File(path);
        if (!savedDir.exists()) {
            savedDir.mkdirs();
        }
        SimpleDateFormat mFormat = new SimpleDateFormat(IMAGE_FILE_NAME_FORMAT);
        Date date = new Date(System.currentTimeMillis());
        String title = mFormat.format(date);
        File file = new File(path, String.valueOf(title) + ".png");
        FileOutputStream fOut = null;
        try {
            try {
                fOut = new FileOutputStream(file);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
                fOut.flush();
            }
            catch (Exception e) {
                LogUtils.e(TAG, "save image fail: " + e);
                try {
                    if (fOut != null) {
                        ((OutputStream)fOut).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fOut != null) {
                    ((OutputStream)fOut).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveBitmap_bmpFormat(Bitmap bitmap, String dir) {
        String path = String.valueOf(SD_PATH) + IMG_SAVE_PATH + dir + "/";
        File savedDir = new File(path);
        if (!savedDir.exists()) {
            savedDir.mkdirs();
        }
        SimpleDateFormat mFormat = new SimpleDateFormat(IMAGE_FILE_NAME_FORMAT);
        Date date = new Date(System.currentTimeMillis());
        String title = mFormat.format(date);
        File file = new File(path, String.valueOf(title) + ".bmp");
        FileOutputStream fOut = null;
        try {
            try {
                fOut = new FileOutputStream(file);
                byte[] buffer = bmpUtil.bitmap2BmpBytes(bitmap);
                ((OutputStream)fOut).write(buffer);
                fOut.flush();
            }
            catch (Exception e) {
                LogUtils.e(TAG, "save image fail: " + e);
                try {
                    if (fOut != null) {
                        ((OutputStream)fOut).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fOut != null) {
                    ((OutputStream)fOut).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveBitmap_absulutePath_bmpFormat(Bitmap bitmap, String dir, String name) {
        String path = String.valueOf(dir) + "/";
        File savedDir = new File(path);
        if (!savedDir.exists()) {
            savedDir.mkdirs();
        }
        String title = name;
        File file = new File(path, String.valueOf(title) + ".bmp");
        FileOutputStream fOut = null;
        try {
            try {
                fOut = new FileOutputStream(file);
                byte[] buffer = bmpUtil.bitmap2BmpBytes(bitmap);
                ((OutputStream)fOut).write(buffer);
                fOut.flush();
            }
            catch (Exception e) {
                LogUtils.e(TAG, "save image fail: " + e);
                try {
                    if (fOut != null) {
                        ((OutputStream)fOut).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fOut != null) {
                    ((OutputStream)fOut).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveRawImg(byte[] imgBuf, String dir, int width, int height, int imgSize) {
        String path = String.valueOf(SD_PATH) + IMG_SAVE_PATH + dir + "/";
        File savedDir = new File(path);
        if (!savedDir.exists()) {
            savedDir.mkdirs();
        }
        SimpleDateFormat mFormat = new SimpleDateFormat(IMAGE_FILE_NAME_FORMAT);
        Date date = new Date(System.currentTimeMillis());
        String title = mFormat.format(date);
        byte[] buffer = new byte[imgSize];
        int i = 0;
        while (i < imgSize) {
            buffer[i] = imgBuf[i];
            ++i;
        }
        File file = new File(path, String.valueOf(title) + "_" + width + "x" + height + ".raw");
        FileOutputStream fOut = null;
        try {
            try {
                fOut = new FileOutputStream(file);
                ((OutputStream)fOut).write(buffer);
                fOut.flush();
            }
            catch (Exception e) {
                LogUtils.e(TAG, "save image fail: " + e);
                try {
                    if (fOut != null) {
                        ((OutputStream)fOut).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fOut != null) {
                    ((OutputStream)fOut).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveRawImg_absulutePath(byte[] imgBuf, String dir, String name, int width, int height, int imgSize) {
        String path = String.valueOf(dir) + "/";
        File savedDir = new File(path);
        if (!savedDir.exists()) {
            savedDir.mkdirs();
        }
        String title = name;
        byte[] buffer = new byte[imgSize];
        int i = 0;
        while (i < imgSize) {
            buffer[i] = imgBuf[i];
            ++i;
        }
        File file = new File(path, String.valueOf(title) + ".raw");
        FileOutputStream fOut = null;
        try {
            try {
                fOut = new FileOutputStream(file);
                ((OutputStream)fOut).write(buffer);
                fOut.flush();
            }
            catch (Exception e) {
                LogUtils.e(TAG, "save image fail: " + e);
                try {
                    if (fOut != null) {
                        ((OutputStream)fOut).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fOut != null) {
                    ((OutputStream)fOut).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveDecodeMsgToFile(boolean isDecoding, int totalTimes, int succTimes, int failTimes) {
        String path = String.valueOf(SD_PATH) + RESULT_SAVE_PATH;
        File savedDir = new File(path);
        if (!savedDir.exists()) {
            savedDir.mkdirs();
        }
        File file = new File(path, RESULT_FILE_NAME);
        String outStr = null;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            outStr = String.format("\t\t\t\t%s\t\t%s\t\t%s\t\t%s", "Time", "TotalDecode", "SuccDecode", "FailDecode");
        } else {
            if (!isDecoding) {
                return;
            }
            SimpleDateFormat mFormat = new SimpleDateFormat(IMAGE_FILE_NAME_FORMAT);
            Date date = new Date(System.currentTimeMillis());
            String time = mFormat.format(date);
            outStr = String.format("%s\t\t%d\t\t\t\t\t%d\t\t\t\t\t\t%d", time, totalTimes, succTimes, failTimes);
        }
        try {
            FileWriter fw = new FileWriter(file, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(outStr);
            bw.newLine();
            bw.flush();
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=9)
    @SuppressLint(value={"NewApi"})
    public static String creatDecodeCertificationDir(Context context) {
        String path = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            LogUtils.d(TAG, "has ExternalStorage");
            path = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + File.separator + LANDI_DECODE_CERTIFICATION_DIR;
        } else {
            LogUtils.d(TAG, "not ExternalStorage, set cer dir to apk dir");
            path = String.valueOf(context.getFilesDir().getAbsolutePath()) + File.separator + LANDI_DECODE_CERTIFICATION_DIR;
        }
        LogUtils.d(TAG, "LandiDecodeCert path=" + path);
        File file = new File(path);
        if (!file.exists()) {
            LogUtils.d(TAG, "dir not exist, creat a new dir");
            file.mkdirs();
        } else {
            LogUtils.d(TAG, "dir exist");
        }
        boolean ret = file.setReadable(true);
        if (ret) {
            LogUtils.d(TAG, "set file readable success");
        } else {
            LogUtils.d(TAG, "set file readable failed");
        }
        ret = file.setWritable(true);
        if (ret) {
            LogUtils.d(TAG, "set file Writable success");
        } else {
            LogUtils.d(TAG, "set file Writable failed");
        }
        return path;
    }

    public static byte[] readFile(String path) {
        FileInputStream is;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "filePath=" + path));
        try {
            is = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "File Not Found"));
            return null;
        }
        int size = 0;
        try {
            size = is.available();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in available()"));
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            return null;
        }
        if (size == 0) {
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            return null;
        }
        byte[] rawFileData = new byte[size];
        int readLen = 0;
        try {
            readLen = is.read(rawFileData);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in read"));
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            return null;
        }
        if (readLen != size) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "file size!=readLen" + ",fileSize=" + size + ",readLen=" + readLen));
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            return null;
        }
        try {
            is.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            return null;
        }
        return rawFileData;
    }

    public static int readFile(String path, byte[] data, int len) {
        FileInputStream is;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "filePath=" + path));
        int ret = 0;
        try {
            is = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "File Not Found"));
            ret = -1;
            return ret;
        }
        int size = 0;
        try {
            size = is.available();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in available()"));
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            ret = -2;
            return ret;
        }
        if (size == 0) {
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            ret = 0;
            return ret;
        }
        byte[] rawFileData = new byte[size];
        int readLen = 0;
        try {
            readLen = is.read(rawFileData);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in read"));
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            ret = -2;
            return ret;
        }
        if (readLen != size) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "file size!=readLen" + ",fileSize=" + size + ",readLen=" + readLen));
            try {
                is.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            }
            ret = -3;
            return ret;
        }
        try {
            is.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "IOException in close"));
            ret = -2;
            return ret;
        }
        ret = readLen < len ? readLen : len;
        int i = 0;
        while (i < ret) {
            data[i] = rawFileData[i];
            ++i;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int writeFile(String path, byte[] data, int len, boolean ifNoExistCreate) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "filePath=" + path));
        char[] writeData = new char[len];
        int i = 0;
        while (i < len) {
            writeData[i] = (char)(data[i] & 0xFF);
            ++i;
        }
        File file = new File(path);
        if (!file.exists()) {
            if (!ifNoExistCreate) return -2;
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + path + " not exist, create it"));
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "createNewFile IOException"));
                return -1;
            }
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + path + " exist, use it"));
        }
        FileUtils.chmod(path);
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(file, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "new FileWriter IOException"));
            return -1;
        }
        bw = new BufferedWriter(fw);
        try {
            bw.write(writeData, 0, len);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "bw.write IOException"));
            try {
                bw.close();
            }
            catch (IOException e1) {
                e.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "bw.close IOException"));
            }
            try {
                fw.close();
                return -1;
            }
            catch (IOException e2) {
                e.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "fw.close IOException"));
            }
            return -1;
        }
        try {
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "bw.flush IOException"));
            try {
                bw.close();
            }
            catch (IOException e1) {
                e.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "bw.close IOException"));
            }
            try {
                fw.close();
                return -1;
            }
            catch (IOException e2) {
                e.printStackTrace();
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "fw.close IOException"));
            }
            return -1;
        }
        try {
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "bw.close IOException"));
        }
        try {
            fw.close();
            return len;
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "fw.close IOException"));
        }
        return len;
    }

    public static void chmod(String Path2) {
        int status = -1;
        try {
            Process p = Runtime.getRuntime().exec("chmod 777 " + Path2);
            status = p.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (status == 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "chmod succeed"));
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "chmod failed"));
        }
    }
}

