/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class CommandExecution {
    public static final String TAG = "ScanDecoder_CommandExecution";
    public static final String COMMAND_SU = "su";
    public static final String COMMAND_SH = "sh";
    public static final String COMMAND_EXIT = "exit\n";
    public static final String COMMAND_LINE_END = "\n";

    public static CommandResult execCommand(String command, boolean isRoot) {
        String[] commands = new String[]{command};
        return CommandExecution.execCommand(commands, isRoot);
    }

    public static CommandResult execCommand(String[] commands, boolean isRoot) {
        CommandResult commandResult = new CommandResult();
        if (commands == null || commands.length == 0) {
            return commandResult;
        }
        Process process = null;
        FilterOutputStream os = null;
        BufferedReader successResult = null;
        BufferedReader errorResult = null;
        StringBuilder successMsg = null;
        StringBuilder errorMsg = null;
        try {
            try {
                String s;
                process = Runtime.getRuntime().exec(isRoot ? COMMAND_SU : COMMAND_SH);
                os = new DataOutputStream(process.getOutputStream());
                String[] stringArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    String command = stringArray[n2];
                    if (command != null) {
                        os.write(command.getBytes());
                        ((DataOutputStream)os).writeBytes(COMMAND_LINE_END);
                        ((DataOutputStream)os).flush();
                    }
                    ++n2;
                }
                ((DataOutputStream)os).writeBytes(COMMAND_EXIT);
                ((DataOutputStream)os).flush();
                commandResult.result = process.waitFor();
                successMsg = new StringBuilder();
                errorMsg = new StringBuilder();
                successResult = new BufferedReader(new InputStreamReader(process.getInputStream()));
                errorResult = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((s = successResult.readLine()) != null) {
                    successMsg.append(s);
                }
                while ((s = errorResult.readLine()) != null) {
                    errorMsg.append(s);
                }
                commandResult.successMsg = successMsg.toString();
                commandResult.errorMsg = errorMsg.toString();
                Log.i((String)TAG, (String)(String.valueOf(commandResult.result) + " | " + commandResult.successMsg + " | " + commandResult.errorMsg));
            }
            catch (IOException e) {
                block39: {
                    String errmsg = e.getMessage();
                    if (errmsg != null) {
                        Log.e((String)TAG, (String)errmsg);
                    } else {
                        e.printStackTrace();
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                        if (successResult != null) {
                            successResult.close();
                        }
                        if (errorResult != null) {
                            errorResult.close();
                        }
                    }
                    catch (IOException e2) {
                        String errmsg2 = e2.getMessage();
                        if (errmsg2 != null) {
                            Log.e((String)TAG, (String)errmsg2);
                            break block39;
                        }
                        e2.printStackTrace();
                    }
                }
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Exception e) {
                block41: {
                    block40: {
                        String errmsg = e.getMessage();
                        if (errmsg != null) {
                            Log.e((String)TAG, (String)errmsg);
                            break block40;
                        }
                        e.printStackTrace();
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                        if (successResult != null) {
                            successResult.close();
                        }
                        if (errorResult != null) {
                            errorResult.close();
                        }
                    }
                    catch (IOException e3) {
                        String errmsg = e3.getMessage();
                        if (errmsg != null) {
                            Log.e((String)TAG, (String)errmsg);
                            break block41;
                        }
                        e3.printStackTrace();
                    }
                }
                if (process != null) {
                    process.destroy();
                }
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (successResult != null) {
                    successResult.close();
                }
                if (errorResult != null) {
                    errorResult.close();
                }
            }
            catch (IOException e) {
                String errmsg = e.getMessage();
                if (errmsg != null) {
                    Log.e((String)TAG, (String)errmsg);
                }
                e.printStackTrace();
            }
            if (process != null) {
                process.destroy();
            }
        }
        return commandResult;
    }

    public static class CommandResult {
        public int result = -1;
        public String errorMsg;
        public String successMsg;
    }
}

