/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.scanDecoder;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.landicorp.android.scan.camera.CameraManager;
import com.landicorp.android.scan.decode.CaptureActivityHandler;
import com.landicorp.android.scan.decode.Result;
import com.landicorp.android.scan.decode.nativeMethod;
import com.landicorp.android.scan.scanDecoder.CaptureActivity;
import com.landicorp.android.scan.scanDecoder.DecodeProperty;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.scanDecoder.ScanDecoder;
import com.landicorp.android.scan.scanDecoder.ScanDecoderParameter;
import com.landicorp.android.scan.util.FileUtils;
import com.landicorp.android.scan.util.Util;
import java.io.IOException;

public class ScanModule_internal {
    private static final String TAG = "ScanDecoder_ScanModule_internal";
    private nativeMethod mNativeMethod = null;
    private boolean inited = false;
    private ScanDecoder.ResultCallback mResultCallback = null;
    private CaptureActivityHandler mCaptureActivityHandler;
    private static ScanModule_internal mScanModule_internal = null;
    private int mCameraID = 1;
    private byte[] mDecodeResultBytes = null;
    private int mDecodeLength = 0;
    private int mCodeType = -1;

    protected static ScanModule_internal getInstance() {
        if (mScanModule_internal == null) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mScanModule_internal=null, create it"));
            mScanModule_internal = new ScanModule_internal();
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mScanModule_internal exist, use it"));
        }
        return mScanModule_internal;
    }

    private int init_internal(int cameraID, ScanDecoder.ResultCallback cb) {
        int ret = 0;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule Version=" + ScanDecoder.version));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule init"));
        if (this.inited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "you has inited once"));
            return 2;
        }
        this.mCameraID = cameraID;
        this.mResultCallback = cb;
        int frontCameraID = 1;
        if (this.mCameraID == 1) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "open front camera"));
            byte[] data = new byte[10];
            int i = 0;
            while (i < data.length) {
                data[i] = 0;
                ++i;
            }
            int len = FileUtils.readFile("/usr/sysdata/roprvpara/scanmodule_id", data, data.length);
            if (len <= 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", set frontCameraID to default 1"));
                frontCameraID = 1;
            } else {
                frontCameraID = data[0] - 48;
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", set frontCameraID to " + frontCameraID));
            }
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "open back camera"));
            ScanDecoder.setBackCameraScanPar(1);
            frontCameraID = 0;
        }
        try {
            ret = CameraManager.openCamera(frontCameraID);
        }
        catch (IOException e) {
            e.printStackTrace();
            ret = 1;
        }
        if (ret != 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "open camera failed"));
            return 3;
        }
        ScanDecoderParameter.setMaxDecodeCounts(55);
        this.mNativeMethod = nativeMethod.getInstance();
        int jniLibVer = 0;
        try {
            jniLibVer = this.mNativeMethod.GetJniLibVersion(0);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for GetJniLibVersion"));
            jniLibVer = 0;
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "jniLibVer=" + jniLibVer));
        ScanDecoderParameter.setJniLibVersion(jniLibVer);
        if (jniLibVer < 1130225) {
            ScanDecoderParameter.setBeepMode(this.mNativeMethod.GetBeepMode(1));
        } else {
            ScanDecoderParameter.setBeepMode(this.mNativeMethod.GetBeepMode(0));
        }
        if (jniLibVer < 1210614) {
            ScanDecoderParameter.EnableCodeOrder();
        }
        ret = this.mNativeMethod.InitDecoder(0, ScanDecoderParameter.getMaxDecodeCounts(), null);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NativeInitDecoder ret=" + ret));
        if (ret != 0) {
            CaptureActivity.closeCamera();
            if (ret == 4) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "activate license failed"));
                return 4;
            }
            if (ret == 20) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "can not find correct decode lib"));
                return 5;
            }
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mNativeMethod.InitDecoder failed"));
            return 1;
        }
        if (jniLibVer >= 1210614 && (ret = ScanDecoderParameter.enableDefaultCode()) != 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoderParameter.enableDefaultCode failed"));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            CameraManager.closeDriver();
            CameraManager.exit();
            ret = DecodeProperty.resetAllProperty();
            if (ret != 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "exit disableAll failed"));
                Log.e((String)TAG, (String)("resetAllProperty ret=" + ret));
            }
            this.mNativeMethod.ExitDecoder(0);
            return 6;
        }
        this.inited = true;
        return 0;
    }

    protected synchronized int init(ScanDecoder.ResultCallback cb) {
        ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        return this.init_internal(1, cb);
    }

    protected synchronized int init(int cameraID, ScanDecoder.ResultCallback cb) {
        ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        return this.init_internal(cameraID, cb);
    }

    protected synchronized int init(ScanDecoder.ResultCallback cb, Boolean enable_1d, Boolean enable_2d) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "init(ResultCallback cb, char enable_1d, char enable_2d) begin"));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable_1d=" + enable_1d + ",enable_2d=" + enable_2d));
        if (enable_1d.booleanValue() && !enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_1D);
        } else if (!enable_1d.booleanValue() && enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_2D);
        } else {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        }
        return this.init_internal(1, cb);
    }

    protected synchronized int init(int cameraID, ScanDecoder.ResultCallback cb, Boolean enable_1d, Boolean enable_2d) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "init(ResultCallback cb, char enable_1d, char enable_2d) begin"));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable_1d=" + enable_1d + ",enable_2d=" + enable_2d));
        if (enable_1d.booleanValue() && !enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_1D);
        } else if (!enable_1d.booleanValue() && enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_2D);
        } else {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        }
        return this.init_internal(cameraID, cb);
    }

    protected synchronized int startScan_internal(Context context) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule startScan_internal"));
        if (!this.inited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule no init"));
            return 1;
        }
        PreferencesManager.setFrontFaceCamera(true);
        PreferencesManager.setTestMode(false);
        PreferencesManager.setShouldPlayBeep(false);
        PreferencesManager.setShouldVibrate(false);
        PreferencesManager.setContinuousScan(false);
        PreferencesManager.setFlashLight(false);
        PreferencesManager.setUseGifPicture(false);
        PreferencesManager.setNoPreview(true);
        PreferencesManager.setOnlyPreview(false);
        PreferencesManager.setShowResult(false);
        PreferencesManager.setSaveBitmapJustOnce(false);
        PreferencesManager.setSaveBitmapContinuous(false);
        PreferencesManager.setSaveBitmapOnSuccessful(false);
        if (this.mCameraID == 1) {
            PreferencesManager.setFrontCameraPreviewSize("640x480");
            PreferencesManager.setFocusMode("fixed");
        } else {
            PreferencesManager.setFrontCameraPreviewSize("1280x720");
            PreferencesManager.setFocusMode("fixed");
        }
        PreferencesManager.setBackCameraPreviewSize("1280x720");
        PreferencesManager.setPreviewCutSize("640x480");
        PreferencesManager.setExposureCompensationIndex("0");
        PreferencesManager.setScanModuleMode(true);
        CameraManager.init(context);
        this.mCodeType = -1;
        try {
            CameraManager.get().openDriver(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return 2;
        }
        if (this.mCaptureActivityHandler == null) {
            this.mCaptureActivityHandler = new CaptureActivityHandler(this, Looper.getMainLooper());
        }
        return 0;
    }

    protected synchronized int startScan(Context context) {
        int ret = 0;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule startScan"));
        PreferencesManager.setLaserLineDecodeFlag(false);
        ret = this.startScan_internal(context);
        return ret;
    }

    protected synchronized int startScan_laser(Context context) {
        int ret = 0;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule startScan_laser"));
        PreferencesManager.setLaserLineDecodeFlag(true);
        ret = this.startScan_internal(context);
        if (ret != 0) {
            PreferencesManager.setLaserLineDecodeFlag(false);
        }
        return ret;
    }

    protected synchronized int stopScan() {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule stopScan"));
        if (!this.inited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule no init"));
            return 1;
        }
        if (this.mCaptureActivityHandler != null) {
            this.mCaptureActivityHandler.quitSynchronously();
            this.mCaptureActivityHandler = null;
        }
        PreferencesManager.setLaserLineDecodeFlag(false);
        return 0;
    }

    protected synchronized void exit() {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule exit"));
        if (this.inited) {
            this.stopScan();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            CameraManager.closeDriver();
            CameraManager.exit();
            int ret = DecodeProperty.resetAllProperty();
            if (ret != 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "exit disableAll failed"));
                Log.e((String)TAG, (String)("resetAllProperty ret=" + ret));
            }
            this.mNativeMethod.ExitDecoder(0);
            if (this.mCameraID == 0) {
                ScanDecoder.setBackCameraScanPar(0);
            }
            PreferencesManager.setLaserLineDecodeFlag(false);
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanModule no init"));
        }
        this.inited = false;
    }

    public Handler getHandler() {
        return this.mCaptureActivityHandler;
    }

    private void restartPreviewAfterDelay(long delayMS) {
        if (this.mCaptureActivityHandler != null) {
            this.mCaptureActivityHandler.sendEmptyMessageDelayed(101, delayMS);
        }
    }

    public void decodeSuccessful_Callback(Result rawResult, int preview_counts, int success_counts, int fail_counts, int jni_cost_time, int scanAndDecodeTime) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "decodeSuccessful_Callback"));
        int jniLibVer = ScanDecoderParameter.getJniLibVersion();
        this.mCodeType = jniLibVer < 1140511 ? -2 : rawResult.getCodeType();
        this.mDecodeLength = rawResult.getmDecodeLenght();
        this.mDecodeResultBytes = rawResult.getmBarcodeBytes();
        if (PreferencesManager.getContinuousScan()) {
            this.restartPreviewAfterDelay(0L);
        } else {
            if (this.mCaptureActivityHandler != null) {
                this.mCaptureActivityHandler.quitSynchronously();
                this.mCaptureActivityHandler = null;
            }
            if (this.mResultCallback != null) {
                this.mResultCallback.onResult(rawResult.getmBarcodeText());
            }
        }
    }

    public void displayDecodeResult(Boolean decodeSuccess, byte[] RawImg, int ImgWidth, int ImgHeight, int preview_counts, int success_counts, int fail_counts, int jni_cost_time, int scanAndDecodeTime) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "displayDecodeResult"));
    }

    public void displayPreveiwCounts(int preview_counts) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "displayPreveiwCounts"));
    }

    protected int getCodeType() {
        return this.mCodeType;
    }

    protected byte[] getDecodeResultBytes() {
        return this.mDecodeResultBytes;
    }

    protected int getDecodeResultLength() {
        return this.mDecodeLength;
    }

    protected void enableBeep(boolean enable) {
        nativeMethod mNativeMethod = null;
        mNativeMethod = nativeMethod.getInstance();
        if (!enable) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "disable beep"));
            ScanDecoderParameter.setBeepMode(mNativeMethod.GetBeepMode(1));
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable beep"));
            ScanDecoderParameter.setBeepMode(mNativeMethod.GetBeepMode(0));
        }
    }
}

