/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.scanDecoder;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import com.landicorp.android.scan.decode.nativeMethod;
import com.landicorp.android.scan.scanDecoder.CaptureActivity;
import com.landicorp.android.scan.scanDecoder.DecodeProperty;
import com.landicorp.android.scan.scanDecoder.ScanDecoder;
import com.landicorp.android.scan.scanDecoder.ScanDecoderParameter;
import com.landicorp.android.scan.util.FileUtils;
import com.landicorp.android.scan.util.Util;
import com.landicorp.android.scanview.ScanLayout;
import java.util.ArrayList;
import java.util.Map;

public class ScanDecoder_internal {
    private static final String TAG = "ScanDecoder_internal";
    private nativeMethod mNativeMethod = null;
    private boolean createSuccess = false;
    private int mFlashLight = 0;
    private static ScanDecoder_internal instance = null;

    protected ScanDecoder_internal() {
    }

    protected static ScanDecoder_internal getInstance() {
        if (instance == null) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder_internal=null, create it"));
            instance = new ScanDecoder_internal();
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder_internal exist, use it"));
        }
        return instance;
    }

    private int Create_internal(int cameraID, ScanDecoder.ResultCallback cb) {
        int ret = 0;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder Version=" + ScanDecoder.version));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Create ScanDecoder"));
        if (this.createSuccess) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "you has Created once"));
            return 2;
        }
        CaptureActivity.setResultCallback(cb);
        if (cameraID == 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "open back camera"));
            ret = CaptureActivity.openCamera(0);
            ScanDecoderParameter.setMaxDecodeCounts(100);
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "open front camera"));
            int frontCameraID = 1;
            byte[] data = new byte[10];
            int i = 0;
            while (i < data.length) {
                data[i] = 0;
                ++i;
            }
            int len = FileUtils.readFile("/usr/sysdata/roprvpara/scanmodule_id", data, data.length);
            if (len <= 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", set frontCameraID to default 1"));
                frontCameraID = 1;
            } else {
                frontCameraID = data[0] - 48;
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", set frontCameraID to " + frontCameraID));
            }
            ret = CaptureActivity.openCamera(frontCameraID);
            ScanDecoderParameter.setMaxDecodeCounts(55);
        }
        if (ret != 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "open camera failed"));
            return 3;
        }
        this.mNativeMethod = nativeMethod.getInstance();
        int jniLibVer = 0;
        try {
            jniLibVer = this.mNativeMethod.GetJniLibVersion(0);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for GetJniLibVersion"));
            jniLibVer = 0;
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "jniLibVer=" + jniLibVer));
        ScanDecoderParameter.setJniLibVersion(jniLibVer);
        if (jniLibVer < 1130225) {
            ScanDecoderParameter.setBeepMode(this.mNativeMethod.GetBeepMode(1));
        } else {
            ScanDecoderParameter.setBeepMode(this.mNativeMethod.GetBeepMode(0));
        }
        if (jniLibVer < 1210614) {
            ScanDecoderParameter.EnableCodeOrder();
        }
        ret = this.mNativeMethod.InitDecoder(0, ScanDecoderParameter.getMaxDecodeCounts(), null);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NativeInitDecoder ret=" + ret));
        if (ret != 0) {
            CaptureActivity.closeCamera();
            if (ret == 4) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "activate license failed"));
                return 4;
            }
            if (ret == 20) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "can not find correct decode lib"));
                return 5;
            }
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mNativeMethod.InitDecoder failed"));
            return 1;
        }
        if (jniLibVer >= 1210614 && (ret = ScanDecoderParameter.enableDefaultCode()) != 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoderParameter.enableDefaultCode failed"));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            CaptureActivity.closeCamera();
            ret = DecodeProperty.resetAllProperty();
            if (ret != 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "exit disableAll failed"));
                Log.e((String)TAG, (String)("resetAllProperty ret=" + ret));
            }
            this.mNativeMethod.ExitDecoder(0);
            return 6;
        }
        this.createSuccess = true;
        return 0;
    }

    protected synchronized int Create(int cameraID, ScanDecoder.ResultCallback cb) {
        ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        return this.Create_internal(cameraID, cb);
    }

    protected synchronized int Create(int cameraID, ScanDecoder.ResultCallback cb, Boolean enable_1d, Boolean enable_2d) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Create(int cameraID, ResultCallback cb, char enable_1d, char enable_2d) begin"));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable_1d=" + enable_1d + ",enable_2d=" + enable_2d));
        if (enable_1d.booleanValue() && !enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_1D);
        } else if (!enable_1d.booleanValue() && enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_2D);
        } else {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        }
        return this.Create_internal(cameraID, cb);
    }

    protected synchronized int Create(int cameraID, ScanDecoder.ResultCallback cb, int flashLight) {
        int ret = 0;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Create(int cameraID, ResultCallback cb, int flashLight) begin"));
        this.mFlashLight = flashLight;
        ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        ret = this.Create_internal(cameraID, cb);
        if (ret != 0) {
            this.mFlashLight = 0;
        }
        return ret;
    }

    protected synchronized int startScanDecode(Activity activity, Map<String, String> par, ArrayList<View> viewList) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder Version=" + ScanDecoder.version));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "startScanDecode(activity, par, viewList)"));
        ScanLayout.setViewList(viewList);
        return this.startScanDecode(activity, par);
    }

    protected synchronized int startScanDecode(Activity activity, Map<String, String> par) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder Version=" + ScanDecoder.version));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "startScanDecode(activity, par)"));
        if (!this.createSuccess) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder no create"));
            return 1;
        }
        Intent intent = new Intent((Context)activity, CaptureActivity.class);
        if (par != null) {
            String strParTimeout_value;
            String strParDevelopTest_value = par.get("PAR_DEVELOP_TEST");
            if (strParDevelopTest_value != null) {
                int iParDevelopTest_value = Integer.parseInt(strParDevelopTest_value);
                intent.putExtra("PAR_DEVELOP_TEST", iParDevelopTest_value);
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "open develop test mode"));
            }
            if ((strParTimeout_value = par.get("PAR_SCAN_TIMEOUT")) != null) {
                int iParTimeout_value = Integer.parseInt(strParTimeout_value);
                intent.putExtra("PAR_SCAN_TIMEOUT", iParTimeout_value);
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "scanTimeout=" + iParTimeout_value));
            }
        }
        intent.putExtra("PAR_FLASH_LIGHT", this.mFlashLight);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mFlashLight=" + this.mFlashLight));
        activity.startActivityForResult(intent, 1001);
        return 0;
    }

    protected synchronized void Destroy() {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder Version=" + ScanDecoder.version));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Destroy ScanDecoder"));
        if (this.createSuccess) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            CaptureActivity.closeCamera();
            int ret = DecodeProperty.resetAllProperty();
            if (ret != 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "exit disableAll failed"));
                Log.e((String)TAG, (String)("resetAllProperty ret=" + ret));
            }
            this.mNativeMethod.ExitDecoder(0);
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoder no create"));
        }
        this.createSuccess = false;
        this.mFlashLight = 0;
    }

    protected int getCodeType() {
        return CaptureActivity.getCodeType();
    }

    protected byte[] getDecodeResultBytes() {
        return CaptureActivity.getDecodeResultBytes();
    }

    protected int getDecodeResultLength() {
        return CaptureActivity.getDecodeResultLength();
    }

    protected int getDecodeLibID() {
        this.mNativeMethod = nativeMethod.getInstance();
        int decodeLibId = 0;
        try {
            decodeLibId = this.mNativeMethod.GetDecodeLibID(0);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for GetDecodeLibID"));
            decodeLibId = 0;
        }
        return decodeLibId;
    }

    protected void enableBeep(boolean enable) {
        nativeMethod mNativeMethod = null;
        mNativeMethod = nativeMethod.getInstance();
        if (!enable) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "disable beep"));
            ScanDecoderParameter.setBeepMode(mNativeMethod.GetBeepMode(1));
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable beep"));
            ScanDecoderParameter.setBeepMode(mNativeMethod.GetBeepMode(0));
        }
    }
}

