/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.scanDecoder;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import com.landicorp.android.scan.scanDecoder.ScanDecoder_internal;
import com.landicorp.android.scan.util.CommandExecution;
import com.landicorp.android.scan.util.FileUtils;
import com.landicorp.android.scan.util.Util;
import java.util.ArrayList;
import java.util.Map;

public class ScanDecoder {
    private static final String TAG = "ScanDecoder";
    public static final int CAMERA_ID_BACK = 0;
    public static final int CAMERA_ID_FRONT = 1;
    public static final String PAR_SCAN_TIMEOUT = "PAR_SCAN_TIMEOUT";
    public static final String PAR_FLASH_LIGHT = "PAR_FLASH_LIGHT";
    public static final int BACK_CAMERA_PAR_PHOTO_MODE = 0;
    public static final int BACK_CAMERA_PAR_SCAN_MODE = 1;
    public static String version = "v1.2.6.0807";
    public static final int FLASH_LIGHT_DEFAULT = -1;
    public static final int FLASH_LIGHT_DISABLE = 0;
    public static final int FLASH_LIGHT_ENABLE = 1;
    private boolean bLaserLineOn = false;

    public ScanDecoder(Context context) {
    }

    public ScanDecoder() {
    }

    public int Create(int cameraID, ResultCallback cb, int flashLight) {
        return ScanDecoder_internal.getInstance().Create(cameraID, cb, flashLight);
    }

    public int Create(int cameraID, ResultCallback cb) {
        return ScanDecoder_internal.getInstance().Create(cameraID, cb);
    }

    public int Create(int cameraID, ResultCallback cb, Boolean enable_1d, Boolean enable_2d) {
        return ScanDecoder_internal.getInstance().Create(cameraID, cb, enable_1d, enable_2d);
    }

    public int startScanDecode(Activity activity, Map<String, String> par, ArrayList<View> viewList) {
        return ScanDecoder_internal.getInstance().startScanDecode(activity, par, viewList);
    }

    public int startScanDecode(Activity activity, Map<String, String> par) {
        return ScanDecoder_internal.getInstance().startScanDecode(activity, par);
    }

    public void Destroy() {
        ScanDecoder_internal.getInstance().Destroy();
    }

    public static String getVesion() {
        return version;
    }

    public int setLedFlash(boolean on) {
        byte[] data = new byte[5];
        int i = 0;
        while (i < data.length) {
            data[i] = 0;
            ++i;
        }
        data[0] = on ? 49 : 48;
        int len = FileUtils.writeFile("/sys/kernel/debug/ledflash", data, 1, false);
        if (len <= 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", writeFile (/sys/kernel/debug/ledflash) failed!"));
            return -1;
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", writeFile (/sys/kernel/debug/ledflash) successful!"));
        return 0;
    }

    public int setLaserLine(boolean on) {
        byte[] data = new byte[5];
        int i = 0;
        while (i < data.length) {
            data[i] = 0;
            ++i;
        }
        if (on) {
            this.bLaserLineOn = true;
            LaserLine mExchangeThread = new LaserLine();
            mExchangeThread.start();
        } else {
            this.bLaserLineOn = false;
            data[0] = 48;
        }
        int len = FileUtils.writeFile("/proc/redled", data, 1, false);
        if (len <= 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", writeFile (/proc/redled) failed!"));
            return -1;
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", writeFile (/proc/redled) successful!"));
        return 0;
    }

    public static int setBackCameraScanPar(int par) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "par=" + par));
        CommandExecution.CommandResult cr = par == 1 ? CommandExecution.execCommand("setprop persist.camera.scan.enable 1", false) : CommandExecution.execCommand("setprop persist.camera.scan.enable 0", false);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "CommandResult:result=" + cr.result + ",successMsg=" + cr.successMsg + ",errorMsg=" + cr.errorMsg));
        return 0;
    }

    public int getCodeType() {
        return ScanDecoder_internal.getInstance().getCodeType();
    }

    public byte[] getDecodeResultBytes() {
        return ScanDecoder_internal.getInstance().getDecodeResultBytes();
    }

    public int getDecodeResultLength() {
        return ScanDecoder_internal.getInstance().getDecodeResultLength();
    }

    public int getDecodeLibID() {
        return ScanDecoder_internal.getInstance().getDecodeLibID();
    }

    public void enableBeep(boolean enable) {
        ScanDecoder_internal.getInstance().enableBeep(enable);
    }

    private class LaserLine
    extends Thread {
        @Override
        public void run() {
            byte[] data = new byte[5];
            int len = 0;
            while (ScanDecoder.this.bLaserLineOn) {
                data[0] = 49;
                len = FileUtils.writeFile("/proc/redled", data, 1, false);
                if (len <= 0) {
                    Log.i((String)ScanDecoder.TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", writeFile (/proc/redled) failed!"));
                    break;
                }
                try {
                    Thread.sleep(60L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                data[0] = 48;
                len = FileUtils.writeFile("/proc/redled", data, 1, false);
                if (len <= 0) {
                    Log.i((String)ScanDecoder.TAG, (String)(String.valueOf(Util.getMethodLine()) + "len=" + len + ", writeFile (/proc/redled) failed!"));
                    break;
                }
                try {
                    Thread.sleep(60L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface ResultCallback {
        public void onResult(String var1);

        public void onCancel();

        public void onTimeout();
    }
}

