/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.scanDecoder;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.landicorp.android.scan.camera.CameraManager;
import com.landicorp.android.scan.decode.CaptureActivityHandler;
import com.landicorp.android.scan.decode.Result;
import com.landicorp.android.scan.scanDecoder.BeepManager;
import com.landicorp.android.scan.scanDecoder.CodeType;
import com.landicorp.android.scan.scanDecoder.GlobalState;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.scanDecoder.ScanDecoder;
import com.landicorp.android.scan.scanDecoder.ScanDecoderParameter;
import com.landicorp.android.scan.scanDecoder.SettingsActivity;
import com.landicorp.android.scan.util.FileUtils;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;
import com.landicorp.android.scanview.GifView;
import com.landicorp.android.scanview.ScanLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=9)
public class CaptureActivity
extends Activity
implements SurfaceHolder.Callback {
    private static final String TAG = "ScanDecoder_CaptureActivity";
    public static final int REQUEST_CODE_SCAN_DECODE = 1001;
    public static final String RESULT_CODE_SCAN_DECODE_TEXT = "scan decode result text";
    public static List<String> continueResultArray = new ArrayList<String>();
    public static long continueTimeMs = 0L;
    private long continue_start_1 = 0L;
    private long continue_end_1 = 0L;
    private CaptureActivityHandler mCaptureActivityHandler;
    private boolean hasSurface;
    private ScanLayout mScanLayout;
    private View resultView;
    private View buttonView;
    private TextView TextView_resultText;
    private BeepManager beepManager;
    public static boolean bContinuousScan = false;
    private static String decodeResultCmpStr = null;
    private static boolean bSaveImgCmpErr = false;
    private String barcodeText = "";
    private int decodeLenght = 0;
    private long start = 0L;
    private long end = 0L;
    private byte[] mRawImg;
    private int mImgWidth;
    private int mImgHeight;
    private Lock mBitmapLock = null;
    private static Boolean mFrontFaceCamera = false;
    private int iDevelopTest = 0;
    private int menu_settings_id;
    private int btnReScan_id;
    private int btnSaveIMG_id;
    private int scan_decoder_setting_preference_id;
    private int scan_decoder_settings_id;
    private int scan_layout_id;
    private int result_view_id;
    private int button_view_id;
    private int result_text_id;
    private int capture_preview_id;
    private int gif_id;
    private int scan_raw_id;
    private GifView gifView;
    public static ScanDecoder.ResultCallback resultCb = null;
    private Timer mScanTimeoutTimer = null;
    private long mScanTimeout = 0L;
    private int mFlashLight = -1;
    private static byte[] mDecodeResultBytes = null;
    private static int mDecodeLength = 0;
    private static int mCodeType = -1;
    private long start_1 = 0L;
    private long end_1 = 0L;
    private View.OnClickListener btnClick = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getId() == CaptureActivity.this.btnReScan_id) {
                LogUtils.i(CaptureActivity.TAG, String.valueOf(Util.getMethodLine()) + "btnReScan");
                CaptureActivity.this.restartPreviewAfterDelay(0L);
            } else if (v.getId() == CaptureActivity.this.btnSaveIMG_id) {
                LogUtils.i(CaptureActivity.TAG, String.valueOf(Util.getMethodLine()) + "btnSaveIMG");
                CaptureActivity.this.stopPreviewAfterDelay(0L);
                CaptureActivity.this.mBitmapLock.lock();
                if (CaptureActivity.this.mRawImg != null) {
                    FileUtils.saveRawImg(CaptureActivity.this.mRawImg, "JustOnce", CaptureActivity.this.mImgWidth, CaptureActivity.this.mImgHeight, CaptureActivity.this.mImgWidth * CaptureActivity.this.mImgHeight);
                }
                CaptureActivity.this.mBitmapLock.unlock();
            }
        }
    };
    public static CaptureActivity instance;
    public static boolean isInitSelf;
    public boolean inited = false;

    static {
        isInitSelf = true;
    }

    public void onCreate(Bundle savedInstanceState) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        this.start_1 = System.currentTimeMillis();
        this.setTheme(16973831);
        this.getWindow().addFlags(128);
        this.getWindow().setFlags(1024, 1024);
        this.requestWindowFeature(1);
        this.menu_settings_id = GlobalState.getResId(this.getApplicationContext(), "id", "menu_settings");
        this.btnReScan_id = GlobalState.getResId(this.getApplicationContext(), "id", "btnReScan");
        this.btnSaveIMG_id = GlobalState.getResId(this.getApplicationContext(), "id", "btnSaveIMG");
        this.scan_decoder_setting_preference_id = GlobalState.getResId(this.getApplicationContext(), "xml", "scan_decoder_setting_preference");
        this.scan_decoder_settings_id = GlobalState.getResId(this.getApplicationContext(), "menu", "scan_decoder_settings");
        this.scan_layout_id = GlobalState.getResId(this.getApplicationContext(), "layout", "scan_layout");
        this.result_view_id = GlobalState.getResId(this.getApplicationContext(), "id", "result_view");
        this.button_view_id = GlobalState.getResId(this.getApplicationContext(), "id", "button_view");
        this.result_text_id = GlobalState.getResId(this.getApplicationContext(), "id", "result_text");
        this.capture_preview_id = GlobalState.getResId(this.getApplicationContext(), "id", "capture_preview");
        this.gif_id = GlobalState.getResId(this.getApplicationContext(), "id", "gif");
        this.scan_raw_id = GlobalState.getResId(this.getApplicationContext(), "raw", "scan");
        PreferenceManager.setDefaultValues((Context)this, (int)this.scan_decoder_setting_preference_id, (boolean)true);
        this.mScanLayout = (ScanLayout)this.findViewById(GlobalState.getResId(this.getApplicationContext(), "id", "scanLayout"));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mScanLayout=" + (Object)((Object)this.mScanLayout) + ",id=" + GlobalState.getResId(this.getApplicationContext(), "id", "scanLayout")));
        this.beepManager = new BeepManager(this);
        Intent intent = this.getIntent();
        this.iDevelopTest = intent.getIntExtra("PAR_DEVELOP_TEST", 0);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + ",iDevelopTest=" + this.iDevelopTest));
        if (this.iDevelopTest == 0) {
            PreferencesManager.writeTestMode2XML(this, false);
        } else {
            PreferencesManager.writeTestMode2XML(this, true);
        }
        this.mScanTimeout = intent.getIntExtra("PAR_SCAN_TIMEOUT", 0);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + ",mScanTimeout=" + this.mScanTimeout));
        this.mFlashLight = intent.getIntExtra("PAR_FLASH_LIGHT", -1);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + ",mFlashLight=" + this.mFlashLight));
        if (this.mFlashLight == 1) {
            PreferencesManager.writeFlashLight2XML(this, true);
        } else if (this.mFlashLight == 0) {
            PreferencesManager.writeFlashLight2XML(this, false);
        }
        PreferencesManager.writeFrontFaceCamera2XML(this, mFrontFaceCamera);
        CameraManager.init((Context)this.getApplication(), this);
        this.hasSurface = false;
        if (this.mScanTimeout != 0L) {
            if (this.mScanTimeoutTimer != null) {
                this.mScanTimeoutTimer.cancel();
                this.mScanTimeoutTimer = null;
            }
            this.mScanTimeoutTimer = new Timer();
            this.mScanTimeoutTimer.schedule((TimerTask)new ScanTimeoutTask(), this.mScanTimeout);
        }
        instance = this;
        super.onCreate(savedInstanceState);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        if (this.iDevelopTest == 1) {
            MenuInflater menuInflater = this.getMenuInflater();
            menuInflater.inflate(this.scan_decoder_settings_id, menu2);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        menu2.clear();
        if (this.iDevelopTest == 1) {
            MenuInflater inflater = this.getMenuInflater();
            inflater.inflate(this.scan_decoder_settings_id, menu2);
            ScanLayout.setRemoveViewFlag(false);
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    private CharSequence[] getSupportPreviewCutSizes() {
        CharSequence[] PreviewCutSizes = null;
        PreviewCutSizes = new CharSequence[]{"640x480", "400x400"};
        return PreviewCutSizes;
    }

    private String getCurrentPreviewCutSize() {
        String PreviewCutSize = null;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        PreviewCutSize = prefs.getString("preview_cut_size", null);
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "CurrentPreviewCutSize=" + PreviewCutSize);
        return PreviewCutSize;
    }

    private CharSequence[] getSupportPreviewSize() {
        Camera camera = CameraManager.get().getCamera();
        CharSequence[] prevewSizes = null;
        if (camera != null) {
            List previewList = camera.getParameters().getSupportedPreviewSizes();
            prevewSizes = new CharSequence[previewList.size()];
            int i = 0;
            while (i < previewList.size()) {
                Camera.Size size = (Camera.Size)previewList.get(i);
                String tmp = String.valueOf(String.valueOf(size.width)) + "x" + String.valueOf(size.height);
                prevewSizes[i] = tmp;
                ++i;
            }
        } else {
            LogUtils.e(TAG, String.valueOf(Util.getMethodLine()) + "camera=null");
        }
        return prevewSizes;
    }

    private String getDefaultPreviewSize() {
        Point point = CameraManager.get().getDefaultPreviewSize();
        if (point == null) {
            LogUtils.e(TAG, String.valueOf(Util.getMethodLine()) + "point=null");
            return null;
        }
        String defaultSize = String.valueOf(String.valueOf(point.x)) + "x" + String.valueOf(point.y);
        return defaultSize;
    }

    private String getBestPreviewSize() {
        Point point = CameraManager.get().getBestPreviewSize();
        if (point == null) {
            LogUtils.e(TAG, String.valueOf(Util.getMethodLine()) + "point=null");
            return null;
        }
        String bestSize = String.valueOf(String.valueOf(point.x)) + "x" + String.valueOf(point.y);
        return bestSize;
    }

    private CharSequence[] getSupportFocusModes() {
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "FOCUS_MODE_AUTO=" + "auto" + ",FOCUS_MODE_INFINITY=" + "infinity" + ",FOCUS_MODE_MACRO=" + "macro" + ",FOCUS_MODE_FIXED=" + "fixed" + ",FOCUS_MODE_EDOF=" + "edof" + ",FOCUS_MODE_CONTINUOUS_VIDEO=" + "continuous-video");
        Camera camera = CameraManager.get().getCamera();
        CharSequence[] focusModes = null;
        if (camera != null) {
            List focusModesList = camera.getParameters().getSupportedFocusModes();
            focusModes = new CharSequence[focusModesList.size()];
            int i = 0;
            while (i < focusModesList.size()) {
                String mode = (String)focusModesList.get(i);
                focusModes[i] = mode;
                ++i;
            }
        } else {
            LogUtils.e(TAG, String.valueOf(Util.getMethodLine()) + "camera=null");
        }
        return focusModes;
    }

    private String getCurrentFocusMode() {
        Camera camera = CameraManager.get().getCamera();
        String focusMode = null;
        if (camera != null) {
            focusMode = camera.getParameters().getFocusMode();
            LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "CurrentFocusMode=" + focusMode);
        } else {
            LogUtils.e(TAG, String.valueOf(Util.getMethodLine()) + "camera=null");
        }
        return focusMode;
    }

    private CharSequence[] getSupportExposureCompensationIndexs() {
        Camera camera = CameraManager.get().getCamera();
        CharSequence[] ExposureCompensationIndexs = null;
        if (camera != null) {
            int MinExposureCompensationIndex = camera.getParameters().getMinExposureCompensation();
            int MaxExposureCompensationIndex = camera.getParameters().getMaxExposureCompensation();
            float ExposureCompensationStep = camera.getParameters().getExposureCompensationStep();
            int CurrentExposureCompensationIndex = camera.getParameters().getExposureCompensation();
            float CurrentExposureValue = (float)CurrentExposureCompensationIndex * ExposureCompensationStep;
            LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "CurrentExposureCompensationIndex=" + CurrentExposureCompensationIndex + ",ExposureCompensationStep=" + ExposureCompensationStep + ",MinExposureCompensationIndex=" + MinExposureCompensationIndex + ",MaxExposureCompensationIndex=" + MaxExposureCompensationIndex + ",CurrentExposureValue=" + CurrentExposureValue);
            if (MaxExposureCompensationIndex == 0 && MinExposureCompensationIndex == 0) {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "phone not support Exposure Compensation");
                return null;
            }
            int sizeExposureCompensationIndex = MaxExposureCompensationIndex - MinExposureCompensationIndex + 1;
            ExposureCompensationIndexs = new CharSequence[sizeExposureCompensationIndex];
            int j = 0;
            int i = MinExposureCompensationIndex;
            while (i <= MaxExposureCompensationIndex) {
                ExposureCompensationIndexs[j] = Integer.toString(i);
                ++i;
                ++j;
            }
        } else {
            LogUtils.e(TAG, String.valueOf(Util.getMethodLine()) + "camera=null");
        }
        return ExposureCompensationIndexs;
    }

    private String getCurrentExposureCompensationIndex() {
        Camera camera = CameraManager.get().getCamera();
        String ret = null;
        int CurrentExposureCompensationIndex = 0;
        if (camera != null) {
            CurrentExposureCompensationIndex = camera.getParameters().getExposureCompensation();
            LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "CurrentExposureCompensationIndex=" + CurrentExposureCompensationIndex);
        } else {
            LogUtils.e(TAG, String.valueOf(Util.getMethodLine()) + "camera=null");
        }
        ret = Integer.toString(CurrentExposureCompensationIndex);
        return ret;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(524288);
        if (item.getItemId() == this.menu_settings_id) {
            String bestPreviewSize;
            String defaultPreviewSize;
            CharSequence[] supportPreviewSizes;
            intent.setClassName((Context)this, SettingsActivity.class.getName());
            if (PreferencesManager.getFrontFaceCamera()) {
                supportPreviewSizes = this.getSupportPreviewSize();
                intent.putExtra("front_camera_support_preview_sizes", supportPreviewSizes);
                defaultPreviewSize = this.getDefaultPreviewSize();
                intent.putExtra("front_camera_default_preview_size", defaultPreviewSize);
                bestPreviewSize = this.getBestPreviewSize();
                intent.putExtra("front_camera_best_preview_size", bestPreviewSize);
            } else {
                supportPreviewSizes = this.getSupportPreviewSize();
                intent.putExtra("back_camera_support_preview_sizes", supportPreviewSizes);
                defaultPreviewSize = this.getDefaultPreviewSize();
                intent.putExtra("back_camera_default_preview_size", defaultPreviewSize);
                bestPreviewSize = this.getBestPreviewSize();
                intent.putExtra("back_camera_best_preview_size", bestPreviewSize);
            }
        } else {
            return super.onOptionsItemSelected(item);
        }
        CharSequence[] supportPreviewCutSizes = this.getSupportPreviewCutSizes();
        intent.putExtra("support_preview_cut_size", supportPreviewCutSizes);
        String currentPreviewCutSize = this.getCurrentPreviewCutSize();
        intent.putExtra("current_preview_cut_size", currentPreviewCutSize);
        CharSequence[] supportFocusModes = this.getSupportFocusModes();
        intent.putExtra("support_focus_modes", supportFocusModes);
        String currentFocusMode = this.getCurrentFocusMode();
        intent.putExtra("current_focus_mode", currentFocusMode);
        CharSequence[] supportExposureCompensationIndexs = this.getSupportExposureCompensationIndexs();
        intent.putExtra("support_ExposureCompensationIndexs", supportExposureCompensationIndexs);
        String currentExposureCompensationIndex = this.getCurrentExposureCompensationIndex();
        intent.putExtra("current_ExposureCompensationIndex", currentExposureCompensationIndex);
        this.startActivity(intent);
        return true;
    }

    protected void onResume() {
        super.onResume();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        if (isInitSelf) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "isInitSelf=true, sdk doInit"));
            this.doInit();
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "isInitSelf=false, user init it"));
        }
    }

    protected void onStart() {
        super.onStart();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
    }

    protected void onStop() {
        super.onStop();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
    }

    protected void onRestart() {
        super.onRestart();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
    }

    protected void onPause() {
        super.onPause();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        if (isInitSelf) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "isInitSelf=true, sdk doUnInit"));
            this.doUnInit();
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "isInitSelf=false, user uninit it"));
        }
        ScanLayout.setRemoveViewFlag(true);
    }

    protected void onDestroy() {
        super.onDestroy();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        this.beepManager.release();
        if (this.mScanTimeoutTimer != null) {
            this.mScanTimeoutTimer.cancel();
            this.mScanTimeoutTimer = null;
        }
        instance = null;
        ScanLayout.clearViewList();
        decodeResultCmpStr = null;
        bSaveImgCmpErr = false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin"));
        switch (keyCode) {
            case 4: {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "KEYCODE_BACK"));
                this.doUnInit();
                if (resultCb != null) {
                    resultCb.onCancel();
                }
                this.ExitCaptureActivity(0, null);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private synchronized void ExitCaptureActivity(int resultCode, Intent data) {
        if (this.isFinishing()) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "CaptureActivity is finishing, so do nothing"));
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "begin finish CaptureActivity"));
            this.setResult(resultCode, data);
            this.finish();
        }
    }

    private void resetStatusView() {
        if (!bContinuousScan && !PreferencesManager.getSaveBitmapJustOnce()) {
            this.buttonView.setVisibility(8);
        }
    }

    public void restartPreviewAfterDelay(long delayMS) {
        if (this.mCaptureActivityHandler != null) {
            this.mCaptureActivityHandler.sendEmptyMessageDelayed(101, delayMS);
        }
        this.resetStatusView();
    }

    public void stopPreviewAfterDelay(long delayMS) {
        if (this.mCaptureActivityHandler != null) {
            this.mCaptureActivityHandler.sendEmptyMessageDelayed(102, delayMS);
        }
    }

    public void decodeSuccessful_Callback(Result rawResult, int preview_counts, int success_counts, int fail_counts, int jni_cost_time, int scanAndDecodeTime) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "decodeSuccessful_Callback"));
        if (ScanDecoderParameter.getBeepMode() == 1) {
            LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "BeepMode=USE_SPEAKER, so call beepManager.playBeepSoundAndVibrate()");
            this.beepManager.playBeepSoundAndVibrate();
        }
        this.barcodeText = rawResult.getmBarcodeText();
        this.decodeLenght = rawResult.getmDecodeLenght();
        int jniLibVer = ScanDecoderParameter.getJniLibVersion();
        mCodeType = jniLibVer < 1140511 ? -2 : rawResult.getCodeType();
        mDecodeLength = rawResult.getmDecodeLenght();
        mDecodeResultBytes = rawResult.getmBarcodeBytes();
        this.displayDecodeResult(true, rawResult.getCodeType(), rawResult.getRawImg(), rawResult.getRawImgWidth(), rawResult.getRawHeight(), preview_counts, success_counts, fail_counts, jni_cost_time, scanAndDecodeTime);
        if (this.iDevelopTest == 1 && bSaveImgCmpErr) {
            if (decodeResultCmpStr != null && !decodeResultCmpStr.equals("null")) {
                Log.d((String)(TAG + Util.getMethodLine()), (String)("decodeResultCmpStr=" + decodeResultCmpStr));
                if (!decodeResultCmpStr.equals(rawResult.getmBarcodeText())) {
                    String name = "decodeImageCmpError_" + rawResult.getRawImgWidth() + "x" + rawResult.getRawHeight();
                    Log.d((String)(TAG + Util.getMethodLine()), (String)("save Cmp Error image to /tmp/" + name));
                    FileUtils.saveRawImg_absulutePath(rawResult.getRawImg(), "/tmp", name, rawResult.getRawImgWidth(), rawResult.getRawHeight(), rawResult.getRawImgWidth() * rawResult.getRawHeight());
                    bContinuousScan = false;
                }
            } else {
                Log.d((String)(TAG + Util.getMethodLine()), (String)"decodeResultCmpStr=null");
            }
        }
        if (bContinuousScan) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ContinuousScan mode, continue..."));
            if (continueResultArray.size() <= 200) {
                continueResultArray.add(rawResult.getmBarcodeText());
                if (continueResultArray.size() == 1) {
                    this.continue_start_1 = System.currentTimeMillis();
                }
                this.continue_end_1 = System.currentTimeMillis();
                continueTimeMs = this.continue_end_1 - this.continue_start_1;
            }
            this.restartPreviewAfterDelay(0L);
        } else {
            if (PreferencesManager.getTestMode() && PreferencesManager.getSaveBitmapJustOnce()) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "test mose and saveBitmap Button open...no exit activity"));
                return;
            }
            this.doUnInit();
            if (resultCb != null) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "call resultCb.onResult"));
                resultCb.onResult(rawResult.getmBarcodeText());
            } else {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "resultCb=null"));
            }
            Intent intent = new Intent();
            intent.putExtra(RESULT_CODE_SCAN_DECODE_TEXT, rawResult.getmBarcodeText());
            this.ExitCaptureActivity(-1, intent);
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            if (PreferencesManager.getFrontFaceCamera()) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "front camera no surfaceHolder,no preview"));
                CameraManager.get().openDriver(null);
            } else {
                CameraManager.get().openDriver(surfaceHolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return;
        }
        if (this.mCaptureActivityHandler == null) {
            this.mCaptureActivityHandler = new CaptureActivityHandler(this);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public Handler getHandler() {
        return this.mCaptureActivityHandler;
    }

    public void displayDecodeResult(Boolean decodeSuccess, int codeType, byte[] RawImg, int ImgWidth, int ImgHeight, int preview_counts, int success_counts, int fail_counts, int jni_cost_time, int scanAndDecodeTime) {
        this.end_1 = System.currentTimeMillis();
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "startActivity time=" + (this.end_1 - this.start_1));
        if (PreferencesManager.getSaveBitmapJustOnce()) {
            this.buttonView.setVisibility(0);
            this.mBitmapLock.lock();
            this.mRawImg = RawImg;
            this.mImgWidth = ImgWidth;
            this.mImgHeight = ImgHeight;
            this.mBitmapLock.unlock();
        }
        if (PreferencesManager.getShowResult()) {
            this.resultView.setVisibility(0);
            long diff = 0L;
            float speed = 0.0f;
            if (preview_counts == 1) {
                this.start = System.currentTimeMillis();
            }
            if (preview_counts > 1) {
                this.end = System.currentTimeMillis();
                diff = this.end - this.start;
                speed = (float)(((double)preview_counts * 1.0 - 1.0) / (double)diff * 1000.0);
            }
            this.TextView_resultText.setText((CharSequence)("text=" + this.barcodeText + "\n" + "lenght=" + this.decodeLenght + "\n" + "codeType=" + codeType + "=" + CodeType.getCodeTypeString(codeType) + "\n" + "DecodeTime=" + jni_cost_time + " ms" + "\n" + "scanAndDecodeTime=" + scanAndDecodeTime + " ms" + "\n" + "success_counts=" + success_counts + "\n" + "fail_counts=" + fail_counts + "\n" + "preview_counts=" + preview_counts + "\n" + "timeElapse=" + diff + " ms" + "\n" + "FramSpeed=" + speed + " fps"));
        }
    }

    public void displayPreveiwCounts(int preview_counts) {
        this.resultView.setVisibility(0);
        long diff = 0L;
        float speed = 0.0f;
        if (preview_counts == 1) {
            this.start = System.currentTimeMillis();
        }
        if (preview_counts > 1) {
            this.end = System.currentTimeMillis();
            diff = this.end - this.start;
            speed = (float)(((double)preview_counts * 1.0 - 1.0) / (double)diff * 1000.0);
        }
        this.TextView_resultText.setText((CharSequence)("preview_counts=" + preview_counts + "\n" + "timeElapse=" + diff + " ms" + "\n" + "FramSpeed=" + speed + " fps"));
    }

    public static int getCodeType() {
        return mCodeType;
    }

    protected static byte[] getDecodeResultBytes() {
        return mDecodeResultBytes;
    }

    protected static int getDecodeResultLength() {
        return mDecodeLength;
    }

    public static void setResultCallback(ScanDecoder.ResultCallback cb) {
        resultCb = cb;
    }

    public static int openCamera(int cameraID) {
        int ret = 0;
        mFrontFaceCamera = cameraID == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        try {
            ret = CameraManager.openCamera(cameraID);
        }
        catch (IOException e) {
            e.printStackTrace();
            ret = 1;
        }
        return ret;
    }

    public static void closeCamera() {
        CameraManager.closeDriver();
    }

    public void doInit() {
        PreferencesManager.readTestModeFromXML(this);
        PreferencesManager.readShouldPlayBeepFromXML(this);
        PreferencesManager.readShouldVibrateFromXML(this);
        PreferencesManager.readContinuousScanFromXML(this);
        PreferencesManager.readFlashLightFromXML(this);
        PreferencesManager.readFrontFaceCameraFromXML(this);
        PreferencesManager.readUseGifPictureFromXML(this);
        PreferencesManager.readNoPreviewFromXML(this);
        PreferencesManager.readOnlyPreviewFromXML(this);
        PreferencesManager.readShowResultFromXML(this);
        PreferencesManager.readSaveBitmapJustOnceFromXML(this);
        PreferencesManager.readSaveBitmapContinuousFromXML(this);
        PreferencesManager.readSaveBitmapOnSuccessfulFromXML(this);
        PreferencesManager.readFrontCameraPreviewSizeFromXML(this);
        PreferencesManager.readBackCameraPreviewSizeFromXML(this);
        PreferencesManager.readPreviewCutSizeFromXML(this);
        PreferencesManager.readFocusModeFromXML(this);
        PreferencesManager.readExposureCompensationIndexFromXML(this);
        PreferencesManager.setScanModuleMode(false);
        Log.d((String)TAG, (String)("SaveBitmapOnSuccessful=" + PreferencesManager.getSaveBitmapOnSuccessful()));
        mCodeType = -1;
        this.beepManager.updatePrefs();
        bContinuousScan = PreferencesManager.getContinuousScan();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "continuousScan=" + bContinuousScan));
        this.setContentView(this.scan_layout_id);
        if (PreferencesManager.getFrontFaceCamera()) {
            Log.d((String)TAG, (String)"front camera do not open preview default");
            if (PreferencesManager.getNoPreview() && PreferencesManager.getUseGifPicture()) {
                this.gifView = (GifView)this.findViewById(this.gif_id);
                this.gifView.setMovieResource(this.scan_raw_id);
            }
        } else {
            Log.d((String)TAG, (String)"back camera open preview default");
        }
        this.mBitmapLock = new ReentrantLock();
        this.resultView = this.findViewById(this.result_view_id);
        this.buttonView = this.findViewById(this.button_view_id);
        this.TextView_resultText = (TextView)this.findViewById(this.result_text_id);
        ((Button)this.findViewById(this.btnReScan_id)).setOnClickListener(this.btnClick);
        ((Button)this.findViewById(this.btnSaveIMG_id)).setOnClickListener(this.btnClick);
        SurfaceView surfaceView = (SurfaceView)this.findViewById(this.capture_preview_id);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
        this.inited = true;
        continueResultArray.clear();
        continueTimeMs = 0L;
    }

    public void doUnInit() {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "doUnInit begin"));
        if (!this.inited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "no inited, return"));
            return;
        }
        if (this.mCaptureActivityHandler != null) {
            this.mCaptureActivityHandler.quitSynchronously();
            this.mCaptureActivityHandler = null;
        }
        this.inited = false;
    }

    public static void setDecodeResultCmpStr(String cmpStr) {
        decodeResultCmpStr = new String(cmpStr);
    }

    public static void setSaveImgCmpError(boolean enable) {
        bSaveImgCmpErr = enable;
    }

    private class ScanTimeoutTask
    extends TimerTask {
        private ScanTimeoutTask() {
        }

        @Override
        public void run() {
            Log.i((String)CaptureActivity.TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanTimeout, ScanTimeoutTask run, begin ExitCaptureActivity"));
            CaptureActivity.this.doUnInit();
            if (resultCb != null) {
                resultCb.onTimeout();
            }
            CaptureActivity.this.ExitCaptureActivity(0, null);
        }
    }
}

