/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.scanDecoder;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import com.landicorp.android.scan.scanDecoder.GlobalState;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;
import java.io.IOException;

final class BeepManager {
    private static final String TAG = "ScanDecoder_" + BeepManager.class.getSimpleName();
    private static final float BEEP_VOLUME = 0.9f;
    private static final long VIBRATE_DURATION = 200L;
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;

    BeepManager(Activity activity) {
        this.activity = activity;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    void updatePrefs() {
        this.playBeep = BeepManager.shouldBeep((Context)this.activity);
        this.vibrate = PreferencesManager.getShouldVibrate();
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "vibrate=" + this.vibrate);
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(3);
            this.mediaPlayer = BeepManager.buildMediaPlayer((Context)this.activity);
        }
    }

    void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.pause();
                this.mediaPlayer.seekTo(0);
            }
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    private static boolean shouldBeep(Context activity) {
        AudioManager audioService;
        boolean shouldPlayBeep = PreferencesManager.getShouldPlayBeep();
        if (shouldPlayBeep && (audioService = (AudioManager)activity.getSystemService("audio")).getRingerMode() != 2) {
            shouldPlayBeep = false;
        }
        return shouldPlayBeep;
    }

    private static MediaPlayer buildMediaPlayer(Context activity) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        mediaPlayer.setAudioStreamType(3);
        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer player) {
                player.seekTo(0);
            }
        });
        AssetFileDescriptor file = activity.getResources().openRawResourceFd(GlobalState.getResId(activity.getApplicationContext(), "raw", "zxbeep"));
        try {
            mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            file.close();
            mediaPlayer.setVolume(0.9f, 0.9f);
            mediaPlayer.prepare();
        }
        catch (IOException ioe) {
            LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + ioe);
            mediaPlayer = null;
        }
        return mediaPlayer;
    }

    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }
}

