/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.decode;

import android.util.Log;
import com.landicorp.android.scan.util.FileEncodingDetect;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;
import java.io.UnsupportedEncodingException;

public class Result {
    private static final String TAG = "ScanDecoder_Result";
    public static final String KEY_SUCCESS_COUNTS = "KEY_SUCCESS_COUNTS";
    public static final String KEY_FAIL_COUNTS = "KEY_FAIL_COUNTS";
    public static final String KEY_PREVIEW_COUNTS = "KEY_PREVIEW_COUNTS";
    public static final String KEY_JNI_COST_TIME = "KEY_JNI_COST_TIME";
    public static final String KEY_BITMAP = "KEY_BITMAP";
    public static final String KEY_IMG_WIDTH = "KEY_IMG_WIDTH";
    public static final String KEY_IMG_HEIGHT = "KEY_IMG_HEIGHT";
    public static final int RESULT_STRING_MODE = 0;
    public static final int RESULT_BYTES_MODE = 1;
    private int mCodeType = -1;
    private String mBarcodeText = null;
    private byte[] mBarcodeBytes = null;
    private int mDecodeLenght = 0;
    private byte[] mRawImg = null;
    private int mImgWidth = 0;
    private int mImgHeight = 0;

    public Result(String barcodeText, int codeType, int length) {
        Log.i((String)TAG, (String)("Result:codeType=" + codeType + ",length=" + length + ",barcodeText=" + barcodeText));
        this.mBarcodeText = barcodeText;
        this.mCodeType = codeType;
        this.mDecodeLenght = length;
        try {
            this.mBarcodeBytes = this.mBarcodeText.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public Result(byte[] barcodeBytes, int codeType, int length) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Result:codeType=" + codeType + ",length=" + length));
        LogUtils.printLargeData(TAG, Util.byte2string(barcodeBytes, true));
        this.mCodeType = codeType;
        this.mDecodeLenght = length;
        this.mBarcodeBytes = new byte[length];
        int i = 0;
        while (i < length) {
            this.mBarcodeBytes[i] = barcodeBytes[i];
            ++i;
        }
        String strEncodeType = FileEncodingDetect.getInstance().detectEncoding(this.mBarcodeBytes);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "strEncodeType=" + strEncodeType));
        if (strEncodeType == null) {
            strEncodeType = "UTF-8";
        }
        try {
            this.mBarcodeText = new String(this.mBarcodeBytes, strEncodeType);
        }
        catch (UnsupportedEncodingException e) {
            Log.i((String)TAG, (String)"UnsupportedEncodingException catch");
            e.printStackTrace();
            this.mBarcodeText = null;
        }
        if (this.mBarcodeText != null) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mBarcodeText=" + this.mBarcodeText));
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mBarcodeText=null"));
        }
    }

    public int getCodeType() {
        return this.mCodeType;
    }

    public String getmBarcodeText() {
        return this.mBarcodeText;
    }

    public byte[] getmBarcodeBytes() {
        return this.mBarcodeBytes;
    }

    public int getmDecodeLenght() {
        return this.mDecodeLenght;
    }

    public byte[] getRawImg() {
        return this.mRawImg;
    }

    public int getRawImgWidth() {
        return this.mImgWidth;
    }

    public int getRawHeight() {
        return this.mImgHeight;
    }

    public void setRawImg(byte[] RawImg) {
        this.mRawImg = RawImg;
    }

    public void setRawImgWidth(int ImgWidth) {
        this.mImgWidth = ImgWidth;
    }

    public void setRawImgHeight(int ImgHeight) {
        this.mImgHeight = ImgHeight;
    }
}

