/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.decode;

import android.os.Handler;
import android.os.Looper;
import com.landicorp.android.scan.decode.DecodeHandler;
import com.landicorp.android.scan.scanDecoder.CaptureActivity;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.scanDecoder.ScanModule_internal;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;
import java.util.concurrent.CountDownLatch;

final class DecodeThread
extends Thread {
    private static final String TAG = "ScanDecoder_DecodeThread";
    private CaptureActivity activity;
    private ScanModule_internal mScanModule = null;
    private Handler handler;
    private final CountDownLatch handlerInitLatch;

    DecodeThread(CaptureActivity activity) {
        this.activity = activity;
        this.handlerInitLatch = new CountDownLatch(1);
    }

    DecodeThread(ScanModule_internal scan_module) {
        this.mScanModule = scan_module;
        this.handlerInitLatch = new CountDownLatch(1);
    }

    Handler getHandler() {
        try {
            this.handlerInitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.handler;
    }

    @Override
    public void run() {
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "begin Looper.prepare()");
        Looper.prepare();
        this.handler = PreferencesManager.getScanModuleMode() ? new DecodeHandler(this.mScanModule) : new DecodeHandler(this.activity);
        this.handlerInitLatch.countDown();
        Looper.loop();
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "exit Looper");
    }
}

