/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.decode;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.landicorp.android.scan.camera.CameraManager;
import com.landicorp.android.scan.decode.Result;
import com.landicorp.android.scan.decode.nativeMethod;
import com.landicorp.android.scan.scanDecoder.CaptureActivity;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.scanDecoder.ScanDecoderParameter;
import com.landicorp.android.scan.scanDecoder.ScanModule_internal;
import com.landicorp.android.scan.util.FileUtils;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.PlanarYUVLuminanceSource;
import com.landicorp.android.scan.util.Util;
import java.util.ArrayList;
import java.util.List;

public class DecodeHandler
extends Handler {
    private static final String TAG = "ScanDecoder_DecodeHandler";
    private CaptureActivity activity = null;
    private ScanModule_internal mScanModule = null;
    private PlanarYUVLuminanceSource planar;
    private int success_counts = 0;
    private int fail_counts = 0;
    private int preview_counts = 0;
    private int jni_cost_time = 0;
    private List<Bitmap> bitmapList = new ArrayList<Bitmap>();
    private nativeMethod mNativeMethod = null;

    DecodeHandler(CaptureActivity activity) {
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "DecodeHandler create");
        this.activity = activity;
        this.planar = new PlanarYUVLuminanceSource();
        this.success_counts = 0;
        this.fail_counts = 0;
        this.preview_counts = 0;
        this.jni_cost_time = 0;
        this.mNativeMethod = nativeMethod.getInstance();
        if (PreferencesManager.getOnlyPreview()) {
            LogUtils.d(TAG, "only preview");
        }
    }

    DecodeHandler(ScanModule_internal scan_module) {
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "DecodeHandler create");
        this.mScanModule = scan_module;
        this.planar = new PlanarYUVLuminanceSource();
        this.success_counts = 0;
        this.fail_counts = 0;
        this.preview_counts = 0;
        this.jni_cost_time = 0;
        this.mNativeMethod = nativeMethod.getInstance();
        if (PreferencesManager.getOnlyPreview()) {
            LogUtils.d(TAG, "only preview");
        }
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 105: {
                this.decode((byte[])message.obj, message.arg1, message.arg2);
                break;
            }
            case 106: {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "handleMessage--MSG_ID_QUIT");
                if (PreferencesManager.getOnlyPreview()) {
                    LogUtils.d(TAG, "only preview");
                }
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "begin Looper.myLooper().quit()");
                Looper.myLooper().quit();
            }
        }
    }

    private void decode(byte[] yuvdata, int previewWidth, int previewHeight) {
        ++this.preview_counts;
        Handler handler = PreferencesManager.getScanModuleMode() ? this.mScanModule.getHandler() : this.activity.getHandler();
        if (PreferencesManager.getOnlyPreview()) {
            LogUtils.d(TAG, "only preview");
            if (handler != null) {
                Message message = Message.obtain((Handler)handler, (int)104);
                Bundle data = new Bundle();
                data.putInt("KEY_SUCCESS_COUNTS", 0);
                data.putInt("KEY_FAIL_COUNTS", 0);
                data.putInt("KEY_PREVIEW_COUNTS", this.preview_counts);
                data.putInt("KEY_JNI_COST_TIME", 0);
                message.setData(data);
                message.sendToTarget();
            }
            return;
        }
        LogUtils.d(TAG, "begin decode");
        byte[] decodeData = null;
        boolean needCut = false;
        int decodeWidth = 0;
        int decodeHeight = 0;
        if (PreferencesManager.getLaserLineDecodeFlag()) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "is LaserLine Decode"));
            needCut = true;
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "normal Decode"));
        }
        if (needCut) {
            decodeWidth = 40;
            decodeHeight = previewHeight;
            int decodeWidthStart = previewWidth / 2 - 1 - (decodeWidth / 2 - 1);
            int decodeWidthEnd = previewWidth / 2 + (decodeWidth / 2 - 1);
            int index = 0;
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "decodeWidth=" + decodeWidth + ",decodeHeight=" + decodeHeight + ",decodeWidthStart=" + decodeWidthStart + ",decodeWidthEnd=" + decodeWidthEnd));
            decodeData = new byte[decodeWidth * decodeHeight];
            int i = 0;
            while (i < previewHeight) {
                int j = decodeWidthStart;
                while (j <= decodeWidthEnd) {
                    decodeData[index] = yuvdata[i * previewWidth + j];
                    ++index;
                    ++j;
                }
                ++i;
            }
        } else {
            decodeWidth = previewWidth;
            decodeHeight = previewHeight;
            decodeData = yuvdata;
        }
        if (PreferencesManager.getSaveBitmapContinuous()) {
            byte[] saveImg = new byte[decodeWidth * decodeHeight];
            int i = 0;
            while (i < saveImg.length) {
                saveImg[i] = decodeData[i];
                ++i;
            }
            String name = "decodeImageConti_" + decodeWidth + "x" + decodeHeight;
            LogUtils.w(TAG + Util.getMethodLine(), "save image to /tmp/" + name);
            FileUtils.saveRawImg_absulutePath(saveImg, "/tmp", name, decodeWidth, decodeHeight, decodeWidth * decodeHeight);
        }
        Result result = null;
        long start = System.currentTimeMillis();
        if (PreferencesManager.getLaserLineDecodeFlag()) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "decode 1d first"));
            this.mNativeMethod.EnableCodeOrder(ScanDecoderParameter.ENABLE_CODE_1D);
            result = this.mNativeMethod.Decode(0, decodeData, decodeWidth, decodeHeight, 1);
            if (result == null) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "decode 1d failed, now decode 2d"));
                this.mNativeMethod.EnableCodeOrder(ScanDecoderParameter.ENABLE_CODE_2D);
                result = this.mNativeMethod.Decode(0, yuvdata, previewWidth, previewHeight, 1);
            }
        } else {
            result = this.mNativeMethod.Decode(0, decodeData, decodeWidth, decodeHeight, 1);
        }
        long end = System.currentTimeMillis();
        this.jni_cost_time = (int)(end - start);
        LogUtils.w(TAG + Util.getMethodLine() + "Time", "jniCostTime =" + this.jni_cost_time + " ms");
        if (result != null) {
            LogUtils.w(TAG + Util.getMethodLine() + "Time", "decode successful");
            if (handler != null) {
                ++this.success_counts;
                PreferencesManager.getSaveBitmapJustOnce();
                if (PreferencesManager.getSaveBitmapOnSuccessful()) {
                    byte[] saveImg = new byte[decodeWidth * decodeHeight];
                    int i = 0;
                    while (i < saveImg.length) {
                        saveImg[i] = decodeData[i];
                        ++i;
                    }
                    String name = "decodeImageSuccess_" + decodeWidth + "x" + decodeHeight;
                    LogUtils.w(TAG + Util.getMethodLine(), "save image to /tmp/" + name);
                    FileUtils.saveRawImg_absulutePath(saveImg, "/tmp", name, decodeWidth, decodeHeight, decodeWidth * decodeHeight);
                }
                result.setRawImg(decodeData);
                result.setRawImgWidth(decodeWidth);
                result.setRawImgHeight(decodeHeight);
                Message message = Message.obtain((Handler)handler, (int)103, (Object)result);
                Bundle data = new Bundle();
                data.putInt("KEY_SUCCESS_COUNTS", this.success_counts);
                data.putInt("KEY_FAIL_COUNTS", this.fail_counts);
                data.putInt("KEY_PREVIEW_COUNTS", this.preview_counts);
                data.putInt("KEY_JNI_COST_TIME", this.jni_cost_time);
                message.setData(data);
                message.sendToTarget();
            }
        } else {
            LogUtils.w(TAG + Util.getMethodLine() + "Time", "decode failed!!!!!");
            if (handler != null) {
                ++this.fail_counts;
                Message message = Message.obtain((Handler)handler, (int)104, (Object)decodeData);
                Bundle data = new Bundle();
                data.putInt("KEY_SUCCESS_COUNTS", this.success_counts);
                data.putInt("KEY_FAIL_COUNTS", this.fail_counts);
                data.putInt("KEY_PREVIEW_COUNTS", this.preview_counts);
                data.putInt("KEY_JNI_COST_TIME", this.jni_cost_time);
                data.putInt("KEY_IMG_WIDTH", decodeWidth);
                data.putInt("KEY_IMG_HEIGHT", decodeHeight);
                message.setData(data);
                message.sendToTarget();
            }
        }
    }

    private Rect getInPreviewRect() {
        return CameraManager.get().getFramingRectInPreview();
    }
}

