/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.decode;

import android.util.Log;
import com.landicorp.android.scan.decode.Result;
import com.landicorp.android.scan.decode.nativeMethod;
import com.landicorp.android.scan.scanDecoder.DecodeProperty;
import com.landicorp.android.scan.scanDecoder.ScanDecoder;
import com.landicorp.android.scan.scanDecoder.ScanDecoderParameter;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;

public class DecodeEngine_internal {
    private static final String TAG = "ScanDecoder_DecodeEngine_internal";
    private boolean isInited = false;
    private nativeMethod mNativeMethod = null;
    private static DecodeEngine_internal instance = null;
    private int mCodeType = -1;
    private byte[] mResultBytes = null;
    private String mResultString = null;

    protected static DecodeEngine_internal getInstance() {
        if (instance == null) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine_internal=null, create it"));
            instance = new DecodeEngine_internal();
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine_internal exist, use it"));
        }
        return instance;
    }

    private int init_internal() {
        int ret = 0;
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine-ScanDecoder Version=" + ScanDecoder.version));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine-init"));
        if (this.isInited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "you has inited once"));
            return 2;
        }
        ScanDecoderParameter.setMaxDecodeCounts(100);
        this.mNativeMethod = nativeMethod.getInstance();
        int jniLibVer = this.GetJniLibVersion();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "jniLibVer=" + jniLibVer));
        ScanDecoderParameter.setJniLibVersion(jniLibVer);
        if (jniLibVer < 1130225) {
            ScanDecoderParameter.setBeepMode(this.mNativeMethod.GetBeepMode(1));
        } else if (ScanDecoderParameter.getBeepMode() != 0) {
            ScanDecoderParameter.setBeepMode(this.mNativeMethod.GetBeepMode(ScanDecoderParameter.getBeepMode()));
        } else {
            ScanDecoderParameter.setBeepMode(this.mNativeMethod.GetBeepMode(0));
        }
        if (jniLibVer < 1210614) {
            ScanDecoderParameter.EnableCodeOrder();
        }
        ret = this.mNativeMethod.InitDecoder(0, ScanDecoderParameter.getMaxDecodeCounts(), null);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NativeInitDecoder ret=" + ret));
        if (ret != 0) {
            if (ret == 4) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "activate license failed"));
                return 3;
            }
            if (ret == 20) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "can not find correct decode lib"));
                return 5;
            }
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mNativeMethod.InitDecoder failed"));
            return 1;
        }
        if (jniLibVer >= 1210614 && (ret = ScanDecoderParameter.enableDefaultCode()) != 0) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "ScanDecoderParameter.enableDefaultCode failed"));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mNativeMethod.ExitDecoder(0);
            return 6;
        }
        this.isInited = true;
        return 0;
    }

    protected synchronized int init() {
        ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        return this.init_internal();
    }

    protected synchronized int init(Boolean enable_1d, Boolean enable_2d) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "init(char enable_1d, char enable_2d) begin"));
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable_1d=" + enable_1d + ",enable_2d=" + enable_2d));
        if (enable_1d.booleanValue() && !enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_1D);
        } else if (!enable_1d.booleanValue() && enable_2d.booleanValue()) {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_2D);
        } else {
            ScanDecoderParameter.setCodeOrder(ScanDecoderParameter.ENABLE_CODE_DEFAULT);
        }
        return this.init_internal();
    }

    protected synchronized String decode(byte[] imageData, int imageWidth, int imageHeight) {
        Result result = null;
        String decodeText = null;
        this.mResultBytes = null;
        this.mResultString = null;
        if (!this.isInited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine no init"));
            return null;
        }
        this.mCodeType = -1;
        result = this.mNativeMethod.Decode(0, imageData, imageWidth, imageHeight, 1);
        if (result != null) {
            LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode successful");
            decodeText = result.getmBarcodeText();
            this.mResultString = result.getmBarcodeText();
            this.mResultBytes = result.getmBarcodeBytes();
            int jniLibVer = ScanDecoderParameter.getJniLibVersion();
            this.mCodeType = jniLibVer < 1140511 ? -2 : result.getCodeType();
        } else {
            LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode failed");
        }
        return decodeText;
    }

    protected synchronized byte[] decode_bytes(byte[] imageData, int imageWidth, int imageHeight) {
        Result result = null;
        byte[] resultBytes = null;
        this.mResultBytes = null;
        this.mResultString = null;
        if (!this.isInited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine no init"));
            return null;
        }
        this.mCodeType = -1;
        result = this.mNativeMethod.Decode(0, imageData, imageWidth, imageHeight, 1);
        if (result != null) {
            LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode successful");
            resultBytes = result.getmBarcodeBytes();
            this.mResultString = result.getmBarcodeText();
            this.mResultBytes = result.getmBarcodeBytes();
            int jniLibVer = ScanDecoderParameter.getJniLibVersion();
            this.mCodeType = jniLibVer < 1140511 ? -2 : result.getCodeType();
        } else {
            LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode failed");
        }
        return resultBytes;
    }

    protected synchronized String decode_laser(byte[] imageData, int imageWidth, int imageHeight) {
        Result result = null;
        String decodeText = null;
        this.mResultBytes = null;
        this.mResultString = null;
        if (!this.isInited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine no init"));
            return null;
        }
        this.mCodeType = -1;
        try {
            result = this.mNativeMethod.DecodeLaser(0, imageData, imageWidth, imageHeight, 1);
            if (result != null) {
                LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode successful");
                decodeText = result.getmBarcodeText();
                this.mResultString = result.getmBarcodeText();
                this.mResultBytes = result.getmBarcodeBytes();
                int jniLibVer = ScanDecoderParameter.getJniLibVersion();
                this.mCodeType = jniLibVer < 1140511 ? -2 : result.getCodeType();
            } else {
                LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode failed");
            }
            return decodeText;
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for DecodeLaser"));
            return null;
        }
    }

    protected synchronized byte[] decode_laser_bytes(byte[] imageData, int imageWidth, int imageHeight) {
        Result result = null;
        byte[] resultBytes = null;
        this.mResultBytes = null;
        this.mResultString = null;
        if (!this.isInited) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine no init"));
            return null;
        }
        this.mCodeType = -1;
        try {
            result = this.mNativeMethod.DecodeLaser(0, imageData, imageWidth, imageHeight, 1);
            if (result != null) {
                LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode successful");
                resultBytes = result.getmBarcodeBytes();
                this.mResultString = result.getmBarcodeText();
                this.mResultBytes = result.getmBarcodeBytes();
                int jniLibVer = ScanDecoderParameter.getJniLibVersion();
                this.mCodeType = jniLibVer < 1140511 ? -2 : result.getCodeType();
            } else {
                LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "decode failed");
            }
            return resultBytes;
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for DecodeLaser"));
            return null;
        }
    }

    protected synchronized void exit() {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine-exit"));
        if (this.isInited) {
            int ret = DecodeProperty.resetAllProperty();
            if (ret != 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "exit disableAll failed"));
                Log.e((String)TAG, (String)("resetAllProperty ret=" + ret));
            }
            this.mNativeMethod.ExitDecoder(0);
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "DecodeEngine no init"));
        }
        this.isInited = false;
    }

    private int GetJniLibVersion() {
        int jniLibVer = 0;
        try {
            jniLibVer = nativeMethod.getInstance().GetJniLibVersion(0);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for GetJniLibVersion"));
            jniLibVer = 0;
        }
        return jniLibVer;
    }

    protected int getCodeType() {
        return this.mCodeType;
    }

    protected byte[] getResultBytes() {
        return this.mResultBytes;
    }

    protected String getResultString() {
        return this.mResultString;
    }

    protected void enableBeep(boolean enable) {
        nativeMethod mNativeMethod = null;
        mNativeMethod = nativeMethod.getInstance();
        if (!enable) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "disable beep"));
            ScanDecoderParameter.setBeepMode(mNativeMethod.GetBeepMode(1));
        } else {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable beep"));
            ScanDecoderParameter.setBeepMode(mNativeMethod.GetBeepMode(0));
        }
    }
}

