/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.decode;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.landicorp.android.scan.camera.CameraManager;
import com.landicorp.android.scan.decode.DecodeThread;
import com.landicorp.android.scan.decode.Result;
import com.landicorp.android.scan.scanDecoder.CaptureActivity;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.scanDecoder.ScanModule_internal;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = "ScanDecoder_CaptureActivityHandler";
    private DecodeThread decodeThread = null;
    private CaptureActivity activity = null;
    private ScanModule_internal mScanModule = null;
    private State state;
    private long scanAndDecodeTimeBegin = 0L;
    private long scanAndDecodeTimeEnd = 0L;

    public CaptureActivityHandler(CaptureActivity activity) {
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity);
        this.decodeThread.start();
        this.state = State.INITED;
        this.restartPreview();
    }

    public CaptureActivityHandler(ScanModule_internal scan_module, Looper looper) {
        super(looper);
        this.mScanModule = scan_module;
        this.decodeThread = new DecodeThread(this.mScanModule);
        this.decodeThread.start();
        this.state = State.INITED;
        this.restartPreview();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 100: {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "message.what=MSG_ID_AUTO_FOCUS");
                CameraManager.get().requestAutoFocus(this, 100);
                break;
            }
            case 101: {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "message.what=MSG_ID_RESTART_PREVIEW");
                this.restartPreview();
                break;
            }
            case 102: {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "message.what=MSG_ID_STOP_PREVIEW");
                this.stopPreviewAndFocus();
                break;
            }
            case 103: {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "Decode successful");
                this.scanAndDecodeTimeEnd = System.currentTimeMillis();
                int scanAndDecodeTime = (int)(this.scanAndDecodeTimeEnd - this.scanAndDecodeTimeBegin);
                this.state = State.SUCCESS;
                Result rawResult = (Result)message.obj;
                Bundle data = message.getData();
                int success_counts = data.getInt("KEY_SUCCESS_COUNTS");
                int fail_counts = data.getInt("KEY_FAIL_COUNTS");
                int preview_counts = data.getInt("KEY_PREVIEW_COUNTS");
                int jni_cost_time = data.getInt("KEY_JNI_COST_TIME");
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "decode result: barcodeText=" + rawResult.getmBarcodeText() + ",codeType=" + rawResult.getCodeType() + ",jni_cost_time=" + jni_cost_time + ",preview_counts=" + preview_counts + ",success_counts=" + success_counts + ",fail_counts=" + fail_counts);
                if (!PreferencesManager.getContinuousScan()) {
                    this.stopPreviewAndFocus();
                }
                if (PreferencesManager.getScanModuleMode()) {
                    this.mScanModule.decodeSuccessful_Callback(rawResult, preview_counts, success_counts, fail_counts, jni_cost_time, scanAndDecodeTime);
                    break;
                }
                this.activity.decodeSuccessful_Callback(rawResult, preview_counts, success_counts, fail_counts, jni_cost_time, scanAndDecodeTime);
                break;
            }
            case 104: {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "Decode failed");
                this.scanAndDecodeTimeEnd = System.currentTimeMillis();
                int scanAndDecodeTime = (int)(this.scanAndDecodeTimeEnd - this.scanAndDecodeTimeBegin);
                this.state = State.PREVIEW;
                this.request_PreviewFrame();
                byte[] img = (byte[])message.obj;
                Bundle data = message.getData();
                int success_counts = data.getInt("KEY_SUCCESS_COUNTS");
                int fail_counts = data.getInt("KEY_FAIL_COUNTS");
                int preview_counts = data.getInt("KEY_PREVIEW_COUNTS");
                int jni_cost_time = data.getInt("KEY_JNI_COST_TIME");
                int width = data.getInt("KEY_IMG_WIDTH");
                int height = data.getInt("KEY_IMG_HEIGHT");
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + ",jni_cost_time=" + jni_cost_time + ",preview_counts=" + preview_counts + ",success_counts=" + success_counts + ",fail_counts=" + fail_counts);
                if (!PreferencesManager.getOnlyPreview()) {
                    if (PreferencesManager.getScanModuleMode()) {
                        this.mScanModule.displayDecodeResult(false, img, width, height, preview_counts, success_counts, fail_counts, jni_cost_time, scanAndDecodeTime);
                        break;
                    }
                    this.activity.displayDecodeResult(false, -1, img, width, height, preview_counts, success_counts, fail_counts, jni_cost_time, scanAndDecodeTime);
                    break;
                }
                if (PreferencesManager.getScanModuleMode()) {
                    this.mScanModule.displayPreveiwCounts(preview_counts);
                    break;
                }
                this.activity.displayPreveiwCounts(preview_counts);
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.stopPreviewAndFocus();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)106);
        quit.sendToTarget();
        this.removeMessages(103);
        this.removeMessages(104);
        this.removeMessages(105);
        this.removeMessages(100);
    }

    private void stopPreviewAndFocus() {
        try {
            if (CameraManager.get() == null) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "CameraManager.get()==null, it has be released."));
                return;
            }
            CameraManager.get().cancelAutoFocus();
            CameraManager.get().stopPreview();
            this.state = State.INITED;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NullPointerException, it has be released."));
        }
    }

    private void restartPreview() {
        try {
            if (CameraManager.get() == null) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "CameraManager.get()==null, it has be released."));
                return;
            }
            CameraManager.get().startPreview();
            LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "state =" + (Object)((Object)this.state));
            if (this.state == State.INITED || this.state == State.PREVIEW || this.state == State.SUCCESS) {
                this.request_PreviewFrame();
                CameraManager.get().requestAutoFocus(this, 100);
            }
            this.state = State.PREVIEW;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NullPointerException, it has be released."));
        }
    }

    private void request_PreviewFrame() {
        this.scanAndDecodeTimeBegin = System.currentTimeMillis();
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "begin requestPreviewFrame");
        try {
            if (CameraManager.get() == null) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "CameraManager.get()==null, it has be released."));
                return;
            }
            CameraManager.get().requestPreviewFrame(this.decodeThread.getHandler(), 105);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NullPointerException, it has be released."));
        }
    }

    private static enum State {
        INITED,
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

