/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.camera;

import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import com.landicorp.android.scan.camera.CameraConfigurationManager;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = "ScanDecoder_" + PreviewCallback.class.getSimpleName();
    private final CameraConfigurationManager configManager;
    private final boolean useOneShotPreviewCallback;
    private Handler previewHandler;
    private int previewMessage;

    PreviewCallback(CameraConfigurationManager configManager, boolean useOneShotPreviewCallback) {
        this.configManager = configManager;
        this.useOneShotPreviewCallback = useOneShotPreviewCallback;
    }

    void setHandler(Handler previewHandler, int previewMessage) {
        this.previewHandler = previewHandler;
        this.previewMessage = previewMessage;
    }

    public void onPreviewFrame(byte[] data, Camera arg1) {
        Point cameraResolution = this.configManager.getCameraResolution();
        if (this.previewHandler != null) {
            Message message = this.previewHandler.obtainMessage(this.previewMessage, cameraResolution.x, cameraResolution.y, (Object)data);
            message.sendToTarget();
            this.previewHandler = null;
        } else {
            LogUtils.d(TAG, String.valueOf(Util.getMethodLine()) + "Got preview callback, but no handler for it");
        }
    }
}

