/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.camera;

import android.util.Log;
import com.landicorp.android.scan.decode.nativeMethod;
import com.landicorp.android.scan.util.Util;

public class FixFucosSetting {
    private static final String TAG = "FixFucosSetting";
    public static final int FIX_FOCUS_ENABLE = 1;
    public static final int FIX_FOCUS_DISABLE = 0;
    public static final int FIX_FOCUS_DISTANCE_MODE_USER_DEFINE = 0;
    public static final int FIX_FOCUS_DISTANCE_MODE_BASE_SCAN = 1;
    public static final int FIX_FOCUS_DISTANCE_MODE_HAND_SCAN = 2;
    public static final int FIX_FOCUS_DISTANCE_MODE_CAPTURE = 3;
    private nativeMethod mNativeMethod = nativeMethod.getInstance();

    public int EnableFixFocus(int enable) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "enable=" + enable));
        int ret = 0;
        try {
            ret = this.mNativeMethod.EnableFixFocus(enable);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for EnableFixFocus"));
            ret = 1;
        }
        return ret;
    }

    public int SetFixFocusDistance(int mode, int reserve) {
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "mode=" + mode + ",reserve=0x" + Integer.toHexString(reserve)));
        if (mode == 0 && (reserve < 178 || reserve > 1017)) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "parameter is wrong. For FIX_FOCUS_DISTANCE_MODE_USER_DEFINE, the reserve range is [0x0b2\uff0c0x3F9]"));
            return 2;
        }
        int ret = 0;
        try {
            ret = this.mNativeMethod.SetFixFocusDistance(mode, reserve);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No implementation in libjni_decode.so for SetFixFocusDistance"));
            ret = 3;
        }
        return ret;
    }
}

