/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.camera;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import com.landicorp.android.scan.camera.AutoFocusCallback;
import com.landicorp.android.scan.camera.CameraConfigurationManager;
import com.landicorp.android.scan.camera.PreviewCallback;
import com.landicorp.android.scan.scanDecoder.CaptureActivity;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;
import java.io.IOException;

public final class CameraManager {
    private static final String TAG = "ScanDecoder_CameraManager";
    private static CameraManager cameraManager;
    static final int SDK_INT;
    private final CameraConfigurationManager configManager;
    private static Camera mCamera;
    private boolean initialized = false;
    private boolean previewing = false;
    private boolean autoFocusing = false;
    private final boolean useOneShotPreviewCallback;
    private final PreviewCallback previewCallback;
    private final AutoFocusCallback autoFocusCallback;
    private Camera.Parameters parameter;
    private static CaptureActivity mActivity;
    private Rect framingRectInPreview;

    static {
        int sdkInt;
        try {
            sdkInt = Build.VERSION.SDK_INT;
        }
        catch (NumberFormatException nfe) {
            sdkInt = 10000;
        }
        SDK_INT = sdkInt;
    }

    public static void init(Context context) {
        mActivity = null;
        if (cameraManager == null) {
            Log.d((String)TAG, (String)"cameraManager=null,create a new instance");
            cameraManager = new CameraManager(context);
        } else {
            Log.d((String)TAG, (String)"cameraManager instance exist, use it");
        }
    }

    public static void init(Context context, CaptureActivity activity) {
        mActivity = activity;
        if (cameraManager == null) {
            Log.d((String)TAG, (String)"cameraManager=null,create a new instance");
            cameraManager = new CameraManager(context, activity);
        } else {
            Log.d((String)TAG, (String)"cameraManager instance exist, use it");
        }
    }

    public static void exit() {
        if (cameraManager != null) {
            cameraManager = null;
        }
    }

    public CaptureActivity getCaptureActivity() {
        return mActivity;
    }

    public static CameraManager get() {
        return cameraManager;
    }

    private CameraManager(Context context) {
        this.configManager = new CameraConfigurationManager(context);
        this.useOneShotPreviewCallback = SDK_INT > 3;
        this.previewCallback = new PreviewCallback(this.configManager, this.useOneShotPreviewCallback);
        this.autoFocusCallback = new AutoFocusCallback();
    }

    private CameraManager(Context context, CaptureActivity activity) {
        this.configManager = new CameraConfigurationManager(context, activity);
        this.useOneShotPreviewCallback = SDK_INT > 3;
        this.previewCallback = new PreviewCallback(this.configManager, this.useOneShotPreviewCallback);
        this.autoFocusCallback = new AutoFocusCallback();
    }

    @SuppressLint(value={"NewApi"})
    public static int openCamera(int cameraID) throws IOException {
        try {
            if (mCamera == null) {
                Log.d((String)TAG, (String)("cameraID=" + cameraID));
                mCamera = Camera.open((int)cameraID);
            }
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"open camera failed");
            return 1;
        }
        if (mCamera == null) {
            return 1;
        }
        return 0;
    }

    @TargetApi(value=9)
    @SuppressLint(value={"NewApi"})
    private void openCamera() {
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            Log.w((String)TAG, (String)"No cameras!");
            return;
        }
        int index = 0;
        while (index < numCameras) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 0) break;
            ++index;
        }
        if (index < numCameras) {
            Log.i((String)TAG, (String)("Opening camera #" + index));
            mCamera = Camera.open((int)index);
        } else if (numCameras >= 2) {
            Log.i((String)TAG, (String)"No camera facing back; returning camera #1");
            mCamera = Camera.open((int)1);
        } else {
            Log.i((String)TAG, (String)"No camera facing back; returning camera #0");
            mCamera = Camera.open((int)0);
        }
    }

    @TargetApi(value=9)
    @SuppressLint(value={"NewApi"})
    public void openDriver(SurfaceHolder holder) throws IOException {
        if (mCamera == null) {
            throw new IOException();
        }
        mCamera.setPreviewDisplay(holder);
        if (!this.initialized) {
            this.configManager.initFromCameraParameters(mCamera);
        }
        this.configManager.setDesiredCameraParameters(mCamera);
    }

    public Point getCameraResolution() {
        return this.configManager.getCameraResolution();
    }

    public Rect getFramingRectInPreview() {
        int topOffset;
        String PreviewCutSize = PreferencesManager.getPreviewCutSize();
        String[] size = PreviewCutSize.split("x");
        int cropWidth = Integer.parseInt(size[0]);
        int cropHeight = Integer.parseInt(size[1]);
        Point point = new Point(cropWidth, cropHeight);
        Point cameraResolution = this.configManager.getCameraResolution();
        int tmpWidth = cameraResolution.x - point.x;
        int tmpHeight = cameraResolution.y - point.y;
        int leftOffset = tmpWidth > 0 ? tmpWidth / 2 : 0;
        int n = topOffset = tmpHeight > 0 ? tmpHeight / 2 : 0;
        if (this.framingRectInPreview == null) {
            if (mCamera == null) {
                return null;
            }
            this.framingRectInPreview = new Rect(leftOffset, topOffset, leftOffset + point.x, topOffset + point.y);
        } else {
            this.framingRectInPreview.set(leftOffset, topOffset, leftOffset + point.x, topOffset + point.y);
        }
        return this.framingRectInPreview;
    }

    public int getCameraOritation() {
        return this.configManager.getCameraDisplayOrientation();
    }

    public static void closeDriver() {
        if (mCamera != null) {
            mCamera.release();
            mCamera = null;
        }
    }

    public void startPreview() {
        if (mCamera != null && !this.previewing) {
            mCamera.startPreview();
            this.previewing = true;
        }
    }

    public void stopPreview() {
        if (mCamera != null && this.previewing) {
            if (!this.useOneShotPreviewCallback) {
                mCamera.setPreviewCallback(null);
            }
            mCamera.stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.autoFocusCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public void requestPreviewFrame(Handler handler, int message) {
        if (mCamera != null && this.previewing) {
            this.previewCallback.setHandler(handler, message);
            if (this.useOneShotPreviewCallback) {
                mCamera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            } else {
                mCamera.setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            }
        } else {
            if (mCamera == null) {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "mCamera == null");
            }
            if (!this.previewing) {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "previewing == false");
            }
        }
    }

    public void requestAutoFocus(Handler handler, int message) {
        if (mCamera != null && this.previewing) {
            this.autoFocusCallback.setHandler(handler, message);
            String focusMode = PreferencesManager.getFocusMode();
            LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "focusMode=" + focusMode);
            if (focusMode == null) {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "focusMode==null, not call autoFocus");
                return;
            }
            if (focusMode.equals("infinity") || focusMode.equals("fixed") || focusMode.equals("continuous-video") || focusMode.equals("continuous-picture") || focusMode.equals("edof")) {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + focusMode + " focusMode not need call autoFocus");
            } else {
                LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + focusMode + " focusMode need call autoFocus");
                mCamera.autoFocus((Camera.AutoFocusCallback)this.autoFocusCallback);
                this.autoFocusing = true;
            }
        }
    }

    public void cancelAutoFocus() {
        if (mCamera != null && this.previewing && this.autoFocusing) {
            mCamera.cancelAutoFocus();
            this.autoFocusing = false;
        }
    }

    public Camera getCamera() {
        return mCamera;
    }

    public Point getDefaultPreviewSize() {
        return this.configManager.getCameraResolution();
    }

    public Point getBestPreviewSize() {
        return this.configManager.getBestCameraResolution(mCamera);
    }

    public Point getScreenResolution() {
        return this.configManager.getScreenResolution();
    }

    public Point getBestCameraResolution() {
        return this.configManager.getBestCameraResolution(mCamera);
    }
}

