/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.camera;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.landicorp.android.scan.scanDecoder.CaptureActivity;
import com.landicorp.android.scan.scanDecoder.PreferencesManager;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

final class CameraConfigurationManager {
    private static final String TAG = "ScanDecoder_" + CameraConfigurationManager.class.getSimpleName();
    private static final int TEN_DESIRED_ZOOM = 27;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int MIN_PREVIEW_PIXELS = 150400;
    private static final int MAX_PREVIEW_PIXELS = 921600;
    private final Context context;
    private Point screenResolution;
    private Point cameraResolution;
    private Point cameraBestResolution;
    private int previewFormat;
    private String previewFormatString;
    private CaptureActivity mActivity = null;
    private int displayOrientation = 0;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    CameraConfigurationManager(Context context, CaptureActivity activity) {
        this.context = context;
        this.mActivity = activity;
    }

    void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        this.previewFormat = parameters.getPreviewFormat();
        this.previewFormatString = parameters.get("preview-format");
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        this.screenResolution = new Point(display.getWidth(), display.getHeight());
        Point screenResolutionForCamera = new Point();
        screenResolutionForCamera.x = this.screenResolution.x;
        screenResolutionForCamera.y = this.screenResolution.y;
        if (this.screenResolution.x < this.screenResolution.y) {
            screenResolutionForCamera.x = this.screenResolution.y;
            screenResolutionForCamera.y = this.screenResolution.x;
        }
        String defaultSize = null;
        if (PreferencesManager.getFrontFaceCamera()) {
            Log.d((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "use front camera"));
            defaultSize = PreferencesManager.getFrontCameraPreviewSize();
        } else {
            Log.d((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "use back camera"));
            defaultSize = PreferencesManager.getBackCameraPreviewSize();
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "previewSizeFromXML=" + defaultSize));
        if (!this.isSupportPreviewSize(defaultSize, camera)) {
            defaultSize = this.getMaxPreviewSize(parameters);
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "finally previewSize=" + defaultSize));
        String[] size = defaultSize.split("x");
        this.cameraResolution = new Point(Integer.parseInt(size[0]), Integer.parseInt(size[1]));
    }

    void setDesiredCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        Log.d((String)TAG, (String)("cameraResolution.x=" + this.cameraResolution.x + ",cameraResolution.y=" + this.cameraResolution.y));
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        this.setFlash(parameters);
        this.setFocusMode(parameters, camera);
        this.setCameraDisplayOrientation(this.mActivity, camera);
        if (PreferencesManager.getFrontFaceCamera()) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "front camera set no-display-mode"));
            parameters.set("no-display-mode", 1);
        }
        camera.setParameters(parameters);
    }

    @TargetApi(value=9)
    @SuppressLint(value={"NewApi"})
    private void setCameraDisplayOrientation(Activity activity, Camera camera) {
        int degrees;
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int i = 0;
        if (i < numberOfCameras) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 0) {
                boolean cameraId = false;
            } else {
                boolean bl = true;
            }
        }
        if (PreferencesManager.getScanModuleMode()) {
            degrees = 0;
        } else {
            int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
            degrees = 0;
            switch (rotation) {
                case 0: {
                    degrees = 0;
                    break;
                }
                case 1: {
                    degrees = 90;
                    break;
                }
                case 2: {
                    degrees = 180;
                    break;
                }
                case 3: {
                    degrees = 270;
                }
            }
        }
        if (cameraInfo.facing == 1) {
            this.displayOrientation = (cameraInfo.orientation + degrees) % 360;
            this.displayOrientation = (360 - this.displayOrientation) % 360;
        } else {
            this.displayOrientation = (cameraInfo.orientation - degrees + 360) % 360;
        }
        LogUtils.i(TAG, String.valueOf(Util.getMethodLine()) + "info.orientation = " + cameraInfo.orientation + " result=" + this.displayOrientation);
        camera.setDisplayOrientation(this.displayOrientation);
    }

    public int getCameraDisplayOrientation() {
        return this.displayOrientation;
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    public Point getBestCameraResolution(Camera camera) {
        if (camera == null) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "camera=null"));
            return null;
        }
        Camera.Parameters parameters = camera.getParameters();
        Point screenResolutionForCamera = new Point();
        screenResolutionForCamera.x = this.screenResolution.x;
        screenResolutionForCamera.y = this.screenResolution.y;
        if (this.screenResolution.x < this.screenResolution.y) {
            screenResolutionForCamera.x = this.screenResolution.y;
            screenResolutionForCamera.y = this.screenResolution.x;
        }
        this.cameraBestResolution = CameraConfigurationManager.findBestPreviewSizeValue(parameters, screenResolutionForCamera);
        return this.cameraBestResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    int getPreviewFormat() {
        return this.previewFormat;
    }

    String getPreviewFormatString() {
        return this.previewFormatString;
    }

    private String getMaxPreviewSize(Camera.Parameters parameters) {
        StringBuilder maxSize = null;
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            Log.w((String)TAG, (String)"Device returned no supported preview sizes; using default");
            Camera.Size defaultSize = parameters.getPreviewSize();
            maxSize = new StringBuilder();
            maxSize.append(defaultSize.width).append("x").append(defaultSize.height);
            return maxSize.toString();
        }
        ArrayList supportedPreviewSizes = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPreviewSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        maxSize = new StringBuilder();
        maxSize.append(((Camera.Size)supportedPreviewSizes.get((int)0)).width).append("x").append(((Camera.Size)supportedPreviewSizes.get((int)0)).height);
        return maxSize.toString();
    }

    private static Point findBestPreviewSizeValue(Camera.Parameters parameters, Point screenResolution) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        if (rawSupportedSizes == null) {
            Log.w((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Device returned no supported preview sizes; using default"));
            Camera.Size defaultSize = parameters.getPreviewSize();
            return new Point(defaultSize.width, defaultSize.height);
        }
        ArrayList supportedPreviewSizes = new ArrayList(rawSupportedSizes);
        Collections.sort(supportedPreviewSizes, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size a, Camera.Size b) {
                int bPixels = b.height * b.width;
                int aPixels = a.height * a.width;
                if (bPixels < aPixels) {
                    return -1;
                }
                if (bPixels > aPixels) {
                    return 1;
                }
                return 0;
            }
        });
        StringBuilder previewSizesString = new StringBuilder();
        for (Camera.Size supportedPreviewSize : supportedPreviewSizes) {
            previewSizesString.append(supportedPreviewSize.width).append('x').append(supportedPreviewSize.height).append(' ');
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Supported preview sizes: " + previewSizesString));
        Point bestSize = null;
        float screenAspectRatio = (float)screenResolution.x / (float)screenResolution.y;
        float diff = Float.POSITIVE_INFINITY;
        for (Camera.Size supportedPreviewSize : supportedPreviewSizes) {
            int maybeFlippedHeight;
            int realWidth = supportedPreviewSize.width;
            int realHeight = supportedPreviewSize.height;
            int pixels = realWidth * realHeight;
            boolean isCandidatePortrait = realWidth < realHeight;
            int maybeFlippedWidth = isCandidatePortrait ? realHeight : realWidth;
            int n = maybeFlippedHeight = isCandidatePortrait ? realWidth : realHeight;
            if (maybeFlippedWidth == screenResolution.x && maybeFlippedHeight == screenResolution.y) {
                Point exactPoint = new Point(realWidth, realHeight);
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Found preview size exactly matching screen size: " + exactPoint));
                return exactPoint;
            }
            float aspectRatio = (float)maybeFlippedWidth / (float)maybeFlippedHeight;
            float newDiff = Math.abs(aspectRatio - screenAspectRatio);
            if (!(newDiff < diff)) continue;
            bestSize = new Point(realWidth, realHeight);
            diff = newDiff;
        }
        if (bestSize == null) {
            Camera.Size defaultSize = parameters.getPreviewSize();
            bestSize = new Point(defaultSize.width, defaultSize.height);
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "No suitable preview sizes, using default: " + bestSize));
        }
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "Found best approximate preview size: " + bestSize));
        return bestSize;
    }

    private static Point getCameraResolution(Camera.Parameters parameters, Point screenResolution) {
        String previewSizeValueString = parameters.get("preview-size-values");
        if (previewSizeValueString == null) {
            previewSizeValueString = parameters.get("preview-size-value");
        }
        Point cameraResolution = null;
        if (previewSizeValueString != null) {
            cameraResolution = CameraConfigurationManager.findBestPreviewSizeValue(previewSizeValueString, screenResolution);
        }
        if (cameraResolution == null) {
            cameraResolution = new Point(screenResolution.x >> 3 << 3, screenResolution.y >> 3 << 3);
        }
        return cameraResolution;
    }

    private static Point findBestPreviewSizeValue(CharSequence previewSizeValueString, Point screenResolution) {
        int bestX = 0;
        int bestY = 0;
        int diff = Integer.MAX_VALUE;
        String[] stringArray = COMMA_PATTERN.split(previewSizeValueString);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                String previewSize = stringArray[n2];
                int dimPosition = (previewSize = previewSize.trim()).indexOf(120);
                if (dimPosition >= 0) {
                    int newY;
                    int newX;
                    try {
                        newX = Integer.parseInt(previewSize.substring(0, dimPosition));
                        newY = Integer.parseInt(previewSize.substring(dimPosition + 1));
                    }
                    catch (NumberFormatException nfe) {
                        break block7;
                    }
                    int newDiff = Math.abs(newX - screenResolution.x) + Math.abs(newY - screenResolution.y);
                    if (newDiff == 0) {
                        bestX = newX;
                        bestY = newY;
                        break;
                    }
                    if (newDiff < diff) {
                        bestX = newX;
                        bestY = newY;
                        diff = newDiff;
                    }
                }
            }
            ++n2;
        }
        if (bestX > 0 && bestY > 0) {
            return new Point(bestX, bestY);
        }
        return null;
    }

    private static int findBestMotZoomValue(CharSequence stringValues, int tenDesiredZoom) {
        int tenBestValue = 0;
        String[] stringArray = COMMA_PATTERN.split(stringValues);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            double value;
            String stringValue = stringArray[n2];
            stringValue = stringValue.trim();
            try {
                value = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException nfe) {
                return tenDesiredZoom;
            }
            int tenValue = (int)(10.0 * value);
            if (Math.abs((double)tenDesiredZoom - value) < (double)Math.abs(tenDesiredZoom - tenBestValue)) {
                tenBestValue = tenValue;
            }
            ++n2;
        }
        return tenBestValue;
    }

    private void setFlash(Camera.Parameters parameters) {
        boolean bFlashLight = PreferencesManager.getFlashLight();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "bFlashLight=" + bFlashLight));
        if (bFlashLight) {
            parameters.setFlashMode("torch");
        } else {
            parameters.setFlashMode("off");
        }
    }

    private void setZoom(Camera.Parameters parameters) {
        String motZoomStepString;
        String motZoomValuesString;
        String takingPictureZoomMaxString;
        String zoomSupportedString = parameters.get("zoom-supported");
        if (zoomSupportedString != null && !Boolean.parseBoolean(zoomSupportedString)) {
            return;
        }
        int tenDesiredZoom = 27;
        String maxZoomString = parameters.get("max-zoom");
        if (maxZoomString != null) {
            try {
                int tenMaxZoom = (int)(10.0 * Double.parseDouble(maxZoomString));
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "Bad max-zoom: " + maxZoomString);
            }
        }
        if ((takingPictureZoomMaxString = parameters.get("taking-picture-zoom-max")) != null) {
            try {
                int tenMaxZoom = Integer.parseInt(takingPictureZoomMaxString);
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                LogUtils.w(TAG, String.valueOf(Util.getMethodLine()) + "Bad taking-picture-zoom-max: " + takingPictureZoomMaxString);
            }
        }
        if ((motZoomValuesString = parameters.get("mot-zoom-values")) != null) {
            tenDesiredZoom = CameraConfigurationManager.findBestMotZoomValue(motZoomValuesString, tenDesiredZoom);
        }
        if ((motZoomStepString = parameters.get("mot-zoom-step")) != null) {
            try {
                double motZoomStep = Double.parseDouble(motZoomStepString.trim());
                int tenZoomStep = (int)(10.0 * motZoomStep);
                if (tenZoomStep > 1) {
                    tenDesiredZoom -= tenDesiredZoom % tenZoomStep;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (maxZoomString != null || motZoomValuesString != null) {
            parameters.set("zoom", String.valueOf((double)tenDesiredZoom / 10.0));
        }
        if (takingPictureZoomMaxString != null) {
            parameters.set("taking-picture-zoom", tenDesiredZoom);
        }
    }

    private void setFocusMode(Camera.Parameters parameters, Camera camera) {
        String focusMode = PreferencesManager.getFocusMode();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "focusMode=" + focusMode));
        if (!this.isSupportFocusMode(focusMode, camera)) {
            Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + focusMode + " is not Supported FocusMode,try to set autoFocus"));
            if (this.isSupportFocusMode("auto", camera)) {
                Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + " it Supporte autoFocus, set it"));
                try {
                    PreferencesManager.setFocusMode("auto");
                    PreferencesManager.writeFocusMode2XML(this.mActivity, "auto");
                    PreferencesManager.readFocusModeFromXML(this.mActivity);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NullPointerException, do not worry, we has deal it."));
                }
                focusMode = PreferencesManager.getFocusMode();
            } else {
                Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + " it not Supporte autoFocus, try to set fixed"));
                if (this.isSupportFocusMode("fixed", camera)) {
                    Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + " it Supporte fixed, set it"));
                    try {
                        PreferencesManager.setFocusMode("fixed");
                        PreferencesManager.writeFocusMode2XML(this.mActivity, "fixed");
                        PreferencesManager.readFocusModeFromXML(this.mActivity);
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "NullPointerException, do not worry, we has deal it."));
                    }
                    focusMode = PreferencesManager.getFocusMode();
                } else {
                    Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + " it not Supporte fixed, do nothing"));
                }
            }
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "after set--focusMode=" + focusMode));
        }
        parameters.setFocusMode(focusMode);
    }

    private void setExposureCompensation(Camera.Parameters parameters, Camera camera) {
        String strExposureCompensationIndex = PreferencesManager.getExposureCompensationIndex();
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "strExposureCompensationIndex=" + strExposureCompensationIndex));
        if (!this.isSupportExposureCompensationIndex(strExposureCompensationIndex, camera)) {
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "use default ExposureCompensation"));
            return;
        }
        int intExposureCompensationIndex = Integer.parseInt(strExposureCompensationIndex);
        Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "intExposureCompensationIndex=" + intExposureCompensationIndex));
        parameters.setExposureCompensation(intExposureCompensationIndex);
    }

    private boolean isSupportPreviewSize(String previewSize, Camera camera) {
        if (previewSize == null) {
            return false;
        }
        if (camera != null) {
            List previewList = camera.getParameters().getSupportedPreviewSizes();
            int i = 0;
            while (i < previewList.size()) {
                Camera.Size size = (Camera.Size)previewList.get(i);
                String tmp = String.valueOf(String.valueOf(size.width)) + "x" + String.valueOf(size.height);
                if (previewSize.equals(tmp)) {
                    Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + previewSize + " is support previewSize"));
                    return true;
                }
                ++i;
            }
        } else {
            Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "camera=null"));
        }
        Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + previewSize + " is not support previewSize"));
        return false;
    }

    private boolean isSupportFocusMode(String focusMode, Camera camera) {
        if (focusMode == null) {
            return false;
        }
        List supportFocusModesList = null;
        if (camera != null) {
            supportFocusModesList = camera.getParameters().getSupportedFocusModes();
            int i = 0;
            while (i < supportFocusModesList.size()) {
                String mode = (String)supportFocusModesList.get(i);
                if (mode.equals(focusMode)) {
                    Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + focusMode + " is Supported FocusMode"));
                    return true;
                }
                ++i;
            }
        } else {
            Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "camera=null"));
        }
        Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + focusMode + " is not Supported FocusMode,set it to autoFocus"));
        return false;
    }

    private boolean isSupportExposureCompensationIndex(String strIndex, Camera camera) {
        if (strIndex == null) {
            return false;
        }
        if (camera != null) {
            int MinExposureCompensationIndex = camera.getParameters().getMinExposureCompensation();
            int MaxExposureCompensationIndex = camera.getParameters().getMaxExposureCompensation();
            float ExposureCompensationStep = camera.getParameters().getExposureCompensationStep();
            int CurrentExposureCompensationIndex = camera.getParameters().getExposureCompensation();
            float CurrentExposureValue = (float)CurrentExposureCompensationIndex * ExposureCompensationStep;
            Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "CurrentExposureCompensationIndex=" + CurrentExposureCompensationIndex + ",ExposureCompensationStep=" + ExposureCompensationStep + ",MinExposureCompensationIndex=" + MinExposureCompensationIndex + ",MaxExposureCompensationIndex=" + MaxExposureCompensationIndex + ",CurrentExposureValue=" + CurrentExposureValue));
            if (MaxExposureCompensationIndex == 0 && MinExposureCompensationIndex == 0) {
                Log.i((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "phone not support Exposure Compensation"));
                return false;
            }
            int i = MinExposureCompensationIndex;
            while (i <= MaxExposureCompensationIndex) {
                String tmp = Integer.toString(i);
                if (tmp.equals(strIndex)) {
                    Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + strIndex + " is support ExposureCompensationIndex"));
                    return true;
                }
                ++i;
            }
        } else {
            Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + "camera=null"));
        }
        Log.e((String)TAG, (String)(String.valueOf(Util.getMethodLine()) + strIndex + " is not support ExposureCompensationIndex"));
        return false;
    }
}

