/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.scan.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import com.landicorp.android.scan.util.LogUtils;
import com.landicorp.android.scan.util.Util;

final class AutoFocusCallback
implements Camera.AutoFocusCallback {
    private static final String TAG = "ScanDecoder_" + AutoFocusCallback.class.getSimpleName();
    private static final long AUTOFOCUS_INTERVAL_MS = 2000L;
    private Handler autoFocusHandler;
    private int autoFocusMessage;

    AutoFocusCallback() {
    }

    void setHandler(Handler autoFocusHandler, int autoFocusMessage) {
        this.autoFocusHandler = autoFocusHandler;
        this.autoFocusMessage = autoFocusMessage;
    }

    public void onAutoFocus(boolean success, Camera arg1) {
        LogUtils.d(TAG, String.valueOf(Util.getMethodLine()) + "begin");
        if (this.autoFocusHandler != null) {
            Message message = this.autoFocusHandler.obtainMessage(this.autoFocusMessage, (Object)success);
            this.autoFocusHandler.sendMessageDelayed(message, 2000L);
            this.autoFocusHandler = null;
        } else {
            LogUtils.d(TAG, String.valueOf(Util.getMethodLine()) + "Got auto-focus callback, but no handler for it");
        }
    }
}

