/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import com.landicorp.android.eptapi.utils.IQrCode;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class QrCode {
    public static final int ECLEVEL_L = 0;
    public static final int ECLEVEL_M = 1;
    public static final int ECLEVEL_Q = 2;
    public static final int ECLEVEL_H = 3;
    private static final int TYPE_BYTES = 0;
    private static final int TYPE_STRING = 1;
    private int type = 0;
    private int eclevel = 2;
    private IQrCode icode;
    private byte[] bytesData;
    private String stringData;

    public QrCode(byte[] data, int eclevel) {
        if (eclevel > 3 || eclevel < 0) {
            throw new IllegalArgumentException("eclevel is not valid!");
        }
        this.type = 0;
        this.icode = this.createIQrCode();
        this.eclevel = eclevel;
        this.bytesData = data;
    }

    public QrCode(String data, int eclevel) {
        if (eclevel > 3 || eclevel < 0) {
            throw new IllegalArgumentException("eclevel is not valid!");
        }
        this.type = 1;
        this.icode = this.createIQrCode();
        this.eclevel = eclevel;
        this.stringData = data;
    }

    private IQrCode createIQrCode() {
        return new IQrCode();
    }

    public boolean convertToImage(String imageFile, int expectedHeight) {
        if (this.type == 0) {
            return this.icode.bytes2Image(this.bytesData, imageFile, this.eclevel, expectedHeight);
        }
        return this.icode.string2Image(this.stringData, imageFile, this.eclevel, expectedHeight);
    }

    public InputStream toImageFileStream(String imageFile, int expectedHeight) {
        try {
            if (!this.convertToImage(imageFile, expectedHeight)) {
                return null;
            }
            return new BufferedInputStream(new FileInputStream(imageFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

