/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.service;

import android.util.SparseArray;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.ClientManager;
import java.util.HashMap;
import java.util.Map;

public class ServiceVariable {
    static final Logger logger = Logger.getLogger(ServiceVariable.class);
    private static int mListenerKey = 1;
    private static Map<String, SparseArray<Integer>> mListeners = new HashMap<String, SparseArray<Integer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getListener(String packageName, int key) {
        Map<String, SparseArray<Integer>> map = mListeners;
        synchronized (map) {
            String appName = ClientManager.convertAppNameIfNeeded(packageName);
            SparseArray<Integer> listener = mListeners.get(appName);
            return listener == null ? null : (Integer)listener.get(key);
        }
    }

    public static int saveListener(String packageName, RemoteListener listener) {
        return ServiceVariable.saveListener(packageName, listener.getEventId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveListener(String packageName, int eventId) {
        Map<String, SparseArray<Integer>> map = mListeners;
        synchronized (map) {
            SparseArray<Integer> listener;
            String appName;
            if (mListenerKey == 0) {
                mListenerKey = 1;
            }
            if (!mListeners.containsKey(appName = ClientManager.convertAppNameIfNeeded(packageName))) {
                listener = new SparseArray<Integer>();
                mListeners.put(appName, listener);
            }
            listener = mListeners.get(appName);
            listener.put(mListenerKey, (Object)eventId);
            int n = mListenerKey++;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer removeListener(String packageName, int key) {
        Map<String, SparseArray<Integer>> map = mListeners;
        synchronized (map) {
            String appName = ClientManager.convertAppNameIfNeeded(packageName);
            if (!mListeners.containsKey(appName)) {
                logger.error("removeListener | packageName: " + appName + ", key: " + key + " not found!", new Object[0]);
                return null;
            }
            SparseArray<Integer> listener = mListeners.get(appName);
            Integer id = (Integer)listener.get(key);
            listener.remove(key);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(String packageName) {
        Map<String, SparseArray<Integer>> map = mListeners;
        synchronized (map) {
            String appName = ClientManager.convertAppNameIfNeeded(packageName);
            SparseArray<Integer> listener = mListeners.remove(appName);
            if (listener != null) {
                listener.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, SparseArray<Integer>> map = mListeners;
        synchronized (map) {
            mListeners.clear();
        }
    }
}

