/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.pinpad;

import android.os.Bundle;
import android.text.TextUtils;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.pinpad.AUKAuthData;
import com.landicorp.pinpad.AUKAuthDataIn;
import com.landicorp.pinpad.BooleanWraper;
import com.landicorp.pinpad.ByteArrayWraper;
import com.landicorp.pinpad.DesMode;
import com.landicorp.pinpad.IntWraper;
import com.landicorp.pinpad.KMS_AuthInfo;
import com.landicorp.pinpad.KMS_AuthOut;
import com.landicorp.pinpad.KMS_ReqInfo;
import com.landicorp.pinpad.KMS_SigOut;
import com.landicorp.pinpad.KapId;
import com.landicorp.pinpad.KapInfo;
import com.landicorp.pinpad.KeyCfg;
import com.landicorp.pinpad.KeyHandle;
import com.landicorp.pinpad.KeyInfo;
import com.landicorp.pinpad.MacMode;
import com.landicorp.pinpad.OfflinePinVerifyResult;
import com.landicorp.pinpad.PinEntryCfg;
import com.landicorp.pinpad.PinEntryEvent;
import com.landicorp.pinpad.PinEntryEventListener;
import com.landicorp.pinpad.PinEntryInfo;
import com.landicorp.pinpad.PinVerifyCfg;
import com.landicorp.pinpad.PinpadCfg;
import com.landicorp.pinpad.PinpadDevice;
import com.landicorp.pinpad.PinpadInfo;
import com.landicorp.pinpad.RemoteKeyData;
import com.landicorp.pinpad.TusnInfo;
import java.util.Arrays;

public class Pinpad {
    static final Logger logger = Logger.getLogger(Pinpad.class);
    public static final String DEVICE_IPP = "IPP";
    public static final String DEVICE_EPP = "COM_EPP";
    public static final int KEYTYPE_MASTER_KEY = 0;
    public static final int KEYTYPE_MAIN_KEY = 0;
    public static final int KEYTYPE_MAC_KEY = 1;
    public static final int KEYTYPE_PIN_KEY = 2;
    public static final int KEYTYPE_TD_KEY = 3;
    public static final int KEYTYPE_TD_KEY_2 = 4;
    public static final int KEYTYPE_ENC_DEC_KEY = 4;
    public static final int KEYTYPE_CBC_MAC_KEY = 5;
    public static final int KEYTYPE_RSA_KEY = 6;
    public static final int KEYTYPE_SIGN_KEY = 6;
    public static final int KEYTYPE_DERIVE_KEY = 7;
    public static final int KEYTYPE_IDENTITY_KEY = 8;
    public static final int INPUTSTATE_SUCCESS = 0;
    public static final int INPUTSTATE_INPUTING = 1;
    public static final int INPUTSTATE_ERROR = 2;
    public static final int INPUTSTATE_CANCEL = 3;
    @Deprecated
    public static final int MAC_ALG_ISO9797 = 0;
    @Deprecated
    public static final int MAC_ALG_AES = 1;
    public static final int MAC_PADDING_MODE_1 = 0;
    public static final int MAC_PADDING_MODE_2 = 16;
    public static final int MM_ALG_ISO9797 = 0;
    public static final int MM_ALG_AES = 1;
    public static final int MM_ALG_SM4 = 3;
    public static final int MM_ALG_TDES_CBC = 2;
    public static final int MAC_USE_ROUTEENC = 65536;
    public static final int MAGTRACK_USE_ROUTEENC = 4096;
    protected static final int KU_MAC_TDES_CBC = 50;
    public static final int KEY_CANCEL = 27;
    public static final int KEY_ENTER = 13;
    public static final int KEY_CLEAR = 101;
    public static final int CANCEL_INPUT_REASON_CANCELLED_BY_USER = 1;
    public static final int CANCEL_INPUT_REASON_LOSE_FOREGROUND = 2;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_OPEN_DEVICE = 2;
    public static final int ERROR_ABOLISH = 27;
    public static final int ERROR_ERROR = 1;
    public static final int ERROR_KCV_ERROR = 85;
    public static final int ERROR_ACCESSING_KAP_DENY = 63;
    public static final int ERROR_PERMISSION_DENY = 62;
    public static final int ERROR_ARGUMENT_CONFLICT = 52;
    public static final int ERROR_INVALID_ARGUMENT = 33;
    public static final int ERROR_BAD_KEY_USAGE = 47;
    public static final int ERROR_BAD_MODE_OF_KEY_USE = 48;
    public static final int ERROR_BAD_STATUS = 46;
    public static final int ERROR_COMM_ERR = 36;
    public static final int ERROR_BUSY = 38;
    public static final int ERROR_KEYBUNDLE_ERR = 77;
    public static final int ERROR_DATA_NOT_FOUND = 255;
    public static final int ERROR_DUKPT_COUNTER_OVERFLOW = 44;
    public static final int ERROR_WRONG_KAP_MODE = 64;
    public static final int ERROR_UNSUPPORTED_FUNC = 37;
    public static final int ERROR_TIME_OUT = 35;
    public static final int ERROR_SERVER_DIED = 92;
    public static final int ERROR_SAME_KEY_VALUE_DETECTED = 76;
    public static final int ERROR_PIN_ENTRY_TOO_FREQUENTLY = 72;
    public static final int ERROR_ENCRYPT_MAG_TRACK_TOO_FREQUENTLY = 78;
    public static final int ERROR_REFER_TO_KEY_OUTSIDE_KAP = 54;
    public static final int ERROR_NO_SUCH_PINPAD = 32;
    public static final int ERROR_KAP_ALREADY_EXIST = 51;
    public static final int ERROR_NO_SUCH_KEY = 39;
    public static final int ERROR_FAIL_TO_AUTH = 41;
    public static final int ERROR_ENC_KEY_FMT_TOO_SIMPLE = 75;
    public static final int ERROR_DUKPT_NOT_INITED = 73;
    public static final int ERROR_NO_ENOUGH_SPACE = 34;
    public static final int ERROR_NO_PIN_ENTERED = 43;
    public static final int ERROR_NO_SUCH_KAP = 50;
    private static final int ERROR_BASE = 32;
    public static final int ERROR_CANCELLED_BY_USER = 42;
    public static final int ERROR_REOPEN_PINPAD = 45;
    public static final int ERROR_INVALID_KEY_HANDLE = 49;
    public static final int ERROR_KEY_USAGE_AND_MODE_OF_USE_NOT_MATCH = 52;
    public static final int ERROR_INCOMPATIBLE_KEY_SYSTEM = 74;
    public static final int EXTEND_ERR_INPUT_TIMEOUT = 65281;
    public static final int EXTEND_ERR_INPUT_COMM_ERR = 65282;
    public static final int EXTEND_ERR_INPUT_UNKNOWN = 65283;
    public static final int KEYOFFSET_MAINKEY = 1;
    public static final int KEYOFFSET_PINKEY = 100;
    public static final int KEYOFFSET_MACKEY = 108;
    public static final int KEYOFFSET_TDKEY = 116;
    public static final int ENC_KEY_FMT_INVALID = -1;
    public static final int ENC_KEY_FMT_NORMAL = 0;
    public static final int ENC_KEY_FMT_ICBC = 1;
    public static final int ENC_KEY_FMT_TR31 = 3;
    public static final int ENC_KEY_FMT_AES192 = 6;
    public static final int ENC_KEY_FMT_CMBC = 5;
    public static final int ENC_KEY_FMT_TCBC = 4;
    public static final char KA_AES = 'A';
    public static final char KA_DEA = 'D';
    public static final char KA_TDEA = 'T';
    public static final char KA_SM4 = 'M';
    public static final char KA_RSA = 'R';
    public static final int KS_MKSK = 0;
    public static final int KS_DUKPT = 1;
    public static final int KS_FIXED_KEY = 2;
    public static final int KS_PKI_KEY = 3;
    public static final int MAC_OUTPUT_LEN_DEFAULT = 8;
    public static final int MAC_OUTPUT_LEN_AES_SM4 = 16;
    public static final int DATA_OUTPUT_LEN_DEFAULT = 8;
    public static final int DATA_OUTPUT_LEN_SM4 = 16;
    protected static final int KCV_LEN_DEFAULT = 4;
    protected static final int KCV_LEN_AES_SM4 = 8;
    protected static final int MAX_MAC_INPUT_EACH_LOAD = 1024;
    public static final int MAX_LEN_OF_GENERATE_RANDOM_NUM = 1024;
    public static final int RANDOM_NUM_LEN_DEFAULT = 8;
    public static final char MTEM_ECBMODE = '\u0000';
    public static final char MTEM_CBCMODE = '\u0001';
    public static final char MTEM_DEFAULT = '\u0000';
    public static final int TK_ALG_TECBMODE = 0;
    public static final int TK_ALG_SMS4MODE = 1;
    public static final int TK_TRANSFORMMODE_NOT = 0;
    public static final int TK_TRANSFORMMODE_REVERSE = 32768;
    public static final int TK_VARIANT_MODE_DEFAULT = 0;
    public static final int TK_VARIANT_MODE_DUKPT = 65536;
    public static final int KMS_MODE_SCHEME_V1 = 0;
    public static final int KMS_MODE_SCHEME_V2 = 16;
    public static final int SDM_DEFAULT_MODE_0 = 0;
    public static final int SDM_CUSTOM_MODE_1 = -16777215;
    private static byte DEFAULT_LOADMAINKEY_KEY_USAGE = (byte)12;
    private final String deviceName;
    private boolean isInputing = false;
    private String clientName;
    private int regionId;
    private int kapNum;
    private int keySystem = 0;
    private int lastError;
    private byte[] lenLimit = new byte[]{0, 6};
    private int timeoutBetweenPinKeys = 60;
    private int pinEntryTimeout = 300;
    private boolean isIpp;
    private int encKeyFormat = 0;
    private PinpadDevice device;
    private char keyAlgorithm = (char)84;
    private OnPinInputListener pinEntryListener;

    public Pinpad(int kapNum, String deviceName) {
        this(0, kapNum, 0, deviceName);
    }

    public Pinpad(String clientName, int kapNum, String deviceName) {
        this(clientName, 0, kapNum, 0, deviceName);
    }

    public Pinpad(int regionId, int kapNum, String deviceName) {
        this(regionId, kapNum, 0, deviceName);
    }

    public Pinpad(String clientName, int regionId, int kapNum, String deviceName) {
        this(clientName, regionId, kapNum, 0, deviceName);
    }

    public Pinpad(int regionId, int kapNum, int keySystem, String deviceName) {
        this(null, regionId, kapNum, keySystem, deviceName);
    }

    public Pinpad(String clientName, int regionId, int kapNum, int keySystem, String deviceName) {
        this.clientName = clientName;
        this.regionId = regionId;
        this.kapNum = kapNum;
        this.keySystem = keySystem;
        this.deviceName = TextUtils.isEmpty((CharSequence)deviceName) ? DEVICE_IPP : deviceName;
        this.isIpp = this.deviceName.equals(DEVICE_IPP);
    }

    private Pinpad(Builder builder) {
        this.clientName = builder.clientName;
        this.regionId = builder.regionId;
        this.kapNum = builder.kapNum;
        this.keySystem = builder.keySystem;
        this.deviceName = TextUtils.isEmpty((CharSequence)builder.deviceName) ? DEVICE_IPP : builder.deviceName;
        this.isIpp = this.deviceName.equals(DEVICE_IPP);
    }

    public void setKeyAlgorithm(char keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public PinpadDevice getInnerDevice() {
        return this.device;
    }

    private int createKap() {
        KapInfo info = new KapInfo();
        int ret = this.device.getKapInfo(new KapId(this.regionId, this.kapNum), info);
        if (ret == 50) {
            ret = this.device.createKap(new KapId(this.regionId, this.kapNum), "", null);
        }
        return ret;
    }

    public void setPinLengthLimit(byte[] lenLimit) {
        if (lenLimit != null) {
            this.lenLimit = lenLimit;
        }
    }

    public void inputOnlinePin(int workKeyId) {
        this.inputOnlinePin(null, workKeyId);
    }

    public void inputOnlinePin(byte[] panBlock, int workKeyId) {
        byte[] block = new byte[8];
        if (panBlock != null) {
            System.arraycopy(panBlock, 0, block, 0, panBlock.length < block.length ? panBlock.length : block.length);
        }
        byte pinBlockFormat = this.isSM4Enabled() ? (byte)-127 : 0;
        this.startPinEntry(true, workKeyId, block, pinBlockFormat);
    }

    public void inputOnlinePin(int workKeyId, byte[] panBlock, byte pinBlockFormat) {
        this.startPinEntry(true, workKeyId, panBlock, pinBlockFormat);
    }

    private void startPinEntrySupportPinBlockFormat(boolean isOnline, int workKeyId, String cardNo, PinEntryCfg pinEntryCfg) {
        if (this.device == null) {
            this.setLastError(49);
            this.onPinInputed(2, 0, null, 0);
            return;
        }
        if (isOnline) {
            pinEntryCfg.mPinEntryWorkMode = this.getPinEntryWorkMode();
            if (pinEntryCfg.mPinBlockFormat != 4 && pinEntryCfg.mPinBlockFormat != -47) {
                pinEntryCfg.mCardNo = Pinpad.makePanBlock(cardNo);
            }
            pinEntryCfg.mPinKey = this.makeKeyHandle(workKeyId);
        } else {
            pinEntryCfg.mPinEntryWorkMode = (byte)3;
            pinEntryCfg.mCardNo = null;
            pinEntryCfg.mPinKey = null;
        }
        this.isInputing = true;
        int ret = 0;
        ret = pinEntryCfg.mPinBlockFormat == 4 || pinEntryCfg.mPinBlockFormat == -47 ? this.device.startPinEntry(this.defaultPinEntryEventListener(), pinEntryCfg, cardNo) : this.device.startPinEntry(this.defaultPinEntryEventListener(), pinEntryCfg);
        if (ret != 0) {
            this.setLastError(ret);
            this.onPinInputed(2, 0, null, 0);
        }
    }

    private void startPinEntry(boolean isOnline, int workKeyId, byte[] panBlock, byte pinBlockFormat) {
        PinEntryCfg pinEntryConfig;
        if (this.device == null) {
            this.setLastError(49);
            this.onPinInputed(2, 0, null, 0);
            return;
        }
        if (isOnline) {
            pinEntryConfig = new PinEntryCfg(this.getPinEntryWorkMode(), this.makeKeyHandle(workKeyId), panBlock, this.lenLimit);
            pinEntryConfig.mPinBlockFormat = pinBlockFormat;
            pinEntryConfig.mPinEncMode = 0;
        } else {
            pinEntryConfig = new PinEntryCfg(3, null, null, this.lenLimit);
        }
        pinEntryConfig.mTimeoutBetweenPinKeys = this.timeoutBetweenPinKeys;
        pinEntryConfig.mPinEntryTimeout = this.pinEntryTimeout;
        pinEntryConfig.mReactionMode = this.isIpp ? 15 : 0;
        this.isInputing = true;
        int ret = this.device.startPinEntry(this.defaultPinEntryEventListener(), pinEntryConfig);
        if (ret != 0) {
            this.setLastError(ret);
            this.onPinInputed(2, 0, null, 0);
        }
    }

    public void startKeyPadEntry() {
        this.startKeyPadEntry(0);
    }

    public void startKeyPadEntry(int reactionMode) {
        PinEntryCfg pinEntryConfig = new PinEntryCfg(5, null, null, this.lenLimit, 0, 0, this.timeoutBetweenPinKeys, this.pinEntryTimeout, reactionMode);
        this.isInputing = true;
        int ret = this.device.startPinEntry(this.defaultPinEntryEventListener(), pinEntryConfig);
        if (ret != 0) {
            this.setLastError(ret);
            this.onPinInputed(2, 0, null, 0);
        }
    }

    private byte getPinEntryWorkMode() {
        byte pinEntryWorkMode = 0;
        switch (this.keySystem) {
            case 1: {
                pinEntryWorkMode = 1;
                break;
            }
            case 2: {
                pinEntryWorkMode = 2;
                break;
            }
            default: {
                pinEntryWorkMode = 0;
            }
        }
        return pinEntryWorkMode;
    }

    public void inputOfflinePin() {
        this.isInputing = true;
        byte pinBlockFormat = this.isSM4Enabled() ? (byte)-127 : 0;
        this.startPinEntry(false, 0, null, pinBlockFormat);
    }

    public void startPinEntry(int pinKeyId, byte[] cardNo, byte pinBlockFormat) {
        this.startPinEntry(true, pinKeyId, cardNo, pinBlockFormat);
    }

    public void startPinEntryNew(int pinKeyId, String cardNo, byte pinBlockFormat) {
        PinEntryCfg pinEntryCfg = new PinEntryCfg(0, null, null, this.lenLimit);
        pinEntryCfg.mPinBlockFormat = pinBlockFormat;
        pinEntryCfg.mPinEncMode = 0;
        pinEntryCfg.mTimeoutBetweenPinKeys = this.timeoutBetweenPinKeys;
        pinEntryCfg.mPinEntryTimeout = this.pinEntryTimeout;
        pinEntryCfg.mReactionMode = this.isIpp ? 15 : 0;
        this.startPinEntrySupportPinBlockFormat(true, pinKeyId, cardNo, pinEntryCfg);
    }

    public void startPinEntry(boolean isOnline, int keyId, byte[] panBlock, PinEntryCfg pinEntryCfg) {
        Precondition.checkNotNull(pinEntryCfg);
        if (this.device == null) {
            this.setLastError(49);
            this.onPinInputed(2, 0, null, 0);
            return;
        }
        if (isOnline) {
            pinEntryCfg.mPinEntryWorkMode = this.getPinEntryWorkMode();
            pinEntryCfg.mCardNo = panBlock;
            pinEntryCfg.mPinKey = this.makeKeyHandle(keyId);
        } else {
            pinEntryCfg.mPinEntryWorkMode = (byte)3;
            pinEntryCfg.mCardNo = null;
            pinEntryCfg.mPinKey = null;
        }
        this.isInputing = true;
        int ret = this.device.startPinEntry(this.defaultPinEntryEventListener(), pinEntryCfg);
        if (ret != 0) {
            this.setLastError(ret);
            this.onPinInputed(2, 0, null, 0);
        }
    }

    public void startPinEntry(boolean isOnline, int keyId, String cardNo, PinEntryCfg pinEntryCfg) {
        this.startPinEntrySupportPinBlockFormat(isOnline, keyId, cardNo, pinEntryCfg);
    }

    public static byte[] makePanBlock(String cardNo) {
        String string = cardNo = cardNo == null ? "" : cardNo;
        if (cardNo.length() < 16) {
            StringBuilder sbuf = new StringBuilder();
            for (int i = 0; i < 16 - cardNo.length(); ++i) {
                sbuf.append("0");
            }
            sbuf.append(cardNo);
            cardNo = sbuf.toString();
        } else {
            cardNo = cardNo.substring(cardNo.length() - 16);
        }
        return BytesUtil.hexString2Bytes(cardNo);
    }

    public void startOfflinePinEntry(int mode) {
        if (this.device == null) {
            this.setLastError(49);
            this.onPinInputed(2, 0, null, 0);
            return;
        }
        PinEntryCfg pinEntryConfig = new PinEntryCfg(3, null, null, this.lenLimit);
        pinEntryConfig.mTimeoutBetweenPinKeys = this.timeoutBetweenPinKeys;
        pinEntryConfig.mPinEntryTimeout = this.pinEntryTimeout;
        pinEntryConfig.mReactionMode = this.isIpp ? 15 : 0;
        this.isInputing = true;
        int ret = this.device.startOfflinePinEntry(mode, this.defaultPinEntryEventListener(), pinEntryConfig);
        if (ret != 0) {
            this.setLastError(ret);
            this.onPinInputed(2, 0, null, 0);
        }
    }

    public void startOfflinePinEntry(int mode, PinEntryCfg pinEntryCfg) {
        Precondition.checkNotNull(pinEntryCfg);
        if (this.device == null) {
            this.setLastError(49);
            this.onPinInputed(2, 0, null, 0);
            return;
        }
        pinEntryCfg.mPinEntryWorkMode = (byte)3;
        pinEntryCfg.mCardNo = null;
        pinEntryCfg.mPinKey = null;
        this.isInputing = true;
        int ret = this.device.startOfflinePinEntry(mode, this.defaultPinEntryEventListener(), pinEntryCfg);
        if (ret != 0) {
            this.setLastError(ret);
            this.onPinInputed(2, 0, null, 0);
        }
    }

    private PinEntryEventListener defaultPinEntryEventListener() {
        return new PinEntryEventListener(){

            public int onPinEntryEvent(PinEntryEvent event) {
                switch (event.mState) {
                    case 0: {
                        Pinpad.this.setLastError(0);
                        Pinpad.this.onPinInputed(1, event.mPinNumInputed, null, event.mKeyCode);
                        break;
                    }
                    case 4: 
                    case 8: {
                        Pinpad.this.setLastError(0);
                        Pinpad.this.onPinInputed(3, 0, null, event.mKeyCode);
                        break;
                    }
                    case 1: {
                        Pinpad.this.setLastError(0);
                        Pinpad.this.onPinInputed(0, event.mPinNumInputed, event.mPinBlock, event.mKeyCode);
                        break;
                    }
                    case 5: {
                        Pinpad.this.setLastError(0);
                        Pinpad.this.onPinInputed(0, event.mPinNumInputed, null, event.mKeyCode);
                        break;
                    }
                    case -1: 
                    case 2: {
                        Pinpad.this.setLastError(65283);
                        Pinpad.this.onPinInputed(2, 0, null, event.mKeyCode);
                        break;
                    }
                    case 7: {
                        Pinpad.this.setLastError(65282);
                        Pinpad.this.onPinInputed(2, 0, null, event.mKeyCode);
                        break;
                    }
                    case 3: {
                        Pinpad.this.setLastError(65281);
                        Pinpad.this.onPinInputed(2, 0, null, event.mKeyCode);
                    }
                }
                return 0;
            }
        };
    }

    public boolean verifyOfflinePin(final int mode, final int icToken, final byte fmtOfPin, final byte verifyCmdFmt, final byte[] random, final PinVerifyCfg.PinEncPublicKey publicKey, final OfflinePinVerifyResult verifyResult) {
        return new Executer(){

            @Override
            int onExecute() {
                PinVerifyCfg pinVerifyCfg = new PinVerifyCfg();
                pinVerifyCfg.mIcCardToken = icToken;
                pinVerifyCfg.mFmtOfPin = fmtOfPin;
                pinVerifyCfg.mVerifyCmdFmt = verifyCmdFmt;
                pinVerifyCfg.mRandom = random;
                pinVerifyCfg.mPinKey = publicKey;
                return Pinpad.this.device.verifyOfflinePin(mode, pinVerifyCfg, verifyResult);
            }
        }.execute();
    }

    public byte[] calcMAC(int mode, int mackeyId, byte[] data) {
        boolean useRouteEnc = (mode >> 16 & 0xFF) > 0;
        byte macAlgorthm = (byte)(mode >> 8 & 0xFF);
        byte paddingMode = (byte)(mode & 0xFF);
        return this.calcMAC(paddingMode, macAlgorthm, useRouteEnc, mackeyId, data);
    }

    public byte[] calcMAC(int paddingMode, int algorthm, boolean userRouteEncryption, int mackeyId, byte[] data) {
        return this.calcMAC(paddingMode, algorthm, userRouteEncryption, mackeyId, null, data);
    }

    public byte[] calcMAC(final int paddingMode, final int algorthm, final boolean userRouteEncryption, final int mackeyId, final byte[] icvData, final byte[] data) {
        if (data == null || data.length == 0) {
            this.setLastError(33);
            return null;
        }
        int blockLen = this.isSM4Enabled() ? 16 : Pinpad.getMacOutpuLength(algorthm);
        final byte[] mac = new byte[blockLen];
        return (byte[])(new Executer(){

            @Override
            int onExecute() {
                MacMode macMode = new MacMode((byte)(paddingMode & 0xFF), (byte)(algorthm & 0xFF), 0, userRouteEncryption);
                this.check(Pinpad.this.device.macInit(macMode, icvData, Pinpad.this.getMacKeyType(), Pinpad.this.makeKeyHandle(mackeyId)));
                if (data.length <= 1024) {
                    this.check(Pinpad.this.device.macLoadData(data));
                } else {
                    this.loadMacData(data);
                }
                return Pinpad.this.device.macGenerate(mac);
            }

            void loadMacData(byte[] data2) {
                int offset = 0;
                int size = 0;
                int piece = data2.length / 1024 + (data2.length % 1024 == 0 ? 0 : 1);
                for (int i = 0; i < piece; ++i) {
                    size = data2.length - offset >= 1024 ? 1024 : data2.length - offset;
                    byte[] block = Arrays.copyOfRange(data2, offset, offset + size);
                    this.check(Pinpad.this.device.macLoadData(block));
                    offset += size;
                }
            }
        }.execute() ? mac : null);
    }

    private static int getMacOutpuLength(int algorithm) {
        switch (algorithm) {
            case 1: 
            case 3: {
                return 16;
            }
        }
        return 8;
    }

    private char getMacKeyType() {
        switch (this.keySystem) {
            case 1: {
                return '\u0001';
            }
        }
        return '\u0000';
    }

    public KeyHandle makeKeyHandle(int keyId) {
        return new KeyHandle(this.getKapId(), this.keySystem, keyId);
    }

    public byte[] calcKCV(final int keyid) {
        int kcvLen = this.isSM4Enabled() ? 8 : 4;
        final byte[] kcv = new byte[kcvLen];
        return (byte[])(new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getKcv(Pinpad.this.makeKeyHandle(keyid), kcv);
            }
        }.execute() ? kcv : null);
    }

    public byte[] calcKCV(final int keyid, final int expectKcvLen) {
        int kcvLen = this.isSM4Enabled() ? 8 : 4;
        final byte[] kcv = new byte[Math.max(expectKcvLen, kcvLen)];
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getKcvNew(0, Pinpad.this.makeKeyHandle(keyid), expectKcvLen, kcv);
            }
        }.execute() ? BytesUtil.subBytes(kcv, 0, expectKcvLen) : null;
    }

    public byte[] encryptMagTrack(final int mode, final int tdkeyId, final byte[] data) {
        final IntWraper outLen = new IntWraper();
        final byte[] encryptedTrack = new byte[1024];
        return new Executer(){

            @Override
            int onExecute() {
                boolean useRouteEnc = (mode >> 8 & 0xFF) > 0;
                char encMode = (char)(mode & 0xFF);
                return Pinpad.this.device.encryptMagTrackData(Pinpad.this.makeKeyHandle(tdkeyId), encMode, useRouteEnc, data, outLen, encryptedTrack);
            }
        }.execute() ? BytesUtil.subBytes(encryptedTrack, 0, outLen.getIntValue()) : null;
    }

    public byte[] encryptData(final int keyId, final byte[] data) {
        final IntWraper outLen = new IntWraper();
        final byte[] encryptedData = new byte[1024];
        return new Executer(){

            @Override
            int onExecute() {
                DesMode desMode = new DesMode(0, 0);
                return Pinpad.this.device.calculateDes(Pinpad.this.makeKeyHandle(keyId), desMode, null, data, outLen, encryptedData);
            }
        }.execute() ? BytesUtil.subBytes(encryptedData, 0, outLen.getIntValue()) : null;
    }

    public byte[] decryptData(final int keyId, final byte[] data) {
        final IntWraper outLen = new IntWraper();
        final byte[] decryptData = new byte[1024];
        return new Executer(){

            @Override
            int onExecute() {
                DesMode desMode = new DesMode(1, 0);
                return Pinpad.this.device.calculateDes(Pinpad.this.makeKeyHandle(keyId), desMode, null, data, outLen, decryptData);
            }
        }.execute() ? BytesUtil.subBytes(decryptData, 0, outLen.getIntValue()) : null;
    }

    public byte[] calculateDes(final int keyId, final DesMode desMode, final byte[] icvData, final byte[] inData) {
        final IntWraper outLen = new IntWraper();
        final byte[] outData = new byte[1024];
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.calculateDes(Pinpad.this.makeKeyHandle(keyId), desMode, icvData, inData, outLen, outData);
            }
        }.execute() ? BytesUtil.subBytes(outData, 0, outLen.getIntValue()) : null;
    }

    public boolean reset() {
        return new Executer(){

            @Override
            int onExecute() {
                PinpadCfg config = new PinpadCfg();
                config.mEnableKeyTone = true;
                return Pinpad.this.device.resetPinpad(config);
            }
        }.execute();
    }

    public boolean resetPinpad(final PinpadCfg config) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.resetPinpad(config);
            }
        }.execute();
    }

    public boolean isOpen() {
        return this.device != null;
    }

    public boolean open() {
        logger.debug("# open | deviceName: " + this.deviceName, new Object[0]);
        if (this.device != null) {
            this.device.closeDevice();
            this.device = null;
        }
        this.device = TextUtils.isEmpty((CharSequence)this.clientName) ? PinpadDevice.openDevice((String)this.deviceName) : PinpadDevice.openDevice((String)this.clientName, (String)this.deviceName);
        if (this.device == null) {
            this.setLastError(2);
        }
        return this.device != null;
    }

    public boolean close() {
        logger.debug("# close | deviceName: " + this.deviceName, new Object[0]);
        this.pinEntryListener = null;
        if (this.device == null) {
            return true;
        }
        this.device.closeDevice();
        this.device = null;
        return true;
    }

    public void setOnPinInputListener(OnPinInputListener listener) {
        Precondition.checkNotNull(listener);
        this.pinEntryListener = listener;
    }

    public boolean isInputing() {
        return this.isInputing;
    }

    public boolean loadMainKey(int keyid, byte[] key) {
        return this.loadMainKey(keyid, key, true);
    }

    public boolean loadMainKey(final int keyid, final byte[] key, boolean autoSwitchMode) {
        boolean ret = new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle tmk = Pinpad.this.makeKeyHandle(keyid);
                KeyCfg keyConfig = new KeyCfg();
                if (Pinpad.this.keySystem == 1) {
                    keyConfig.mKeyUsage = 1;
                    keyConfig.mModeOfUse = (char)88;
                } else {
                    keyConfig.mKeyUsage = DEFAULT_LOADMAINKEY_KEY_USAGE;
                    keyConfig.mModeOfUse = (char)68;
                }
                keyConfig.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyConfig.mVersionNumber = 0;
                keyConfig.mExportability = (byte)78;
                return Pinpad.this.device.loadPlainTextKey(tmk, keyConfig, key);
            }
        }.execute();
        if (ret && autoSwitchMode) {
            return this.switchToWorkMode();
        }
        return ret;
    }

    public boolean loadPlainTextKey(final int keyId, final KeyCfg keyCfg, final byte[] clrKeyData) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle keyHandle = Pinpad.this.makeKeyHandle(keyId);
                return Pinpad.this.device.loadPlainTextKey(keyHandle, keyCfg, clrKeyData);
            }
        }.execute();
    }

    public boolean loadEncKey(final int srcKeyId, final int dstKeyId, final int encKeyFmt, final KeyCfg keyCfg, final byte[] encKey) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle srcKeyHandle = Pinpad.this.makeKeyHandle(srcKeyId);
                KeyHandle dstKeyHandle = Pinpad.this.makeKeyHandle(dstKeyId);
                return Pinpad.this.device.loadEncKey(srcKeyHandle, dstKeyHandle, encKeyFmt, keyCfg, encKey);
            }
        }.execute();
    }

    public boolean loadEncKey(final KeyHandle srcKeyHandle, final KeyHandle dstKeyHandle, final int encKeyFmt, final KeyCfg keyCfg, final byte[] encKey) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                return Pinpad.this.device.loadEncKey(srcKeyHandle, dstKeyHandle, encKeyFmt, keyCfg, encKey);
            }
        }.execute();
    }

    public boolean loadPlainTextKey(final int keyId, final int keyType, final byte[] key) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle keyHandle = Pinpad.this.makeKeyHandle(keyId);
                KeyCfg keyConfig = new KeyCfg();
                keyConfig.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyConfig.mVersionNumber = 0;
                keyConfig.mExportability = (byte)78;
                switch (keyType) {
                    case 0: {
                        if (Pinpad.this.keySystem == 1) {
                            keyConfig.mKeyUsage = 1;
                            keyConfig.mModeOfUse = (char)88;
                            break;
                        }
                        keyConfig.mKeyUsage = DEFAULT_LOADMAINKEY_KEY_USAGE;
                        keyConfig.mModeOfUse = (char)68;
                        break;
                    }
                    case 2: {
                        keyConfig.mKeyUsage = (byte)20;
                        keyConfig.mModeOfUse = (char)69;
                        break;
                    }
                    case 1: {
                        keyConfig.mKeyUsage = (byte)(Pinpad.this.isDESAlgorithm() ? 17 : 15);
                        keyConfig.mModeOfUse = (char)67;
                        break;
                    }
                    case 3: {
                        keyConfig.mKeyUsage = (byte)32;
                        keyConfig.mModeOfUse = (char)69;
                        break;
                    }
                    case 4: {
                        keyConfig.mKeyUsage = (byte)3;
                        keyConfig.mModeOfUse = (char)66;
                        break;
                    }
                    case 5: {
                        keyConfig.mKeyUsage = (byte)50;
                        keyConfig.mModeOfUse = (char)71;
                        break;
                    }
                    case 6: {
                        keyConfig.mKeyUsage = (byte)33;
                        keyConfig.mModeOfUse = (char)83;
                        break;
                    }
                    case 7: {
                        keyConfig.mKeyUsage = (byte)51;
                        keyConfig.mModeOfUse = (char)88;
                        break;
                    }
                    case 8: {
                        keyConfig.mKeyUsage = (byte)52;
                        keyConfig.mModeOfUse = (char)69;
                        keyConfig.mExportability = (byte)69;
                        break;
                    }
                }
                return Pinpad.this.device.loadPlainTextKey(keyHandle, keyConfig, key);
            }
        }.execute();
    }

    private boolean isDESAlgorithm() {
        return this.keyAlgorithm == 'T' || this.keyAlgorithm == 'D';
    }

    public boolean loadEncryptMainKey(final int encKeyId, final int keyId, final byte[] key, final byte[] kcv) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                if (!Pinpad.this.loadEncryptMainKey(encKeyId, keyId, key)) {
                    return 1;
                }
                if (kcv == null) {
                    return 0;
                }
                KeyHandle mainKeyHandle = Pinpad.this.makeKeyHandle(keyId);
                int kcvLen = Pinpad.calcKcvLength(Pinpad.this.keyAlgorithm);
                byte[] kcvValue = new byte[kcvLen];
                int ret = Pinpad.this.device.getKcv(mainKeyHandle, kcvValue);
                if (ret != 0) {
                    return ret;
                }
                ret = Pinpad.isKcvEquals(kcv, kcvValue) ? 0 : 1;
                return ret;
            }
        }.execute();
    }

    private static int calcKcvLength(char keyAlgorithm) {
        switch (keyAlgorithm) {
            case 'A': 
            case 'M': {
                return 8;
            }
        }
        return 4;
    }

    public boolean loadEncryptMainKey(final int encKeyId, final int keyId, final byte[] key) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle encKeyHandle = Pinpad.this.makeKeyHandle(encKeyId);
                KeyHandle mainKeyHandle = Pinpad.this.makeKeyHandle(keyId);
                KeyCfg keyConfig = new KeyCfg();
                if (Pinpad.this.keySystem == 1) {
                    keyConfig.mKeyUsage = 1;
                    keyConfig.mModeOfUse = (char)88;
                } else {
                    keyConfig.mKeyUsage = DEFAULT_LOADMAINKEY_KEY_USAGE;
                    keyConfig.mModeOfUse = (char)68;
                }
                keyConfig.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyConfig.mVersionNumber = 0;
                keyConfig.mExportability = (byte)78;
                return Pinpad.this.device.loadEncKey(encKeyHandle, mainKeyHandle, Pinpad.this.encKeyFormat, keyConfig, key);
            }
        }.execute();
    }

    public boolean switchToWorkMode() {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.switchKapToWorkMode(Pinpad.this.getKapId());
            }
        }.execute();
    }

    public boolean getKapMode(final IntWraper mode) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                return Pinpad.this.device.getKapMode(Pinpad.this.getKapId(), mode);
            }
        }.execute();
    }

    public boolean isWorkMode(IntWraper mode) {
        return mode.getIntValue() == 1;
    }

    public boolean checkKeyInfo(final int keyid, final BooleanWraper isExistent, final KeyInfo keyInfo) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.checkKey(Pinpad.this.makeKeyHandle(keyid), isExistent, keyInfo);
            }
        }.execute();
    }

    public boolean loadWorkKey(int mainkeyid, int keytype, int keyid, byte[] key) {
        return this.loadWorkKeyInner(mainkeyid, keytype, keyid, key, true);
    }

    private boolean loadWorkKeyInner(final int mainkeyid, final int keytype, final int keyid, final byte[] key, boolean cacheKey) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle masterKeyHandle = Pinpad.this.makeKeyHandle(mainkeyid);
                KeyHandle workKeyHandle = Pinpad.this.makeKeyHandle(keyid);
                KeyCfg keyConfig = new KeyCfg();
                keyConfig.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyConfig.mVersionNumber = 0;
                keyConfig.mExportability = (byte)78;
                switch (keytype) {
                    case 0: {
                        if (Pinpad.this.keySystem == 1) {
                            keyConfig.mKeyUsage = 1;
                            keyConfig.mModeOfUse = (char)88;
                            break;
                        }
                        keyConfig.mKeyUsage = DEFAULT_LOADMAINKEY_KEY_USAGE;
                        keyConfig.mModeOfUse = (char)68;
                        break;
                    }
                    case 2: {
                        keyConfig.mKeyUsage = (byte)20;
                        keyConfig.mModeOfUse = (char)69;
                        break;
                    }
                    case 1: {
                        keyConfig.mKeyUsage = (byte)(Pinpad.this.isDESAlgorithm() ? 17 : 15);
                        keyConfig.mModeOfUse = (char)67;
                        break;
                    }
                    case 3: {
                        keyConfig.mKeyUsage = (byte)32;
                        keyConfig.mModeOfUse = (char)69;
                        break;
                    }
                    case 4: {
                        keyConfig.mKeyUsage = (byte)3;
                        keyConfig.mModeOfUse = (char)66;
                        break;
                    }
                    case 5: {
                        keyConfig.mKeyUsage = (byte)50;
                        keyConfig.mModeOfUse = (char)71;
                        break;
                    }
                    case 6: {
                        keyConfig.mKeyUsage = (byte)33;
                        keyConfig.mModeOfUse = (char)83;
                        break;
                    }
                    case 7: {
                        keyConfig.mKeyUsage = (byte)51;
                        keyConfig.mModeOfUse = (char)88;
                        break;
                    }
                    case 8: {
                        keyConfig.mKeyUsage = (byte)52;
                        keyConfig.mModeOfUse = (char)69;
                        keyConfig.mExportability = (byte)69;
                        break;
                    }
                }
                return Pinpad.this.device.loadEncKey(masterKeyHandle, workKeyHandle, Pinpad.this.encKeyFormat, keyConfig, key);
            }
        }.execute();
    }

    public boolean getPinpadInfo(final PinpadInfo info) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getPinpadInfo(info);
            }
        }.execute();
    }

    public boolean setPinpadSerialNum(final byte[] serialNum) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.setPinpadSerialNum(serialNum);
            }
        }.execute();
    }

    public byte[] calculateTKMAC(int mode, final byte[] icvData, final int keyId, final byte[] data, final byte[] variant) {
        if (data == null || data.length == 0) {
            this.setLastError(33);
            return null;
        }
        final boolean useRouteEnc = (mode >> 16 & 0xFF) > 0;
        final byte algorithm = (byte)(mode >> 8 & 0xFF);
        final byte paddingMode = (byte)(mode & 0xFF);
        int blockLen = this.isSM4Enabled() ? 16 : 8;
        final byte[] mac = new byte[blockLen];
        return (byte[])(new Executer(){

            @Override
            int onExecute() {
                MacMode macMode = new MacMode((byte)(paddingMode & 0xFF), (byte)(algorithm & 0xFF), 0, useRouteEnc);
                this.check(Pinpad.this.device.macInit(macMode, icvData, '\u0003', Pinpad.this.makeTKKeyHanle(keyId), 1, variant));
                if (data.length <= 1024) {
                    this.check(Pinpad.this.device.macLoadData(data));
                } else {
                    this.loadMacData(data);
                }
                return Pinpad.this.device.macGenerate(mac);
            }

            void loadMacData(byte[] data2) {
                int offset = 0;
                int size = 0;
                int piece = data2.length / 1024 + (data2.length % 1024 == 0 ? 0 : 1);
                for (int i = 0; i < piece; ++i) {
                    size = data2.length - offset >= 1024 ? 1024 : data2.length - offset;
                    byte[] block = Arrays.copyOfRange(data2, offset, offset + size);
                    this.check(Pinpad.this.device.macLoadData(block));
                    offset += size;
                }
            }
        }.execute() ? mac : null);
    }

    public byte[] calculateTKKCV(final int mode, final int keyId, final byte[] variant, final byte[] dataIn) {
        int kcvLen = (this.isSM4Enabled() ? 8 : 4) * 2;
        final byte[] dataOut = new byte[kcvLen];
        boolean success = new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = Pinpad.this.makeTKKeyHanle(keyId);
                return Pinpad.this.device.calculateTKKCV(mode, keyHandle, variant, dataIn, dataOut);
            }
        }.execute();
        return (byte[])(success ? dataOut : null);
    }

    public byte[] getDataForAUKAuth(final int mode, final int datalen) {
        final ByteArrayWraper outData = new ByteArrayWraper();
        boolean success = new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getDataForAUKAuth(mode, datalen, outData);
            }
        }.execute();
        return success ? outData.getByteArrayValue() : null;
    }

    public byte[] aukAuthenData(final int mode, final int aukKeyId, final AUKAuthData authData, final AUKAuthDataIn authDataIn) {
        final ByteArrayWraper outData = new ByteArrayWraper();
        boolean success = new Executer(){

            @Override
            int onExecute() {
                KeyHandle aukKeyHandle = Pinpad.this.makeTKKeyHanle(aukKeyId);
                return Pinpad.this.device.aukAuthenData(mode, aukKeyHandle, authData, authDataIn, outData);
            }
        }.execute();
        return success ? outData.getByteArrayValue() : null;
    }

    public boolean loadRemoteEncKey(final int mode, final int tkKeyId, final int keyId, final RemoteKeyData keyData) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle tkKeyHandle = Pinpad.this.makeTKKeyHanle(tkKeyId);
                KeyHandle mkKeyHandle = Pinpad.this.makeKeyHandle(keyId);
                KeyCfg keyCfg = new KeyCfg();
                keyCfg.mKeyUsage = DEFAULT_LOADMAINKEY_KEY_USAGE;
                keyCfg.mModeOfUse = (char)68;
                keyCfg.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyCfg.mVersionNumber = 0;
                keyCfg.mExportability = (byte)78;
                return Pinpad.this.device.loadRemoteEncKey(mode, tkKeyHandle, mkKeyHandle, keyCfg, keyData);
            }
        }.execute();
    }

    public byte[] aukCalcData(final int mode, final DesMode desMode, final byte[] iv, final byte[] variant, final byte[] inData) {
        final ByteArrayWraper outData = new ByteArrayWraper();
        boolean success = new Executer(){

            @Override
            int onExecute() {
                KeyHandle aukKeyHandle = Pinpad.this.makeTKKeyHanle(0);
                return Pinpad.this.device.aukCalcData(mode, aukKeyHandle, desMode, iv, variant, inData, outData);
            }
        }.execute();
        return success ? outData.getByteArrayValue() : null;
    }

    public boolean loadTkEncKey(final int mode, final int keyId, final byte[] variant, final byte[] encKey) {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                KeyHandle srcKeyHandle = Pinpad.this.makeTKKeyHanle(0);
                KeyHandle dstKeyHandle = Pinpad.this.makeKeyHandle(keyId);
                KeyCfg keyCfg = new KeyCfg();
                keyCfg.mKeyUsage = DEFAULT_LOADMAINKEY_KEY_USAGE;
                keyCfg.mModeOfUse = (char)68;
                keyCfg.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyCfg.mVersionNumber = 0;
                keyCfg.mExportability = (byte)78;
                return Pinpad.this.device.loadTkEncKey(mode, srcKeyHandle, dstKeyHandle, keyCfg, variant, encKey);
            }
        }.execute();
    }

    private KeyHandle makeTKKeyHanle(int keyId) {
        return new KeyHandle(KapId.GSK_ID, this.keySystem, keyId);
    }

    public TusnInfo getTUSN(final int mode, final byte[] input) {
        final TusnInfo tusnInfo = new TusnInfo();
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = new KeyHandle(KapId.GSK_ID, 0, 0);
                MacMode macMode = new MacMode(0, 3, 0, true);
                return Pinpad.this.device.manageTUSN(mode, macMode, '\u00ff', keyHandle, input, tusnInfo);
            }
        }.execute() ? tusnInfo : null;
    }

    public byte[] calculateTusnMAC(final byte[] input, final byte[] icvData) {
        final byte[] mac = new byte[16];
        return (byte[])(new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = new KeyHandle(KapId.GSK_ID, 0, 0);
                MacMode macMode = new MacMode(0, 3, 0, false);
                this.check(Pinpad.this.device.macInit(macMode, icvData, '\u00ff', keyHandle));
                this.check(Pinpad.this.device.macLoadData(input));
                return Pinpad.this.device.macGenerate(mac);
            }
        }.execute() ? mac : null);
    }

    public byte[] getPinBlockWithNokey(final int mode, final byte[] clrPin, int keyId, String cardNo) {
        if (clrPin == null) {
            this.setLastError(33);
            return null;
        }
        int bufferSize = 16;
        bufferSize = this.keyAlgorithm == 'A' || this.keyAlgorithm == 'M' ? 32 : 16;
        final byte[] pinBlock = new byte[bufferSize];
        final IntWraper pinBlockLen = new IntWraper();
        final PinEntryCfg pinEntryCfg = new PinEntryCfg(this.getPinEntryWorkMode(), this.makeKeyHandle(keyId), Pinpad.makePanBlock(cardNo), this.lenLimit);
        pinEntryCfg.mPinBlockFormat = 0;
        pinEntryCfg.mPinEncMode = 0;
        pinEntryCfg.mTimeoutBetweenPinKeys = this.timeoutBetweenPinKeys;
        pinEntryCfg.mPinEntryTimeout = this.pinEntryTimeout;
        pinEntryCfg.mReactionMode = this.isIpp ? 15 : 0;
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getPinBlockWithNokey(mode, clrPin, pinEntryCfg, pinBlockLen, pinBlock);
            }
        }.execute() ? Arrays.copyOf(pinBlock, pinBlockLen.getIntValue()) : null;
    }

    public byte[] getRandom() {
        return this.getRandom(8);
    }

    public byte[] getRandom(int length) {
        int size = Math.min(length > 0 ? length : 8, 1024);
        final byte[] random = new byte[size];
        return (byte[])(new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getRandom(random.length, random);
            }
        }.execute() ? random : null);
    }

    private KapId getKapId() {
        return new KapId(this.regionId, this.kapNum);
    }

    public boolean generateKey(final char mode, final int srcKeyId, final int dstKeyId, final KeyCfg keyCfg, final byte[] inData, BytesBuffer outData) {
        final IntWraper outLen = new IntWraper();
        final byte[] buffer = new byte[512];
        boolean isOk = new Executer(){

            @Override
            int onExecute() {
                KeyHandle srcKeyHandle = Pinpad.this.makeKeyHandle(srcKeyId);
                KeyHandle dstKeyHandle = Pinpad.this.makeKeyHandle(dstKeyId);
                return Pinpad.this.device.generateKey(mode, srcKeyHandle, inData, keyCfg, dstKeyHandle, outLen, buffer);
            }
        }.execute();
        if (isOk) {
            outData.setData(Arrays.copyOf(buffer, outLen.getIntValue()));
        }
        return isOk;
    }

    public boolean generateKey(int mainkeyid, int keytype, int keyid, byte[] random) {
        return this.generateKeyInner(mainkeyid, keytype, keyid, random, true);
    }

    private boolean generateKeyInner(final int mainkeyid, final int keytype, final int keyid, final byte[] random, boolean cacheKey) {
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle masterKeyHandle = Pinpad.this.makeKeyHandle(mainkeyid);
                KeyHandle workKeyHandle = Pinpad.this.makeKeyHandle(keyid);
                KeyCfg keyConfig = new KeyCfg();
                switch (keytype) {
                    case 2: {
                        keyConfig.mKeyUsage = (byte)20;
                        keyConfig.mModeOfUse = (char)69;
                        break;
                    }
                    case 1: {
                        keyConfig.mKeyUsage = (byte)(Pinpad.this.isDESAlgorithm() ? 17 : 15);
                        keyConfig.mModeOfUse = (char)67;
                        break;
                    }
                    case 3: {
                        keyConfig.mKeyUsage = (byte)32;
                        keyConfig.mModeOfUse = (char)69;
                        break;
                    }
                    case 4: {
                        keyConfig.mKeyUsage = (byte)3;
                        keyConfig.mModeOfUse = (char)66;
                        break;
                    }
                    case 5: {
                        keyConfig.mKeyUsage = (byte)50;
                        keyConfig.mModeOfUse = (char)71;
                        break;
                    }
                    case 6: {
                        keyConfig.mKeyUsage = (byte)33;
                        keyConfig.mModeOfUse = (char)83;
                        break;
                    }
                    case 7: {
                        keyConfig.mKeyUsage = (byte)51;
                        keyConfig.mModeOfUse = (char)88;
                        break;
                    }
                }
                keyConfig.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyConfig.mVersionNumber = 0;
                keyConfig.mExportability = (byte)78;
                return Pinpad.this.device.generateKey('\u0001', masterKeyHandle, random, keyConfig, workKeyHandle, null, null);
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPinInputed(int state, int len, byte[] data, int key) {
        logger.debug("# onPinInputed | state: " + state, new Object[0]);
        this.isInputing = state == 1;
        OnPinInputListener listener = this.pinEntryListener;
        if (listener == null) {
            logger.error("# onPinInputed | OnPinInputListener is null!", new Object[0]);
            return;
        }
        OnPinInputListener onPinInputListener = listener;
        synchronized (onPinInputListener) {
            switch (state) {
                case 0: {
                    listener.onConfirm(Pinpad.changePinDataFormat(data), data == null || data.length == 0);
                    break;
                }
                case 1: {
                    switch (key) {
                        case 13: {
                            key = 13;
                            break;
                        }
                        case 101: {
                            key = 101;
                            break;
                        }
                        case 27: {
                            key = 27;
                        }
                    }
                    listener.onInput(len, key);
                    break;
                }
                case 2: {
                    listener.onError(this.lastError);
                    break;
                }
                case 3: {
                    listener.onCancel();
                }
            }
        }
    }

    public int getLastError() {
        return this.lastError;
    }

    public void setLastError(int errorCode) {
        this.lastError = errorCode;
        logger.debug("# setLastError | error: 0x" + Integer.toHexString(errorCode), new Object[0]);
    }

    public boolean sendKey(final int keycode) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.injectPinEntryFuncKey(keycode);
            }
        }.execute();
    }

    public boolean cancelInput(final int reason) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.cancelPinEntry((char)reason);
            }
        }.execute();
    }

    public boolean cancelInput() {
        return this.cancelInput(1);
    }

    public void setTimeout(int timeout) {
        this.setTimeoutBetweenPinKeys(timeout);
    }

    public void setPinEntryTimeout(int pinEntryTimeout) {
        this.pinEntryTimeout = pinEntryTimeout >= 300 && pinEntryTimeout <= 600 ? pinEntryTimeout : 300;
    }

    public void setTimeoutBetweenPinKeys(int timeoutBetweenPinKeys) {
        this.timeoutBetweenPinKeys = timeoutBetweenPinKeys >= 1 && timeoutBetweenPinKeys <= 300 ? timeoutBetweenPinKeys : 60;
    }

    public boolean deleteKey(final int keyId) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.deleteKey(Pinpad.this.makeKeyHandle(keyId));
            }
        }.execute();
    }

    public boolean format() {
        return new Executer(){

            @Override
            int onExecute() {
                this.check(Pinpad.this.createKap());
                return Pinpad.this.device.formatKap(new KapId(Pinpad.this.regionId, Pinpad.this.kapNum), null);
            }
        }.execute();
    }

    public boolean beep(final int beepMs) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.pinpadBeep(beepMs);
            }
        }.execute();
    }

    public boolean display(final int line, final String msg) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.dispPinpad(line, msg);
            }
        }.execute();
    }

    public void setEncKeyFormat(int keyFormat) {
        this.encKeyFormat = keyFormat;
    }

    private static byte[] changePinDataFormat(byte[] pin) {
        if (pin == null) {
            return pin;
        }
        for (int i = 0; i < pin.length; ++i) {
            if (pin[i] < 58 || pin[i] > 63) continue;
            int n = i;
            pin[n] = (byte)(pin[n] - 58);
            int n2 = i;
            pin[n2] = (byte)(pin[n2] + 65);
        }
        return pin;
    }

    public boolean isIpp() {
        return this.isIpp;
    }

    public boolean isSM4Enabled() {
        return this.keyAlgorithm == 'M';
    }

    public boolean initDukptIkKsn(final int keyId, final byte[] ksnData) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.loadDukptInitialKeyFromKap(Pinpad.this.getKapId(), keyId, ksnData);
            }
        }.execute();
    }

    public boolean increaseDukptKsn(final int keyId) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.increaseDukptKsn(Pinpad.this.makeKeyHandle(keyId));
            }
        }.execute();
    }

    public byte[] getDukptCurKsn(final int keyId) {
        byte[] ksnValue = null;
        final ByteArrayWraper ksn = new ByteArrayWraper();
        boolean success = new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getDukptCurKsn(Pinpad.this.makeKeyHandle(keyId), ksn);
            }
        }.execute();
        if (success) {
            ksnValue = new byte[ksn.getByteArrayLength()];
            System.arraycopy(ksn.getByteArrayValue(), 0, ksnValue, 0, ksn.getByteArrayLength());
        }
        return ksnValue;
    }

    public void startDukptVerifyPin(int keyId, String cardNo, byte pinBlockFormat) {
        int PEWM_GET_DUKPT_VERIFY_PIN = 7;
        if (this.device == null) {
            this.setLastError(49);
            this.onPinInputed(2, 0, null, 0);
            return;
        }
        PinEntryCfg pinEntryCfg = new PinEntryCfg(7, null, null, this.lenLimit);
        pinEntryCfg.mPinBlockFormat = pinBlockFormat;
        pinEntryCfg.mPinEncMode = 0;
        pinEntryCfg.mTimeoutBetweenPinKeys = this.timeoutBetweenPinKeys;
        pinEntryCfg.mPinEntryTimeout = this.pinEntryTimeout;
        pinEntryCfg.mReactionMode = this.isIpp ? 15 : 0;
        pinEntryCfg.mPinKey = this.makeKeyHandle(keyId);
        pinEntryCfg.mCardNo = (byte[])(pinBlockFormat != 4 && pinBlockFormat != -47 ? Pinpad.makePanBlock(cardNo) : null);
        this.isInputing = true;
        int ret = 0;
        ret = pinBlockFormat == 4 || pinBlockFormat == -47 ? this.device.startPinEntry(this.defaultPinEntryEventListener(), pinEntryCfg, cardNo) : this.device.startPinEntry(this.defaultPinEntryEventListener(), pinEntryCfg);
        if (ret != 0) {
            this.setLastError(ret);
            this.onPinInputed(2, 0, null, 0);
        }
    }

    public boolean loadAndRandomSoftKeyBoard(final int mode, final int[] coordinate, final ByteArrayWraper randomKeyValue) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.loadAndRandomSoftKeyBoard(mode, coordinate, randomKeyValue);
            }
        }.execute();
    }

    public boolean checkKapAccess(final int mode, final int pid, final int uid, final KapId kapId) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.checkKapAccess(mode, pid, uid, kapId);
            }
        }.execute();
    }

    public KapId[] getAccessableKapIds(final int expectedKapsNum) {
        final KapId[] kapIdsList = new KapId[expectedKapsNum];
        final IntWraper actualKapsNum = new IntWraper();
        boolean success = new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getAccessableKapIds(expectedKapsNum, kapIdsList, actualKapsNum);
            }
        }.execute();
        return success ? Arrays.copyOf(kapIdsList, actualKapsNum.getIntValue()) : new KapId[]{};
    }

    public boolean getKapInfo(final KapId kapId, final KapInfo kapInfo) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getKapInfo(kapId, kapInfo);
            }
        }.execute();
    }

    public boolean setPinpadConfig(final boolean enterKeyClearDisplay, final boolean enableKeyTone) {
        return new Executer(){

            @Override
            int onExecute() {
                PinpadCfg pinpadCfg = new PinpadCfg(enterKeyClearDisplay, enableKeyTone);
                return Pinpad.this.device.setPinpadCfg(pinpadCfg);
            }
        }.execute();
    }

    public static PinpadInfo[] getAllPinpadsInfo() {
        IntWraper devsNum = new IntWraper();
        PinpadInfo[] pinpadList = new PinpadInfo[3];
        int result = PinpadDevice.getAllPinpadsInfo((IntWraper)devsNum, (PinpadInfo[])pinpadList);
        return result == 0 ? Arrays.copyOf(pinpadList, devsNum.getIntValue()) : new PinpadInfo[]{};
    }

    public PinEntryInfo getPinEntryInfo() {
        final PinEntryInfo pinEntryInfo = new PinEntryInfo();
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getPinEntryInfo(pinEntryInfo);
            }
        }.execute() ? pinEntryInfo : null;
    }

    public boolean authEncKeyKCV(final int srcKeyId, final int dstKeyId, final byte mode, final byte[] encKey, final byte[] kcv) {
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle srcKeyHandle = Pinpad.this.makeKeyHandle(srcKeyId);
                KeyHandle dstKeyHandle = Pinpad.this.makeKeyHandle(dstKeyId);
                return Pinpad.this.device.authEncKeyKcv(srcKeyHandle, dstKeyHandle, mode, encKey, kcv);
            }
        }.execute();
    }

    public KapId[] getExistentKapIds(final int expectedKapsNum) {
        if (expectedKapsNum <= 0) {
            this.setLastError(33);
            return null;
        }
        final KapId[] kapIds = new KapId[expectedKapsNum + 1];
        final IntWraper actualKapsNum = new IntWraper();
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getExistentKapIds(expectedKapsNum, kapIds, actualKapsNum);
            }
        }.execute() ? Arrays.copyOf(kapIds, actualKapsNum.getIntValue()) : null;
    }

    public int[] getExistentKeyIdsInKeySystem(final byte keyUsage, final int expectedKeysNum) {
        if (expectedKeysNum <= 0) {
            this.setLastError(33);
            return null;
        }
        final int[] keyIdsList = new int[expectedKeysNum + 1];
        final IntWraper actualKeysNum = new IntWraper();
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getExistentKeyIdsInKeySystem(Pinpad.this.getKapId(), Pinpad.this.keySystem, keyUsage, expectedKeysNum, keyIdsList, actualKeysNum);
            }
        }.execute() ? Arrays.copyOf(keyIdsList, actualKeysNum.getIntValue()) : null;
    }

    public boolean initRemoteKeyLoadProc(final int mode, final KMS_ReqInfo reqInfo) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.initRemoteKeyLoadProc(mode, reqInfo);
            }
        }.execute();
    }

    public boolean authKMSCrt(final int mode, final KMS_AuthInfo authInfo, final KMS_AuthOut authOut) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.authKMSCrt(mode, authInfo, authOut);
            }
        }.execute();
    }

    public boolean checkCIDandSignData(final int mode, final byte[] cid, final byte[] msg, final KMS_SigOut sigOut) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.checkCIDandSignData(mode, cid, msg, sigOut);
            }
        }.execute();
    }

    public boolean loadRKISv2RemoteKey(final int mode, final int keyId, final byte[] encKey) {
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = Pinpad.this.makeKeyHandle(keyId);
                return Pinpad.this.device.loadRKISv2RemoteKey(mode, keyHandle, encKey);
            }
        }.execute();
    }

    public byte[] getBocomRKLData(final int mode) {
        final ByteArrayWraper output = new ByteArrayWraper();
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.getBocomRKLData(mode, output);
            }
        }.execute() ? output.getByteArrayValue() : null;
    }

    public boolean checkAndSaveBocomPk(final int mode, final byte[] pubKey, final byte[] sign) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.checkandSaveBocomPk(mode, pubKey, sign);
            }
        }.execute();
    }

    public boolean injectBocomRemoteKey(final int mode, final int keyId, final int encKeyFmt, final byte[] encKey, final byte[] sign) {
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = Pinpad.this.makeKeyHandle(keyId);
                KeyCfg keyConfig = new KeyCfg();
                if (Pinpad.this.keySystem == 1) {
                    keyConfig.mKeyUsage = 1;
                    keyConfig.mModeOfUse = (char)88;
                } else {
                    keyConfig.mKeyUsage = DEFAULT_LOADMAINKEY_KEY_USAGE;
                    keyConfig.mModeOfUse = (char)68;
                }
                keyConfig.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyConfig.mVersionNumber = 0;
                keyConfig.mExportability = (byte)78;
                return Pinpad.this.device.injectBocomRemoteKey(mode, keyHandle, encKeyFmt, keyConfig, encKey, sign);
            }
        }.execute();
    }

    public boolean generatePineLabsRsa(final int uid, final ByteArrayWraper terminalRandomKeyCertificate, final ByteArrayWraper terminalSubCA, final ByteArrayWraper terminalCA) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.generatePineLabsRsa(uid, terminalRandomKeyCertificate, terminalSubCA, terminalCA);
            }
        }.execute();
    }

    public boolean loadPineLabsRootPK(final byte[] signedKmsRootKey) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.loadPineLabsRootPK(signedKmsRootKey);
            }
        }.execute();
    }

    public boolean updatePineLabsPKCertifacate(final byte[] kmsKeyCertificate) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.updatePineLabsPKCertifacate(kmsKeyCertificate);
            }
        }.execute();
    }

    public boolean loadPineLabsSignedKey(final int keyId, final byte[] signature, final byte[] cipheredKkmsBlock) {
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = Pinpad.this.makeKeyHandle(keyId);
                KeyCfg keyCfg = new KeyCfg();
                keyCfg.mKeyUsage = (byte)12;
                keyCfg.mModeOfUse = (char)68;
                keyCfg.mKeyAlgorithm = Pinpad.this.keyAlgorithm;
                keyCfg.mVersionNumber = 0;
                keyCfg.mExportability = (byte)78;
                return Pinpad.this.device.loadPineLabsSignedKey(keyHandle, keyCfg, signature, cipheredKkmsBlock);
            }
        }.execute();
    }

    public boolean injectJiaLRemoteKey(final int mode, final int keyId, final int encKeyFormat, final KeyCfg keyCfg, final byte[] encKey) {
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = Pinpad.this.makeKeyHandle(keyId);
                return Pinpad.this.device.injectJiaLRemoteKey(mode, keyHandle, encKeyFormat, keyCfg, encKey);
            }
        }.execute();
    }

    public byte[] signJiaLData(final int mode, final byte[] inData) {
        final IntWraper signLen = new IntWraper();
        final byte[] signature = new byte[512];
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.signJiaLData(mode, inData, signLen, signature);
            }
        }.execute() ? Arrays.copyOf(signature, signLen.getIntValue()) : null;
    }

    public byte[] signData(final int mode, final int keyId, final byte[] inData) {
        final IntWraper signLen = new IntWraper();
        final byte[] signature = new byte[1024];
        return new Executer(){

            @Override
            int onExecute() {
                KeyHandle keyHandle = Pinpad.this.makeKeyHandle(keyId);
                return Pinpad.this.device.signData(mode, keyHandle, inData, signLen, signature);
            }
        }.execute() ? Arrays.copyOf(signature, signLen.getIntValue()) : null;
    }

    public byte[] loadEncKeyC6(final int mode, final KeyHandle srcKeyHandle, final KeyHandle dstKeyHandle, final KeyCfg keyCfg, final byte[] encKey) {
        final ByteArrayWraper decipherBuffer = new ByteArrayWraper();
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.loadEncKeyC6(mode, srcKeyHandle, dstKeyHandle, keyCfg, encKey, decipherBuffer);
            }
        }.execute() ? decipherBuffer.getByteArrayValue() : null;
    }

    public boolean setPinEntryExtraConfig(final Bundle config) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.setPinEntryExtraConfig(config);
            }
        }.execute();
    }

    public boolean hmacInit(final char hashAlgorithm, final char macKeyType, final KeyHandle keyHandle) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.hmacInit(hashAlgorithm, macKeyType, keyHandle);
            }
        }.execute();
    }

    public boolean hmacUpdate(final byte[] inData) {
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.hmacUpdate(inData);
            }
        }.execute();
    }

    public byte[] hmacFinal() {
        final ByteArrayWraper outData = new ByteArrayWraper();
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.hmacFinal(outData);
            }
        }.execute() ? outData.mByteArray : null;
    }

    public byte[] hmacOneshot(final char hashAlgorithm, final char macKeyType, final KeyHandle keyHandle, final byte[] inData) {
        final ByteArrayWraper outData = new ByteArrayWraper();
        return new Executer(){

            @Override
            int onExecute() {
                return Pinpad.this.device.hmacOneshot(hashAlgorithm, macKeyType, keyHandle, inData, outData);
            }
        }.execute() ? outData.mByteArray : null;
    }

    public static String getErrorDescription(int error) {
        switch (error) {
            case 0: {
                return "\u6267\u884c\u6210\u529f";
            }
            case 1: {
                return "\u5176\u4ed6\u9519\u8bef";
            }
            case 2: {
                return "\u8bbe\u5907\u6253\u5f00\u5931\u8d25";
            }
            case 27: {
                return "\u7528\u6237\u53d6\u6d88";
            }
            case 32: {
                return "\u7528\u6237\u6307\u5b9a\u540d\u79f0\u7684pinpad\u4e0d\u5b58\u5728";
            }
            case 33: {
                return "PINPAD\u8c03\u7528\u5931\u8d25\uff0c\u65e0\u6548\u5b9e\u53c2";
            }
            case 34: {
                return "\u7a7a\u95f4\u4e0d\u8db3";
            }
            case 35: {
                return "\u8d85\u65f6";
            }
            case 36: {
                return "\u901a\u8baf\u9519\u8bef";
            }
            case 37: {
                return "\u5f53\u524dPINPAD\u7248\u672c\u4e0d\u652f\u6301\u8be5\u529f\u80fd";
            }
            case 38: {
                return "PINPAD\u5fd9!";
            }
            case 39: {
                return "\u65e0\u6307\u5b9a\u5bc6\u94a5";
            }
            case 41: {
                return "\u654f\u611f\u670d\u52a1\u8ba4\u8bc1\u9519\u8bef";
            }
            case 42: {
                return "\u8f93\u5165PIN \u65f6\uff0c\u7528\u6237\u6309\u53d6\u6d88\u9000\u51fa";
            }
            case 43: {
                return "\u65e0PIN\u8f93\u5165";
            }
            case 44: {
                return "DUKPT\u8ba1\u6570\u5668\u6ea2\u51fa";
            }
            case 45: {
                return "\u4e0d\u53ef\u91cd\u590d\u6253\u5f00Pinpad\u8bbe\u5907";
            }
            case 46: {
                return "pinpad\u6a21\u5757\u5f53\u524d\u72b6\u6001\u9519\u8bef\u6216\u8005\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u8be5\u8c03\u7528";
            }
            case 47: {
                return "\u8d85\u51fa\u5bc6\u94a5\u7684\u7528\u9014";
            }
            case 48: {
                return "\u5bc6\u94a5\u7684\u7528\u9014\u9519";
            }
            case 49: {
                return "\u65e0\u6548\u7684\u5bc6\u94a5\u53e5\u67c4";
            }
            case 50: {
                return "\u8be5\u64cd\u4f5c\u6307\u5b9a\u7684\u5bc6\u94a5\u533a\u4e0d\u5b58\u5728";
            }
            case 51: {
                return "\u6307\u5b9a\u7684\u5bc6\u94a5\u533a\u5df2\u7ecf\u5b58\u5728";
            }
            case 52: {
                return "\u5f85\u4e0b\u8f7d\u7684\u5bc6\u94a5\u7528\u9014\u4e0e\u7528\u9014\u6a21\u5f0f\u4e0d\u5339\u914d";
            }
            case 85: {
                return "KCV\u6821\u9a8c\u5931\u8d25";
            }
            case 92: {
                return "pinpad\u670d\u52a1died";
            }
            case 255: {
                return "\u6570\u636e\u672a\u627e\u5230";
            }
            case 54: {
                return "\u65e0\u6cd5\u4f7f\u7528\u76ee\u6807\u5bc6\u94a5\u533a\u4e4b\u5916\u7684\u5bc6\u94a5\u6216\u540c\u65f6\u5f15\u7528\u4e86\u4e0d\u540c\u5bc6\u94a5\u533a\u7684\u5bc6\u94a5";
            }
            case 62: {
                return "\u6ca1\u6709\u6743\u9650\u8bbf\u95eePinpad";
            }
            case 63: {
                return "\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u5bc6\u94a5\u533a";
            }
            case 64: {
                return "\u8be5\u5bc6\u94a5\u533a\u4e0d\u517c\u5bb9";
            }
            case 72: {
                return "PIN\u8f93\u5165\u8c03\u7528\u592a\u9891\u7e41";
            }
            case 73: {
                return "\u5f53\u524d\u5bc6\u94a5\u533a\u7684dukpt\u673a\u6784\u5c1a\u672a\u521d\u59cb\u5316";
            }
            case 74: {
                return "\u5f53\u524d\u64cd\u4f5c\u548c\u6307\u5b9a\u5bc6\u94a5\u7cfb\u7edf\u4e0d\u517c\u5bb9\uff0c\u6216\u8005\u67d0\u64cd\u4f5c\u4e2d\u4e24\u4e2a\u76f8\u5173\u5bc6\u94a5\u7cfb\u7edf\u4e0d\u517c\u5bb9";
            }
            case 75: {
                return "\u5f53\u524d\u5f85\u8f7d\u5165\u7684\u5bc6\u6587\u5bc6\u94a5\u7684\u683c\u5f0f\u592a\u7b80\u5355";
            }
            case 76: {
                return "\u5f53\u524d\u5f85\u8f7d\u5165\u7684\u5bc6\u94a5\u548c\u8bbe\u5907\u4e2d\u5df2\u6709\u7684\u5176\u4ed6\u5bc6\u94a5\u91cd\u590d\uff0c\u7981\u6b62\u4e0b\u8f7d";
            }
            case 77: {
                return "\u5f53\u524d\u5f85\u8f7d\u5165\u7684\u5bc6\u6587\u5bc6\u94a5\u7684\u6253\u5305\u5185\u5bb9\u9519\u8bef";
            }
            case 78: {
                return "\u8c03\u7528\u78c1\u9053\u52a0\u5bc6\u64cd\u4f5c\u592a\u9891\u7e41";
            }
            case 65281: {
                return "PIN\u8f93\u5165\u8d85\u65f6";
            }
            case 65282: {
                return "PIN\u8f93\u5165\u901a\u8baf\u5f02\u5e38";
            }
            case 65283: {
                return "\u672a\u77e5\u7684PIN\u8f93\u5165\u9519\u8bef";
            }
        }
        logger.debug(" -------------------unkown - error ----------------------- " + error, new Object[0]);
        return "\u9519\u8bef";
    }

    private static boolean isKcvEquals(byte[] kcv1, byte[] kcv2) {
        if (kcv1 == null && kcv2 == null) {
            return true;
        }
        if (kcv1 == null || kcv2 == null) {
            return false;
        }
        if (kcv1.length == kcv2.length) {
            return Arrays.equals(kcv1, kcv2);
        }
        int cmpLen = Math.min(kcv1.length, kcv2.length);
        if (kcv1.length > cmpLen) {
            return Arrays.equals(Arrays.copyOf(kcv1, cmpLen), kcv2);
        }
        return Arrays.equals(Arrays.copyOf(kcv2, cmpLen), kcv1);
    }

    abstract class Executer {
        Executer() {
        }

        final boolean execute() {
            if (Pinpad.this.device == null) {
                Pinpad.this.setLastError(49);
                return false;
            }
            try {
                int ret = this.onExecute();
                Pinpad.this.setLastError(ret);
                return ret == 0;
            }
            catch (ExecuteError e) {
                Pinpad.this.setLastError(e.getErrorCode());
                return false;
            }
        }

        protected void check(int ret) {
            if (ret != 0) {
                throw new ExecuteError(ret);
            }
        }

        abstract int onExecute();

        class ExecuteError
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private int errorCode;

            public ExecuteError(int error) {
                this.setErrorCode(error);
            }

            public int getErrorCode() {
                return this.errorCode;
            }

            public void setErrorCode(int errorCode) {
                this.errorCode = errorCode;
            }
        }
    }

    public static class Builder {
        private final int kapNum;
        private int regionId = 0;
        private int keySystem = 0;
        private String deviceName = "IPP";
        private String clientName;

        public Builder(int kapNum) {
            this.kapNum = kapNum;
        }

        public Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder regionId(int regionId) {
            this.regionId = regionId;
            return this;
        }

        public Builder keySystem(int keySystem) {
            this.keySystem = keySystem;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Pinpad build() {
            return new Pinpad(this);
        }
    }

    public static interface OnPinInputListener {
        public void onInput(int var1, int var2);

        public void onCancel();

        public void onConfirm(byte[] var1, boolean var2);

        public void onError(int var1);
    }
}

