/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Build;
import android.os.Environment;
import android.os.Parcel;
import android.os.Process;
import android.text.TextUtils;
import com.landicorp.android.eptapi.device.OnlySupportProgressException;
import com.landicorp.android.eptapi.device.PrintableImage;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.IOUtils;
import com.landicorp.android.eptapi.utils.ImageTransformer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.OdCode;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.QrCode;
import com.landicorp.android.eptapi.utils.StringUtil;
import com.landicorp.android.eptapi.utils.TimeSlicer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Printer {
    static final Logger logger = Logger.getLogger(Printer.class);
    public static final int MODE_VIRTUAL = 1;
    public static final int MODE_REAL = 2;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_PAPERENDED = 240;
    public static final int ERROR_HARDERR = 242;
    public static final int ERROR_OVERHEAT = 243;
    public static final int ERROR_BUFOVERFLOW = 245;
    public static final int ERROR_LOWVOL = 225;
    public static final int ERROR_PAPERENDING = 244;
    public static final int ERROR_MOTORERR = 251;
    public static final int ERROR_PENOFOUND = 252;
    public static final int ERROR_PAPERJAM = 238;
    public static final int ERROR_NOBM = 246;
    public static final int ERROR_BUSY = 247;
    public static final int ERROR_BMBLACK = 248;
    public static final int ERROR_WORKON = 230;
    public static final int ERROR_LIFTHEAD = 224;
    public static final int ERROR_CUTPOSITIONERR = 226;
    public static final int ERROR_LOWTEMP = 227;
    public static final int ERROR_COMMERR = 229;
    public static final int ERROR_PRNEND = 233;
    public static final int ERROR_CUTERROR = 176;
    public static final int ERROR_OPENCOVER = 177;
    public static final int ERROR_CUTCLEAN = 178;
    public static final int ERROR_CUTFAULT = 179;
    public static final int ERROR_SENDOUTTIME = 182;
    public static final int ERROR_NOPRINTER = 184;
    protected static final int CMD_BEGIN = 11;
    protected static final int CMD_CONT = 12;
    protected static final int CMD_END = 14;
    private static final int SET_FORMAT = 1;
    private static final int PRINT_TEXT = 2;
    private static final int PRINT_LINE = 3;
    private static final int PRINT_LINE_OFF = 4;
    private static final int PRINT_MIX = 5;
    private static final int PRINT_IMAGE = 7;
    private static final int PRINT_BARCODE = 6;
    private static final int FEED_PAPER = 8;
    private static final int SET_GRAY = 9;
    private static final int SET_PAGE_SPACE = 16;
    private static final int SET_MORE_DATA_IN_LINE = 17;
    private static final int SET_LINE_ALLOWED_FOR_LACK = 18;
    private static final int PRINT_TEXT_ALIGN = 19;
    private static final int PRINT_BARCODE_ALIGN = 20;
    private static final int SET_SCALE_MODE = 21;
    private static final int TEXT_LINE_AJUSTMENT = 22;
    private static final int FEED_MARK = 23;
    private static final int SET_PRINT_MODE = 24;
    private static final int SET_PRINT_FORMAT = 25;
    private static final int PRINT_MONOCHROME_BMP = 26;
    private static final int PRINT_MIX_STYLE_LINE = 27;
    private static final int SET_STYLE = 28;
    private static final int CUTTER_PAPER = 32;
    private static final int AUTO_CUTTER_PAPER = 33;
    private static final int MARK_FORWARD = 0;
    private static final int MARK_BACKWARD = 1;
    private static final int TEXT_ALIGN_MID = 1;
    static final int FORMAT_BACKSUPPORT = 4352;
    static final int FORMAT_VALIDAREA = 4608;
    static final int FORMAT_BMSUPPORT = 4864;
    static final int FORMAT_CUTTERSUPPORT = 5120;
    static final int VALUE_VALID = 21504;
    static final int VALUE_INVALID = 21505;
    static final int DEFAULT_PRINT_WIDTH = 384;
    private static Map<String, Printer> sInstances = new ConcurrentHashMap<String, Printer>();
    private Parcel mData = null;
    private int mMode = 2;
    private ParcelCache mCache;
    private boolean useCache;
    private int validWidth;
    private String packageName;

    protected Printer() {
    }

    public static String getErrorDescription(int error) {
        switch (error) {
            case 0: {
                return "\u6b63\u5e38\u72b6\u6001";
            }
            case 240: {
                return "\u7f3a\u7eb8\uff0c\u4e0d\u80fd\u6253\u5370";
            }
            case 242: {
                return "\u786c\u4ef6\u9519\u8bef";
            }
            case 243: {
                return "\u6253\u5370\u5934\u8fc7\u70ed";
            }
            case 245: {
                return "\u7f13\u51b2\u6a21\u5f0f\u4e0b\u6240\u64cd\u4f5c\u7684\u4f4d\u7f6e\u8d85\u51fa\u8303\u56f4 ";
            }
            case 225: {
                return "\u4f4e\u538b\u4fdd\u62a4";
            }
            case 244: {
                return "\u7eb8\u5f20\u5c06\u8981\u7528\u5c3d";
            }
            case 251: {
                return "\u6253\u5370\u673a\u82af\u6545\u969c(\u8fc7\u5feb\u6216\u8005\u8fc7\u6162)";
            }
            case 252: {
                return "\u81ea\u52a8\u5b9a\u4f4d\u6ca1\u6709\u627e\u5230\u5bf9\u9f50\u4f4d\u7f6e,\u7eb8\u5f20\u56de\u5230\u539f\u6765\u4f4d\u7f6e";
            }
            case 238: {
                return "\u5361\u7eb8";
            }
            case 246: {
                return "\u6ca1\u6709\u627e\u5230\u9ed1\u6807";
            }
            case 247: {
                return "\u6253\u5370\u673a\u5904\u4e8e\u5fd9\u72b6\u6001";
            }
            case 248: {
                return "\u9ed1\u6807\u63a2\u6d4b\u5668\u68c0\u6d4b\u5230\u9ed1\u8272\u4fe1\u53f7";
            }
            case 230: {
                return "\u6253\u5370\u673a\u7535\u6e90\u5904\u4e8e\u6253\u5f00\u72b6\u6001";
            }
            case 224: {
                return "\u6253\u5370\u5934\u62ac\u8d77";
            }
            case 226: {
                return "\u5207\u7eb8\u5200\u4e0d\u5728\u539f\u4f4d";
            }
            case 227: {
                return "\u4f4e\u6e29\u4fdd\u62a4\u6216AD\u51fa\u9519";
            }
            case 229: {
                return "\u624b\u5ea7\u673a\u72b6\u6001\u6b63\u5e38\uff0c\u4f46\u901a\u8baf\u5931\u8d25";
            }
            case 176: {
                return "\u5207\u7eb8\u5200\u5361\u5200";
            }
            case 177: {
                return "\u7eb8\u4ed3\u88ab\u6253\u5f00";
            }
            case 178: {
                return "\u7eb8\u4ed3\u5835\u7eb8\uff0c\u9700\u6e05\u7406\u7eb8\u4ed3";
            }
            case 179: {
                return "\u5207\u7eb8\u5200\u6545\u969c";
            }
            case 182: {
                return "\u5e95\u5c42\u901a\u4fe1\u8d85\u65f6";
            }
            case 184: {
                return "\u672a\u8bc6\u522b\u5230\u6253\u5370\u673a\u6a21\u5757";
            }
            case 233: {
                return "\u6253\u5370\u7ed3\u675f";
            }
        }
        return Integer.toHexString(error);
    }

    protected void prepareForPrint() {
        this.initCache();
        this.mData.writeInt(this.mMode);
    }

    protected Parcel initCache() {
        this.clearAfterPrint();
        this.mData = Parcel.obtain();
        this.mCache = new ParcelCache();
        this.mCache.init(this.mMode);
        return this.mData;
    }

    protected void appendCache() {
        if (this.mData != null && this.mData.dataSize() > 0) {
            Printer.getInstance().mData.appendFrom(this.mData, 0, this.mData.dataSize());
        }
    }

    protected void clearAfterPrint() {
        if (this.mCache != null) {
            this.mCache.recycle();
        }
        if (this.mData != null) {
            this.mData.recycle();
        }
        this.mData = null;
    }

    public static Printer getInstance() {
        return Printer.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Printer getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, Printer> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                return sInstances.get(packageName);
            }
            Printer instance = new Printer();
            instance.packageName = packageName;
            sInstances.put(packageName, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, Printer> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                sInstances.remove(packageName);
            }
        }
    }

    public void setStyle(final Format format) throws OnlySupportProgressException {
        Precondition.checkNotNull(format);
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(28);
                format.writeToParcel(parcel);
            }
        }.apply();
    }

    public void setFormat(final Format format) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(1);
                format.writeToParcel(parcel);
            }
        }.apply();
    }

    public void setPrintFormat(final int format, final int value) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(25);
                parcel.writeInt(format);
                parcel.writeInt(value);
            }
        }.apply();
    }

    public void printText(final String text) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(2);
                parcel.writeByteArray(Printer.this.getGB18030(text));
            }
        }.apply();
    }

    public void println(final String text) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(3);
                parcel.writeByteArray(Printer.this.getGB18030(text));
            }
        }.apply();
    }

    public void printMid(final String text) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(19);
                parcel.writeByteArray(Printer.this.getGB18030(text));
                parcel.writeInt(1);
            }
        }.apply();
    }

    public void printText(final Alignment align, final String text) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(19);
                parcel.writeByteArray(Printer.this.getGB18030(text));
                if (align == Alignment.RIGHT) {
                    parcel.writeInt(2);
                } else if (align == Alignment.CENTER) {
                    parcel.writeInt(1);
                } else {
                    parcel.writeInt(0);
                }
            }
        }.apply();
    }

    public void printQrCode(int position, QrCode qrCode, int imageHeight) throws OnlySupportProgressException {
        File tmpFile = new File(Printer.tempFilePath("_tmp_qrcode_"));
        if (!qrCode.convertToImage(tmpFile.getAbsolutePath(), imageHeight)) {
            tmpFile.delete();
            return;
        }
        this.printImage(position, tmpFile.getAbsolutePath());
        tmpFile.delete();
    }

    public void printQrCode(Alignment align, QrCode qrCode, int imageHeight) throws OnlySupportProgressException {
        File tmpFile = new File(Printer.tempFilePath("_tmp_qrcode_"));
        if (!qrCode.convertToImage(tmpFile.getAbsolutePath(), imageHeight)) {
            tmpFile.delete();
            return;
        }
        this.printImage(align, tmpFile.getAbsolutePath());
        tmpFile.delete();
    }

    public void printBarCode(int position, OdCode odCode, int codeWidth, int expectedWidth, int expectedHeight) throws OnlySupportProgressException {
        File tmpFile = new File(Printer.tempFilePath("_tmp_idcode_"));
        if (!odCode.covertToBmpFile(tmpFile.getAbsolutePath(), codeWidth, expectedWidth, expectedHeight)) {
            logger.error("/// printBarCode | covertToBmpFile failed!!!", new Object[0]);
            tmpFile.delete();
            return;
        }
        this.printImage(position, tmpFile.getAbsolutePath());
        tmpFile.delete();
    }

    public void printBarCode(Alignment align, OdCode odCode, int codeWidth, int expectedWidth, int expectedHeight) throws OnlySupportProgressException {
        File tmpFile = new File(Printer.tempFilePath("_tmp_idcode_"));
        if (!odCode.covertToBmpFile(tmpFile.getAbsolutePath(), codeWidth, expectedWidth, expectedHeight)) {
            logger.error("/// printBarCode | covertToBmpFile failed!!!", new Object[0]);
            tmpFile.delete();
            return;
        }
        this.printImage(align, tmpFile.getAbsolutePath());
        tmpFile.delete();
    }

    public void startUnderline() throws OnlySupportProgressException {
        this.printText("\u0007");
    }

    public void endUnderline() throws OnlySupportProgressException {
        this.printText("\b");
    }

    public void println(final int position, final String text) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(4);
                parcel.writeInt(position);
                parcel.writeByteArray(Printer.this.getGB18030(text));
            }
        }.apply();
    }

    public void printMixStyleLine(final int position, final Alignment align, final Format format, final String text) throws OnlySupportProgressException {
        Precondition.checkNotNull(align);
        Precondition.checkNotNull(format);
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(27);
                format.writeToParcel(parcel);
                parcel.writeInt(position);
                parcel.writeInt(align == Alignment.LEFT ? 0 : (align == Alignment.CENTER ? 1 : 2));
                parcel.writeByteArray(Printer.this.getGB18030(text));
            }
        }.apply();
    }

    public void printMixText(final Format format, final String text) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(5);
                format.writeToParcel(parcel);
                parcel.writeByteArray(Printer.this.getGB18030(text));
            }
        }.apply();
    }

    public void printBarCode(final int codeWidth, final int codeHeight, final int columnOff, final int lineOff, final String barcode) throws OnlySupportProgressException {
        Precondition.checkNotNull(barcode);
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(6);
                parcel.writeInt(codeWidth);
                parcel.writeInt(codeHeight);
                parcel.writeInt(columnOff);
                parcel.writeInt(lineOff);
                parcel.writeByteArray(Printer.this.getGB18030(barcode));
            }
        }.apply();
    }

    public void printBarCode(int columnOff, int lineOff, String barcode) throws OnlySupportProgressException {
        this.printBarCode(-1, -1, columnOff, lineOff, barcode);
    }

    public void printBarCode(final Alignment align, final int codeWidth, final int codeHeight, final String barcode) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(20);
                parcel.writeInt(align == Alignment.LEFT ? 0 : (align == Alignment.CENTER ? 1 : 2));
                parcel.writeByteArray(Printer.this.getGB18030(barcode));
                parcel.writeInt(codeWidth);
                parcel.writeInt(codeHeight);
            }
        }.apply();
    }

    public void printBarCode(final Alignment align, final String barcode) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(20);
                parcel.writeInt(align == Alignment.LEFT ? 0 : (align == Alignment.CENTER ? 1 : 2));
                parcel.writeByteArray(Printer.this.getGB18030(barcode));
                parcel.writeInt(-1);
                parcel.writeInt(-1);
            }
        }.apply();
    }

    public void printBarCode(String barcode) throws OnlySupportProgressException {
        this.printBarCode(-1, -1, -1, -1, barcode);
    }

    public void printImage(final int position, final int width, final int height, final byte[] imageData) throws OnlySupportProgressException {
        Precondition.checkNotNull(imageData);
        this.checkIfInProgress();
        logger.debug("# printImage | offset: " + position + ", width: " + width + ", height: " + height + ", size: " + imageData.length, new Object[0]);
        if (imageData.length < width * height / 8) {
            logger.error("# printImage | print image size error!", new Object[0]);
            return;
        }
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(7);
                parcel.writeInt(position);
                parcel.writeInt(width);
                parcel.writeInt(height);
                parcel.writeByteArray(imageData);
            }
        }.apply();
    }

    public void cutPaper() throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(32);
            }
        }.apply();
    }

    public void autoCutPaper() throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(33);
            }
        }.apply();
    }

    public void printImage(int position, String imagePath) throws OnlySupportProgressException {
        try {
            PrintableImage image = PrintableImage.create(imagePath);
            this.printImage(position, image.getWidth(), image.getHeight(), image.getImageData());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error("# printImage | error: " + e.getMessage(), new Object[0]);
        }
    }

    public void printImage(int position, InputStream stream) throws OnlySupportProgressException {
        PrintableImage image = PrintableImage.create(stream);
        this.printImage(position, image.getWidth(), image.getHeight(), image.getImageData());
    }

    public void printMonochromeBmp(final int position, final Factor factor, final String bmpPath) {
        if (bmpPath != null && bmpPath.length() > 0) {
            new ParcelWriter(){

                @Override
                public void writeParcelData(Parcel parcel) {
                    parcel.writeInt(26);
                    parcel.writeInt(position);
                    parcel.writeInt(1);
                    parcel.writeInt(factor.value());
                    parcel.writeByteArray(Printer.this.getGB18030(bmpPath));
                }
            }.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMonochromeBmp(final int position, final Factor factor, byte[] imageData) {
        final ByteArrayOutputStream out = ImageTransformer.convert1BitBmp(imageData);
        if (out == null) {
            logger.error("/// printMonochromeBmp | convert1BitBmp failed!!!", new Object[0]);
            return;
        }
        try {
            new ParcelWriter(){

                @Override
                public void writeParcelData(Parcel parcel) {
                    parcel.writeInt(26);
                    parcel.writeInt(position);
                    parcel.writeInt(0);
                    parcel.writeInt(factor.value());
                    parcel.writeByteArray(out.toByteArray());
                }
            }.apply();
        }
        finally {
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    public void printMonochromeBmp(int position, String bmpPath) {
        this.printMonochromeBmp(position, Factor.BMP1X1, bmpPath);
    }

    public void printMonochromeBmp(int position, byte[] bmpData) {
        this.printMonochromeBmp(position, Factor.BMP1X1, bmpData);
    }

    public void printImage(Alignment align, String imagePath) throws OnlySupportProgressException {
        try {
            PrintableImage image = PrintableImage.create(imagePath);
            int offset = this.calculateOffset(align, image.getWidth());
            this.printImage(offset, image.getWidth(), image.getHeight(), image.getImageData());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error("# printImage | error: " + e.getMessage(), new Object[0]);
        }
    }

    public void printImage(Alignment align, InputStream stream) throws OnlySupportProgressException {
        PrintableImage image = PrintableImage.create(stream);
        int offset = this.calculateOffset(align, image.getWidth());
        this.printImage(offset, image.getWidth(), image.getHeight(), image.getImageData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printImageNew(Alignment align, byte[] imageData) throws OnlySupportProgressException {
        ByteArrayOutputStream out = null;
        try {
            out = ImageTransformer.convert1BitBmp(imageData);
            if (out == null) {
                logger.error("/// printImageNew | convert1BitBmp failed!!!", new Object[0]);
                return;
            }
            PrintableImage image = PrintableImage.create(new ByteArrayInputStream(out.toByteArray()));
            int offset = this.calculateOffset(align, image.getWidth());
            this.printImage(offset, image.getWidth(), image.getHeight(), image.getImageData());
        }
        finally {
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    private int calculateOffset(Alignment align, int width) {
        int offset = 0;
        int validWidth = this.getValidWidth();
        switch (align) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                offset = validWidth - width;
                break;
            }
            case CENTER: {
                offset = (validWidth - width) / 2;
            }
        }
        return offset;
    }

    public void feedPix(final int pix) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(8);
                parcel.writeByte((byte)0);
                parcel.writeByte((byte)(pix > 0 ? 1 : 0));
                parcel.writeInt(pix > 0 ? pix : -pix);
            }
        }.apply();
    }

    public void feedLine(final int line) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(8);
                parcel.writeByte((byte)1);
                parcel.writeByte((byte)(line > 0 ? 1 : 0));
                parcel.writeInt(line > 0 ? line : -line);
            }
        }.apply();
    }

    public void feedToNextMark() throws OnlySupportProgressException {
        this.checkIfInProgress();
        this.feedToMark(0);
    }

    public void feedToPrevMark() throws OnlySupportProgressException {
        this.checkIfInProgress();
        this.feedToMark(1);
    }

    private void feedToMark(final int direction) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(23);
                parcel.writeInt(direction);
            }
        }.apply();
    }

    public void setPageSpace(final int space) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(16);
                parcel.writeInt(space);
            }
        }.apply();
    }

    public void setAutoTrunc(final boolean enable) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(17);
                parcel.writeByte((byte)(enable ? 1 : 0));
            }
        }.apply();
    }

    public void setLinesAllowedForLack(final int lines) {
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(18);
                parcel.writeInt(lines);
            }
        }.apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repeat(int times) {
        if (times <= 0) {
            return;
        }
        Parcel oldData = Parcel.obtain();
        try {
            oldData.appendFrom(this.mData, 4, this.mData.dataSize() - 4);
            for (int i = 0; i < times; ++i) {
                this.mData.appendFrom(oldData, 0, oldData.dataSize());
            }
        }
        finally {
            oldData.recycle();
        }
    }

    public int getStatus() throws RequestException {
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 258, null, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            reply.recycle();
        }
    }

    public int getValidWidth() {
        if (this.validWidth != 0) {
            return this.validWidth;
        }
        int width = 384;
        IntegerBuffer value = new IntegerBuffer();
        try {
            int ret = this.getFormat(4608, value);
            if (ret == 0 && value.getData() > 0) {
                this.validWidth = width = value.getData();
            }
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        return width;
    }

    public boolean isSupportBM() {
        IntegerBuffer value = new IntegerBuffer();
        try {
            int ret = this.getFormat(4864, value);
            if (ret == 0) {
                return value.getData() == 21504;
            }
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isSupportBack() {
        IntegerBuffer value = new IntegerBuffer();
        try {
            int ret = this.getFormat(4352, value);
            if (ret == 0) {
                return value.getData() == 21504;
            }
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isSupportCutter() {
        IntegerBuffer value = new IntegerBuffer();
        try {
            int ret = this.getFormat(5120, value);
            if (ret == 0) {
                return value.getData() == 21504;
            }
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFormat(int format, IntegerBuffer formatValue) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(format);
            MasterController.getInstance().request(this.packageName, 260, data, reply);
            int ret = reply.readInt();
            int value = reply.readInt();
            if (ret == 0 && value > 0) {
                formatValue.setData(value);
            }
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public void setGray(final int g) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(9);
                parcel.writeByte((byte)g);
            }
        }.apply();
    }

    private static String tempFilePath(String fileName) {
        StringBuilder path = new StringBuilder();
        if (Build.VERSION.SDK_INT >= 26) {
            path.append(Environment.getExternalStorageDirectory().getPath()).append('/').append(fileName).append(Process.myPid()).append(".dat");
        } else {
            path.append("/tmp/").append(fileName).append(Process.myPid()).append(".dat");
        }
        return path.toString();
    }

    public void setScaleMode(final ScaleMode mode) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(21);
                parcel.writeByte((byte)mode.ordinal());
            }
        }.apply();
    }

    public void setSpeedMode(final SpeedMode mode) throws OnlySupportProgressException {
        this.checkIfInProgress();
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(24);
                parcel.writeByte((byte)mode.ordinal());
            }
        }.apply();
    }

    public void ajustTextLine() {
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(22);
                parcel.writeByte((byte)1);
            }
        }.apply();
    }

    public void restoreTextLineAjustment() {
        new ParcelWriter(){

            @Override
            public void writeParcelData(Parcel parcel) {
                parcel.writeInt(22);
                parcel.writeByte((byte)0);
            }
        }.apply();
    }

    public void setMode(int mode) {
        this.mMode = mode;
    }

    private void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    protected void checkIfInProgress() throws OnlySupportProgressException {
        if (this.mData == null) {
            throw new OnlySupportProgressException();
        }
    }

    private byte[] getGB18030(String str) {
        return StringUtil.getGB18030(str);
    }

    abstract class ParcelWriter {
        ParcelWriter() {
        }

        public void apply() {
            if (Printer.this.useCache) {
                Parcel parcel = Parcel.obtain();
                try {
                    this.writeParcelData(parcel);
                    Printer.this.mCache.put(parcel);
                }
                finally {
                    parcel.recycle();
                }
            } else {
                this.writeParcelData(Printer.this.mData);
            }
        }

        public abstract void writeParcelData(Parcel var1);
    }

    private static class ParcelCache {
        static final long MAX_PARCEL_SIZE = 524288L;
        private List<Parcel> parcelList = new ArrayList<Parcel>();

        public void init(int mode) {
            if (this.parcelList.isEmpty()) {
                Parcel parcel = Parcel.obtain();
                parcel.writeInt(11);
                parcel.writeInt(mode);
                this.parcelList.add(parcel);
            }
        }

        public void put(Parcel data) {
            if (!ParcelCache.checkDataSize(data)) {
                logger.error("# ParcelCache | parcel date size too large!!!", new Object[0]);
                return;
            }
            this.checkIfInitilaized();
            int index = this.parcelList.size() - 1;
            Parcel current = this.parcelList.get(index);
            logger.debug("ParcelCache | index[" + index + "] current.dataSize = " + current.dataSize() + ", dataSize = " + data.dataSize(), new Object[0]);
            if ((long)(current.dataSize() + data.dataSize()) > 524288L) {
                Parcel newItem = Parcel.obtain();
                newItem.writeInt(12);
                newItem.appendFrom(data, 0, data.dataSize());
                this.parcelList.add(newItem);
            } else {
                current.appendFrom(data, 0, data.dataSize());
            }
        }

        public Parcel get(int index) {
            if (index < 0 || index >= this.parcelList.size()) {
                return null;
            }
            return this.parcelList.get(index);
        }

        public int count() {
            return this.parcelList.size();
        }

        public void recycle() {
            for (Parcel parcel : this.parcelList) {
                if (parcel == null) continue;
                parcel.recycle();
            }
            this.parcelList.clear();
        }

        private static boolean checkDataSize(Parcel data) {
            if (data == null) {
                return false;
            }
            return data.dataSize() > 0 && (long)data.dataSize() <= 524288L;
        }

        private void checkIfInitilaized() {
            if (this.parcelList.isEmpty()) {
                throw new IllegalStateException("init() should be called first!!!");
            }
        }
    }

    public static enum SpeedMode {
        SLOWMODE,
        FASTMODE;

    }

    public static enum ScaleMode {
        NORMAL,
        BASE16X8;

    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static enum Factor {
        BMP1X1(1),
        BMP2X2(2),
        BMP3X3(3),
        BMP4X4(4),
        BMP5X5(5);

        private int value;

        private Factor(int val) {
            this.value = val;
        }

        public int value() {
            return this.value;
        }
    }

    public static abstract class Progress
    extends RemoteListener {
        private static final int ID = 513;
        private List<Step> mStepList = new ArrayList<Step>();
        private Thread printThread;
        private String packageName;

        public Progress() {
            this(MasterController.getInstance().getDefaultAppName());
        }

        public Progress(String packageName) {
            this.packageName = packageName;
        }

        public Progress(PausableHandler handler) {
            super(handler);
            this.packageName = MasterController.getInstance().getDefaultAppName();
        }

        public Progress(String packageName, PausableHandler handler) {
            super(handler);
            this.packageName = packageName;
        }

        public void setCallbackRunOnIPCThread() {
            this.setRunOnIPCThread();
        }

        public abstract void doPrint(Printer var1) throws Exception;

        public abstract void onFinish(int var1);

        public final void addStep(Step step) {
            if (step != null) {
                this.mStepList.add(step);
            }
        }

        protected Printer getPrinter() {
            return TextUtils.isEmpty((CharSequence)this.packageName) ? Printer.getInstance() : Printer.getInstance(this.packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() throws RequestException {
            Class<Progress> clazz = Progress.class;
            synchronized (Progress.class) {
                if (this.isPrintThreadStart()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                Printer printer = this.getPrinter();
                printer.setUseCache(false);
                printer.prepareForPrint();
                try {
                    for (Step s : this.mStepList) {
                        s.doPrint(printer);
                    }
                    this.doPrint(printer);
                    this.flushNoWait(printer);
                }
                catch (RequestException e) {
                    throw e;
                }
                catch (OnlySupportProgressException e) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    printer.clearAfterPrint();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start(boolean supportFlushMode) throws RequestException {
            if (!supportFlushMode) {
                this.start();
                return;
            }
            Class<Progress> clazz = Progress.class;
            synchronized (Progress.class) {
                if (this.isPrintThreadStart()) {
                    long startTime = System.currentTimeMillis();
                    while (true) {
                        this.abort();
                        if (!this.isPrintThreadStart()) break;
                        if (startTime + 500L < System.currentTimeMillis()) {
                            throw new IllegalStateException("----------the printer was started----------");
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.printThread = new Thread("printer"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Printer printer = Progress.this.getPrinter();
                        printer.prepareForPrint();
                        logger.debug("----------------------- flush mode start ------------------------", new Object[0]);
                        try {
                            for (Step s : Progress.this.mStepList) {
                                s.doPrint(printer);
                            }
                            Progress.this.doPrint(printer);
                            logger.debug("----------------------- flush final start ------------------------", new Object[0]);
                            Progress.this.flushNoWait(printer);
                            logger.debug("----------------------- flush final end ------------------------", new Object[0]);
                        }
                        catch (RequestException e) {
                            logger.debug("---------------------- req exception -------------------", new Object[0]);
                            Progress.this.notifyRemoteCrash();
                        }
                        catch (OnlySupportProgressException e) {
                        }
                        catch (PrintInterruptedExecption e) {
                            logger.debug("---------------------- interrupt -------------------", new Object[0]);
                        }
                        catch (Exception e) {
                            logger.debug("---------------------- excpetion -------------------", new Object[0]);
                            throw new RuntimeException(e);
                        }
                        finally {
                            Class<Progress> e = Progress.class;
                            synchronized (Progress.class) {
                                Progress.this.printThread = null;
                                // ** MonitorExit[e] (shouldn't be in output)
                                printer.clearAfterPrint();
                            }
                        }
                    }
                };
                this.printThread.start();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        protected final boolean flush(Printer printer) throws RequestException {
            int status;
            this.flushNoWaitBlockMode(printer);
            printer.prepareForPrint();
            block4: while (true) {
                status = printer.getStatus();
                switch (status) {
                    case 247: {
                        continue block4;
                    }
                    case 0: {
                        return true;
                    }
                }
                break;
            }
            this.post(new Runnable(){

                @Override
                public void run() {
                    Progress.this.onFlushError(status);
                }
            });
            this.waitForResume();
            return false;
        }

        private void flushNoWait(Printer printer) throws RequestException {
            MasterController.getInstance().installListener(printer.packageName, this);
            MasterController.getInstance().request(printer.packageName, 257, printer.mData, (RemoteListener)this);
        }

        private void flushNoWaitBlockMode(Printer printer) throws RequestException {
            MasterController.getInstance().request(printer.packageName, 257, printer.mData);
        }

        private boolean isPrintThreadStart() {
            return this.printThread != null && this.printThread.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void abort() {
            Class<Progress> clazz = Progress.class;
            synchronized (Progress.class) {
                if (this.printThread != null) {
                    this.printThread.interrupt();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resume() {
            if (this.printThread != null) {
                Thread thread = this.printThread;
                synchronized (thread) {
                    this.printThread.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForResume() {
            Thread thread = this.printThread;
            synchronized (thread) {
                try {
                    this.printThread.wait();
                }
                catch (InterruptedException e) {
                    throw new PrintInterruptedExecption();
                }
            }
        }

        @Override
        public final int getEventId() {
            return 513;
        }

        @Override
        protected final void onListened(Parcel data) {
            MasterController.getInstance().uninstallListener(this.packageName, this);
            int ret = data.readInt();
            if (ret == 233) {
                ret = 0;
            }
            this.onFinish(ret);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute() throws RequestException {
            Class<Progress> clazz = Progress.class;
            synchronized (Progress.class) {
                if (this.isPrintThreadStart()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                Printer printer = this.getPrinter();
                printer.setUseCache(true);
                printer.prepareForPrint();
                try {
                    for (Step s : this.mStepList) {
                        s.doPrint(printer);
                    }
                    this.doPrint(printer);
                    this.flushPrintData(printer);
                }
                catch (RequestException e) {
                    throw e;
                }
                catch (OnlySupportProgressException e) {
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    printer.clearAfterPrint();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushPrintData(Printer printer) throws RequestException {
            TimeSlicer timeLogger = TimeSlicer.create();
            ParcelCache cache = printer.mCache;
            int count = cache.count();
            logger.debug("Printer | flushPrintData | count = " + count, new Object[0]);
            for (int index = 0; index < count; ++index) {
                Parcel reply = Parcel.obtain();
                try {
                    Parcel item = cache.get(index);
                    MasterController.getInstance().request(this.packageName, 259, item, reply);
                    int result = reply.readInt();
                    logger.debug("Printer | flushPrintData | result = " + result, new Object[0]);
                    continue;
                }
                finally {
                    reply.recycle();
                }
            }
            Parcel data = Parcel.obtain();
            try {
                data.writeInt(14);
                MasterController.getInstance().installListener(this.packageName, this);
                MasterController.getInstance().request(this.packageName, 259, data, (RemoteListener)this);
            }
            finally {
                data.recycle();
            }
            timeLogger.slice("flushPrintData");
        }

        protected void onFlushError(int error) {
        }

        class PrintInterruptedExecption
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            PrintInterruptedExecption() {
            }
        }
    }

    public static interface Step {
        public void doPrint(Printer var1) throws Exception;
    }

    public static class Format {
        public static final AscSize ASC_DOT5x7 = AscSize.DOT5x7;
        public static final AscSize ASC_DOT7x7 = AscSize.DOT7x7;
        public static final AscSize ASC_DOT16x8 = AscSize.DOT16x8;
        public static final AscSize ASC_DOT24x12 = AscSize.DOT24x12;
        public static final AscSize ASC_DOT24x8 = AscSize.DOT24x8;
        public static final AscSize ASC_DOT32x12 = AscSize.DOT32x12;
        public static final AscScale ASC_SC1x1 = AscScale.SC1x1;
        public static final AscScale ASC_SC1x2 = AscScale.SC1x2;
        public static final AscScale ASC_SC1x3 = AscScale.SC1x3;
        public static final AscScale ASC_SC2x1 = AscScale.SC2x1;
        public static final AscScale ASC_SC2x1SP = AscScale.SC2x1SP;
        public static final AscScale ASC_SC2x2 = AscScale.SC2x2;
        public static final AscScale ASC_SC2x3 = AscScale.SC2x3;
        public static final AscScale ASC_SC3x1 = AscScale.SC3x1;
        public static final AscScale ASC_SC3x2 = AscScale.SC3x2;
        public static final AscScale ASC_SC3x3 = AscScale.SC3x3;
        public static final HzSize HZ_DOT16x16 = HzSize.DOT16x16;
        public static final HzSize HZ_DOT24x24 = HzSize.DOT24x24;
        public static final HzSize HZ_DOT24x16 = HzSize.DOT24x16;
        public static final HzSize HZ_DOT32x24 = HzSize.DOT32x24;
        public static final HzScale HZ_SC1x1 = HzScale.SC1x1;
        public static final HzScale HZ_SC1x2 = HzScale.SC1x2;
        public static final HzScale HZ_SC1x3 = HzScale.SC1x3;
        public static final HzScale HZ_SC2x1 = HzScale.SC2x1;
        public static final HzScale HZ_SC2x2 = HzScale.SC2x2;
        public static final HzScale HZ_SC2x3 = HzScale.SC2x3;
        public static final HzScale HZ_SC3x1 = HzScale.SC3x1;
        public static final HzScale HZ_SC3x2 = HzScale.SC3x2;
        public static final HzScale HZ_SC3x3 = HzScale.SC3x3;
        public static final PicScale PIC_SC1x1 = PicScale.SC1x1;
        public static final PicScale PIC_SC2x2 = PicScale.SC2x2;
        public static final PicScale PIC_SC3x3 = PicScale.SC3x3;
        private AscScale mAscScale = null;
        private HzScale mHzScale = null;
        private AscSize mAscSize = null;
        private HzSize mHzSize = null;
        private int mXSpace = -1;
        private int mYSpace = -1;
        private PicScale mPicScale = null;

        public static Format asc(AscSize size, AscScale scale) {
            Format f = new Format();
            f.setAscSize(size);
            f.setAscScale(scale);
            return f;
        }

        public static Format asc(AscSize size) {
            return Format.asc(size, null);
        }

        public static Format asc(AscScale scale) {
            return Format.asc(null, scale);
        }

        public static Format hz(HzSize size, HzScale scale) {
            Format f = new Format();
            f.setHzSize(size);
            f.setHzScale(scale);
            return f;
        }

        public static Format hz(HzSize size) {
            return Format.hz(size, null);
        }

        public static Format hz(HzScale scale) {
            return Format.hz(null, scale);
        }

        public static Format space(int xspace, int yspace) {
            Format f = new Format();
            f.setXSpace(xspace);
            f.setYSpace(yspace);
            return f;
        }

        public AscSize getAscSize() {
            return this.mAscSize;
        }

        public void setAscSize(AscSize mAscSize) {
            this.mAscSize = mAscSize;
        }

        public AscScale getAscScale() {
            return this.mAscScale;
        }

        public void setAscScale(AscScale mAscScale) {
            this.mAscScale = mAscScale;
        }

        public HzSize getHzSize() {
            return this.mHzSize;
        }

        public void setHzSize(HzSize mHzSize) {
            this.mHzSize = mHzSize;
        }

        public HzScale getHzScale() {
            return this.mHzScale;
        }

        public void setHzScale(HzScale mHzScale) {
            this.mHzScale = mHzScale;
        }

        public static Format pic(PicScale scale) {
            Format f = new Format();
            f.setPicScale(scale);
            return f;
        }

        public PicScale getPicScale() {
            return this.mPicScale;
        }

        public void setPicScale(PicScale mPicScale) {
            this.mPicScale = mPicScale;
        }

        public int getXSpace() {
            return this.mXSpace;
        }

        public void setXSpace(int mXSpace) {
            this.mXSpace = mXSpace;
        }

        public int getYSpace() {
            return this.mYSpace;
        }

        public void setYSpace(int mYSpace) {
            this.mYSpace = mYSpace;
        }

        private void writeToParcel(Parcel dest) {
            byte[] data = new byte[]{(byte)(this.mAscSize == null ? 0 : this.mAscSize.getValue()), (byte)(this.mAscScale == null ? 0 : this.mAscScale.getValue()), (byte)(this.mHzSize == null ? 0 : this.mHzSize.getValue()), (byte)(this.mHzScale == null ? 0 : this.mHzScale.getValue()), (byte)this.mXSpace, (byte)this.mYSpace, (byte)(this.mPicScale == null ? 0 : this.mPicScale.getValue())};
            dest.writeByteArray(data);
        }

        public static enum PicScale {
            SC1x1(1),
            SC2x2(2),
            SC3x3(3);

            private int mValue;

            private PicScale(int value) {
                this.mValue = value;
            }

            int getValue() {
                return this.mValue;
            }
        }

        public static enum HzScale {
            SC1x1(1),
            SC2x1(2),
            SC1x2(4),
            SC2x2(5),
            SC1x3(6),
            SC2x3(7),
            SC3x1(8),
            SC3x2(9),
            SC3x3(10);

            private int mValue;

            private HzScale(int value) {
                this.mValue = value;
            }

            int getValue() {
                return this.mValue;
            }
        }

        public static enum HzSize {
            DOT16x16(1),
            DOT24x24(2),
            DOT24x16(3),
            DOT32x24(4);

            private int mValue;

            private HzSize(int value) {
                this.mValue = value;
            }

            int getValue() {
                return this.mValue;
            }
        }

        public static enum AscScale {
            SC1x1(1),
            SC2x1(2),
            SC2x1SP(3),
            SC1x2(4),
            SC2x2(5),
            SC1x3(6),
            SC2x3(7),
            SC3x1(8),
            SC3x2(9),
            SC3x3(10);

            private int mValue;

            private AscScale(int value) {
                this.mValue = value;
            }

            int getValue() {
                return this.mValue;
            }
        }

        public static enum AscSize {
            DOT5x7(1),
            DOT7x7(2),
            DOT16x8(3),
            DOT24x12(4),
            DOT24x8(5),
            DOT32x12(6);

            private int mValue;

            private AscSize(int value) {
                this.mValue = value;
            }

            int getValue() {
                return this.mValue;
            }
        }
    }
}

