/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import com.landicorp.android.eptapi.device.IModem;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;

public class Modem {
    public static final int BPS_DEFAULT = 0;
    public static final int BPS_1200 = 1;
    public static final int BPS_2400 = 2;
    public static final int BPS_9600 = 3;
    public static final int BPS_14400 = 4;
    public static final int BPS_19200 = 5;
    public static final int BPS_28800 = 6;
    public static final int BPS_33600 = 7;
    public static final int BPS_300 = 8;
    public static final int BPS_24000 = 9;
    public static final int BPS_26400 = 10;
    public static final int BPS_56000 = 11;
    public static final int PAR_NO = 78;
    public static final int PAR_EVEN = 69;
    public static final int PAR_ODD = 79;
    public static final int DBS_7DBS = 7;
    public static final int DBS_8DBS = 8;
    public static final int CMD_RESET_MODEM = 1;
    public static final int CMD_DEBUG_ON = 2;
    public static final int CMD_DEBUG_OFF = 3;
    public static final int CMD_TEST_LINE = 4;
    public static final int CMD_CONNECT_TIME = 5;
    public static final int CMD_SNRM_TIME = 6;
    public static final int CMD_SET_DCDTIMEOUT = 17;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_INVALID_HANDLE = -1;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_OTHER = 70;
    public static final int ERROR_PHONEINUSE = 80;
    public static final int ERROR_HANGUP = 79;
    public static final int ERROR_INDIAL = 68;
    public static final int ERROR_RECVNOACK = 71;
    public static final int ERROR_ATCOMRIGHT = 48;
    public static final int ERROR_ATCOMERROR = 69;
    public static final int ERROR_TIMEOUT = 86;
    public static final int ERROR_NOPATCH = 90;
    public static final int ERROR_NOTSUPPORT = 78;
    public static final int STATE_OK = 0;
    public static final int STATE_ERROR = 1;
    public static final int STATE_LINEBUSY = 55;
    public static final int STATE_INPROCESS = 67;
    public static final int STATE_NOCARRIER = 51;
    public static final int STATE_NODIALTONE = 54;
    public static final int STATE_TIMEOUT = 86;
    public static final int PTC_V22FC = 1;
    public static final int PTC_V22 = 2;
    public static final int PTC_V22BIS = 3;
    public static final int PTC_V29FC = 4;
    public static final int PTC_Bell212 = 5;
    public static final int DTMF_MODE = 84;
    public static final int PLUS_MODE = 80;
    public static final int SDLCAD = 48;
    public static final int SST = 5;
    private IModem.DeviceHandle handle;
    private IModem driver = new IModem();
    private String deviceName = "MODEM";
    private static Modem instance;

    private Modem() {
    }

    public static Modem getInstance() {
        return instance;
    }

    public synchronized int open() {
        if (this.handle != null) {
            return 0;
        }
        this.handle = IModem.DeviceHandle.open(this.deviceName);
        return this.handle.getError();
    }

    public synchronized boolean isOpen() {
        return this.handle != null;
    }

    public synchronized void close() {
        if (this.handle == null) {
            return;
        }
        this.handle.close();
        this.handle = null;
    }

    public synchronized int initDial(int bps, int par, int dbs) {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.initDial(this.handle.getValue(), bps, par, dbs);
    }

    public synchronized int initSdlc(int bps, int sdlcAD, int sst) {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.initSdlc(this.handle.getValue(), bps, sdlcAD, sst);
    }

    public synchronized int dial(String atCmd) {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.dial(this.handle.getValue(), atCmd);
    }

    public synchronized int getLineStatus(BytesBuffer sts) {
        if (this.handle == null) {
            return -1;
        }
        if (sts == null) {
            sts = new BytesBuffer();
        }
        return this.driver.getLineStatus(this.handle.getValue(), sts);
    }

    public synchronized int ringDetect() {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.ringDetect(this.handle.getValue());
    }

    public synchronized int answer(int bps, BytesBuffer sts) {
        if (this.handle == null) {
            return -1;
        }
        if (sts == null) {
            sts = new BytesBuffer();
        }
        return this.driver.answer(this.handle.getValue(), bps, sts);
    }

    public synchronized int dialOff() {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.dialOff(this.handle.getValue());
    }

    public synchronized int clearInputBuffer() {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.clearInputBuffer(this.handle.getValue());
    }

    public synchronized boolean isInputBufferEmpty() {
        if (this.handle == null) {
            return true;
        }
        return this.driver.isInputBufferEmpty(this.handle.getValue());
    }

    public synchronized int ioctl(int cmd, String param) {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.ioctl(this.handle.getValue(), cmd, param);
    }

    public synchronized int write(int timeout, byte[] data) {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.write(this.handle.getValue(), timeout, data);
    }

    public int write(int timeout, byte[] data, int offset, int len) {
        return this.write(timeout, BytesUtil.subBytes(data, offset, len));
    }

    public synchronized int read(int timeout, byte[] data, int offset, int len) {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.read(this.handle.getValue(), timeout, data, offset, len);
    }

    public synchronized int reset() {
        if (this.handle == null) {
            return -1;
        }
        return this.driver.ioctl(this.handle.getValue(), 1, null);
    }

    static {
        System.loadLibrary("eptand_jni");
        instance = new Modem();
    }
}

