/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class At1608Driver
implements InsertDriver {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NOPOWER = 227;
    public static final int ERROR_NOCARD = 251;
    public static final int ERROR_FAILED = 1;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_OTHER = 143;
    public static final int ERROR_ERRTYPE = 194;
    public static final int ERROR_WRITEFAIL = 80;
    public static final int ERROR_READFAIL = 81;
    public static final int ERROR_OPERATIONFAIL = 143;
    public static final int ERROR_OPERAFORBID = 83;
    public static final int ERROR_FUSEDONE = 84;
    public static final int ERROR_SECCODE_UNVERI = 85;
    public static final int ERROR_NOVERIFY = 231;
    public static final int ERROR_TIMEOUT = 209;
    public static final int ERROR_ACKERR = 210;
    public static final int ERROR_RSTERR = 143;
    public static final int ERROR_READARERR = 212;
    public static final int ERROR_READPACERR = 213;
    public static final int ERROR_VERCOUNTOVL = 214;
    public static final int ERROR_VERIFYFAIL = 143;
    public static final int ERROR_READFUSEFAIL = 81;
    public static final int ERROR_USERZONENOTSET = 217;
    public static final int ERROR_NOAUTH = 218;
    public static final int ERROR_READAACERR = 219;
    public static final int ERROR_INITAUTHERR = 220;
    public static final int ERROR_READONLY = 221;
    public static final int ERROR_READNCERR = 222;
    public static final int ERROR_READCIERR = 223;
    public static final int ERROR_AUTHERR = 143;
    public static final int VOL_5 = 0;
    public static final int VOL_3 = 1;
    public static final int FLAG_SCVERFIY = 2;
    public static final int FLAG_READPWD = 1;
    public static final int FLAG_WRITEPWD = 0;
    private String deviceName;
    private String packageName;

    public At1608Driver() {
        this("USERCARD");
    }

    public At1608Driver(String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public At1608Driver(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        this.packageName = packageName;
        this.deviceName = deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 771, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void halt() throws RequestException {
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 772, data);
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public String getDriverName() {
        return "INSERT_AT1608";
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerUp(int vol, BytesBuffer atr) throws RequestException {
        Precondition.checkNotNull(atr);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(vol);
            MasterController.getInstance().request(this.packageName, 849, data, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            atr.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerDown() throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 850, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verify(int rwFlag, byte[] password, IntegerBuffer errorCount) throws RequestException {
        Precondition.checkNotNull(password);
        Precondition.checkNotNull(errorCount);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(rwFlag);
            data.writeByteArray(password);
            MasterController.getInstance().request(this.packageName, 851, data, reply);
            int ret = reply.readInt();
            errorCount.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeKey(int rwFlag, byte[] password) throws RequestException {
        Precondition.checkNotNull(password);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(rwFlag);
            data.writeByteArray(password);
            MasterController.getInstance().request(this.packageName, 852, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readErrorCount(int rwFlag, IntegerBuffer errorCount) throws RequestException {
        Precondition.checkNotNull(errorCount);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(rwFlag);
            MasterController.getInstance().request(this.packageName, 853, data, reply);
            int ret = reply.readInt();
            errorCount.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(int address, int len, BytesBuffer data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            d.writeInt(len);
            MasterController.getInstance().request(this.packageName, 854, d, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            data.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    public int read(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        Precondition.checkArgument(data.length >= offset + len);
        BytesBuffer d = new BytesBuffer();
        if (data.length < offset + len) {
            return 139;
        }
        int ret = this.read(address, len, d);
        if (d.getData() != null) {
            System.arraycopy(d.getData(), 0, data, offset, len);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(int address, byte[] data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            d.writeByteArray(data);
            MasterController.getInstance().request(this.packageName, 855, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    public int write(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        Precondition.checkArgument(data.length >= offset + len);
        if (data.length < offset + len) {
            return 139;
        }
        return this.write(address, BytesUtil.subBytes(data, offset, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readAccessStatus(IntegerBuffer status) throws RequestException {
        Precondition.checkNotNull(status);
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 856, d, reply);
            int ret = reply.readInt();
            status.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeAccessStatus(int status) throws RequestException {
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(status);
            MasterController.getInstance().request(this.packageName, 857, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setUserZone(int zone) throws RequestException {
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(zone);
            MasterController.getInstance().request(this.packageName, 858, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFuse(IntegerBuffer fuse) throws RequestException {
        Precondition.checkNotNull(fuse);
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 859, d, reply);
            int ret = reply.readInt();
            fuse.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeFuse() throws RequestException {
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 860, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    public int authentication(byte[] key, GcCalculator calculator, IntegerBuffer errorCount) throws RequestException {
        Precondition.checkNotNull(key);
        Precondition.checkNotNull(calculator);
        Precondition.checkNotNull(errorCount);
        BytesBuffer nc = new BytesBuffer();
        int ret = this.authenticationStep1(nc);
        if (ret != 0) {
            return ret;
        }
        byte[] gc = calculator.onCalculate(key, nc.getData());
        if (gc == null) {
            return 139;
        }
        return this.authenticationStep2(gc, errorCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int authenticationStep1(BytesBuffer nc) throws RequestException {
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 861, d, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            nc.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int authenticationStep2(byte[] gc, IntegerBuffer errorCount) throws RequestException {
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeByteArray(gc);
            MasterController.getInstance().request(this.packageName, 862, d, reply);
            int ret = reply.readInt();
            errorCount.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readAuthInfo(IntegerBuffer aac, BytesBuffer nc) throws RequestException {
        Precondition.checkNotNull(aac);
        Precondition.checkNotNull(nc);
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 863, d, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            aac.setData(reply.readInt());
            nc.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeAuthInfo(int aac, byte[] nc, byte[] gc) throws RequestException {
        Precondition.checkNotNull(nc);
        Precondition.checkNotNull(gc);
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(aac);
            d.writeByteArray(nc);
            d.writeByteArray(gc);
            MasterController.getInstance().request(this.packageName, 864, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioTest() throws RequestException {
        Parcel d = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 865, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    public static interface GcCalculator {
        public byte[] onCalculate(byte[] var1, byte[] var2);
    }
}

