/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.impl.auth;

import com.icbc.api.internal.apache.http.Header;
import com.icbc.api.internal.apache.http.HttpRequest;
import com.icbc.api.internal.apache.http.annotation.NotThreadSafe;
import com.icbc.api.internal.apache.http.auth.AuthenticationException;
import com.icbc.api.internal.apache.http.auth.Credentials;
import com.icbc.api.internal.apache.http.impl.auth.GGSSchemeBase;
import com.icbc.api.internal.apache.http.protocol.HttpContext;
import com.icbc.api.internal.apache.http.util.Args;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@NotThreadSafe
public class KerberosScheme
extends GGSSchemeBase {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";

    public KerberosScheme(boolean stripPort, boolean useCanonicalHostname) {
        super(stripPort, useCanonicalHostname);
    }

    public KerberosScheme(boolean stripPort) {
        super(stripPort);
    }

    public KerberosScheme() {
    }

    public String getSchemeName() {
        return "Kerberos";
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return super.authenticate(credentials, request, context);
    }

    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return super.generateToken(input, authServer);
    }

    protected byte[] generateToken(byte[] input, String authServer, Credentials credentials) throws GSSException {
        return this.generateGSSToken(input, new Oid(KERBEROS_OID), authServer, credentials);
    }

    public String getParameter(String name) {
        Args.notNull(name, "Parameter name");
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }
}

