/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.crypt;

import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Digest {
    public static String sha256(String data) throws Exception {
        MessageDigest sha = MessageDigest.getInstance("SHA256");
        sha.update(data.getBytes());
        byte[] digest = sha.digest();
        return Digest.toHax(digest);
    }

    public static String hmac(String data, String password) throws Exception {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey key = keyFactory.generateSecret(keySpec);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(key);
        byte[] digestBytes = mac.doFinal(data.getBytes());
        return Digest.toHax(digestBytes);
    }

    public static String toHax(byte[] digest) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            String out = Integer.toHexString(digest[i] & 0xFF);
            if (out.length() == 1) {
                sb.append('0');
            }
            sb.append(out);
        }
        return sb.toString();
    }
}

