/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util.common;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import com.aofeng.hybrid.util.LogUtil;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ThirdPartyAppWakeUp {
    private Context context;

    public static String WaleUpAppIntentForPackage(Context context, String apppackage, String serviceKey, JSONObject params) {
        try {
            Intent intent = null;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(apppackage, 0);
            if (null != packageInfo) {
                Context pkgContext = ThirdPartyAppWakeUp.getPackageContext(context, apppackage);
                intent = ThirdPartyAppWakeUp.getAppOpenIntentByPackageName(context, apppackage);
                if (intent == null || pkgContext != null) {
                    // empty if block
                }
                ThirdPartyAppWakeUp.stopAppByKill(context, apppackage);
                intent = context.getPackageManager().getLaunchIntentForPackage(apppackage);
                intent.putExtra("servicekey", serviceKey);
                Iterator keys = params.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    intent.putExtra(key, params.getString(key));
                }
                intent.setFlags(0x10000000);
                context.startActivity(intent);
                LogUtil.i("ThirdPartyAppWakeUp", "\u5f53\u524d\u6253\u5f00\u7684\u7b2c\u4e09\u65b9app\u3010\u4e0d\u5728\u3011\u540e\u53f0\u8fd0\u884c" + apppackage);
                return "\u6210\u529f";
            }
            LogUtil.w("ThirdPartyAppWakeUp", "\u5f53\u524d\u6253\u5f00\u7684\u7b2c\u4e09\u65b9APP\u672a\u5b89\u88c5");
            return "\u5f53\u524d\u6253\u5f00\u7684\u7b2c\u4e09\u65b9APP\u672a\u5b89\u88c5";
        }
        catch (PackageManager.NameNotFoundException e) {
            return "\u5f53\u524d\u6253\u5f00\u7684\u7b2c\u4e09\u65b9APP\u672a\u5b89\u88c5";
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "\u8bf7\u6838\u5bf9\u8df3\u8f6c\u65f6\u53c2\u6570\u662f\u5426\u6b63\u786e";
        }
    }

    public static Intent getAppOpenIntentByPackageName(Context context, String packageName) {
        String mainAct = null;
        PackageManager pkgMag = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setFlags(0x10200000);
        List list = pkgMag.queryIntentActivities(intent, 1);
        for (int i = 0; i < list.size(); ++i) {
            ResolveInfo info = (ResolveInfo)list.get(i);
            if (!info.activityInfo.packageName.equals(packageName)) continue;
            mainAct = info.activityInfo.name;
            break;
        }
        if (TextUtils.isEmpty(mainAct)) {
            return null;
        }
        intent.setComponent(new ComponentName(packageName, mainAct));
        return intent;
    }

    public static Context getPackageContext(Context context, String packageName) {
        Context pkgContext = null;
        if (context.getPackageName().equals(packageName)) {
            pkgContext = context;
        } else {
            try {
                pkgContext = context.createPackageContext(packageName, 3);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return pkgContext;
    }

    public static void stopAppByKill(Context context, String packageName) {
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        mActivityManager.killBackgroundProcesses(packageName);
    }
}

