/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util.amap;

import android.content.Context;
import com.amap.api.maps.model.LatLng;
import com.aofeng.hybrid.android.receiver.PhoneStatus;
import com.aofeng.hybrid.service.LogicService;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import com.aofeng.hybrid.util.amap.PathSmoothTool;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class LocalPointTrajectoryProcessing {
    private static final int pageSize = 1000;
    private static SimpleDateFormat format;
    private static SimpleDateFormat sdf;

    public static void getLocalLocationStatus(Context context) {
        try {
            JSONObject pref = CommUtil.getHybridContext(context);
            String f_user_name = pref.getString("f_repairman_name");
            String f_subcompany = pref.getString("f_subcompany");
            String f_user_id = pref.get("f_repairman_id") + "";
            JSONObject data = new JSONObject();
            data.put("f_user_id", (Object)f_user_id);
            data.put("f_datetime", (Object)sdf.format(new Date()));
            LogicService logicService = new LogicService(context);
            JSONObject result = (JSONObject)logicService.run("queryLocalLocationStatus", data);
            if (result.getInt("code") == 200) {
                JSONArray resultJSONArray = result.getJSONArray("data");
                StringBuilder deleteIds = new StringBuilder();
                List<LatLng> trackPoints = new ArrayList<LatLng>();
                for (int i = 0; i < resultJSONArray.length(); ++i) {
                    trackPoints.add(new LatLng(Double.parseDouble(resultJSONArray.getJSONObject(i).getString("f_latitude")), Double.parseDouble(resultJSONArray.getJSONObject(i).getString("f_longitude"))));
                    deleteIds.append("'" + resultJSONArray.getJSONObject(i).optInt("id") + "',");
                }
                deleteIds.deleteCharAt(deleteIds.length() - 1);
                PathSmoothTool pathSmoothTool = new PathSmoothTool();
                pathSmoothTool.setIntensity(4);
                trackPoints = pathSmoothTool.pathOptimize(trackPoints);
                JSONObject resultEnd = new JSONObject();
                JSONArray subArray = new JSONArray();
                int lents = trackPoints.size();
                for (int i = 0; i < lents; ++i) {
                    LatLng latLng = trackPoints.get(i);
                    JSONObject objectLatLon = new JSONObject();
                    subArray.put((Object)objectLatLon.put("lat", latLng.latitude));
                    subArray.put((Object)objectLatLon.put("lon", latLng.longitude));
                }
                resultEnd.put("f_location", (Object)subArray);
                resultEnd.put("f_start_date", (Object)resultJSONArray.getJSONObject(0).optString("f_realtime"));
                resultEnd.put("f_end_date", (Object)resultJSONArray.getJSONObject(resultJSONArray.length() - 1).optString("f_realtime"));
                resultEnd.put("f_user_name", (Object)f_user_name);
                resultEnd.put("f_user_id", (Object)f_user_id);
                resultEnd.put("f_sn", (Object)PhoneStatus.getDeviceId(context));
                resultEnd.put("deleteIds", (Object)deleteIds);
                logicService.run("UpLocalLocationToRemote", resultEnd);
            } else {
                LogUtil.e("\u63d0\u53d6\u672c\u5730\u4f4d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0cqueryLocalLocationStatus", "\u9519\u8bef\u539f\u56e0\uff1a" + result.getString("data"));
            }
        }
        catch (Exception e) {
            LogUtil.e("\u67e5\u8be2\u672c\u5730\u6240\u6709\u7684\u70b9\u6c47\u603b\u7ea0\u504f\u5931\u8d25", e.toString());
        }
    }

    public static String TimeDiff(String pBeginTime, String pEndTime) throws Exception {
        format = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        Long beginL = format.parse(pBeginTime).getTime();
        Long endL = format.parse(pEndTime).getTime();
        Long day = (endL - beginL) / 86400000L;
        Long hour = (endL - beginL) % 86400000L / 3600000L;
        Long min = (endL - beginL) % 86400000L % 3600000L / 60000L;
        return hour.toString();
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

