/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.core.app.ActivityCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PermissionHelper {
    public static boolean hasPermissions(Context context, String[] permissions) {
        for (String perm : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)perm) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean hasDefinedPermission(Context context, String permission2) {
        List<String> requestedPermissionsList;
        ArrayList<String> requestedPermissionsArrayList;
        boolean hasPermission = false;
        String[] requestedPermissions = PermissionHelper.getManifestPermissions(context);
        if (requestedPermissions != null && requestedPermissions.length > 0 && (requestedPermissionsArrayList = new ArrayList<String>(requestedPermissionsList = Arrays.asList(requestedPermissions))).contains(permission2)) {
            hasPermission = true;
        }
        return hasPermission;
    }

    public static boolean hasDefinedPermissions(Context context, String[] permissions) {
        for (String permission2 : permissions) {
            if (PermissionHelper.hasDefinedPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    public static String[] getManifestPermissions(Context context) {
        String[] requestedPermissions = null;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 4096);
            if (packageInfo != null) {
                requestedPermissions = packageInfo.requestedPermissions;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return requestedPermissions;
    }

    public static String[] getUndefinedPermissions(Context context, String[] neededPermissions) {
        ArrayList<String> undefinedPermissions = new ArrayList<String>();
        String[] requestedPermissions = PermissionHelper.getManifestPermissions(context);
        if (requestedPermissions != null && requestedPermissions.length > 0) {
            List<String> requestedPermissionsList = Arrays.asList(requestedPermissions);
            ArrayList<String> requestedPermissionsArrayList = new ArrayList<String>(requestedPermissionsList);
            for (String permission2 : neededPermissions) {
                if (requestedPermissionsArrayList.contains(permission2)) continue;
                undefinedPermissions.add(permission2);
            }
            String[] undefinedPermissionArray = new String[undefinedPermissions.size()];
            undefinedPermissionArray = undefinedPermissions.toArray(undefinedPermissionArray);
            return undefinedPermissionArray;
        }
        return neededPermissions;
    }
}

