/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogcatHelper {
    private static LogcatHelper INSTANCE = null;
    private static String PATH_LOGCAT;
    private LogDumper mLogDumper = null;
    private int mPId;

    public void init(Context context) {
        Log.d((String)"ss", (String)"\u521d\u59cb\u5316\u5f02\u5e38\u65e5\u5fd7\u7c7bssssssssssssssssssssssssssss");
        PATH_LOGCAT = Environment.getExternalStorageState().equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath() + File.separator + "bsyqLog" : context.getFilesDir().getAbsolutePath() + File.separator + "llvisionLog";
        File file = new File(PATH_LOGCAT);
        System.out.println("PATH_LOGCAT" + PATH_LOGCAT);
        System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728-\uff1f-" + file.exists());
        if (!file.exists()) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728---\u91cd\u65b0\u521b\u5efa------");
            file.mkdirs();
        }
    }

    public static LogcatHelper getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new LogcatHelper(context);
        }
        return INSTANCE;
    }

    private LogcatHelper(Context context) {
        this.init(context);
        this.mPId = android.os.Process.myPid();
    }

    public void start() {
        if (this.mLogDumper == null) {
            this.mLogDumper = new LogDumper(String.valueOf(this.mPId), PATH_LOGCAT);
        }
        this.mLogDumper.start();
    }

    public void stop() {
        if (this.mLogDumper != null) {
            this.mLogDumper.stopLogs();
            this.mLogDumper = null;
        }
    }

    public String getFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(new Date(System.currentTimeMillis()));
        return date;
    }

    private class LogDumper
    extends Thread {
        private Process logcatProc;
        private BufferedReader mReader = null;
        private boolean mRunning = true;
        String cmds = null;
        private String mPID;
        private FileOutputStream out = null;

        public LogDumper(String pid, String dir) {
            this.mPID = pid;
            try {
                this.out = new FileOutputStream(new File(dir, "log-" + LogcatHelper.this.getFileName() + (int)(Math.random() * 999.0) + (int)(Math.random() * 999.0) + (int)(Math.random() * 999.0) + ".log"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.cmds = "logcat *:e *:i | grep \"(" + this.mPID + ")\"";
        }

        public void stopLogs() {
            this.mRunning = false;
        }

        @Override
        public void run() {
            System.out.println("\u5df2\u5220\u9664\u6587\u4ef6\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01111");
            try {
                this.logcatProc = Runtime.getRuntime().exec(this.cmds);
                this.mReader = new BufferedReader(new InputStreamReader(this.logcatProc.getInputStream()), 1024);
                String line = null;
                while (this.mRunning && (line = this.mReader.readLine()) != null) {
                    if (!this.mRunning) {
                        break;
                    }
                    if (line.length() == 0 || this.out == null || !line.contains(this.mPID)) continue;
                    this.out.write((line + "\n").getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.logcatProc != null) {
                    this.logcatProc.destroy();
                    this.logcatProc = null;
                }
                if (this.mReader != null) {
                    try {
                        this.mReader.close();
                        this.mReader = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.out = null;
                }
            }
        }
    }
}

