/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.annotation.SuppressLint;
import android.util.Log;
import com.szzt.android.util.SzztDebug;

@SuppressLint(value={"DefaultLocale"})
public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getHexString(byte[] bytes) {
        String str = "";
        for (byte b : bytes) {
            str = str + String.format("%02X ", b);
        }
        return str;
    }

    public static String dumpHexString(byte[] array) {
        return HexDump.dumpHexString(array, 0, array.length);
    }

    public static String decBytesToHex(byte[] buffs) {
        if (buffs == null || buffs.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int len = buffs.length;
        for (int i = 0; i < len; ++i) {
            buffer.append(String.format("%02X", buffs[i]));
        }
        return buffer.toString();
    }

    public static String dumpHexString(byte[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        byte[] line = new byte[16];
        int lineIndex = 0;
        result.append("\n0x");
        result.append(HexDump.toHexString(offset));
        for (int i = offset; i < offset + length; ++i) {
            if (lineIndex == 16) {
                result.append(" ");
                for (int j = 0; j < 16; ++j) {
                    if (line[j] > 32 && line[j] < 126) {
                        result.append(new String(line, j, 1));
                        continue;
                    }
                    result.append(".");
                }
                result.append("\n0x");
                result.append(HexDump.toHexString(i));
                lineIndex = 0;
            }
            byte b = array[i];
            result.append(" ");
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
            line[lineIndex++] = b;
        }
        if (lineIndex != 16) {
            int i;
            int count = (16 - lineIndex) * 3;
            ++count;
            for (i = 0; i < count; ++i) {
                result.append(" ");
            }
            for (i = 0; i < lineIndex; ++i) {
                if (line[i] > 32 && line[i] < 126) {
                    result.append(new String(line, i, 1));
                    continue;
                }
                result.append(".");
            }
        }
        return result.toString();
    }

    public static String dumpHex(byte[] array) {
        if (array == null) {
            return "null";
        }
        return HexDump.dumpHex(array, 0, array.length);
    }

    public static String decBytesToHex(byte[] buffs, int length) {
        if (buffs == null || length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(String.format("%02X", buffs[i]));
        }
        return buffer.toString();
    }

    public static String dumpHex(byte[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            if (i != offset) {
                result.append(" ");
            }
            result.append("0x");
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
        }
        result.append(" ");
        return result.toString();
    }

    public static String toHexString(byte b) {
        return HexDump.toHexString(HexDump.toByteArray(b));
    }

    public static String toHexStringX(byte b) {
        return "0x" + HexDump.toHexString(HexDump.toByteArray(b));
    }

    public static String toHexString(byte[] array) {
        if (array == null) {
            return "null";
        }
        return HexDump.toHexString(array, 0, array.length);
    }

    public static String toHexString(byte[] array, int offset, int length) {
        char[] buf = new char[length * 2];
        int bufIndex = 0;
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            buf[bufIndex++] = HEX_DIGITS[b >>> 4 & 0xF];
            buf[bufIndex++] = HEX_DIGITS[b & 0xF];
        }
        return new String(buf);
    }

    public static String toHexString(int i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static String toHexStringX(int i) {
        return "0x" + HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static byte[] toByteArray(byte b) {
        byte[] array = new byte[]{b};
        return array;
    }

    public static byte[] toByteArray(int i) {
        byte[] array = new byte[4];
        array[3] = (byte)(i & 0xFF);
        array[2] = (byte)(i >> 8 & 0xFF);
        array[1] = (byte)(i >> 16 & 0xFF);
        array[0] = (byte)(i >> 24 & 0xFF);
        return array;
    }

    private static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("Invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        byte[] buffer = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            buffer[i / 2] = (byte)(HexDump.toByte(hexString.charAt(i)) << 4 | HexDump.toByte(hexString.charAt(i + 1)));
        }
        return buffer;
    }

    public static String bcd2Str(byte[] bytes) {
        StringBuffer temp = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            temp.append((byte)((bytes[i] & 0xF0) >> 4));
            temp.append((byte)(bytes[i] & 0xF));
        }
        return temp.toString().substring(0, 1).equalsIgnoreCase("0") ? temp.toString().substring(1) : temp.toString();
    }

    public static String byte2bcd(byte[] bcds) {
        char[] ascii = "0123456789abcdef".toCharArray();
        byte[] temp = new byte[bcds.length * 2];
        for (int i = 0; i < bcds.length; ++i) {
            temp[i * 2] = (byte)(bcds[i] >> 4 & 0xF);
            temp[i * 2 + 1] = (byte)(bcds[i] & 0xF);
        }
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < temp.length; ++i) {
            res.append(ascii[temp[i]]);
        }
        return res.toString().toUpperCase();
    }

    public static byte[] str2Bcd(String asc) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            asc = "0" + asc;
            len = asc.length();
        }
        byte[] abt = new byte[len];
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        abt = asc.getBytes();
        for (int p = 0; p < asc.length() / 2; ++p) {
            byte b;
            int j = abt[2 * p] >= 48 && abt[2 * p] <= 57 ? abt[2 * p] - 48 : (abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : abt[2 * p] - 65 + 10);
            int k = abt[2 * p + 1] >= 48 && abt[2 * p + 1] <= 57 ? abt[2 * p + 1] - 48 : (abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : abt[2 * p + 1] - 65 + 10);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
        }
        return bbt;
    }

    public static int byteToInt(byte[] b) {
        if (b == null || b.length > 4) {
            return 0;
        }
        int value = 0;
        for (int i = 0; i < b.length; ++i) {
            int shift = (b.length - 1 - i) * 8;
            value += (b[i + 0] & 0xFF) << shift;
        }
        return value;
    }

    public static String getSendCmd(String paramString1, String paramString2, String paramString3) {
        StringBuilder stringBuilder1 = new StringBuilder();
        stringBuilder1.append("getSendCmd");
        stringBuilder1.append(paramString1);
        stringBuilder1.append("=====waiteCmd:");
        stringBuilder1.append(paramString2);
        stringBuilder1.append("====paramsCmd:");
        stringBuilder1.append(paramString3);
        Log.d((String)SzztDebug.TAG, (String)("getSendCmd: " + stringBuilder1));
        stringBuilder1 = new StringBuilder();
        stringBuilder1.append(paramString1);
        stringBuilder1.append(paramString2);
        stringBuilder1.append(paramString3);
        paramString1 = stringBuilder1.toString();
        paramString2 = HexDump.getNVerifyCmd(Integer.toHexString(paramString1.length() / 2 + 1));
        String str = HexDump.flipsOfBit(paramString2);
        paramString3 = HexDump.getVerifyCode(paramString1, true);
        return "A6" + paramString2 + str + paramString1 + paramString3;
    }

    public static String getNVerifyCmd(String paramString) {
        if (paramString == null || paramString.length() <= 0) {
            return null;
        }
        String str = paramString;
        if (paramString.length() % 2 != 0) {
            str = "0" + paramString;
        }
        return str;
    }

    public static String flipsOfBit(String paramString) {
        String str = "";
        for (int i = 0; i < paramString.length(); ++i) {
            String str1 = Integer.toHexString(Integer.parseInt(paramString.substring(i, i + 1), 16) ^ 0xF);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(str);
            stringBuilder.append(str1);
            str = stringBuilder.toString();
        }
        return str;
    }

    public static String getVerifyCode(String paramString, boolean paramBoolean) {
        String str;
        int i = -1;
        i = paramBoolean ? Integer.parseInt("78", 16) : 0;
        paramString = HexDump.getNVerifyCmd(paramString);
        int j = 0;
        int k = i;
        for (i = j; i < paramString.length() / 2; ++i) {
            j = i * 2;
            k += Integer.parseInt(paramString.substring(j, j + 2), 16);
        }
        paramString = str = Integer.toHexString(k);
        if (str.length() > 2) {
            paramString = HexDump.getVerifyCode(str, false);
        }
        paramString = str = HexDump.getNVerifyCmd(paramString);
        if (paramBoolean) {
            paramString = HexDump.flipsOfBit(str);
        }
        return paramString;
    }
}

