/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.aofeng.hybrid.util.DevConfig;
import com.aofeng.hybrid.util.LogUtil;
import com.aofeng.hybrid.util.SSLClient;
import com.tencent.smtt.sdk.ValueCallback;
import com.tencent.smtt.sdk.WebView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONException;
import org.json.JSONObject;

public class CommUtil {
    public static boolean hasNetwork(Context context) {
        NetworkInfo[] nwis;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        for (NetworkInfo nwi : nwis = cm.getAllNetworkInfo()) {
            if (nwi.getState() != NetworkInfo.State.CONNECTED) continue;
            if (nwi.getType() == 1) {
                return true;
            }
            if (nwi.getType() != 0) continue;
            return true;
        }
        return false;
    }

    public static void savePreference(Context context, String appId, String key, String value) {
        SharedPreferences.Editor prefEditor = context.getSharedPreferences(appId, 0).edit();
        prefEditor.putString(key, value);
        prefEditor.commit();
    }

    public static String getPreference(Context context, String appId, String key) {
        return context.getSharedPreferences(appId, 0).getString(key, null);
    }

    public static String getFromAssets(Context context, String fileName) {
        StringBuilder Result = new StringBuilder();
        try {
            InputStreamReader inputReader = new InputStreamReader(context.getResources().getAssets().open(fileName));
            BufferedReader bufReader = new BufferedReader(inputReader);
            String line = "";
            while ((line = bufReader.readLine()) != null) {
                Result.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Result.toString();
    }

    public static int getVersionCode(Context context, String packageName) {
        try {
            PackageInfo manager = context.getPackageManager().getPackageInfo(packageName, 0);
            return manager.versionCode;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static HttpClient getTimeoutHttpClient() {
        BasicHttpParams httpParameters = new BasicHttpParams();
        int timeoutConnection = 30000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
        int timeoutSocket = 120000;
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
        return SSLClient.initHttpClient((HttpParams)httpParameters);
    }

    public static HttpClient getCardServiceHttpClient() {
        BasicHttpParams httpParameters = new BasicHttpParams();
        int timeoutConnection = 10000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
        int timeoutSocket = 50000;
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
        return SSLClient.initHttpClient((HttpParams)httpParameters);
    }

    public static HttpClient getClient() {
        BasicHttpParams httpParameters = new BasicHttpParams();
        int timeoutConnection = 3000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
        int timeoutSocket = 30000;
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
        return SSLClient.initHttpClient((HttpParams)httpParameters);
    }

    public static HttpClient getTimeClient(int timeoutConnection, int timeoutSocket) {
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)(timeoutConnection * 1000));
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)(timeoutSocket * 1000));
        return SSLClient.initHttpClient((HttpParams)httpParameters);
    }

    public static void evaluateJavascript(WebView mWebview, String script, ValueCallback<String> resultCallback) {
        if (DevConfig.isJsNative()) {
            mWebview.evaluateJavascript(script, resultCallback);
        } else {
            mWebview.loadUrl(script);
        }
    }

    public static void evaluateJavascript(WebView mWebview, String script) {
        if (script.lastIndexOf("javascript:") == -1) {
            Log.e((String)"evaluateJavascript", (String)"\u6ca1\u6709javascript,\u65e0\u6cd5\u6267\u884c,\u9875\u9762\u52a0\u8f7d\u8bf7\u4f7f\u7528loadUrl");
            return;
        }
        script = script.substring(script.lastIndexOf("javascript:"));
        if (DevConfig.isJsNative()) {
            mWebview.evaluateJavascript(script, (ValueCallback)new ValueCallback<String>(){

                public void onReceiveValue(String s) {
                    Log.d((String)"evaluateJavascript", (String)("onReceiveValue: " + s));
                }
            });
        } else {
            mWebview.loadUrl(script);
        }
    }

    public static String getFilePath(Context context) {
        return context.getFilesDir().getAbsolutePath() + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String path) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            String buf = "";
            while ((line = br.readLine()) != null) {
                if (buf.equals("")) {
                    buf = line;
                    continue;
                }
                buf = buf + "\n" + line;
            }
            String string2 = buf;
            return string2;
        }
        catch (Exception e) {
            LogUtil.d("CommUtil", "\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\u3002");
            String string3 = "";
            return string3;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    LogUtil.d("CommUtil", "\u5173\u95ed\u6587\u4ef6\u51fa\u9519\u3002");
                }
            }
        }
    }

    public static String getSharedPreference(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(context.getPackageName(), 0);
        return sp.getString(key, "");
    }

    public static void setSharedPreference(Context context, String key, String value) {
        SharedPreferences.Editor editor = context.getSharedPreferences(context.getPackageName(), 0).edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static void setSharedPreference(Context context, JSONObject jo) throws JSONException {
        SharedPreferences.Editor editor = context.getSharedPreferences(context.getPackageName(), 0).edit();
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (jo.isNull(key)) continue;
            editor.putString(key, jo.get(key) + "");
        }
        editor.commit();
    }

    public static void delSharedPreference(Context context, String key) {
        SharedPreferences.Editor editor = context.getSharedPreferences(context.getPackageName(), 0).edit();
        editor.remove(key);
        editor.commit();
    }

    public static int getVersionCode(Context context) {
        try {
            PackageInfo manager = context.getPackageManager().getPackageInfo(context.getApplicationInfo().packageName, 0);
            return manager.versionCode;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean hasConfig(Context context) {
        String path = context.getFilesDir().toString() + "/globals.txt";
        File config = new File(path);
        return config.exists();
    }

    public static boolean checkIP(String ip) {
        String rg = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        return ip.matches(rg);
    }

    public static JSONObject getHybridContext(Context ctx) throws JSONException {
        JSONObject jo = new JSONObject();
        SharedPreferences sp = ctx.getSharedPreferences(ctx.getPackageName(), 0);
        Map allEntries = sp.getAll();
        for (Map.Entry entry : allEntries.entrySet()) {
            String key = (String)entry.getKey();
            jo.put(key, entry.getValue());
        }
        return jo;
    }

    public static void notify(Context context, int notificationId, String title, String msg, boolean insistent, int smallIconId, int largeIconId, int soundId) {
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        Notification notification = builder.setContentTitle((CharSequence)title).setContentText((CharSequence)msg).setWhen(System.currentTimeMillis()).setSmallIcon(smallIconId).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeIconId)).build();
        notification.sound = Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + soundId));
        if (insistent) {
            notification.flags |= 4;
        }
        manager.notify(notificationId, notification);
    }

    public static int getId(String resourceName, Class<?> c) {
        try {
            Field idField = c.getDeclaredField(resourceName);
            return idField.getInt(idField);
        }
        catch (Exception e) {
            throw new RuntimeException("No resource ID found for: " + resourceName + " / " + c, e);
        }
    }
}

