/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;

public class CheckBluetooth {
    private static final String TAG = "CheckBluetooth";
    private static int mState = -1;
    public static final int STATE_DISABLE = -1;
    public static final int STATE_NONE = 0;
    public static final int STATE_LISTEN = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    public static final int DISCOVERY_FINISHED = 4;

    public CheckBluetooth(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action != null) {
                    block10 : switch (action) {
                        case "android.bluetooth.adapter.action.STATE_CHANGED": {
                            int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                            Log.d((String)CheckBluetooth.TAG, (String)("onReceive: blueState = " + blueState));
                            switch (blueState) {
                                case 10: 
                                case 13: {
                                    CheckBluetooth.this.setState(-1);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED": 
                        case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                            Log.d((String)CheckBluetooth.TAG, (String)("onReceive: action = " + action));
                            CheckBluetooth.this.setState(0);
                            break;
                        }
                        case "android.bluetooth.device.action.FOUND": 
                        case "android.bluetooth.adapter.action.DISCOVERY_STARTED": {
                            CheckBluetooth.this.setState(1);
                            break;
                        }
                        case "android.bluetooth.device.action.ACL_CONNECTED": {
                            CheckBluetooth.this.setState(3);
                            break;
                        }
                        case "android.bluetooth.adapter.action.DISCOVERY_FINISHED": {
                            CheckBluetooth.this.setState(4);
                            break;
                        }
                        case "android.bluetooth.device.action.BOND_STATE_CHANGED": {
                            int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", 0);
                            switch (bondState) {
                                case 12: {
                                    CheckBluetooth.this.setState(2);
                                    break block10;
                                }
                                case 11: {
                                    CheckBluetooth.this.setState(3);
                                    break block10;
                                }
                                case 10: {
                                    CheckBluetooth.this.setState(0);
                                    break block10;
                                }
                            }
                        }
                    }
                }
            }
        };
        context.registerReceiver(mReceiver, intentFilter);
    }

    public synchronized void setState(int state) {
        Log.d((String)TAG, (String)("setState() " + mState + " -> " + state));
        mState = state;
    }

    public static int getState() {
        return mState;
    }
}

