/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.HexDump;
import com.aofeng.hybrid.util.common.AndroidInfoTools;
import com.tencent.smtt.sdk.WebView;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@RequiresApi(api=18)
public class BluetoothTools {
    @SuppressLint(value={"StaticFieldLeak"})
    private static final BluetoothAdapter mBtAdapter = BluetoothAdapter.getDefaultAdapter();
    private static WebView webView;
    private static List<BluetoothDevice> bleDevices;
    private static BluetoothGatt mGatt;
    private static BluetoothGattCharacteristic WCharacter;
    private static BluetoothGattCharacteristic RCharacter;
    private static int type;
    private static final BluetoothAdapter.LeScanCallback mLeScanCallback;

    private static boolean checkPermission() {
        String[] promess = new String[]{"android.permission.BLUETOOTH", "android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_ADMIN"};
        if (ContextCompat.checkSelfPermission((Context)webView.getContext(), (String)"android.permission.BLUETOOTH") != 0 || ContextCompat.checkSelfPermission((Context)webView.getContext(), (String)"android.permission.BLUETOOTH_ADMIN") != 0 || ContextCompat.checkSelfPermission((Context)webView.getContext(), (String)"android.permission.BLUETOOTH_SCAN") != 0 || ContextCompat.checkSelfPermission((Context)webView.getContext(), (String)"android.permission.BLUETOOTH_CONNECT") != 0 || ContextCompat.checkSelfPermission((Context)webView.getContext(), (String)"android.permission.BLUETOOTH_ADVERTISE") != 0) {
            Log.d((String)"BluetoothTools", (String)"\u6ca1\u6709\u6743\u9650");
            ActivityCompat.requestPermissions((Activity)AndroidInfoTools.findActivity(webView.getContext()), (String[])promess, (int)1);
            return false;
        }
        return true;
    }

    public static void scanBle(WebView webView, boolean isScan, String uuid, long scanTime, int type) {
        BluetoothTools.type = type;
        if (!mBtAdapter.isEnabled() && BluetoothTools.checkPermission()) {
            mBtAdapter.enable();
        }
        while (!mBtAdapter.isEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.e((String)"BluetoothTools", (String)"ScanBluetooth : ", (Throwable)e);
            }
        }
        BluetoothTools.webView = webView;
        bleDevices = new ArrayList<BluetoothDevice>();
        if (isScan) {
            new Handler().postDelayed(() -> {
                if (BluetoothTools.checkPermission()) {
                    mBtAdapter.stopLeScan(mLeScanCallback);
                }
            }, scanTime * 1000L);
            UUID[] uuids = null;
            if (uuid != null) {
                String[] ids = uuid.split(",");
                uuids = new UUID[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    uuids[i] = UUID.fromString(ids[i]);
                }
            }
            mBtAdapter.startLeScan(uuids, mLeScanCallback);
        } else {
            mBtAdapter.stopLeScan(mLeScanCallback);
        }
    }

    public static void connectBle(String address, String WUUID, final String RUUID) {
        UUID[] ruuids;
        UUID[] wuuids;
        if (BluetoothTools.checkPermission()) {
            mBtAdapter.stopLeScan(mLeScanCallback);
        }
        if (WUUID.contains(",")) {
            String[] uuid = WUUID.split(",");
            wuuids = new UUID[uuid.length];
            for (int i = 0; i < uuid.length; ++i) {
                wuuids[i] = UUID.fromString(uuid[i]);
            }
        } else {
            wuuids = new UUID[]{UUID.fromString(WUUID)};
        }
        if (WUUID.contains(",")) {
            String[] uuid = RUUID.split(",");
            ruuids = new UUID[uuid.length];
            for (int i = 0; i < uuid.length; ++i) {
                ruuids[i] = UUID.fromString(uuid[i]);
            }
        } else {
            ruuids = new UUID[]{UUID.fromString(RUUID)};
        }
        BluetoothDevice mCurDevice = mBtAdapter.getRemoteDevice(address);
        if (mGatt == null) {
            mGatt = mCurDevice.connectGatt(webView.getContext(), false, new BluetoothGattCallback(){

                public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                    switch (newState) {
                        case 2: {
                            ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    CommUtil.evaluateJavascript(webView, String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "CONN", "\u84dd\u7259\u5df2\u8fde\u63a5"));
                                }
                            });
                            if (!BluetoothTools.checkPermission()) break;
                            gatt.discoverServices();
                            break;
                        }
                        case 0: {
                            ((Activity)webView.getContext()).runOnUiThread(() -> {
                                BluetoothTools.unconnectBle(webView);
                                CommUtil.evaluateJavascript(webView, String.format("javascript:HostApp.__bluetooth_clear_callback__(\"%s\",\"%s\");", "CONN", "\u84dd\u7259\u5df2\u65ad\u5f00"));
                            });
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                }

                public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                    if (status == 0) {
                        List bgss = gatt.getServices();
                        for (BluetoothGattService bgs : bgss) {
                            for (UUID uuid : wuuids) {
                                WCharacter = bgs.getCharacteristic(uuid);
                                if (WCharacter == null) continue;
                                Log.e((String)"BluetoothTools", (String)("WCharacter: " + WCharacter.getUuid()));
                                break;
                            }
                            if (WCharacter == null) continue;
                            Log.e((String)"BluetoothTools", (String)("WCharacter: " + WCharacter.getUuid()));
                            break;
                        }
                        if (RUUID != null) {
                            for (BluetoothGattService bgs : bgss) {
                                List descriptorList;
                                for (UUID uuid : ruuids) {
                                    RCharacter = bgs.getCharacteristic(uuid);
                                    if (RCharacter == null) continue;
                                    Log.e((String)"BluetoothTools", (String)("RCharacter: " + RCharacter.getUuid()));
                                    break;
                                }
                                if (RCharacter == null) continue;
                                Log.e((String)"BluetoothTools", (String)("RCharacter: " + RCharacter.getUuid()));
                                if (!BluetoothTools.checkPermission()) continue;
                                boolean isEnableNotification = gatt.setCharacteristicNotification(RCharacter, true);
                                if (!isEnableNotification || (descriptorList = RCharacter.getDescriptors()) == null || descriptorList.size() <= 0) break;
                                for (BluetoothGattDescriptor descriptor : descriptorList) {
                                    descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                                    gatt.writeDescriptor(descriptor);
                                }
                            }
                        }
                    }
                }

                public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                    String message = HexDump.toHexString(characteristic.getValue());
                    Log.e((String)"onCharacteristicWrite\u4e2d", (String)message);
                    if (status == 0) {
                        Log.e((String)"onCharacteristicWrite\u4e2d", (String)"\u53d1\u9001\u6210\u529f");
                        ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CommUtil.evaluateJavascript(webView, String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "WRITE", "\u53d1\u9001\u6210\u529f"));
                            }
                        });
                    } else if (status == 257) {
                        Log.e((String)"onCharacteristicWrite\u4e2d", (String)"\u53d1\u9001\u5931\u8d25");
                        ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CommUtil.evaluateJavascript(webView, String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "WRITE", "\u53d1\u9001\u5931\u8d25"));
                            }
                        });
                    } else if (status == 3) {
                        Log.e((String)"onCharacteristicWrite\u4e2d", (String)"\u65e0\u6743\u9650");
                        ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                CommUtil.evaluateJavascript(webView, String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "WRITE", "\u65e0\u6743\u9650"));
                            }
                        });
                    }
                }

                public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                    final String message = type == 1 ? new String(characteristic.getValue()) : HexDump.toHexString(characteristic.getValue());
                    Log.e((String)"onCharacteristicChanged", (String)message);
                    ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CommUtil.evaluateJavascript(webView, String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", "BACK", message));
                        }
                    });
                }
            });
        } else {
            mGatt.connect();
            mGatt.discoverServices();
        }
    }

    public static void wirteBle(String data) {
        if (type == 1) {
            WCharacter.setValue(data.getBytes(StandardCharsets.UTF_8));
        } else {
            WCharacter.setValue(HexDump.hexStringToByteArray(data));
        }
        if (BluetoothTools.checkPermission()) {
            mGatt.writeCharacteristic(WCharacter);
        }
    }

    public static void unconnectBle(WebView webView) {
        if (BluetoothTools.checkPermission() && mGatt != null) {
            mGatt.disconnect();
            mGatt.close();
            mGatt = null;
        }
    }

    static {
        type = 0;
        mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(final BluetoothDevice device, int rssi, byte[] scanRecord) {
                if (BluetoothTools.checkPermission() && !bleDevices.contains(device) && device.getName() != null) {
                    Log.e((String)"BluetoothTools", (String)("onLeScan: name = " + device.getName() + ", address = " + device.getAddress()));
                    bleDevices.add(device);
                    ((Activity)webView.getContext()).runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (BluetoothTools.checkPermission()) {
                                CommUtil.evaluateJavascript(webView, String.format("javascript:HostApp.__callback__(\"%s\",\"%s\");", device.getName(), device.getAddress()));
                            }
                        }
                    });
                }
            }
        };
    }
}

