/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.sync;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import com.aofeng.hybrid.pos.reader.CardAgent;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import com.aofeng.hybrid.util.common.AndroidInfoTools;
import com.centerm.smartpos.aidl.sys.IPackageInstallListener;
import com.centerm.smartpos.aidl.sys.IPackageUnInstallListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONObject;

public class SyncAPKHelper {
    private static Context context;
    private static IPackageInstallListener InstallListener;
    private static IPackageUnInstallListener unInstallListener;

    public static boolean CheckInstall(Context context, String packageName) {
        boolean checkResult = false;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            checkResult = packageInfo != null;
        }
        catch (Exception e) {
            checkResult = false;
        }
        return checkResult;
    }

    public static void downloadSignAPK(Context context, String filename) {
        CardAgent.log("downloadSignAPK filename = " + filename);
        try {
            SyncAPKHelper.context = context;
            JSONObject config = CommUtil.getHybridContext(context);
            String url = config.getString("cc_base_url");
            String fileDownloadUrl = url + "/" + filename;
            HttpClient client = CommUtil.getTimeoutHttpClient();
            HttpGet httpGet = new HttpGet(fileDownloadUrl);
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            String PATH = AndroidInfoTools.getSafecheckDirectory(context);
            File file = new File(PATH);
            file.mkdirs();
            File outputFile = new File(file, filename);
            String fileName = outputFile.getAbsolutePath();
            if (outputFile.exists()) {
                outputFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(outputFile);
            InputStream is = response.getEntity().getContent();
            byte[] buffer = new byte[1024];
            int len1 = 0;
            boolean n = false;
            while ((len1 = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len1);
            }
            fos.flush();
            fos.close();
            is.close();
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri uri = Uri.fromFile((File)new File(fileName));
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
            context.startActivity(intent);
            System.exit(-1);
        }
        catch (Exception e) {
            LogUtil.d("SyncAPKHelper", "loadContextByAssets  Assets not " + filename);
            LogUtil.d("SyncAPKHelper", "\u9519\u8bef " + e.getMessage());
        }
    }

    public static void downloadSignAPKBackground(Context context, String filename) {
        CardAgent.log("downloadSignAPK filename = " + filename);
        try {
            SyncAPKHelper.context = context;
            JSONObject config = CommUtil.getHybridContext(context);
            String url = config.getString("cc_base_url");
            String signPackageName = config.getString("signPackageName");
            String fileDownloadUrl = url + "/" + filename;
            HttpClient client = CommUtil.getTimeoutHttpClient();
            HttpGet httpGet = new HttpGet(fileDownloadUrl);
            HttpResponse response = client.execute((HttpUriRequest)httpGet);
            String PATH = AndroidInfoTools.getSafecheckDirectory(context);
            File file = new File(PATH);
            file.mkdirs();
            File outputFile = new File(file, filename);
            String fileName = outputFile.getAbsolutePath();
            if (outputFile.exists()) {
                outputFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(outputFile);
            InputStream is = response.getEntity().getContent();
            byte[] buffer = new byte[1024];
            int len1 = 0;
            boolean n = false;
            while ((len1 = is.read(buffer)) != -1) {
                fos.write(buffer, 0, len1);
            }
            fos.flush();
            fos.close();
            is.close();
            SyncAPKHelper.installBackground(fileName, signPackageName);
            System.exit(-1);
        }
        catch (Exception e) {
            LogUtil.d("SyncAPKHelper", "loadContextByAssets  Assets not " + filename);
            LogUtil.d("SyncAPKHelper", "\u9519\u8bef " + e.getMessage());
        }
    }

    public static void installBackground(String fileName, String signPackageName) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri uri = Uri.fromFile((File)new File(fileName));
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtil.d("SyncAPKHelper", "\u9519\u8bef " + e.getMessage());
        }
    }

    static {
        InstallListener = new IPackageInstallListener(){

            public void onInstallFinished() {
            }

            public void onInstallError(int i) throws RemoteException {
                LogUtil.d("SyncAPKHelper", "\u540e\u53f0\u5b89\u88c5\u5931\u8d25");
            }

            public IBinder asBinder() {
                return null;
            }
        };
        unInstallListener = new IPackageUnInstallListener(){

            public void onRemoveFinished() throws RemoteException {
            }

            public void onRemoveError(int i) throws RemoteException {
            }

            public IBinder asBinder() {
                return null;
            }
        };
    }
}

