/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.service;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import com.af.util.Pair;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.db.QueryExecutor;
import com.aofeng.hybrid.orm.DBMeta;
import com.aofeng.hybrid.orm.DatabaseManager;
import com.aofeng.hybrid.service.GenericService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class EntityService
extends GenericService {
    public static final String DIALECT_SQLSERVER = "SqlServer";
    public static final String DIALECT_ORACLE = "Oracle";
    public static final String COL_STRING = "STRING";
    public static final String COL_DATE = "DATE";
    public static final String COL_TIME = "TIME";
    public static final String COL_BOOLEAN = "BOOLEAN";
    public static final String COL_NUMBER = "NUMBER";
    public static final String COL_NOTSUPPORTED = "NOT_SUPPORTED";
    public static final String ID_GUID = "ID_GUID";
    public static final String ID_SEQ = "ID_SEQ";
    public static final String ID_AUTO = "ID_AUTO";
    public static final String ID_ASSIGNED = "ID_ASSIGNED";
    public static final String ID_FOREIGNER = "ID_FOREIGNER";
    public static HashMap<String, HashMap<String, Object>> metaMap;
    public static HashMap<String, String> entityLiftMap;

    public EntityService(Context context) {
        super(context);
        metaMap = DBMeta.getMeta(context);
        entityLiftMap = DBMeta.entityLiftMap;
    }

    private String findDialect() throws Exception {
        return this.context.getResources().getString(R.string.dialect);
    }

    public <T extends Serializable> T deepClone(T o) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(o);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        return (T)((Serializable)o.getClass().cast(in.readObject()));
    }

    private void enchanceMetaData(HashMap<String, Object> pmd, String entityName) throws Exception {
        HashMap<String, Object> md = metaMap.get(entityName);
        HashMap links = (HashMap)md.get("links");
        HashMap plinks = (HashMap)pmd.get("links");
        for (String key : links.keySet()) {
            plinks.put(key, this.deepClone((Pair)links.get(key)));
        }
        HashMap sub = md.containsKey("subclasses") ? (HashMap)md.get("subclasses") : new HashMap();
        HashMap psub = pmd.containsKey("subclasses") ? (HashMap)pmd.get("subclasses") : new HashMap();
        for (String key : sub.keySet()) {
            psub.put(key, this.deepClone((Pair)sub.get(key)));
        }
        HashMap inv = (HashMap)md.get("inverses");
        HashMap pinv = (HashMap)pmd.get("inverses");
        for (String key : inv.keySet()) {
            pinv.put(key, (String)inv.get(key));
        }
        HashMap invid = md.containsKey("inverseid") ? (HashMap)md.get("inverseid") : new HashMap();
        HashMap pinvid = pmd.containsKey("inverseid") ? (HashMap)pmd.get("inverseid") : new HashMap();
        for (String key : invid.keySet()) {
            pinvid.put(key, this.deepClone((Pair)invid.get(key)));
        }
    }

    public String partialSave(String entityName, JSONObject row) throws Exception {
        HashMap<String, Object> md;
        if (entityLiftMap.containsKey(entityName)) {
            String pEntityName = entityLiftMap.get(entityName);
            md = this.deepClone(metaMap.get(pEntityName));
            this.enchanceMetaData(md, entityName);
        } else {
            md = metaMap.get(entityName);
        }
        String dialect = this.findDialect();
        Serializable aid = this.partialSave(row, md, null, null, dialect);
        JSONObject result = new JSONObject();
        result.put((String)md.get("idName"), (Object)aid.toString());
        return result.toString();
    }

    public String partialSaveBackId(String entityName, JSONObject row) throws Exception {
        HashMap<String, Object> md;
        if (entityLiftMap.containsKey(entityName)) {
            String pEntityName = entityLiftMap.get(entityName);
            md = this.deepClone(metaMap.get(pEntityName));
            this.enchanceMetaData(md, entityName);
        } else {
            md = metaMap.get(entityName);
        }
        String dialect = this.findDialect();
        Serializable aid = this.partialSave(row, md, null, null, dialect);
        return aid.toString();
    }

    private Serializable partialSave(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect) throws Exception {
        int affectedRows;
        Object idValue = null;
        String idName = (String)md.get("idName");
        String idType = (String)md.get("idType");
        if (row.has(idName)) {
            idValue = row.get(idName);
        }
        HashMap columns = (HashMap)md.get("columns");
        HashMap links = (HashMap)md.get("links");
        boolean isInsert = false;
        if (idValue == null) {
            affectedRows = this.doInsert(row, md, pIdValue, pEntityName, dialect, idName, idType, columns);
        } else if (!md.get("idGenerator").equals(ID_ASSIGNED)) {
            isInsert = false;
            affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, dialect, idValue, idType, columns);
        } else if (this.hasKeyRow(dialect, (String)md.get("tableName"), (String)md.get("idColName"), idValue, idType)) {
            isInsert = false;
            affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, dialect, idValue, idType, columns);
        } else {
            isInsert = true;
            affectedRows = this.doInsert(row, md, pIdValue, pEntityName, dialect, idName, idType, columns);
        }
        if (affectedRows == 0) {
            Log.d((String)"EntityService", (String)"\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u5728\u5176\u4ed6\u5730\u65b9\u53ef\u80fd\u88ab\u4fee\u6539\u3002");
            throw new Exception("\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u5728\u5176\u4ed6\u5730\u65b9\u53ef\u80fd\u88ab\u4fee\u6539\u3002");
        }
        idValue = row.get(idName);
        if (isInsert) {
            row.remove(idName);
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr2 = (String)itr.next();
            if (!links.containsKey(attr2) || !row.has(attr2)) continue;
            Pair pair = (Pair)links.get(attr2);
            HashMap<String, Object> cmd = metaMap.get(pair.col);
            String cEntityName = (String)md.get("entityName");
            if (row.isNull(attr2)) {
                if (!pair.col.equals(attr2)) continue;
                this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), row.get(idName), idType);
                continue;
            }
            Object obj = row.get(attr2);
            if (obj instanceof JSONArray) {
                JSONArray rows = row.getJSONArray(attr2);
                for (int i = 0; i < rows.length(); ++i) {
                    this.partialSave(rows.getJSONObject(i), cmd, idValue, cEntityName, dialect);
                }
                continue;
            }
            this.partialSave((JSONObject)obj, cmd, idValue, cEntityName, dialect);
        }
        return (Serializable)idValue;
    }

    private void deleteOneToOne(String dialect, String tableName, String idCol, Object idValue, String idType) throws Exception {
        String sql = "delete from " + tableName + " where " + idCol + "=" + this.normalizeValue(dialect, idValue, idType);
        Log.d((String)"EntityService", (String)("\u4e00\u5bf9\u4e00\u5220\u9664sql:" + sql));
        this.SQLUpdate(sql);
    }

    private boolean hasKeyRow(final String dialect, final String tableName, final String idColName, final Object idValue, final String idType) throws Exception {
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                try (Cursor cursor = null;){
                    cursor = db.rawQuery("select 1 from " + tableName + " where " + idColName + "=" + EntityService.this.normalizeValue(dialect, idValue, idType), null);
                    boolean result = cursor.moveToNext();
                    Boolean bl = new Boolean(result);
                    return bl;
                }
            }
        });
        return (Boolean)obj;
    }

    private int doUpdate(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect, Object idValue, String idType, HashMap<String, Pair> columns) throws Exception {
        HashMap associations;
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        StringBuilder sb = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null && associations.containsKey(pEntityName)) {
            Pair pair = (Pair)associations.get(pEntityName);
            foreignkey = pair.col;
            sb.append(" " + foreignkey + "=" + this.normalizeValue(dialect, pIdValue, pair.type) + ", ");
        }
        if (verName != null) {
            sb.append(" " + verName + "=" + this.normalizeVer(dialect, verValue, verType) + ", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr2 = (String)itr.next();
            if (!columns.containsKey(attr2) || attr2.equals(foreignkey) || attr2.equals(verName)) continue;
            Pair pair = columns.get(attr2);
            sb.append(" " + pair.col + "=" + (row.isNull(attr2) ? "null, " : this.normalizeValue(dialect, row.get(attr2), pair.type) + ", "));
        }
        if (sb.length() == 0) {
            Log.d((String)"EntityService", (String)("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row.toString()));
            throw new Exception("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row.toString());
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.insert(0, "update " + md.get("tableName") + " set ");
        sb.append(" where " + md.get("idColName") + " = " + this.normalizeValue(dialect, idValue, idType));
        if (md.get("verName") != null) {
            sb.append(" and " + md.get("verColName") + "=" + this.normalizeValue(dialect, verValue, verType));
        }
        Log.d((String)"EntityService", (String)("\u751f\u6210\u7684\u66f4\u65b0sql: " + sb));
        int affectedRow = this.SQLUpdate(sb.toString());
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuffer buf = new StringBuffer();
                HashMap<String, Object> smd = metaMap.get(sentity);
                String keyAttr = (String)smd.get("idName");
                HashMap attrs = (HashMap)smd.get("columns");
                for (String attr3 : attrs.keySet()) {
                    if (attr3.equals(keyAttr) || !row.has(attr3)) continue;
                    p = (Pair)attrs.get(attr3);
                    buf.append(p.col + "=" + this.normalizeValue(dialect, row.isNull(attr3) ? null : row.get(attr3), p.type) + ", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.insert(0, "update " + smd.get("tableName") + " set ");
                buf.append(" where " + smd.get("idColName") + " = " + this.normalizeValue(dialect, idValue, idType));
                Log.d((String)"EntityService", (String)("\u751f\u6210\u7684\u5b50\u66f4\u65b0sql: " + buf));
                this.SQLUpdate(buf.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr4 = (String)itrLink.next();
                    if (pLinks.containsKey(attr4) || !links.containsKey(attr4) || !row.has(attr4)) continue;
                    Pair pair = (Pair)links.get(attr4);
                    HashMap<String, Object> cmd = metaMap.get(pair.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr4)) {
                        if (!pair.col.equals(attr4)) continue;
                        this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), idValue, idType);
                        continue;
                    }
                    Object obj = row.get(attr4);
                    if (obj instanceof JSONArray) {
                        JSONArray rows = row.getJSONArray(attr4);
                        for (int i = 0; i < rows.length(); ++i) {
                            this.partialSave(rows.getJSONObject(i), cmd, idValue, cEntityName, dialect);
                        }
                        continue;
                    }
                    this.partialSave((JSONObject)obj, cmd, idValue, cEntityName, dialect);
                }
                break block1;
            }
        }
        this.handleInverses(row, md, dialect);
        return affectedRow;
    }

    private void handleInverses(JSONObject row, HashMap<String, Object> md, String dialect) throws Exception {
        HashMap inverses = (HashMap)md.get("inverses");
        for (String inverse : inverses.keySet()) {
            Object arow;
            if (row.isNull(inverse) || !((arow = row.get(inverse)) instanceof JSONObject)) continue;
            HashMap<String, Object> amd = metaMap.get(inverses.get(inverse));
            this.partialSave((JSONObject)arow, amd, null, null, dialect);
        }
    }

    private int doInsert(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect, String idName, String idType, HashMap<String, Pair> columns) throws Exception {
        String aid;
        Pair pair;
        HashMap associations;
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        String idColName = (String)md.get("idColName");
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null) {
            for (String ass : associations.keySet()) {
                if (!ass.equals(pEntityName) && !this.hasParent(ass, pEntityName)) continue;
                pair = (Pair)associations.get(ass);
                foreignkey = pair.col;
                if (sbCols.indexOf(foreignkey + ",") != -1) continue;
                sbCols.append(foreignkey + ", ");
                sbValues.append(this.normalizeValue(dialect, pIdValue, pair.type) + ", ");
            }
        }
        if (verName != null) {
            sbCols.append(verName + ", ");
            sbValues.append(this.normalizeVer(dialect, verValue, verType) + ", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr2 = (String)itr.next();
            if (!columns.containsKey(attr2) || attr2.equals(foreignkey) || attr2.equals(verName)) continue;
            Pair pair2 = columns.get(attr2);
            sbCols.append(pair2.col + ", ");
            sbValues.append(row.isNull(attr2) ? "null, " : this.normalizeValue(dialect, row.get(attr2), pair2.type) + ", ");
        }
        String idStrategy = (String)md.get("idGenerator");
        if (idStrategy.equals(ID_GUID)) {
            sbCols.append(idColName + ", ");
            String guid = UUID.randomUUID().toString().replace("-", "");
            sbValues.append("'" + guid + "', ");
            row.put(idName, (Object)guid);
        } else if (idStrategy.equals(ID_SEQ)) {
            sbCols.append(idColName + ", ");
            aid = this.getLastSeqId((String)md.get("sequence"));
            sbValues.append("'" + aid + "', ");
            row.put(idName, (Object)aid);
        } else if (idStrategy.equals(ID_ASSIGNED)) {
            sbCols.append(idColName + ", ");
            sbValues.append(this.normalizeValue(dialect, row.get(idName), idType) + ", ");
            row.put(idName, row.get(idName));
        } else if (idStrategy.equals(ID_FOREIGNER)) {
            sbCols.append(idColName + ", ");
            aid = this.normalizeValue(dialect, pIdValue, idType);
            sbValues.append(aid + ", ");
            row.put(idName, (Object)aid);
        }
        if (md.containsKey("inverses")) {
            HashMap inverses = (HashMap)md.get("inverses");
            HashMap inversesid = (HashMap)md.get("inverseid");
            for (String inverse : inverses.keySet()) {
                if (row.isNull(inverse)) continue;
                Object arow = row.get(inverse);
                Log.d((String)"EntityService", (String)"\u53d1\u73b0\u591a\u5bf9\u4e00\u5c5e\u6027\u8d4b\u503c:");
                if (arow instanceof JSONObject) continue;
                Pair pair3 = (Pair)inversesid.get(inverse);
                sbCols.append(pair3.col + ", ");
                sbValues.append(this.normalizeValue(dialect, arow, pair3.type) + ", ");
                Log.d((String)"EntityService", (String)("\u53d1\u73b0\u591a\u5bf9\u4e00\u5c5e\u6027\u8d4b\u503c:\u5c5e\u6027:" + pair3.col + "\uff0c\u503c\uff1a" + arow));
            }
        }
        sbCols.delete(sbCols.length() - 2, sbCols.length());
        sbCols.insert(0, "insert into " + md.get("tableName") + " (");
        sbValues.delete(sbValues.length() - 2, sbValues.length());
        sbCols.append(") values (");
        sbCols.append((CharSequence)sbValues);
        sbCols.append(")");
        Log.d((String)"EntityService", (String)("\u751f\u6210\u7684\u63d2\u5165sql\uff1b" + sbCols));
        int affectedRows = 1;
        if (idStrategy.equals(ID_AUTO)) {
            pair = this.rawJdbcUpdate(sbCols.toString());
            row.put(idName, (Object)pair.type);
            affectedRows = Integer.parseInt(pair.col);
        } else {
            affectedRows = this.SQLUpdate(sbCols.toString());
        }
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuffer fields = new StringBuffer();
                StringBuffer vals = new StringBuffer();
                HashMap<String, Object> smd = metaMap.get(sentity);
                String keyCol = (String)smd.get("idColName");
                fields.append(keyCol + ", ");
                vals.append(this.normalizeValue(dialect, row.get(idName), idType) + ", ");
                HashMap attrs = (HashMap)smd.get("columns");
                for (Object attr3 : attrs.keySet()) {
                    if (!row.has((String)attr3)) continue;
                    p = (Pair)attrs.get(attr3);
                    fields.append(p.col + ", ");
                    vals.append(this.normalizeValue(dialect, row.isNull(attr3) ? null : row.get(attr3), p.type) + ", ");
                }
                if (smd.containsKey("inverseid")) {
                    HashMap lookup = (HashMap)smd.get("inverseid");
                    for (String property : lookup.keySet()) {
                        Pair pair4;
                        if (!row.has(property) || row.isNull(property)) continue;
                        Object obj = row.get(property);
                        if (obj instanceof JSONObject) {
                            pair4 = (Pair)lookup.get(property);
                            JSONObject record = (JSONObject)obj;
                            if (!record.has(pair4.col) || record.isNull(pair4.col)) continue;
                            fields.append(pair4.col + ", ");
                            vals.append(this.normalizeValue(dialect, record.get(pair4.col), pair4.type) + ", ");
                            continue;
                        }
                        pair4 = (Pair)lookup.get(property);
                        fields.append(pair4.col + ", ");
                        vals.append(this.normalizeValue(dialect, row.get(property), pair4.type) + ", ");
                    }
                }
                foreignkey = null;
                HashMap associations2 = (HashMap)md.get("associations");
                if (associations2 != null) {
                    for (String ass : associations2.keySet()) {
                        Pair pair5 = (Pair)associations2.get(ass);
                        foreignkey = pair5.col;
                        if (!attrs.containsKey(foreignkey) || pIdValue == null || fields.indexOf(foreignkey + ", ") != -1) continue;
                        fields.append(foreignkey + ", ");
                        vals.append(this.normalizeValue(dialect, pIdValue, pair5.type) + ", ");
                    }
                }
                fields.delete(fields.length() - 2, fields.length());
                vals.delete(vals.length() - 2, vals.length());
                fields.insert(0, "insert into " + smd.get("tableName") + " (");
                fields.append(") values (");
                fields.append(vals);
                fields.append(")");
                Log.d((String)"EntityService", (String)("\u751f\u6210\u7684\u5b50\u63d2\u5165sql: " + fields));
                this.SQLUpdate(fields.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr4 = (String)itrLink.next();
                    if (pLinks.containsKey(attr4) || !links.containsKey(attr4) || !row.has(attr4)) continue;
                    Pair pair6 = (Pair)links.get(attr4);
                    HashMap<String, Object> cmd = metaMap.get(pair6.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr4)) {
                        if (!pair6.col.equals(attr4)) continue;
                        this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), row.get(idName), idType);
                        continue;
                    }
                    Object obj = row.get(attr4);
                    if (obj instanceof JSONArray) {
                        JSONArray rows = row.getJSONArray(attr4);
                        for (int i = 0; i < rows.length(); ++i) {
                            this.partialSave(rows.getJSONObject(i), cmd, row.get(idName), cEntityName, dialect);
                        }
                        continue;
                    }
                    this.partialSave((JSONObject)obj, cmd, row.get(idName), cEntityName, dialect);
                }
                break block3;
            }
        }
        this.handleInverses(row, md, dialect);
        return affectedRows;
    }

    private boolean hasParent(String entity, String pEntityName) {
        if (entityLiftMap.containsKey(entity)) {
            return true;
        }
        while (entityLiftMap.containsKey(entity)) {
            String pEntity = entityLiftMap.get(entity);
            if (pEntity.equals(pEntityName)) {
                return true;
            }
            entity = pEntity;
        }
        return false;
    }

    private Pair rawJdbcUpdate(final String sql) throws Exception {
        final Pair pair = new Pair("", "");
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                db.execSQL(sql);
                SQLiteStatement statement = db.compileStatement("SELECT changes()");
                pair.col = statement.simpleQueryForLong() + "";
                statement = db.compileStatement("SELECT last_insert_rowid()");
                pair.type = statement.simpleQueryForLong() + "";
                return pair;
            }
        });
        return pair;
    }

    private int SQLUpdate(final String sql) throws Exception {
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                db.execSQL(sql);
                SQLiteStatement statement = db.compileStatement("SELECT changes()");
                return new Long(statement.simpleQueryForLong());
            }
        });
        return ((Long)obj).intValue();
    }

    private String getLastSeqId(String seq) throws Exception {
        throw new Exception("android\u7aef\u4e0d\u652f\u6301Sequence");
    }

    private String normalizeVer(String dialect, Object verValue, String verType) {
        if (verType.equals(COL_TIME)) {
            if (dialect.equals(DIALECT_ORACLE)) {
                return "current_timestamp";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + sdf.format(new Date()) + "'";
        }
        if (verValue == null) {
            return "1";
        }
        return Integer.parseInt(verValue + "") + 1 + "";
    }

    private String normalizeValue(String dialect, Object value, String valType) {
        if (value == null) {
            return "null";
        }
        if (valType.equals(COL_STRING)) {
            return "'" + value.toString().replace("'", "''") + "'";
        }
        if (valType.equals(COL_NUMBER)) {
            return value + "";
        }
        if (valType.equals(COL_BOOLEAN)) {
            if (dialect.equals(DIALECT_ORACLE)) {
                return "'" + ((Boolean)value != false ? "Y" : "N") + "'";
            }
            return (Boolean)value != false ? "1" : "0";
        }
        if (valType.equals(COL_DATE)) {
            return "'" + value + "'";
        }
        if (valType.equals(COL_TIME)) {
            return "'" + value + "'";
        }
        throw new RuntimeException("\u4f20\u9012\u6570\u636e\u7c7b\u578b\u51fa\u9519");
    }

    @Override
    public JSONObject action(JSONObject json) {
        JSONObject result = new JSONObject();
        try {
            result.put("code", 500);
            result.put("data", (Object)"\u4e0d\u53ef\u5904\u7406\u5f02\u5e38\u3002");
            String method = json.getString("method");
            if (method.equals("delete")) {
                int n = this.delete(json.getString("entity"), json.get("id") + "");
                result.put("code", 200);
                result.put("data", n);
                return result;
            }
            if (method.equals("save") || method.equals("saveBatch")) {
                Object obj = json.get("data");
                this.partialSave(json.getString("entity"), (JSONObject)obj);
                result.put("code", 200);
                result.put("data", obj);
                return result;
            }
            result.put("code", 500);
            result.put("data", (Object)"\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\u3002");
            return result;
        }
        catch (Exception e) {
            try {
                result.put("code", 500);
                result.put("data", (Object)e.getMessage());
                return result;
            }
            catch (Exception ex) {
                return result;
            }
        }
    }

    public int delete(final String entity, final String id2) throws Exception {
        Object obj = DatabaseManager.getInstance().executeQuery(new QueryExecutor(){

            @Override
            public Object run(SQLiteDatabase db) throws Exception {
                Map map = metaMap.get(entity);
                String idName = (String)map.get("idName");
                String idColName = (String)map.get("idColName");
                String idType = (String)map.get("idType");
                String idGenerator = (String)map.get("idGenerator");
                String tableName = (String)map.get("tableName");
                String criterion = idColName + "=" + EntityService.this.normalizeValue(EntityService.this.findDialect(), id2, idType);
                return new Integer(db.delete(tableName, criterion, new String[0]));
            }
        });
        return (Integer)obj;
    }

    public static String normalizeColType(String dialect, String type) {
        if (type.equals(COL_BOOLEAN)) {
            return dialect.equals(DIALECT_ORACLE) ? "INTEGER" : "TEXT";
        }
        if (type.equals(COL_NUMBER)) {
            return "INTEGER";
        }
        return "TEXT";
    }

    public static List<String> getChildName(String tableName) {
        ArrayList<String> childTable = new ArrayList<String>();
        if (metaMap.containsKey(tableName)) {
            HashMap<String, Object> map = metaMap.get(tableName);
            HashMap childmap = new HashMap();
            childmap = (HashMap)map.get("subclasses");
            if (childmap != null) {
                Set keys = childmap.keySet();
                Iterator iter = keys.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    childTable.add((String)iter.next());
                    ++i;
                }
            }
        }
        return childTable;
    }

    static {
        entityLiftMap = new HashMap();
    }
}

