/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.qinhua;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.widget.ImageView;
import android.widget.Toast;
import com.aofeng.hybrid.qinhua.Vault;
import com.aofeng.hybrid.util.common.AndroidInfoTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class Util {
    public static Calendar Login_Date;
    private static Calendar System_Date;
    public static long elapsedRealtime;
    private static int TIME;

    public static Calendar getSystem_Date() {
        if (System_Date == null) {
            System_Date = Calendar.getInstance();
        }
        long next = SystemClock.elapsedRealtime();
        System_Date.setTimeInMillis(next + elapsedRealtime);
        return System_Date;
    }

    public static void setSystem_Date(Calendar system_Date) {
        System_Date = system_Date;
    }

    public static void run() {
        Calendar sys = Util.getSystem_Date();
        sys.add(14, 1);
        Util.setSystem_Date(sys);
        System.out.println(Util.getSystem_Date().getTime());
    }

    public static void setSysDate(String sysdate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date d = formatter.parse(sysdate);
            System_Date = Calendar.getInstance();
            System_Date.setTime(d);
            Login_Date = Calendar.getInstance();
            Login_Date.setTime(d);
            elapsedRealtime = d.getTime() - SystemClock.elapsedRealtime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static String FormatSysDateToday(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(Util.getSystem_Date().getTime());
    }

    public static String FormatDateToday(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static String FormatDate(String format, long l) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date(l));
    }

    public static String FormatTime(String format, String dt) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date(dt));
    }

    public static String FormatTimeNow(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DBExists(Context context) {
        if (!Util.fileExists(context.getDatabasePath("safecheck.db"))) {
            Toast.makeText((Context)context, (CharSequence)"\u8bf7\u5148\u8fdb\u884c\u7cfb\u7edf\u8bbe\u7f6e\u3002", (int)1).show();
            return false;
        }
        try (SQLiteDatabase db = context.openOrCreateDatabase("safecheck.db", 0, null);){
            String sql = "select * from t_checkplan where 1=1";
            db.rawQuery(sql, null);
            sql = "select * from T_IC_SAFECHECK_PAPAER where 1=1";
            db.rawQuery(sql, null);
            sql = "select * from T_INSPECTION where 1=1";
            db.rawQuery(sql, null);
            sql = "select * from T_IC_SAFECHECK_HIDDEN where 1=1";
            db.rawQuery(sql, null);
        }
        return true;
    }

    public static boolean fileExists(File path) {
        return path.exists();
    }

    public static void deleteFiles(Context context, String uuid) {
        File file = new File(Util.getSharedPreference(context, "FileDir") + uuid + "_sign.png");
        file.delete();
        for (int i = 1; i < 8; ++i) {
            file = new File(Util.getSharedPreference(context, "FileDir") + uuid + "_" + i + ".jpg");
            file.delete();
        }
    }

    public static void ClearBit(Context context, int mask, String paperId) {
        SQLiteDatabase db = context.openOrCreateDatabase("safecheck.db", 0, null);
        String sql = "update T_IC_SAFECHECK_PAPAER set CONDITION=CAST (CAST (CONDITION as INTEGER) & " + ~mask + " as TEXT) where id=?";
        db.execSQL(sql, new Object[]{paperId});
        db.close();
    }

    public static void SetBit(Context context, int mask, String paperId) {
        if (mask == Vault.INSPECT_FLAG) {
            Util.ClearBit(context, Vault.DENIED_FLAG + Vault.NOANSWER_FLAG + Vault.UPLOAD_FLAG, paperId);
        } else if (mask == Vault.DENIED_FLAG) {
            Util.ClearBit(context, Vault.INSPECT_FLAG + Vault.NOANSWER_FLAG + Vault.UPLOAD_FLAG, paperId);
        } else if (mask == Vault.NOANSWER_FLAG) {
            Util.ClearBit(context, Vault.INSPECT_FLAG + Vault.DENIED_FLAG + Vault.UPLOAD_FLAG, paperId);
        } else if (mask == Vault.NOCHECK_FLAG) {
            Util.ClearBit(context, Vault.INSPECT_FLAG + Vault.DENIED_FLAG + Vault.UPLOAD_FLAG, paperId);
        }
        SQLiteDatabase db = context.openOrCreateDatabase("safecheck.db", 0, null);
        String sql = "update T_IC_SAFECHECK_PAPAER set CONDITION=CAST (CAST(CONDITION as INTEGER) | " + mask + "  as TEXT) where id=?";
        db.execSQL(sql, new Object[]{paperId});
        db.close();
    }

    public static void ClearCache(Context context, String uuid) {
        SQLiteDatabase db = context.openOrCreateDatabase("safecheck.db", 0, null);
        String sql = "delete from T_INP where id=?";
        db.execSQL(sql, new Object[]{uuid});
        sql = "delete from T_INP_LINE where id=?";
        db.execSQL(sql, new Object[]{uuid});
        db.close();
    }

    public static boolean IsCached(Context context, String uuid) {
        Boolean result = false;
        SQLiteDatabase db = context.openOrCreateDatabase("safecheck.db", 0, null);
        String sql = "select id from T_INP where id=?";
        Cursor c = db.rawQuery(sql, new String[]{uuid});
        result = c.moveToNext() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        db.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getRepairList(Context context) {
        ArrayList<String> list = new ArrayList<String>();
        try (SQLiteDatabase db = null;){
            db = context.openOrCreateDatabase("safecheck.db", 0, null);
            String sql = "select NAME from T_PARAMS where id=?";
            Cursor c = db.rawQuery(sql, new String[]{"\u5b89\u68c0\u7ef4\u4fee\u9009\u9879"});
            while (c.moveToNext()) {
                list.add(c.getString(0));
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    public static int getVersionCode(Context context) {
        try {
            PackageInfo manager = context.getPackageManager().getPackageInfo(Vault.packageName, 0);
            return manager.versionCode;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static String getSharedPreference(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(Vault.appID, 1);
        return sp.getString(key, "");
    }

    public static void setSharedPreference(Context context, String key, String value) {
        SharedPreferences.Editor editor = context.getSharedPreferences(Vault.appID, 1).edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static void deleteAllPics(Activity context) {
        File file = new File(Util.getSharedPreference((Context)context, "FileDir"));
        String[] files = file.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].toUpperCase().endsWith("JPG") && !files[i].toUpperCase().endsWith("PNG")) continue;
            File aFile = new File(file, files[i]);
            aFile.delete();
        }
    }

    public static void releaseBitmap(ImageView iv) {
        BitmapDrawable bd = (BitmapDrawable)iv.getDrawable();
        if (bd != null) {
            Bitmap bt = bd.getBitmap();
            if (bt != null && !bt.isRecycled()) {
                bt.recycle();
                Log.d((String)"\u91ca\u653e\u56fe\u7247\uff1a", (String)(iv.getId() + ""));
            }
            Object var2_2 = null;
        }
    }

    public static HttpClient getTimeoutHttpClient() {
        BasicHttpParams httpParameters = new BasicHttpParams();
        int timeoutConnection = 5000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)timeoutConnection);
        int timeoutSocket = 30000;
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)timeoutSocket);
        return new DefaultHttpClient((HttpParams)httpParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dbbackup(Context context) {
        AbstractInterruptibleChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            File dbFile = context.getDatabasePath("safecheck.db");
            File exportDir = new File(AndroidInfoTools.getSafecheckDirectory(context, "dbBackup"));
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            File backup = new File(exportDir, "CA_inspection_" + Util.getSharedPreference(context, Vault.USER_NAME) + "_" + Util.getSharedPreference(context, Vault.PASSWORD) + "_" + Util.FormatDate("yyyyMMddHHmmss", new Date().getTime()) + ".db");
            backup.createNewFile();
            inChannel = new FileInputStream(dbFile).getChannel();
            outChannel = new FileOutputStream(backup).getChannel();
            ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), (WritableByteChannel)((Object)outChannel));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getLocalBitmap(String url) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(url);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)fis);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Bitmap getBitmapThumbnail(String path, int width, int height) {
        Bitmap bitmap = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        opts.inSampleSize = Math.min((int)((float)opts.outHeight / (float)height), (int)((float)opts.outWidth / (float)width));
        opts.inJustDecodeBounds = false;
        bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)opts);
        return bitmap;
    }

    public static boolean isServiceRunning(Context context, String serviceName) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceName.equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBigScreen(Context context) {
        String carrier = Build.MANUFACTURER.toLowerCase();
        return "samsung".equals(carrier);
    }

    static {
        elapsedRealtime = -1L;
        TIME = 1000;
    }
}

