/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.qinhua;

import blesps.Hex;
import blesps.ReadCard;
import com.aofeng.hybrid.qinhua.BluetoothActivity;

public class Card {
    static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private BluetoothActivity context;
    public boolean isToolCard = false;
    public boolean isRF = false;
    public String cardPurpose = "\u672a\u77e5\u5361";
    public String cardNo = "";
    public String surplusGM = "";
    public String useGas = "";
    public String sellGM = "";
    public String sellCount = "";
    public String noUseDay = "";
    public boolean isClose = false;
    public String firstClose = "";
    public String secondClose = "";
    public boolean isHK = false;
    public boolean isSB = false;
    public String firstSB = "";
    public String secondSB = "";
    public String meterDT = "";
    public String kfTime = "";
    public String gfTime = "";
    public String mcGas = "";
    public String priceType = "";
    public String price = "";
    public String jtPriceOne = "";
    public String jtGasOne = "";
    public String jtPriceTwo = "";
    public String jtGasTwo = "";
    public String jtPriceThree = "";
    public boolean isModifyPrice = false;
    public String modifyPriceDate = "";
    public String newPrice = "";
    public String jtPriceOneNew = "";
    public String jtGasOneNew = "";
    public String jtPriceTwoNew = "";
    public String jtGasTwoNew = "";
    public String jtPriceThreeNew = "";
    public boolean isAllow = false;
    public String allowGas = "";
    public String meterState = "";
    public String monthGas = "";
    public String AJyear = "";
    public String AJday = "";
    public String BFyear = "";
    public String BFday = "";
    public String BJgas1 = "";
    public String BJgas2 = "";
    public String TZgas = "";
    public String lastTZgas = "";
    public String lastRepairDate = "";
    public String jtSumGas = "";
    public String strTemp = "";

    public Card(BluetoothActivity context) {
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object read102(byte[] bytes) throws Exception {
        int[] buf = this.complement(bytes);
        if (buf[12] == 15) {
            throw new Exception("\u5361\u574f\u3002");
        }
        if (this.foundToolCard(buf)) {
            this.isToolCard = true;
            return this;
        }
        this.cardNo = this.toHexStr(buf, 17, 4);
        if (this.cardNo.equals("FFFFFFFF")) {
            throw new Exception("\u7a7a\u767d\u5361\u3002");
        }
        String pass = this.getRemotePass(this.cardNo);
        int ret = this.context.mBluetoothUtils.cmp_scRW(1, pass);
        if (ret != 0) {
            throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
        }
        if (buf[2] == 170 || buf[2] == 165) {
            this.cardNo = this.toHexStr(buf, 16, 5);
            if (buf[21] == 6) {
                this.cardPurpose = "\u8d5b\u798f\u7528\u6237\u5361";
                int[] data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 2, 2));
                this.surplusGM = data[0] * 256 + data[1] + "";
                return this;
            } else if (buf[21] == 8) {
                this.cardPurpose = "\u6c11\u7528\u8fdc\u4f20\u7528\u6237\u5361";
                int[] data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 0, 30));
                this.surplusGM = data[1] == 165 || data[1] == 170 ? data[24] * 256 + data[25] + "" : "0";
                return this;
            } else {
                if (buf[21] != 9) throw new Exception("\u672a\u77e5\u7528\u6237\u5361\u3002");
                this.cardPurpose = "\u5de5\u4e1a\u8fdc\u4f20\u7528\u6237\u5361";
                int[] data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 0, 30));
                this.surplusGM = data[1] == 165 || data[1] == 170 ? data[14] * 256 * 256 + data[24] * 256 + data[25] + "" : "0";
            }
            return this;
        } else {
            int[] data;
            if (buf[21] != 2 && buf[21] != 12 || !this.toHexStr(buf, 2, 7).equals("1A584152514753")) throw new Exception("\u672a\u77e5\u5361\u3002");
            this.cardPurpose = "\u79e6\u6e2f\u7528\u6237\u5361";
            if (buf[21] == 2) {
                this.cardNo = "00" + this.cardNo;
            } else {
                if (buf[21] != 12) throw new Exception("\u672a\u77e5\u7528\u6237\u5361\u3002");
                data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 14, 2));
                this.cardNo = data[0] / 10 * 16 + "" + data[0] % 10 + this.cardNo;
            }
            data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 2, 2));
            if (data[0] != 44 && data[0] != 72) {
                this.surplusGM = "0";
                return this;
            } else {
                data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 6, 2));
                this.surplusGM = (this.transform(data[0]) * 256 + this.transform(data[1])) / 10 + "";
            }
        }
        return this;
    }

    private int transform(int b) {
        int mask1 = 128;
        int mask2 = 1;
        int dd = 0;
        for (int i = 0; i < 8; ++i) {
            if ((b & mask1) > 0) {
                dd += mask2;
            }
            mask1 >>= 1;
            mask2 <<= 1;
        }
        return dd;
    }

    private boolean foundToolCard(int[] buf) throws Exception {
        if (buf[2] == 87 && buf[21] == 6) {
            this.cardPurpose = "\u8d5b\u798f\u68c0\u6d4b\u5361";
            int ret = this.context.mBluetoothUtils.cmp_scRW(1, "5101");
            if (ret == 0) {
                int[] m_card = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 32, 30));
                this.cardNo = this.toHexStr(m_card, 15, 5);
                if (this.cardNo.startsWith("FFFFFFFF")) {
                    throw new Exception("\u7a7a\u767d\u8d5b\u798f\u68c0\u6d4b\u5361\u3002");
                }
                this.surplusGM = String.format("%d.%d", m_card[2] * 256 + m_card[1], m_card[0]);
                this.useGas = String.format("%d.%d", (long)m_card[6] * 256L * 256L + (long)m_card[5] * 256L + (long)m_card[4], m_card[3]);
                this.sellGM = String.format("%d.%d", (long)m_card[13] * 256L * 256L + (long)m_card[12] * 256L + (long)m_card[11], m_card[10]);
                this.sellCount = String.format("%d", m_card[14]);
                this.noUseDay = String.format("%d\u5929%d\u79d2", m_card[7], m_card[9] * 256 + m_card[8]);
                this.isClose = true;
                this.firstClose = String.format("%d", m_card[25]);
                this.secondClose = String.format("%d", m_card[26]);
                if (m_card[23] == 1) {
                    this.isHK = true;
                }
                if (m_card[24] == 1) {
                    this.isSB = true;
                }
                return true;
            }
            throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
        }
        if (buf[2] == 87 && buf[21] == 8) {
            this.cardPurpose = "\u6c11\u7528\u8fdc\u4f20\u68c0\u6d4b\u5361";
            int ret = this.context.mBluetoothUtils.cmp_scRW(1, "5101");
            if (ret == 0) {
                int[] m_card = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 32, 30));
                this.cardNo = this.toHexStr(m_card, 15, 5);
                if (this.cardNo.startsWith("FFFFFFFF")) {
                    throw new Exception("\u7a7a\u767d\u6c11\u7528\u8fdc\u4f20\u68c0\u6d4b\u5361\u3002");
                }
                this.surplusGM = String.format("%d", m_card[2] * 256 + m_card[1]);
                this.sellCount = String.format("%d", m_card[14]);
                m_card = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 60, 8));
                this.meterDT = String.format("20%02d-%02d-%02d %02d:%02d:%02d", m_card[1], m_card[2], m_card[3], m_card[4], m_card[5], m_card[6]);
                return true;
            }
            throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
        }
        if (buf[2] == 87 && buf[21] == 9) {
            this.cardPurpose = "\u5de5\u4e1a\u8fdc\u4f20\u68c0\u6d4b\u5361";
            int ret = this.context.mBluetoothUtils.cmp_scRW(1, "6080");
            if (ret == 0) {
                int[] m_card = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 32, 30));
                this.cardNo = this.toHexStr(m_card, 15, 5);
                if (this.cardNo.startsWith("FFFFFFFF")) {
                    throw new Exception("\u7a7a\u767d\u5de5\u4e1a\u8fdc\u4f20\u68c0\u6d4b\u5361\u3002");
                }
                int[] buffer = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 64, 8));
                this.surplusGM = String.format("%d", buffer[6] * 256 * 256 + m_card[2] * 256 + m_card[1]);
                this.sellCount = String.format("%d", m_card[14]);
                m_card = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 60, 8));
                this.meterDT = String.format("20%02d-%02d-%02d %02d:%02d:%02d", m_card[1], m_card[2], m_card[3], m_card[4], m_card[5], m_card[6]);
                buffer = this.complement(this.context.mBluetoothUtils.rd_datRW(0, 78, 8));
                this.kfTime = String.format("%02d", buffer[0]);
                this.gfTime = String.format("%02d", buffer[1]);
                this.mcGas = String.format("%02d", buffer[2]);
                return true;
            }
            throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
        }
        if (buf[2] == 85 && (buf[21] == 2 || buf[21] == 12)) {
            this.cardPurpose = "\u79e6\u6e2f\u68c0\u6d4b\u5361";
            int ret = this.context.mBluetoothUtils.cmp_scRW(1, "4840");
            if (ret == 0) {
                int[] data;
                this.cardNo = this.toHexStr(buf, 17, 4);
                if (this.cardNo.equals("FFFFFFFF")) {
                    throw new Exception("\u7a7a\u767d\u79e6\u6e2f\u68c0\u6d4b\u5361\u3002");
                }
                if (buf[21] == 2) {
                    this.cardNo = "00" + this.cardNo;
                } else if (buf[21] == 12) {
                    data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 14, 2));
                    this.cardNo = data[0] / 10 * 16 + "" + data[0] % 10 + this.cardNo;
                } else {
                    throw new Exception("\u672a\u77e5\u5361\u3002");
                }
                data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 2, 2));
                if (data[0] != 44 && data[0] != 72) {
                    this.surplusGM = "0";
                } else {
                    data = this.complement(this.context.mBluetoothUtils.rd_datRW(1, 6, 2));
                    this.surplusGM = (this.transform(data[0]) * 256 + this.transform(data[1])) / 10 + "";
                }
                return true;
            }
            throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
        }
        return false;
    }

    public Object readRF() throws Exception {
        this.isRF = true;
        ReadCard readCard = new ReadCard();
        this.rwSendData("00a40000023f01", 11, readCard);
        this.rwSendData("00a40000020021", 11, readCard);
        this.rwSendData("00b000000c", 9, readCard);
        byte[] byRecv = new byte[512];
        int int1 = 0;
        int int2 = 0;
        if (readCard.byRecv[15] == 34) {
            Double double1;
            this.cardNo = Hex.intToHexString((int)(readCard.byRecv[4] & 0xFF)) + Hex.intToHexString((int)(readCard.byRecv[5] & 0xFF)) + Hex.intToHexString((int)(readCard.byRecv[6] & 0xFF)) + Hex.intToHexString((int)(readCard.byRecv[7] & 0xFF)) + Hex.intToHexString((int)(readCard.byRecv[8] & 0xFF));
            this.rwSendData("00b0840003", 9, readCard);
            if ((readCard.byRecv[4] & 0xFF) == 129) {
                this.cardPurpose = "\u5f00\u6237\u5361";
            } else if ((readCard.byRecv[4] & 0xFF) == 1) {
                this.cardPurpose = "\u8865\u5361";
            } else if ((readCard.byRecv[4] & 0xFF) == 0) {
                this.cardPurpose = "\u8d2d\u6c14\u5361";
            }
            this.sellCount = (readCard.byRecv[6] & 0xFF) % 256 + "";
            try {
                this.rwSendData("805c000204", 9, readCard);
            }
            catch (Exception ex) {
                this.rwSendData("00b2011404", 9, readCard);
            }
            if ((readCard.byRecv[4] & 0x80) != 0) {
                readCard.byRecv[4] = ~readCard.byRecv[4];
                readCard.byRecv[5] = ~readCard.byRecv[5];
                readCard.byRecv[6] = ~readCard.byRecv[6];
                double1 = (double)((readCard.byRecv[4] & 0xFF) * 256 * 256 + (readCard.byRecv[5] & 0xFF) * 256 + (readCard.byRecv[6] & 0xFF)) + (double)(readCard.byRecv[7] & 0xFF) / 100.0;
                double1 = -double1.doubleValue();
            } else {
                double1 = (double)((readCard.byRecv[4] & 0xFF) * 256 * 256 + (readCard.byRecv[5] & 0xFF) * 256 + (readCard.byRecv[6] & 0xFF)) + (double)(readCard.byRecv[7] & 0xFF) / 100.0;
            }
            this.surplusGM = String.format("%.02f", double1);
            this.rwSendData("00a40000020007", 11, readCard);
            this.rwSendData("00b0000028", 9, readCard);
            int1 = readCard.intRecv - 7;
            System.arraycopy(readCard.byRecv, 4, byRecv, 0, int1);
            this.rwSendData("00b0002828", 9, readCard);
            int2 = readCard.intRecv - 7;
            System.arraycopy(readCard.byRecv, 4, byRecv, int1, int2);
            if (byRecv[7] == 0) {
                this.priceType = "\u666e\u901a\u5355\u4ef7";
                this.price = String.format("%d.%02d", byRecv[8], byRecv[9]);
                if (byRecv[20] == 1) {
                    this.isModifyPrice = true;
                    this.modifyPriceDate = String.format("20%02d-%02d-%02d %02d:%02d:%02d", byRecv[21], byRecv[22], byRecv[23], byRecv[24], byRecv[25], byRecv[26]);
                    this.newPrice = String.format("%d.%02d", byRecv[27], byRecv[28]);
                }
            } else if (byRecv[7] == 1) {
                this.priceType = "\u9636\u68af\u5355\u4ef7";
                this.jtPriceOne = String.format("%d.%02d", byRecv[8], byRecv[9]);
                this.jtGasOne = String.format("%d", byRecv[10] * 256 * 256 + byRecv[11] * 256 + byRecv[12]);
                this.jtPriceTwo = String.format("%d.%02d", byRecv[13], byRecv[14]);
                this.jtGasTwo = String.format("%d", byRecv[15] * 256 * 256 + byRecv[16] * 256 + byRecv[17]);
                this.jtPriceThree = String.format("%d.%02d", byRecv[18], byRecv[19]);
                if (byRecv[20] == 1) {
                    this.isModifyPrice = true;
                    this.modifyPriceDate = String.format("20%02d-%02d-%02d %02d:%02d:%02d", byRecv[21], byRecv[22], byRecv[23], byRecv[24], byRecv[25], byRecv[26]);
                    this.jtPriceOneNew = String.format("%d.%02d", byRecv[27], byRecv[28]);
                    this.jtGasOneNew = String.format("%d", byRecv[29] * 256 * 256 + byRecv[30] * 256 + byRecv[31]);
                    this.jtPriceTwoNew = String.format("%d.%02d", byRecv[32], byRecv[33]);
                    this.jtGasTwoNew = String.format("%d", byRecv[34] * 256 * 256 + byRecv[35] * 256 + byRecv[36]);
                    this.jtPriceThreeNew = String.format("%d.%02d", byRecv[37], byRecv[38]);
                }
            }
            this.rwSendData("00b088000F", 9, readCard);
            if (readCard.byRecv[4] == 1) {
                this.isClose = true;
                this.firstClose = String.format("%d", readCard.byRecv[5]);
                this.secondClose = String.format("%d", readCard.byRecv[6]);
            }
            if (readCard.byRecv[7] == 9) {
                this.isAllow = true;
                this.allowGas = String.format("%d", readCard.byRecv[14] * 256 + readCard.byRecv[15]);
            }
            if (readCard.byRecv[7] == 1) {
                this.isAllow = true;
                this.allowGas = String.format("%d", readCard.byRecv[8] * 256 * 256 + readCard.byRecv[9] * 256 + readCard.byRecv[10]);
            }
        } else if (readCard.byRecv[15] == 7) {
            this.cardPurpose = "\u68c0\u6d4b\u5361";
            this.isToolCard = true;
            this.readMeterData(byRecv, int1, int2, readCard);
        } else {
            throw new Exception("\u672a\u77e5\u5361\u3002");
        }
        return this;
    }

    private String DefineChange(int ch1, int ch2) {
        String temp4 = "";
        if ((ch1 & 1) > 0) {
            temp4 = temp4 + "\u65e0\u6c14\u91cf-";
        }
        if ((ch1 & 2) > 0) {
            temp4 = temp4 + "\u5b89\u68c0-";
        }
        if ((ch1 & 4) > 0) {
            temp4 = temp4 + "\u5916\u7f6e\u7535\u6c60\u6389\u7535-";
        }
        if ((ch1 & 8) > 0) {
            temp4 = temp4 + "\u8fc7\u6d41-";
        }
        if ((ch1 & 0x10) > 0) {
            temp4 = temp4 + "\u6b7b\u88682-";
        }
        if ((ch1 & 0x20) > 0) {
            temp4 = temp4 + "\u6b7b\u88681\u540e\u5f00\u9600-";
        }
        if ((ch1 & 0x40) > 0) {
            temp4 = temp4 + "\u6b7b\u88681-";
        }
        if ((ch1 & 0x80) > 0) {
            temp4 = temp4 + "\u6cc4\u9732-";
        }
        if ((ch2 & 1) > 0) {
            temp4 = temp4 + "\u5173\u9600";
        }
        if ((ch2 & 4) > 0) {
            temp4 = temp4 + "\u5916\u7f6e\u7535\u6c60\u4f4e\u7535";
        }
        if ((ch2 & 8) > 0) {
            temp4 = temp4 + "\u78c1\u5e72\u6270";
        }
        if ((ch2 & 0x20) > 0) {
            temp4 = temp4 + "\u5185\u7f6e\u7535\u6c60\u4f4e\u7535";
        }
        if ((ch2 & 0x80) > 0) {
            temp4 = temp4 + "\u6b20\u91cf";
        }
        if (temp4 == "") {
            temp4 = temp4 + "\u6b63\u5e38";
        }
        return temp4;
    }

    private void readMeterData(byte[] byRecv, int int1, int int2, ReadCard readCard) throws Exception {
        int i;
        this.rwSendData("00a40000020003", 11, readCard);
        this.rwSendData("00b0000030", 11, readCard);
        int1 = readCard.intRecv - 7;
        System.arraycopy(readCard.byRecv, 4, byRecv, 0, int1);
        this.rwSendData("00b000302E", 11, readCard);
        int2 = readCard.intRecv - 7;
        System.arraycopy(readCard.byRecv, 4, byRecv, int1, int2);
        this.rwSendData("00b0005E32", 11, readCard);
        int1 += int2;
        int2 = readCard.intRecv - 7;
        System.arraycopy(readCard.byRecv, 4, byRecv, int1, int2);
        this.rwSendData("00b0009029", 11, readCard);
        int1 += int2;
        int2 = readCard.intRecv - 7;
        System.arraycopy(readCard.byRecv, 4, byRecv, int1, int2);
        if ((byRecv[5] & 0x80) > 0) {
            byRecv[5] = ~byRecv[5];
            byRecv[6] = ~byRecv[6];
            byRecv[7] = ~byRecv[7];
            this.surplusGM = String.format("%d.%02d", byRecv[5] * 256 * 256 + byRecv[6] * 256 + byRecv[7], byRecv[8]);
        } else {
            this.surplusGM = String.format("%d.%02d", byRecv[5] * 256 * 256 + byRecv[6] * 256 + byRecv[7], byRecv[8]);
        }
        this.useGas = String.format("%d.%02d", byRecv[9] * 256 * 256 + byRecv[10] * 256 + byRecv[11], byRecv[12]);
        this.sellGM = String.format("%d.%02d", byRecv[13] * 256 * 256 + byRecv[14] * 256 + byRecv[15], byRecv[16]);
        this.sellCount = String.format("%d", byRecv[17]);
        this.price = String.format("%d.%02d", byRecv[18], byRecv[19]);
        this.meterDT = String.format("20%02d-%02d-%02d %02d:%02d:%02d", byRecv[20], byRecv[21], byRecv[22], byRecv[23], byRecv[24], byRecv[25]);
        this.noUseDay = String.format("%d\u5929%d\u79d2", byRecv[26], byRecv[27] * 256 + byRecv[28]);
        if (byRecv[29] == 1) {
            this.isSB = true;
            this.firstSB = String.format("%d", byRecv[30]);
            this.secondSB = String.format("%d", byRecv[31]);
        }
        if (byRecv[32] == 1) {
            this.isAllow = true;
            this.allowGas = String.format("%d", byRecv[33] * 256 * 256 + byRecv[34] * 256 + byRecv[35]);
        }
        this.cardNo = String.format("%02x%02x%02x%02x%02x", byRecv[36], byRecv[37], byRecv[38], byRecv[39], byRecv[40]);
        this.meterState = this.DefineChange(byRecv[41] & 0xFF, byRecv[42] & 0xFF);
        if (byRecv[43] == 1) {
            this.isHK = true;
        }
        if (byRecv[46] <= 1 && byRecv[47] < 50) {
            this.NPricePara(byRecv);
        } else if (byRecv[45] == 0) {
            this.priceType = "\u666e\u901a\u5355\u4ef7";
            this.price = String.format("%d.%02d", byRecv[46], byRecv[47]);
            if (byRecv[58] == 1) {
                this.isModifyPrice = true;
                this.modifyPriceDate = String.format("20%02d-%02d-%02d %02d:%02d:%02d", byRecv[59], byRecv[60], byRecv[61], byRecv[62], byRecv[63], byRecv[64]);
                this.newPrice = String.format("%d.%02d", byRecv[65], byRecv[66]);
            }
        } else if (byRecv[45] == 1) {
            this.priceType = "\u9636\u68af\u5355\u4ef7";
            this.jtPriceOne = String.format("%d.%02d", byRecv[46], byRecv[47]);
            this.jtGasOne = String.format("%d", byRecv[48] * 256 * 256 + byRecv[49] * 256 + byRecv[50]);
            this.jtPriceTwo = String.format("%d.%02d", byRecv[51], byRecv[52]);
            this.jtGasTwo = String.format("%d", byRecv[53] * 256 * 256 + byRecv[54] * 256 + byRecv[55]);
            this.jtPriceThree = String.format("%d.%02d", byRecv[56], byRecv[57]);
            if (byRecv[58] == 1) {
                this.isModifyPrice = true;
                this.modifyPriceDate = String.format("20%02d-%02d-%02d %02d:%02d:%02d", byRecv[59], byRecv[60], byRecv[61], byRecv[62], byRecv[63], byRecv[64]);
                this.jtPriceOneNew = String.format("%d.%02d", byRecv[65], byRecv[66]);
                this.jtGasOneNew = String.format("%d", byRecv[67] * 256 * 256 + byRecv[68] * 256 + byRecv[69]);
                this.jtPriceTwoNew = String.format("%d.%02d", byRecv[70], byRecv[71]);
                this.jtGasTwoNew = String.format("%d", byRecv[72] * 256 * 256 + byRecv[73] * 256 + byRecv[74]);
                this.jtPriceThreeNew = String.format("%d.%02d", byRecv[75], byRecv[76]);
            }
            this.monthGas = String.format("%d.%02d", byRecv[77] * 256 * 256 + byRecv[78] * 256 + byRecv[79], byRecv[80]);
        }
        this.rwSendData("00a40000020005", 11, readCard);
        this.rwSendData("00b0000031", 11, readCard);
        int1 = readCard.intRecv - 7;
        System.arraycopy(readCard.byRecv, 4, byRecv, 0, int1);
        this.rwSendData("00b0003132", 11, readCard);
        int2 = readCard.intRecv - 7;
        System.arraycopy(readCard.byRecv, 4, byRecv, int1, int2);
        this.strTemp = String.format("\u7d2f\u8ba1\u6d88\u8017\u91cf\u6240\u5c5e\u6708\u4efd: %02d\u5e74%02d\u6708\r\n", byRecv[96], byRecv[97]);
        for (i = 0; i < 24; ++i) {
            this.strTemp = this.strTemp + String.format("\u7d2f\u8ba1\u6d88\u8017\u91cf%d:%d.%02d\r\n", i + 1, byRecv[i * 4] * 256 * 256 + byRecv[i * 4 + 1] * 256 + byRecv[i * 4 + 2], byRecv[i * 4 + 3]);
        }
        if (byRecv[98] != 0 && byRecv[98] != 255) {
            this.rwSendData(String.format("00b00063%02x", 48), 11, readCard);
            int1 = readCard.intRecv - 7;
            System.arraycopy(readCard.byRecv, 4, byRecv, 0, int1);
            this.rwSendData(String.format("00b00093%02x", 46), 11, readCard);
            int2 = readCard.intRecv - 7;
            System.arraycopy(readCard.byRecv, 4, byRecv, int1, int2);
            for (i = 0; i < byRecv[98] && (byRecv[i * 6] != 0 || byRecv[i * 6 + 1] != 0 || byRecv[i * 6 + 2] != 0); ++i) {
                this.strTemp = this.strTemp + String.format("\u5b89\u68c0\u5361\u4fe1\u606f%d: %x%02x%02x  %02d\u5e74%02d\u6708%02d\u65e5\r\n", i + 1, byRecv[i * 6], byRecv[i * 6 + 1], byRecv[i * 6 + 2], byRecv[i * 6 + 3], byRecv[i * 6 + 4], byRecv[i * 6 + 5]);
            }
            this.AJday = String.format("%d", byRecv[90] * 256 + byRecv[91]);
            this.BFday = String.format("%d", byRecv[92] * 256 + byRecv[93]);
        }
        this.rwSendData("00b085C112", 11, readCard);
        if (readCard.byRecv[4] == 170 && readCard.byRecv[5] == 85) {
            this.AJyear = String.format("%d", readCard.byRecv[7]);
            this.BFyear = String.format("%d", readCard.byRecv[8]);
            this.BJgas1 = String.format("%d", readCard.byRecv[9]);
            this.BJgas2 = String.format("%d", readCard.byRecv[10]);
            this.TZgas = String.format("%d.%02d", readCard.byRecv[11] * 256 * 256 + readCard.byRecv[12] * 256 + readCard.byRecv[13], readCard.byRecv[14]);
            this.lastTZgas = String.format("%d.%02d", readCard.byRecv[15] * 256 * 256 + readCard.byRecv[16] * 256 + readCard.byRecv[17], readCard.byRecv[18]);
            this.lastRepairDate = String.format("%d-%d-%d", readCard.byRecv[19], readCard.byRecv[20], readCard.byRecv[21]);
        }
    }

    private void NPricePara(byte[] buf) {
        if (buf[51] < 12) {
            buf[51] = 12;
        }
        if (buf[45] == 0) {
            this.priceType = "\u666e\u901a\u5355\u4ef7";
            this.price = String.format("%d.%02d", buf[77], buf[78]);
            if (buf[46] == 1) {
                this.isModifyPrice = true;
                this.modifyPriceDate = String.format("%02d-%02d-%02d %02d", buf[47], buf[48], buf[49], buf[50]);
                this.newPrice = String.format("%d.%02d", buf[89], buf[90]);
            }
        } else {
            this.priceType = "\u9636\u68af\u5355\u4ef7";
            this.jtPriceOne = String.format("%d.%02d", buf[53 + buf[51] * 2], buf[54 + buf[51] * 2]);
            this.jtGasOne = String.format("%d", buf[55 + buf[51] * 2] * 256 * 256 + buf[56 + buf[51] * 2] * 256 + buf[57 + buf[51] * 2]);
            this.jtPriceTwo = String.format("%d.%02d", buf[58 + buf[51] * 2], buf[59 + buf[51] * 2]);
            this.jtGasTwo = String.format("%d", buf[60 + buf[51] * 2] * 256 * 256 + buf[61 + buf[51] * 2] * 256 + buf[62 + buf[51] * 2]);
            this.jtPriceThree = String.format("%d.%02d", buf[63 + buf[51] * 2], buf[64 + buf[51] * 2]);
            if (buf[46] == 1) {
                this.isModifyPrice = true;
                this.modifyPriceDate = String.format("%02d-%02d-%02d %02d", buf[47], buf[48], buf[49], buf[50]);
                this.jtPriceOneNew = String.format("%d.%02d", buf[65 + buf[51] * 2], buf[66 + buf[51] * 2]);
                this.jtGasOneNew = String.format("%d", buf[67 + buf[51] * 2] * 256 * 256 + buf[68 + buf[51] * 2] * 256 + buf[69 + buf[51] * 2]);
                this.jtPriceTwoNew = String.format("%d.%02d", buf[70 + buf[51] * 2], buf[71 + buf[51] * 2]);
                this.jtGasTwoNew = String.format("%d", buf[72 + buf[51] * 2] * 256 * 256 + buf[73 + buf[51] * 2] * 256 + buf[74 + buf[51] * 2]);
                this.jtPriceThreeNew = String.format("%d.%02d", buf[75 + buf[51] * 2], buf[76 + buf[51] * 2]);
            }
            this.jtSumGas = String.format("%d.%02d", buf[53 + buf[51] * 2 + buf[52 + buf[51] * 2] * 24] * 256 * 256 + buf[54 + buf[51] * 2 + buf[52 + buf[51] * 2] * 24] * 256 + buf[55 + buf[51] * 2 + buf[52 + buf[51] * 2] * 24], buf[56 + buf[51] * 2 + buf[52 + buf[51] * 2] * 24]);
        }
    }

    private void rwSendData(String strDataString, int len, ReadCard readCard) throws Exception {
        Thread.sleep(50L);
        byte[] byTemp = new byte[64];
        byTemp = Hex.HexStringBytes((String)strDataString);
        byte[] by = new byte[byTemp.length + 4];
        by[0] = (byte)(byTemp.length + 2);
        by[1] = 6;
        by[2] = 2;
        System.arraycopy(byTemp, 0, by, 3, byTemp.length);
        byte re = 0;
        for (int i = 0; i < byTemp.length + 3; ++i) {
            re = (byte)(re + by[i]);
        }
        by[byTemp.length + 3] = re;
        int ret = -1;
        for (int i = 0; i < 3; ++i) {
            ret = this.context.mBluetoothUtils.onwrite2(by);
            if (ret != 0) {
                throw new Exception("\u84dd\u7259\u4ea4\u4e92\u9519\u8bef\u3002");
            }
            ret = this.context.mBluetoothUtils.checkdata2(readCard, len);
            if (ret == 0) break;
        }
        if (ret != 0) {
            throw new Exception("\u8bfb\u53d6\u6570\u636e\u51fa\u9519\u3002");
        }
    }

    public Object makeCard(byte[] bytes, Object[] params) throws Exception {
        int[] buf = this.complement(bytes);
        int ret = 0;
        if (buf[2] == 87 && buf[21] == 6) {
            ret = this.context.mBluetoothUtils.cmp_scRW(1, "5101");
            if (ret != 0) {
                throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
            }
        } else if (buf[2] == 87 && buf[21] == 8) {
            ret = this.context.mBluetoothUtils.cmp_scRW(1, "5101");
            if (ret != 0) {
                throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
            }
        } else if (buf[2] == 87 && buf[21] == 9) {
            ret = this.context.mBluetoothUtils.cmp_scRW(1, "6080");
            if (ret != 0) {
                throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
            }
        } else if (buf[2] == 85 && buf[21] == 2) {
            ret = this.context.mBluetoothUtils.cmp_scRW(1, "4840");
            if (ret != 0) {
                throw new Exception("\u5bc6\u7801\u6821\u9a8c\u9519\u8bef\u3002");
            }
        } else if ("FFFFFFFF".equals(this.toHexStr(buf, 17, 4))) {
            ret = this.context.mBluetoothUtils.cmp_scRW(1, "F0F0");
            if (ret != 0) {
                throw new Exception("\u975e\u65b0\u5361\u6216\u68c0\u6d4b\u5361\u3002");
            }
        } else {
            throw new Exception("\u975e\u65b0\u5361\u6216\u68c0\u6d4b\u5361\u3002");
        }
        String dataStr = "";
        if (params == null) {
            throw new Exception("\u672a\u77e5\u8868\u578b\u3002");
        }
        dataStr = "000F0F" + params[0] + "FFFFFFFFFFFFFF" + params[1] + "FFFFFFFFFFFFFFFFFF" + params[2] + "00";
        byte[] data = this.hexStr2Bytes(dataStr);
        int isSuccess = this.context.mBluetoothUtils.wr_datRW(0, 0, 22, data);
        data = this.hexStr2Bytes("00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00");
        isSuccess += this.context.mBluetoothUtils.wr_datRW(1, 0, 64, data);
        if ((isSuccess += this.context.mBluetoothUtils.wr_datRW(2, 0, 64, data)) != 0) {
            throw new Exception("\u5236\u5361\u5931\u8d25\u3002");
        }
        return this;
    }

    private byte[] hexStr2Bytes(String hs) {
        int len = hs.length();
        byte[] defaultBytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            defaultBytes[i / 2] = (byte)((Character.digit(hs.charAt(i), 16) << 4) + Character.digit(hs.charAt(i + 1), 16));
        }
        return defaultBytes;
    }

    private int[] complement(byte[] buf) {
        int[] ints = new int[buf.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = buf[i] & 0xFF;
        }
        return ints;
    }

    private String toHexStr(int[] bytes, int offset, int n) {
        char[] hexChars = new char[n * 2];
        for (int j = 0; j < n; ++j) {
            int v = bytes[offset + j];
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private String getRemotePass(String cardNo) throws Exception {
        int i;
        int[] encrypt = new int[10];
        int[] s00 = new int[4];
        String s1 = "0246f53798adcbe1";
        int[] s = new int[20];
        int[] t = new int[20];
        int b = 4375;
        for (i = 0; i < 4; ++i) {
            s00[i] = cardNo.charAt(i + 4);
        }
        int a = this.zh(s00);
        for (i = 0; i < 16; ++i) {
            s[i] = s1.charAt(i) >= 'a' && s1.charAt(i) <= 'z' ? s1.charAt(i) - 97 + 10 : s1.charAt(i) - 48;
        }
        int c = 0;
        if ((a += b) > 65536) {
            a -= 65536;
        }
        i = 0;
        int j = 1;
        while (i < 16) {
            if (i != 0) {
                t[i++] = a >> j++ & 1;
                continue;
            }
            t[i++] = a & 1;
        }
        c = 0;
        i = 15;
        while (i >= 0) {
            if (i != 15) {
                c = c << 1 | t[s[i--]];
                continue;
            }
            c |= t[s[i--]];
        }
        encrypt[0] = (byte)((c & 0xFF00) >> 8);
        encrypt[1] = (byte)c;
        this.BinToAsc(encrypt, 2);
        for (j = 0; j < 4; ++j) {
            if (encrypt[j] < 97 || encrypt[j] > 102) continue;
            int n = j;
            encrypt[n] = encrypt[n] - -32;
        }
        j = 4;
        int j1 = 3;
        while (j1 > 0) {
            encrypt[j1--] = encrypt[--j];
        }
        j = 0;
        while (j < 0) {
            encrypt[j++] = 48;
        }
        String tmp = "";
        for (i = 0; i < 10; ++i) {
            if (encrypt[i] == 0) continue;
            tmp = tmp + (char)encrypt[i];
        }
        return tmp;
    }

    private void BinToAsc(int[] src, int cc) {
        for (int i = cc - 1; i >= 0; --i) {
            int v = src[i] & 0xFF;
            src[i * 2] = hexArray[v >> 4];
            src[i * 2 + 1] = hexArray[v & 0xF];
        }
    }

    private int zh(int[] b) {
        int i;
        int c = 48;
        for (i = 0; i < 4; ++i) {
            c = b[i];
            if (c < 97 || c > 122) continue;
            b[i] = c = c - 97 + 65;
        }
        int s = b[0] >= 65 && b[0] <= 90 ? b[0] - 65 + 10 : b[0] - 48;
        for (i = 1; i < 4; ++i) {
            s = b[i] >= 65 && b[i] <= 90 ? (s << 4) + b[i] - 65 + 10 : (s << 4) + b[i] - 48;
        }
        return s;
    }
}

