/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.util.Log;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.pos.device.VerifoneDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.smartpos.syncard.BytesValue;
import com.smartpos.syncard.IntValue;

public class VerifoneReader
implements ICardReader {
    final String TAG = this.getClass().getName();
    VerifoneDevice device;

    @Override
    public boolean openDevice(Chip chip) {
        if (this.device == null) {
            this.device = (VerifoneDevice)AFApplication.device;
        }
        if (this.device.deviceService == null) {
            this.device.initDevice(MainActivity.context);
            try {
                Thread.sleep(1000L);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean closeDevice(Chip chip) {
        return true;
    }

    @Override
    public boolean read(Chip chip) {
        if (chip.chipName == 1) {
            return this.read4442(chip);
        }
        return false;
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 1) {
            return this.write4442(offset, buf);
        }
        return false;
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                boolean ret = this.verify4442Pwd(new byte[]{secret[i], secret[i + 1], secret[i + 2]});
                if (!ret) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 1) {
            return this.change4442Pwd(newSecret);
        }
        return false;
    }

    @Override
    public Chip getNvlChip() {
        try {
            boolean ret = VerifoneDevice.isim4442CardReaderManager.exist();
            if (ret) {
                return new Chip(1);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"getNvlChip: ", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean hasCard() {
        try {
            return VerifoneDevice.isim4442CardReaderManager.exist();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"hasCard: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public byte[] resetCPUCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetRFCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetPSAMCard() {
        return new byte[0];
    }

    @Override
    public byte[] CPUsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    private boolean read4442(Chip chip) {
        try {
            boolean ret = VerifoneDevice.isim4442CardReaderManager.powerUp(5, new BytesValue());
            if (!ret) {
                Log.d((String)this.TAG, (String)"read4442: \u4e0a\u7535\u5931\u8d25");
                return false;
            }
            BytesValue bytes = new BytesValue();
            int read = VerifoneDevice.isim4442CardReaderManager.read(0, 256, bytes);
            if (read == 0) {
                System.arraycopy(bytes.getData(), 0, chip.buf, 0, 256);
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"read4442: ", (Throwable)e);
        }
        return false;
    }

    private boolean verify4442Pwd(byte[] secret) {
        try {
            return VerifoneDevice.isim4442CardReaderManager.verify(secret, new IntValue()) == 0;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"verifyPwd4442: ", (Throwable)e);
            return false;
        }
    }

    private boolean write4442(int offset, byte[] data) {
        try {
            int read = VerifoneDevice.isim4442CardReaderManager.write(offset, data);
            return read == 0;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"read4442: ", (Throwable)e);
            return false;
        }
    }

    private boolean change4442Pwd(byte[] data) {
        try {
            int read = VerifoneDevice.isim4442CardReaderManager.changeKey(data);
            return read == 0;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"read4442: ", (Throwable)e);
            return false;
        }
    }
}

