/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.util.Log;
import com.aofeng.hybrid.pos.device.EsLinkDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import tw.com.prolific.driver.pl2303.PL2303Driver;

public class EsLinkReader
implements ICardReader {
    private final String TAG = this.getClass().getName();
    private final ExecutorService mThreadPool = Executors.newFixedThreadPool(3);
    private String respResultStr = null;
    private boolean isReceiver = false;

    @Override
    public boolean openDevice(Chip chip) {
        return EsLinkDevice.init();
    }

    @Override
    public boolean closeDevice(Chip chip) {
        return EsLinkDevice.close();
    }

    @Override
    public boolean read(Chip chip) {
        if (chip.chipName == 1) {
            return this.read4442(chip);
        }
        if (chip.chipName == 0) {
            return this.read102(chip);
        }
        return false;
    }

    public boolean read4442(Chip chip) {
        String cardData;
        if (this.reset(chip) && this.get4442PasswordCount() > 1 && (cardData = this.read4442CardData(0, 256)) != null) {
            chip.buf = HexDump.hexStringToByteArray(cardData);
            return true;
        }
        return false;
    }

    public boolean read102(Chip chip) {
        String cardData;
        if (this.reset(chip) && this.get102PasswordCount() > 1 && (cardData = this.read4442CardData(0, 178)) != null) {
            chip.buf = HexDump.hexStringToByteArray(cardData);
            return true;
        }
        return false;
    }

    public boolean reset(Chip chip) {
        String result = this.sendCmd("A603FC120570");
        if (result == null) {
            return false;
        }
        if (result.startsWith("A213") && chip.chipName == 1) {
            return true;
        }
        return result.startsWith("F0F0") && chip.chipName == 0;
    }

    public int get4442PasswordCount() {
        String result = this.sendCmd("A603FC14145F");
        if (result.startsWith("07")) {
            return 3;
        }
        if (result.startsWith("06")) {
            return 2;
        }
        if (result.startsWith("04")) {
            return 1;
        }
        return 0;
    }

    public int get102PasswordCount() {
        String result = this.sendCmd(HexDump.getSendCmd("88", "C8", "01000C0001"));
        if (result.startsWith("F")) {
            return 4;
        }
        if (result.startsWith("7")) {
            return 3;
        }
        if (result.startsWith("3")) {
            return 2;
        }
        if (result.startsWith("1")) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        String data = HexDump.toHexString(buf);
        return this.writeCard(data, offset);
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        block4: {
            String key;
            block3: {
                key = chip.secret;
                if (key == null || "".equals(key)) {
                    return false;
                }
                if (chip.chipName != 1) break block3;
                for (int i = 0; i < key.length(); i += 6) {
                    String pass = key.substring(i, i + 6);
                    String sendCmd = HexDump.getSendCmd("19", "14", pass);
                    String result = this.sendCmd(sendCmd);
                    if (result == null) continue;
                    chip.secret = pass;
                    return true;
                }
                break block4;
            }
            if (chip.chipName != 0) break block4;
            for (int i = 0; i < key.length(); i += 4) {
                String pass = key.substring(i, i + 4);
                String sendCmd = HexDump.getSendCmd("88", "FF", "04000A0002" + pass + "000C00");
                String result = this.sendCmd(sendCmd);
                if (result == null) continue;
                chip.secret = pass;
                this.sendCmd("A605FA88FF07FFF7");
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 1) {
            String stringBuilder = "0103" + HexDump.toHexString(newSecret);
            String result = this.sendCmd(HexDump.getSendCmd("18", "64", stringBuilder));
            return result != null;
        }
        if (chip.chipName == 0) {
            return false;
        }
        return false;
    }

    @Override
    public Chip getNvlChip() {
        String result = this.sendCmd("A603FC120570");
        if (result == null) {
            return null;
        }
        if (result.startsWith("A213")) {
            return new Chip(1);
        }
        return null;
    }

    @Override
    public boolean hasCard() {
        return this.getNvlChip() != null;
    }

    @Override
    public byte[] resetCPUCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetRFCard() {
        return new byte[0];
    }

    @Override
    public byte[] resetPSAMCard() {
        return new byte[0];
    }

    @Override
    public byte[] CPUsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] RFsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        return new byte[0];
    }

    public String read4442CardData(int paramInt2, int paramInt3) {
        int paramInt1 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (paramInt1 < (paramInt3 + 143) / 144) {
            int i = paramInt1 * 144;
            String str1 = HexDump.getNVerifyCmd(Integer.toHexString(i + paramInt2));
            int j = paramInt3 - i;
            i = Math.min(j, 144);
            String str2 = HexDump.getNVerifyCmd(Integer.toHexString(i));
            String stringBuilder1 = str1 + str2;
            String stepInfo1 = this.sendCmd(HexDump.getSendCmd("13", "14", stringBuilder1));
            if (stepInfo1 == null) continue;
            stringBuilder.append(stepInfo1);
            ++paramInt1;
        }
        return stringBuilder.toString();
    }

    public String read102CardData(int paramInt2, int paramInt3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int paramInt1 = 0; paramInt1 < (paramInt3 + 143) / 144; ++paramInt1) {
            int i = paramInt1 * 144;
            String str1 = HexDump.getNVerifyCmd(Integer.toHexString(i + paramInt2));
            int j = paramInt3 - i;
            i = Math.min(j, 144);
            String str2 = HexDump.getNVerifyCmd(Integer.toHexString(i));
            String stringBuilder1 = "0100" + str1 + "00" + str2;
            String stepInfo1 = this.sendCmd(HexDump.getSendCmd("88", "C8", stringBuilder1));
            if (stepInfo1 != null) {
                stringBuilder.append(stepInfo1);
                continue;
            }
            return null;
        }
        return stringBuilder.toString();
    }

    public String sendCmd(String paramString2) {
        String str2 = "";
        PL2303Driver pL2303Driver = EsLinkDevice.driver;
        if (pL2303Driver == null) {
            return null;
        }
        if (!pL2303Driver.isConnected()) {
            return null;
        }
        String stringBuilder2 = "sendCmd : " + paramString2;
        Log.e((String)this.TAG, (String)stringBuilder2);
        byte[] arrayOfByte = HexDump.hexStringToByteArray(paramString2);
        int s1 = -1;
        int s2 = -1;
        try {
            s2 = pL2303Driver.write(arrayOfByte, arrayOfByte.length);
        }
        catch (Exception exception) {
            Log.e((String)this.TAG, (String)exception.getMessage());
            str2 = exception.getMessage();
        }
        if (s2 < 0) {
            StringBuilder stringBuilder1 = new StringBuilder();
            stringBuilder1.append("setup2: fail to controlTransfer: ");
            stringBuilder1.append(s2);
            Log.d((String)this.TAG, (String)stringBuilder1.toString());
            stringBuilder1 = new StringBuilder();
            stringBuilder1.append("");
            stringBuilder1.append(str2);
            Log.e((String)this.TAG, (String)stringBuilder1.toString());
        } else {
            this.isReceiver = true;
            this.readDataFromSerial();
        }
        while (this.isReceiver && s2 > 0) {
            try {
                Thread.sleep(100L);
                --s2;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.isReceiver) {
            this.isReceiver = false;
            return null;
        }
        return EsLinkReader.getResult(this.respResultStr);
    }

    public void readDataFromSerial() {
        this.mThreadPool.execute(() -> {
            byte[] arrayOfByte = new byte[512];
            StringBuilder stringBuffer = new StringBuilder();
            Log.e((String)this.TAG, (String)"************** readDataFromSerial() **************");
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("====== id ");
            stringBuilder2.append(Thread.currentThread().getId());
            stringBuilder2.append(" Threadname ");
            stringBuilder2.append(Thread.currentThread().getName());
            stringBuilder2.append(" =====");
            Log.e((String)this.TAG, (String)stringBuilder2.toString());
            Log.d((String)this.TAG, (String)"Enter readDataFromSerial");
            if (EsLinkDevice.driver == null) {
                return;
            }
            if (!EsLinkDevice.driver.isConnected()) {
                return;
            }
            int i = 0;
            int j = 0;
            while (this.isReceiver) {
                if (EsLinkDevice.driver == null) {
                    this.isReceiver = false;
                    return;
                }
                int k = EsLinkDevice.driver.read(arrayOfByte);
                if (k < 0) {
                    Log.d((String)this.TAG, (String)"Fail to bulkTransfer(read data)");
                    return;
                }
                if (k > 0) {
                    stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("read len : ");
                    stringBuilder2.append(k);
                    Log.d((String)this.TAG, (String)stringBuilder2.toString());
                    String str = HexDump.toHexString(arrayOfByte).substring(0, k * 2);
                    Log.e((String)this.TAG, (String)str);
                    stringBuffer.append(str);
                    i = 0;
                    k = 1;
                } else {
                    int m;
                    Log.d((String)this.TAG, (String)"read len : 0 ");
                    i = m = i + 1;
                    k = j;
                    if (m > 6) {
                        i = m;
                        k = j;
                        if (j == 1) {
                            k = j;
                            i = m;
                            this.isReceiver = false;
                        }
                    }
                }
                try {
                    Thread.sleep(10L);
                    j = k;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    j = k;
                }
            }
            String stringBuilder1 = "msg = " + stringBuffer.toString();
            Log.e((String)this.TAG, (String)stringBuilder1);
            Log.d((String)this.TAG, (String)"Leave readDataFromSerial");
            this.respResultStr = stringBuffer.toString();
            this.isReceiver = false;
        });
    }

    public static String getResult(String paramString1) {
        if (paramString1 == null) {
            return null;
        }
        int length = Integer.parseInt(paramString1.substring(2, 4), 16);
        if (!paramString1.startsWith("A6") || paramString1.length() < length * 2 + 6) {
            return null;
        }
        if (!paramString1.startsWith("00", 8)) {
            return null;
        }
        return paramString1.substring(10, paramString1.length() - 2);
    }

    public boolean writeCard(String writeData, int offset) {
        String str2;
        String str1;
        int zone;
        if (offset < 32) {
            zone = (32 - offset) * 2;
            if (writeData.length() < zone) {
                str1 = writeData;
                str2 = "";
            } else {
                str1 = writeData.substring(0, zone);
                str2 = writeData.substring(zone);
            }
        } else {
            str1 = "";
            str2 = writeData;
        }
        zone = 0;
        for (int i = 0; i < str1.length() / 2; ++i) {
            int start = zone * 2;
            String str = str1.substring(start, start + 2);
            start = offset + zone;
            String send = HexDump.getNVerifyCmd(Integer.toHexString(start));
            String result = this.sendCmd(HexDump.getSendCmd("16", "64", send = send + "01" + str));
            if (result == null) {
                return false;
            }
            ++zone;
        }
        zone = offset;
        if (zone < 32) {
            zone = 32;
        }
        List<String> list = EsLinkReader.get4442WriteCmds(zone, str2);
        for (zone = 0; zone < list.size(); ++zone) {
            String result = this.sendCmd(list.get(zone));
            if (result != null) continue;
            return false;
        }
        return true;
    }

    public static List<String> get4442WriteCmds(int paramInt, String paramString) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = paramString.length();
        for (int j = 0; j < (i + 64 - 1) / 64; ++j) {
            int m;
            int n;
            int k = paramString.length();
            String str = k <= (n = (m = j + 1) * 64) ? paramString.substring(j * 64) : paramString.substring(j * 64, n);
            String stringBuilder = HexDump.getNVerifyCmd(Integer.toHexString(j * 32 + paramInt)) + HexDump.getNVerifyCmd(Integer.toHexString(str.length() / 2)) + str;
            arrayList.add(HexDump.getSendCmd("16", "64", stringBuilder));
        }
        return arrayList;
    }
}

