/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.aofeng.hybrid.pos.device.VerifoneDevice;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.zacloud.deviceservice.aidl.PrinterListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class VerifonePrint
implements AfPrinter {
    private final String TAG = this.getClass().getName();
    private boolean result = false;
    private int data = -1;
    PrinterListener printerListener = new PrinterListener.Stub(){

        public void onFinish() throws RemoteException {
            Log.i((String)VerifonePrint.this.TAG, (String)"======print onFinish:");
            VerifonePrint.this.result = true;
            VerifonePrint.this.data = 1;
        }

        public void onError(int error) throws RemoteException {
            Log.i((String)VerifonePrint.this.TAG, (String)("======print error:" + error));
            VerifonePrint.this.result = true;
            VerifonePrint.this.data = error;
        }
    };

    @Override
    public boolean openPrinter() {
        this.result = false;
        this.data = -1;
        return true;
    }

    @Override
    public boolean closePrinter() {
        this.result = false;
        this.data = -1;
        return true;
    }

    @Override
    public int getPrinterState() {
        return 0;
    }

    @Override
    public int print(String param) {
        try {
            JSONArray arry = new JSONArray(param);
            if (arry.length() > 0) {
                for (int i = 0; i < arry.length(); ++i) {
                    Bundle bundle;
                    JSONObject json = arry.getJSONObject(i);
                    if (json.getInt("type") == 1) {
                        bundle = new Bundle();
                        bundle.putInt("offset", 100);
                        bundle.putInt("expectedHeight", 200);
                        VerifoneDevice.printer.addBarCode(bundle, json.optString("text", ""));
                        continue;
                    }
                    if (json.getInt("type") == 2) {
                        bundle = new Bundle();
                        bundle.putInt("offset", 100);
                        bundle.putInt("expectedHeight", 200);
                        VerifoneDevice.printer.addQrCode(bundle, json.optString("text", ""));
                        continue;
                    }
                    if (json.getInt("type") == 3) {
                        bundle = new Bundle();
                        bundle.putInt("font", json.getInt("fontsize"));
                        bundle.putInt("align", 0);
                        bundle.putBoolean("newline", true);
                        VerifoneDevice.printer.addText(bundle, json.optString("text", ""));
                        continue;
                    }
                    if (json.getInt("type") != 4) continue;
                    VerifoneDevice.printer.setGray(1);
                }
            }
            VerifoneDevice.printer.startPrint(this.printerListener);
            while (!this.result) {
                Thread.sleep(100L);
            }
            return this.data;
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)"print: ", (Throwable)e);
            return -2;
        }
    }
}

